/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.BlockFlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CompositeBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.value.Length;

public abstract class CSSLayout
extends FlowFigureLayout
implements FlowContext {
    private BlockFlowContext _absoluteContext;
    private FlowBox _boxForAbsolute;
    protected LineBox _currentLine;
    private boolean _calculatingMaxWidth = false;

    protected CSSLayout(CSSFigure flowFigure) {
        super(flowFigure);
    }

    public ICSSStyle getCSSStyle() {
        return this.getCSSFigure().getCSSStyle();
    }

    protected final BlockFlowContext getAbsoluteContext() {
        return this._absoluteContext;
    }

    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
    }

    protected abstract void createNewLine();

    protected void createNewLine(int topMargin) {
        this.createNewLine();
    }

    public LineBox getCurrentLine() {
        if (this._currentLine == null) {
            this.createNewLine();
        }
        return this._currentLine;
    }

    public LineBox getCurrentLine(int topMargin) {
        if (this._currentLine == null) {
            this.createNewLine(topMargin);
        } else if (this._currentLine.isEmptyStringLine()) {
            List list = this._currentLine.getFragments();
            this.createNewLine(topMargin);
            this._currentLine._fragments.addAll(list);
        }
        return this._currentLine;
    }

    public boolean isCurrentLineOccupied() {
        return this._currentLine != null && this._currentLine.isOccupied();
    }

    protected void layout() {
        this.preLayout();
        this.layoutChildren();
        this.flush();
        this.cleanup();
    }

    protected final boolean isAbsolutePosition() {
        Object obj;
        ICSSStyle style = this.getCSSStyle();
        if (style != null && ("absolute".equals(obj = style.getStyleProperty("position")) || "fixed".equals(obj))) {
            return this.supportAbsolutePosition();
        }
        return false;
    }

    protected boolean supportAbsolutePosition() {
        return this.findContainingPositionedFigure() != null;
    }

    protected void preLayout() {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            style.processCounters();
        }
        if (this.isAbsolutePosition()) {
            FlowContext parentFigureContext = this.getParentFigureContext();
            this._absoluteContext = new BlockFlowContext(parentFigureContext, style);
            this._boxForAbsolute = new FlowBox();
            this._boxForAbsolute.setVerticalAlignData("top");
            parentFigureContext.addToCurrentLine(this._boxForAbsolute);
        } else {
            this._absoluteContext = null;
        }
    }

    public FlowContext getFlowContext() {
        if (this._absoluteContext != null) {
            return this._absoluteContext;
        }
        return this.getOriginalFlowContext();
    }

    private FlowContext getParentFigureContext() {
        return super.getFlowContext();
    }

    final void postValidateForAbsolute() {
        if (this._absoluteContext != null) {
            ICSSStyle style = this.getCSSStyle();
            this._absoluteContext.endBlock();
            ICSSFigure containingPositionedFigure = this.findContainingPositionedFigure();
            IFigure parentFigure = this.getCSSFigure().getParent();
            int xOffset = this.calculatePositionRelativeToParent(style, containingPositionedFigure, parentFigure, true);
            int yOffset = this.calculatePositionRelativeToParent(style, containingPositionedFigure, parentFigure, false);
            this.move(this._absoluteContext._blockBox, xOffset, yOffset);
        }
    }

    private int calculatePositionRelativeToParent(ICSSStyle style, ICSSFigure containingPositionedFigure, IFigure parentFigure, boolean horizontal) {
        int xOffset;
        List fragments;
        int leftValue;
        Object right;
        Object left = horizontal ? style.getStyleProperty("left") : style.getStyleProperty("top");
        Object object = right = horizontal ? style.getStyleProperty("right") : style.getStyleProperty("bottom");
        if (!(left instanceof Length) && !(right instanceof Length)) {
            return horizontal ? this._boxForAbsolute._x : this._boxForAbsolute._y;
        }
        if (left instanceof Length) {
            Length leftLength = (Length)left;
            leftValue = leftLength.getValue();
            if (leftLength.isPercentage()) {
                leftValue = (horizontal ? containingPositionedFigure.getBounds().width : containingPositionedFigure.getBounds().height) * leftValue / 100;
            }
        } else {
            Length rightLength = (Length)right;
            int lengthValue = rightLength.getValue();
            if (rightLength.isPercentage()) {
                lengthValue = (horizontal ? containingPositionedFigure.getBounds().width : containingPositionedFigure.getBounds().height) * lengthValue / 100;
            }
            leftValue = horizontal ? containingPositionedFigure.getBounds().width - this._absoluteContext._blockBox.getWidth() - lengthValue : containingPositionedFigure.getBounds().height - this._absoluteContext._blockBox.getHeight() - lengthValue;
        }
        if ((fragments = containingPositionedFigure.getFragmentsForRead()).size() > 0) {
            FlowBox box = (FlowBox)fragments.get(0);
            xOffset = (horizontal ? box._x : box._y) + leftValue;
        } else {
            xOffset = leftValue;
        }
        Point p = horizontal ? new Point(xOffset, 0) : new Point(0, xOffset);
        containingPositionedFigure.translateFromParent((Translatable)p);
        containingPositionedFigure.translateToAbsolute((Translatable)p);
        parentFigure.translateToRelative((Translatable)p);
        return horizontal ? p.x : p.y;
    }

    private ICSSFigure findContainingPositionedFigure() {
        IFigure figure = this.getCSSFigure().getParent();
        if (figure instanceof ICSSFigure) {
            return (ICSSFigure)figure;
        }
        return null;
    }

    private void move(CompositeBox compBox, int x, int y) {
        compBox._x += x;
        compBox._y += y;
        List list = compBox.getFragments();
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            if (box instanceof CompositeBox && !(box instanceof BlockBox)) {
                this.move((CompositeBox)box, x, y);
            } else {
                box._x += x;
                box._y += y;
            }
            ++i;
        }
    }

    protected void layoutChildren() {
        List children = this.getFlowFigure().getChildren();
        int i = 0;
        while (i < children.size()) {
            Figure f = (Figure)children.get(i);
            f.invalidate();
            f.validate();
            ++i;
        }
    }

    public int getLastMarginRight() {
        if (this._currentLine == null || !this._currentLine.isOccupied()) {
            return 0;
        }
        FlowBox box = (FlowBox)this._currentLine.getFragments().get(this._currentLine.getFragments().size() - 1);
        if (box != null) {
            return box.getMarginInsets().right;
        }
        return 0;
    }

    public void setCalculatingMaxWidth(boolean c) {
        this._calculatingMaxWidth = c;
    }

    public boolean getCalcuatingMaxWidth() {
        return this._calculatingMaxWidth;
    }

    public boolean isCalculatingMaxWidth() {
        if (this._calculatingMaxWidth) {
            return true;
        }
        if (this.getFlowContext() == null) {
            return false;
        }
        return this.getFlowContext().isCalculatingMaxWidth();
    }

    protected abstract void flush();

    protected abstract void cleanup();

    protected final CSSFigure getCSSFigure() {
        return (CSSFigure)this.getFlowFigure();
    }

    public abstract List getFragmentsForRead();

    public abstract void postValidate();

    public void setBoundsCalled(Rectangle rect, boolean invalidate) {
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    protected boolean handlingBorderForBlock() {
        return true;
    }

    protected void figureRevalidate() {
    }
}

