/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IterateOverElementsOperation
extends AbstractTransformOperation {
    private String xPathExpression;

    public Element transform(Element srcElement, Element curElement) {
        if (this.getParameters().length < 1) {
            this.getLog().error("Warning.TransformOperationFactory.TooFewParameters", this.getTransformOperationID());
            return null;
        }
        this.xPathExpression = this.getParameters()[0];
        Assert.isNotNull((Object)this.xPathExpression);
        Element retElement = curElement;
        if (srcElement != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                Object resultObject = xPath.evaluate(this.xPathExpression, srcElement, XPathConstants.NODESET);
                if (resultObject instanceof NodeList) {
                    NodeList nodes = (NodeList)resultObject;
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Node node = nodes.item(i);
                        if (node instanceof Element) {
                            retElement = this.executeChildOperations((Element)node, retElement);
                        }
                        ++i;
                    }
                }
            }
            catch (XPathExpressionException xPathExpressionException) {}
        }
        return retElement;
    }
}

