/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.annotations.core.processor;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsCoreProcessorFactory
implements AnnotationProcessorFactory {
    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> annotationSet, AnnotationProcessorEnvironment processorEnvironment) {
        ArrayList<AnnotationProcessor> annotationProcessors = new ArrayList<AnnotationProcessor>();
        Map<String, List<IConfigurationElement>> annotationProcessorCache = AnnotationsManager.getAnnotationProcessorsCache();
        for (AnnotationTypeDeclaration annotationTypeDeclaration : annotationSet) {
            List<IConfigurationElement> processorElements = annotationProcessorCache.get(annotationTypeDeclaration.getQualifiedName());
            for (IConfigurationElement configurationElement : processorElements) {
                AnnotationProcessor processor;
                if (configurationElement == null || (processor = this.getAnnotationProcessor(configurationElement, processorEnvironment)) == null) continue;
                annotationProcessors.add(processor);
            }
        }
        return AnnotationProcessors.getCompositeAnnotationProcessor(annotationProcessors);
    }

    public AnnotationProcessor getAnnotationProcessor(IConfigurationElement configurationElement, AnnotationProcessorEnvironment processorEnvironment) {
        try {
            AbstractAnnotationProcessor annotationProcessor = (AbstractAnnotationProcessor)configurationElement.createExecutableExtension("class");
            annotationProcessor.setAnnotationProcessorEnvironment(processorEnvironment);
            return annotationProcessor;
        }
        catch (CoreException ce) {
            AnnotationsCorePlugin.log(ce.getStatus());
            return null;
        }
    }

    public Collection<String> supportedAnnotationTypes() {
        return AnnotationsManager.getAnnotationProcessorsCache().keySet();
    }

    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }
}

