/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.facet.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.core.constant.Axis2Constants;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.core.utils.RuntimePropertyUtils;
import org.eclipse.jst.ws.axis2.facet.commands.MergeWEBXMLCommand;
import org.eclipse.jst.ws.axis2.facet.utils.Axis2RuntimeUtils;
import org.eclipse.jst.ws.axis2.facet.utils.Axis2WebappUtils;
import org.eclipse.jst.ws.axis2.facet.utils.ContentCopyUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.validation.ValidationFramework;

public class Axis2WebservicesServerCommand
extends AbstractDataModelOperation {
    IProject project;
    Axis2EmitterContext context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();

    public Axis2WebservicesServerCommand(IProject project) {
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public IStatus executeOverride(IProgressMonitor monitor) {
        IStatus status = null;
        String runtimeLocation = null;
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils(this.getEnvironment());
        try {
            runtimeLocation = this.context.isAxis2ServerPathRepresentsWar() || RuntimePropertyUtils.getWarStatusFromPropertiesFile() ? Axis2RuntimeUtils.copyAxis2War(monitor, "path") : Axis2WebappUtils.copyAxis2War(monitor, "path");
        }
        catch (FileNotFoundException e) {
            return this.handleExceptionStatus(e);
        }
        catch (IOException e) {
            return this.handleExceptionStatus(e);
        }
        catch (Exception e) {
            return this.handleExceptionStatus(e);
        }
        Path libPath = new Path(runtimeLocation);
        libPath = libPath.append("WEB-INF");
        libPath = libPath.append("lib");
        ArrayList<String> ignoreList = new ArrayList<String>();
        ignoreList.add(libPath.toOSString());
        contentCopyUtils.updateCheckList(ignoreList);
        ValidationFramework validationFrameworkInstance = ValidationFramework.getDefault();
        String[] node = new String[]{"axis2-web"};
        Path pathForAxis2JSPContainer = new Path(FileUtils.addNodesToPath(J2EEUtils.getWebContentPath((IProject)this.project).toOSString(), node));
        validationFrameworkInstance.disableValidation((IResource)this.project.getWorkspace().getRoot().getFolder((IPath)pathForAxis2JSPContainer));
        status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(runtimeLocation, FacetContainerUtils.pathToWebProjectContainer(this.project.toString()), monitor, false);
        ArrayList includeList = new ArrayList();
        contentCopyUtils.updateCheckList(this.loadIncludeListWithAxis2Libs(libPath.toOSString(), includeList));
        String[] nodes = new String[]{"WEB-INF", "lib"};
        status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(libPath.toOSString(), FileUtils.addNodesToPath(FacetContainerUtils.pathToWebProjectContainer(this.project.toString()), nodes), monitor, true);
        MergeWEBXMLCommand mergeWebXMLCommand = new MergeWEBXMLCommand();
        mergeWebXMLCommand.setExtraAxis2TagsAdded(false);
        mergeWebXMLCommand.setServerProject(this.project);
        mergeWebXMLCommand.exexuteOverride(monitor);
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists() && this.context.isAxis2ServerPathRepresentsWar()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
        status = Status.OK_STATUS;
        return status;
    }

    private void cleanupIfFacetStatusFailed(String runtimeLocation) {
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
    }

    private IStatus handleExceptionStatus(Exception e) {
        Status status = null;
        status = new Status(1, this.project.toString(), 1, Axis2CoreUIMessages.ERROR_SERVER_IS_NOT_SET, (Throwable)e);
        this.cleanupIfFacetStatusFailed(Axis2CoreUtils.tempAxis2Directory());
        return status;
    }

    private List loadIncludeListWithAxis2Libs(String path, List includeList) {
        int i = 0;
        while (i < Axis2Constants.AXIS2_LIB_PREFIXES.length) {
            File[] jarFileList = FileUtils.getMatchingFiles(path, Axis2Constants.AXIS2_LIB_PREFIXES[i], "jar");
            int j = 0;
            while (j < jarFileList.length) {
                includeList.add(jarFileList[j].getAbsolutePath());
                ++j;
            }
            File[] licenseFileList = FileUtils.getMatchingFiles(path, Axis2Constants.AXIS2_LIB_PREFIXES[i], "txt");
            int k = 0;
            while (k < licenseFileList.length) {
                includeList.add(licenseFileList[k].getAbsolutePath());
                ++k;
            }
            ++i;
        }
        return includeList;
    }
}

