/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class SpringUtils {
    private static Namespace SPRING_BEANS_NS = Namespace.getNamespace((String)"http://www.springframework.org/schema/beans");
    private static Namespace XMLNS_XSI = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static Namespace JAXWS_NS = Namespace.getNamespace((String)"jaxws", (String)"http://cxf.apache.org/jaxws");
    private static Namespace SOAP_NS = Namespace.getNamespace((String)"soap", (String)"http://cxf.apache.org/bindings/soap");
    private static String DOC_ROOT = "beans";

    private SpringUtils() {
    }

    public static IFile getBeansFile(IProject project) throws IOException {
        IFile beansFile = null;
        IPath webContentPath = J2EEUtils.getWebContentPath((IProject)project);
        if (!webContentPath.hasTrailingSeparator()) {
            webContentPath = webContentPath.addTrailingSeparator();
            IPath webINFPath = webContentPath.append((IPath)new Path("WEB-INF/"));
            IFolder webINFFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(webINFPath);
            beansFile = webINFFolder.getFile("beans.xml");
            if (!beansFile.exists()) {
                try {
                    NullProgressMonitor progressMonitor = new NullProgressMonitor();
                    beansFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)progressMonitor);
                    SpringUtils.createBaseBeansFile(beansFile);
                }
                catch (CoreException ce) {
                    CXFCorePlugin.log(ce);
                }
            }
        }
        return beansFile;
    }

    public static IFile getBeansFile(String projectName) throws IOException {
        return SpringUtils.getBeansFile(FileUtils.getProject(projectName));
    }

    public static IFile getCXFServlet(IProject project) throws IOException {
        IFile cxfServlet = null;
        IPath webContentPath = J2EEUtils.getWebContentPath((IProject)project);
        if (!webContentPath.hasTrailingSeparator()) {
            webContentPath = webContentPath.addTrailingSeparator();
            IPath webINFPath = webContentPath.append((IPath)new Path("WEB-INF/"));
            IFolder webINFFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(webINFPath);
            cxfServlet = webINFFolder.getFile("cxf-servlet.xml");
            if (!cxfServlet.exists()) {
                try {
                    NullProgressMonitor progressMonitor = new NullProgressMonitor();
                    cxfServlet.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)progressMonitor);
                    SpringUtils.createBaseCXFServletFile(cxfServlet);
                }
                catch (CoreException ce) {
                    CXFCorePlugin.log(ce.getStatus());
                }
            }
        }
        return cxfServlet;
    }

    public static IFile getCXFServlet(String projectName) throws IOException {
        return SpringUtils.getCXFServlet(FileUtils.getProject(projectName));
    }

    private static void createBaseCXFServletFile(IFile cxfServlet) throws IOException {
        Element beans = new Element(DOC_ROOT);
        beans.setNamespace(SPRING_BEANS_NS);
        beans.addNamespaceDeclaration(XMLNS_XSI);
        beans.addNamespaceDeclaration(JAXWS_NS);
        beans.addNamespaceDeclaration(SOAP_NS);
        Attribute schemaLocation = new Attribute("schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd http://cxf.apache.org/bindings/soap http://cxf.apache.org/schemas/configuration/soap.xsd http://cxf.apache.org/jaxws http://cxf.apache.org/schemas/jaxws.xsd", XMLNS_XSI);
        beans.setAttribute(schemaLocation);
        SpringUtils.writeConfig(new Document(beans), cxfServlet);
    }

    private static void createBaseBeansFile(IFile beansFile) throws IOException {
        Element beans = new Element(DOC_ROOT);
        beans.setNamespace(SPRING_BEANS_NS);
        beans.addNamespaceDeclaration(XMLNS_XSI);
        beans.addNamespaceDeclaration(JAXWS_NS);
        Attribute schemaLocation = new Attribute("schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd http://cxf.apache.org/jaxws http://cxf.apache.org/schemas/jaxws.xsd", XMLNS_XSI);
        beans.setAttribute(schemaLocation);
        Element importCXFResource = new Element("import", SPRING_BEANS_NS);
        importCXFResource.setAttribute("resource", "classpath:META-INF/cxf/cxf.xml");
        Element importCXFSoapExtensionResource = new Element("import", SPRING_BEANS_NS);
        importCXFSoapExtensionResource.setAttribute("resource", "classpath:META-INF/cxf/cxf-extension-soap.xml");
        Element importCXFServeltResource = new Element("import", SPRING_BEANS_NS);
        importCXFServeltResource.setAttribute("resource", "classpath:META-INF/cxf/cxf-servlet.xml");
        beans.addContent((Content)importCXFResource);
        beans.addContent((Content)importCXFSoapExtensionResource);
        beans.addContent((Content)importCXFServeltResource);
        SpringUtils.writeConfig(new Document(beans), beansFile);
    }

    public static boolean isSpringBeansFile(IFile springBeansFile) throws IOException {
        FileInputStream springBeansInputStream = new FileInputStream(springBeansFile.getLocation().toFile());
        if (springBeansInputStream.available() > 0) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build((InputStream)springBeansInputStream);
                Element root = doc.getRootElement();
                if (root.getName().equals(DOC_ROOT) && root.getNamespace().equals((Object)SPRING_BEANS_NS)) {
                    return true;
                }
            }
            catch (JDOMException jdome) {
                CXFCorePlugin.log(jdome);
            }
            finally {
                springBeansInputStream.close();
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static boolean isBeanDefined(CXFDataModel cxfDataModel, String projectName, String elementName, Namespace namespace, String id) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getEndpointAddress(IProject project, String jaxwsEndpointId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createConfigurationFromWSDL(WSDL2JavaDataModel model) throws IOException {
        String targetNamespace = model.getTargetNamespace();
        String packageName = model.getIncludedNamespaces().get(targetNamespace);
        Definition definition = model.getWsdlDefinition();
        Map servicesMap = definition.getServices();
        Set servicesSet = servicesMap.entrySet();
        for (Map.Entry serviceEntry : servicesSet) {
            Service service = (Service)serviceEntry.getValue();
            model.setServiceName(service.getQName().getLocalPart());
            Map portsMap = service.getPorts();
            Set portsSet = portsMap.entrySet();
            for (Map.Entry portEntry : portsSet) {
                Port port = (Port)portEntry.getValue();
                model.setEndpointName(port.getName());
                PortType portType = port.getBinding().getPortType();
                QName qName = portType.getQName();
                String portTypeName = qName.getLocalPart();
                String fullyQualifiedClassName = String.valueOf(packageName) + "." + SpringUtils.convertPortTypeName(portTypeName) + "Impl";
                model.setFullyQualifiedJavaClassName(fullyQualifiedClassName);
                SpringUtils.createJAXWSEndpoint(model);
            }
        }
    }

    public static void loadSpringConfigInformationFromWSDL(CXFDataModel model) {
        IFile wsdlFile = WSDLUtils.getWSDLFolder((String)model.getProjectName()).getFile(model.getWsdlFileName());
        if (wsdlFile.exists()) {
            try {
                model.setWsdlURL(wsdlFile.getLocationURI().toURL());
                Definition definition = WSDLUtils.readWSDL((URL)model.getWsdlURL());
                Map servicesMap = definition.getServices();
                Set servicesSet = servicesMap.entrySet();
                for (Map.Entry serviceEntry : servicesSet) {
                    Service service = (Service)serviceEntry.getValue();
                    model.setServiceName(service.getQName().getLocalPart());
                    Map portsMap = service.getPorts();
                    Set portsSet = portsMap.entrySet();
                    for (Map.Entry portEntry : portsSet) {
                        Port port = (Port)portEntry.getValue();
                        model.setEndpointName(port.getName());
                    }
                }
                model.setWsdlDefinition(definition);
            }
            catch (MalformedURLException murle) {
                CXFCorePlugin.log(murle);
            }
            catch (IOException ioe) {
                CXFCorePlugin.log(ioe);
            }
        }
    }

    private static String convertPortTypeName(String portTypeName) {
        String[] segments = portTypeName.split("[\\-\\.\\:\\_\\u00b7\\u0387\\u06dd\\u06de]");
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.length() != 0) {
                char firstCharacter = segment.charAt(0);
                if (!Character.isDigit(firstCharacter) && Character.isLowerCase(firstCharacter)) {
                    segment = String.valueOf(segment.substring(0, 1).toUpperCase()) + segment.substring(1);
                }
                int i = 1;
                while (i < segment.length()) {
                    char currentChar = segment.charAt(i);
                    char precedingChar = segment.charAt(i - 1);
                    if (Character.isLetter(currentChar) && Character.isDigit(precedingChar) && Character.isLowerCase(currentChar)) {
                        segment = String.valueOf(segment.substring(0, i)) + segment.substring(i, i + 1).toUpperCase() + segment.substring(i + 1, segment.length());
                    }
                    ++i;
                }
                stringBuilder.append(segment);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static void createJAXWSEndpoint(CXFDataModel model) throws IOException {
        String projectName = model.getProjectName();
        IFile springConfigFile = null;
        springConfigFile = CXFCorePlugin.getDefault().getJava2WSContext().isUseSpringApplicationContext() ? SpringUtils.getBeansFile(projectName) : SpringUtils.getCXFServlet(projectName);
        if (SpringUtils.isSpringBeansFile(springConfigFile)) {
            SAXBuilder builder = new SAXBuilder();
            FileInputStream springConfigInputSteam = new FileInputStream(springConfigFile.getLocation().toFile());
            try {
                try {
                    Document doc = builder.build((InputStream)springConfigInputSteam);
                    Element beans = doc.getRootElement();
                    Element jaxwsEndpoint = new Element("endpoint", JAXWS_NS);
                    String id = SpringUtils.getJAXWSEndpointID(model);
                    model.setConfigId(id);
                    jaxwsEndpoint.setAttribute("id", id);
                    jaxwsEndpoint.setAttribute("implementor", model.getFullyQualifiedJavaClassName());
                    if (model.getConfigWsdlLocation() != null) {
                        jaxwsEndpoint.setAttribute("wsdlLocation", model.getConfigWsdlLocation());
                        if (model.getEndpointName() != null && model.getServiceName() != null) {
                            jaxwsEndpoint.setAttribute("endpointName", "tns:" + model.getEndpointName());
                            jaxwsEndpoint.setAttribute("serviceName", "tns:" + model.getServiceName());
                            Namespace XMLNS_TNS = Namespace.getNamespace((String)"tns", (String)model.getTargetNamespace());
                            jaxwsEndpoint.addNamespaceDeclaration(XMLNS_TNS);
                        }
                    }
                    if (model.getEndpointName() != null) {
                        jaxwsEndpoint.setAttribute("address", "/" + model.getEndpointName());
                    } else {
                        jaxwsEndpoint.setAttribute("address", "/" + id);
                    }
                    Element jaxwsFeatures = new Element("features", JAXWS_NS);
                    Element bean = new Element("bean", SPRING_BEANS_NS);
                    bean.setAttribute("class", "org.apache.cxf.feature.LoggingFeature");
                    jaxwsFeatures.addContent((Content)bean);
                    jaxwsEndpoint.addContent((Content)jaxwsFeatures);
                    if (!SpringUtils.isBeanDefined(model, projectName, "endpoint", JAXWS_NS, id)) {
                        beans.addContent((Content)jaxwsEndpoint);
                        SpringUtils.writeConfig(doc, springConfigFile);
                    }
                }
                catch (JDOMException jdome) {
                    CXFCorePlugin.log(jdome);
                    springConfigInputSteam.close();
                }
            }
            finally {
                springConfigInputSteam.close();
            }
        }
    }

    private static String getJAXWSEndpointID(CXFDataModel model) {
        String implementor = model.getFullyQualifiedJavaClassName();
        if (implementor.indexOf(".") != -1) {
            implementor = implementor.substring(implementor.lastIndexOf(".") + 1, implementor.length());
        }
        implementor = !implementor.startsWith("Impl") && implementor.indexOf("Impl") != -1 ? implementor.substring(0, implementor.indexOf("Impl")).toLowerCase() : implementor.toLowerCase();
        return implementor;
    }

    private static void writeConfig(Document document, IFile springConfigFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(springConfigFile.getLocation().toFile());
        try {
            try {
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(document, (OutputStream)outputStream);
                springConfigFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                FileUtils.formatXMLFile(springConfigFile);
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
                ((OutputStream)outputStream).close();
            }
        }
        finally {
            ((OutputStream)outputStream).close();
        }
    }
}

