/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.ws.jaxws.core.tests.TestProject;

public class TestJavaProject
extends TestProject {
    private IJavaProject javaProject = JavaCore.create((IProject)this.getProject());

    public TestJavaProject(String projectName) throws CoreException {
        super(projectName);
        this.addProjectNature(this.getProject(), "org.eclipse.jdt.core.javanature");
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createSourceFolder();
        this.addToClasspath(this.javaProject, this.getJREContainerEntry());
        this.createOutputFolder();
    }

    public void setAutoBuilding(boolean autoBuild) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(autoBuild);
        ResourcesPlugin.getWorkspace().setDescription(description);
    }

    public void enableAnnotationProcessing(boolean enable) {
        AptConfig.setEnabled((IJavaProject)this.javaProject, (boolean)enable);
    }

    private IClasspathEntry getJREContainerEntry() {
        IVMInstallType[] installTypes;
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        if (defaultVMInstall != null && this.isJava6OrGreaterJRE(defaultVMInstall)) {
            return JavaRuntime.getDefaultJREContainerEntry();
        }
        IVMInstallType[] iVMInstallTypeArray = installTypes = JavaRuntime.getVMInstallTypes();
        int n = installTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] vmInstalls;
            IVMInstallType installType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstalls = installType.getVMInstalls();
            int n3 = vmInstalls.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                if (this.isJava6OrGreaterJRE(vmInstall)) {
                    return JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((String)installType.getId(), (String)vmInstall.getName()));
                }
                ++n4;
            }
            ++n2;
        }
        return JavaRuntime.getDefaultJREContainerEntry();
    }

    private boolean isJava6OrGreaterJRE(IVMInstall vmInstall) {
        IVMInstall2 vmInstall2;
        return vmInstall instanceof IVMInstall2 && (vmInstall2 = (IVMInstall2)vmInstall).getJavaVersion().compareTo("1.6") > 0;
    }

    public ICompilationUnit createCompilationUnit(String packageName, String name, String contents) throws JavaModelException {
        return this.getPackageFragment(packageName).createCompilationUnit(name, contents, false, this.monitor);
    }

    private IPackageFragment getPackageFragment(String packageName) throws JavaModelException {
        return this.getPackageFragmentRoot().createPackageFragment(packageName, true, this.monitor);
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return this.getJavaProject().getPackageFragmentRoot((IResource)this.getProject().getFolder("src"));
    }

    private void createSourceFolder() throws CoreException {
        IFolder srcDir = this.getProject().getFolder("src");
        this.mkdirs(srcDir);
        this.addToClasspath(this.javaProject, JavaCore.newSourceEntry((IPath)srcDir.getFullPath()));
    }

    private void createOutputFolder() throws CoreException {
        IFolder outputDir = this.getProject().getFolder("bin");
        this.mkdirs(outputDir);
        this.getJavaProject().setOutputLocation(outputDir.getFullPath(), this.monitor);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void addToClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        try {
            IClasspathEntry[] currentClasspathEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newClasspathEntries = new IClasspathEntry[currentClasspathEntries.length + 1];
            System.arraycopy(currentClasspathEntries, 0, newClasspathEntries, 0, currentClasspathEntries.length);
            newClasspathEntries[currentClasspathEntries.length] = classpathEntry;
            javaProject.setRawClasspath(newClasspathEntries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
    }
}

