/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class DualParseSyntaxErrorTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public DualParseSyntaxErrorTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedSyntaxErrorDiagnosis, String testName) {
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        if (computedUnit.types != null) {
            int i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        StringBuffer buffer = new StringBuffer(100);
        if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
            CategorizedProblem[] problems = compilationResult.getAllProblems();
            int count = problems.length;
            int problemCount = 0;
            char[] unitSource = compilationResult.compilationUnit.getContents();
            int i = 0;
            while (i < count) {
                if (problems[i] != null) {
                    if (problemCount == 0) {
                        buffer.append("----------\n");
                    }
                    buffer.append(String.valueOf(++problemCount) + (problems[i].isError() ? ". ERROR" : ". WARNING"));
                    buffer.append(" in " + new String(problems[i].getOriginatingFileName()).replace('/', '\\'));
                    try {
                        buffer.append(((DefaultProblem)problems[i]).errorReportSource(unitSource));
                        buffer.append("\n");
                        buffer.append(problems[i].getMessage());
                        buffer.append("\n");
                    }
                    catch (Exception e) {
                        StringWriter stringWriter = new StringWriter();
                        e.printStackTrace(new PrintWriter(stringWriter));
                        buffer.append(stringWriter.getBuffer());
                    }
                    buffer.append("----------\n");
                }
                ++i;
            }
        }
        String computedSyntaxErrorDiagnosis = buffer.toString();
        if (!Util.convertToIndependantLineDelimiter(expectedSyntaxErrorDiagnosis).equals(Util.convertToIndependantLineDelimiter(computedSyntaxErrorDiagnosis))) {
            System.out.println(Util.displayString(computedSyntaxErrorDiagnosis));
        }
        DualParseSyntaxErrorTest.assertEquals("Invalid syntax error diagnosis" + testName, Util.convertToIndependantLineDelimiter(expectedSyntaxErrorDiagnosis), Util.convertToIndependantLineDelimiter(computedSyntaxErrorDiagnosis));
    }

    public void test01() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {   \t\t\t\t\t\t\t\n\t\tfX = 0;  \t\t\t\t\t\t\t\n\t}\t\t\t  \t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test1>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test02() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {   \t\t\t\t\t\t\t\n\t\tfX = 0;  \t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test2> (at line 4)\n\tfX = 0;  \t\t\t\t\t\t\t\n\t      ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n";
        String testName = "<test2>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test03() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo()   \t\t\t\t\t\t\t\n\t\tfX = 0;  \t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test3> (at line 3)\n\tvoid foo()   \t\t\t\t\t\t\t\n\t         ^\nSyntax error on token \")\", { expected after this token\n----------\n2. ERROR in <test3> (at line 4)\n\tfX = 0;  \t\t\t\t\t\t\t\n\t      ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n";
        String testName = "<test3>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test04() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo()   \t\t\t\t\t\t\t\n\t\tfX = 0;  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test4> (at line 3)\n\tvoid foo()   \t\t\t\t\t\t\t\n\t         ^\nSyntax error on token \")\", { expected after this token\n----------\n";
        String testName = "<test4>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test5> (at line 4)\n\tif(true){  \t\t\t\t\t\t\t\n\t        ^\nSyntax error, insert \"}\" to complete Statement\n----------\n";
        String testName = "<test5>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test06() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\t//comment\t\t\t\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test6> (at line 4)\n\tif(true){  \t\t\t\t\t\t\t\n\t        ^\nSyntax error, insert \"}\" to complete Statement\n----------\n";
        String testName = "<test6>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test07() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\tSystem.out.println();\t\t\t\t\t\n\tpublic void bar() {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test7> (at line 6)\n\tSystem.out.println();\t\t\t\t\t\n\t                    ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n";
        String testName = "<test7>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test08() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\tpublic int bar;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test8> (at line 4)\n\tif(true){  \t\t\t\t\t\t\t\n\t        ^\nSyntax error, insert \"}\" to complete Statement\n----------\n";
        String testName = "<test8>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test09() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\t//comment\t  \t\t\t\t\t\t\t\n\tpublic int bar;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test9> (at line 4)\n\tif(true){  \t\t\t\t\t\t\t\n\t        ^\nSyntax error, insert \"}\" to complete Statement\n----------\n";
        String testName = "<test9>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test10() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tint fX;         \t\t\t\t\t\t\n\tvoid foo() {  \t\t\t\t\t\t\t\n\t\tif(true){  \t\t\t\t\t\t\t\n\t} \t\t\t  \t\t\t\t\t\t\t\n\tSystem.out.println();\t\t\t\t\t\n\tpublic int bar;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test10> (at line 6)\n\tSystem.out.println();\t\t\t\t\t\n\t                    ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n";
        String testName = "<test10>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }
}

