/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTest_1_4
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    static /* synthetic */ Class class$0;

    public JavadocTest_1_4(String name) {
        super(name);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest_1_4");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return JavadocTest_1_4.buildMinimalComplianceTestSuite(JavadocTest_1_4.testClass(), 2);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        } else {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocCommentsVisibility != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
        } else {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "error");
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocComments = "ignore";
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <E> Type\n  */\n public class X<E> {}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\t* @param <E> Type\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\r\n\tpublic class X<E> {}\r\n\t               ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <E> Type extends RuntimeException\n  */\n public class X<E extends RuntimeException> {}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\t* @param <E> Type extends RuntimeException\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\r\n\tpublic class X<E extends RuntimeException> {}\r\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <U> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\t* @param <T> Type parameter 1\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\r\n\t* @param <U> Type parameter 2\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\r\n\t* @param <V> Type parameter 3\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\r\n\tpublic class X<T, U, V> {}\r\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E> Type parameter\n  */\n public class X {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E> Type parameter\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E> Type parameter\n  */\n public class X<E, F> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E> Type parameter\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<E, F> {}\n\t               ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <U> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tpublic class X<T> {}\n\t               ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <X> Type parameter 2\n  * @param <U> Type parameter 2\n  * @param <E> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <X> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <E> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <V> Type parameter 3\n  * @param <U> Type parameter 2\n  * @param <T> Type parameter 1\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\t* @param <V> Type parameter 3\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\r\n\t* @param <U> Type parameter 2\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\r\n\t* @param <T> Type parameter 1\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\r\n\tpublic class X<T, U, V> {}\r\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 1\n  * @param <E> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 2\n  * @param <T> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <E> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <T> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <U> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 3\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <U> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  * @param <U> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <U> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 2\n  * @param <X> Type parameter 2\n  * @param <U> Type parameter 1\n  * @param <E> Type parameter 2\n  * @param <U> Type parameter 2\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <X> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <E> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 2\n  * @param\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V> {}\n\t               ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, , V> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tpublic class X<T, , V> {}\n\t              ^^\nSyntax error on tokens, delete these tokens\n----------\n5. ERROR in X.java (at line 7)\n\tpublic class X<T, , V> {}\n\t               ^\nSyntax error, insert \"ClassBody\" to complete JavaScriptUnit\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V extend Exception> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <T> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t              ^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n5. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                   ^\nSyntax error, insert \"ClassBody\" to complete JavaScriptUnit\n----------\n6. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                       ^^^^^^\nextend cannot be resolved to a type\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <E> Type\n\t */\n\tpublic <E> void foo() {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\r\n\t* @param <E> Type\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\r\n\tpublic <E> void foo() {}\r\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <E> Type extends RuntimeException\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <E extends RuntimeException> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\r\n\t* @param <E> Type extends RuntimeException\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 8)\r\n\tpublic <E extends RuntimeException> void foo(int val, Object obj) {}\r\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param val int\n\t * @param obj Object\n\t * @param <T> Type parameter 1\n\t * @param <U> Type parameter 2\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 6)\r\n\t* @param <T> Type parameter 1\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 7)\r\n\t* @param <U> Type parameter 2\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 8)\r\n\t* @param <V> Type parameter 3\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 10)\r\n\tpublic <T, U, V> void foo(int val, Object obj) {}\r\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param val int\n\t * @param <E> Type parameter\n\t * @param obj Object\n\t */\n\tpublic void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <E> Type parameter\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <E> Type parameter\n\t */\n\tpublic <E, F> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <E> Type parameter\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t        ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t                           ^^^\nJavadoc: Missing tag for parameter val\n----------\n4. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t                                       ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 1\n\t * @param <U> Type parameter 2\n\t * @param <V> Type parameter 3\n\t * @param xxx int\n\t * @param Obj Object\n\t */\n\tpublic <T> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\t* @param xxx int\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n5. ERROR in X.java (at line 8)\n\t* @param Obj Object\n\t         ^^^\nJavadoc: Parameter Obj is not declared\n----------\n6. ERROR in X.java (at line 10)\n\tpublic <T> void foo(int val, Object obj) {}\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in X.java (at line 10)\n\tpublic <T> void foo(int val, Object obj) {}\n\t                        ^^^\nJavadoc: Missing tag for parameter val\n----------\n8. ERROR in X.java (at line 10)\n\tpublic <T> void foo(int val, Object obj) {}\n\t                                    ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 1\n\t * @param <X> Type parameter 2\n\t * @param val int\n\t * @param <U> Type parameter 2\n\t * @param <E> Type parameter 2\n\t * @param obj Object\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <X> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 7)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 8)\n\t* @param <E> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 10)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 12)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <V> Type parameter 3\n\t * @param obj Object\n\t * @param <U> Type parameter 2\n\t * @param val int\n\t * @param <T> Type parameter 1\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\r\n\t* @param <V> Type parameter 3\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\r\n\t* @param <U> Type parameter 2\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 8)\r\n\t* @param <T> Type parameter 1\r\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 10)\r\n\tpublic <T, U, V> void foo(int val, Object obj) {}\r\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n3. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 3\n\t * @param val int\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 7)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 7)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param obj Object\n\t * @param <U> Type parameter 3\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <V> Type parameter 3\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param val int\n\t * @param <V> Type parameter 2\n\t * @param <X> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param Object obj\n\t * @param <E> Type parameter 2\n\t * @param <U> Type parameter 2\n\t * @param val int\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <X> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 7)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 8)\n\t* @param Object obj\n\t         ^^^^^^\nJavadoc: Parameter Object is not declared\n----------\n5. ERROR in X.java (at line 9)\n\t* @param <E> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 10)\n\t* @param <U> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n7. ERROR in X.java (at line 11)\n\t* @param val int\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n8. ERROR in X.java (at line 13)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n9. ERROR in X.java (at line 13)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <V> Type parameter 2\n\t * @param\n\t * @param <U> Type parameter 1\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n5. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n6. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference: compile error\n\t * @param <T> Type parameter 2\n\t * @param <V> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <T, , V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 10)\n\tpublic <T, , V> void foo(int val, Object obj) {}\n\t       ^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference: compile error\n\t * @param <T> Type parameter 2\n\t * @param <V> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <T, U, V extends Exceptions> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 1\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 10)\n\tpublic <T, U, V extends Exceptions> void foo(int val, Object obj) {}\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param < Type\n  * @param < Type for parameterization\n  * @param <> Type\n  * @param <?> Type\n  * @param <*> Type\n  */\n public class X<E> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param < Type\n\t         ^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param < Type for parameterization\n\t         ^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <> Type\n\t         ^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <?> Type\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <*> Type\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<E> {}\n\t               ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E Type parameter of class X\n  * @param E> Type\n  * @param <<E> Type\n  * @param <<<E> Type\n  * @param <E>> Type\n  */\n public class X<E> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E Type parameter of class X\n\t         ^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param E> Type\n\t         ^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <<E> Type\n\t         ^^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <<<E> Type\n\t         ^^^^^\nJavadoc: Invalid param tag name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <E>> Type\n\t         ^^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<E> {}\n\t               ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void test040() {
        this.runConformReferenceTest(new String[]{"X.java", "/**\n * @category\n */\npublic class X {\n}\n"});
    }

    public void testBug80257() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @see G#G(Object)\n * @see G#G(Exception)\n */\npublic class X extends G<Exception> {\n\tX(Exception exc) { super(exc);}\n}\nclass G<E extends Exception> {\n\tG(E e) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @see G#G(Object)\n\t         ^^^^^^^^^\nJavadoc: The constructor G(Object) is undefined\n----------\n2. ERROR in X.java (at line 3)\n\t* @see G#G(Exception)\n\t         ^^^^^^^^^^^^\nJavadoc: The constructor G(Exception) is undefined\n----------\n3. ERROR in X.java (at line 5)\n\tpublic class X extends G<Exception> {\n\t                       ^\nThe type G is not generic; it cannot be parameterized with arguments <Exception>\n----------\n4. ERROR in X.java (at line 5)\n\tpublic class X extends G<Exception> {\n\t                         ^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n5. ERROR in X.java (at line 6)\n\tX(Exception exc) { super(exc);}\n\t                   ^^^^^^^^^^^\nThe constructor Object(Exception) is undefined\n----------\n6. ERROR in X.java (at line 8)\n\tclass G<E extends Exception> {\n\t        ^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in X.java (at line 9)\n\tG(E e) {}\n\t  ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug82514() {
        this.runNegativeTest(new String[]{"X.java", "class ComparableUtils {\n   public static <T extends Comparable< ? super T>> int compareTo(final Object first, final Object firstPrime,  final Class<T> type) throws ClassCastException\n    {\n        return 0;\n    }\n    public static <X extends Comparable< ? super X>> int compareTo(final X first, final X firstPrime)\n        throws ClassCastException\n    {\n        return 0;\n    }\n}\npublic final class X {  \n\t/** Tests the method{@link ComparableUtils#compareTo(Object, Object, Class)} and\n\t *  {@link ComparableUtils#compareTo(Object, Object)}.\n\t */\n    public void testCompareTo() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static <T extends Comparable< ? super T>> int compareTo(final Object first, final Object firstPrime,  final Class<T> type) throws ClassCastException\n\t               ^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tpublic static <T extends Comparable< ? super T>> int compareTo(final Object first, final Object firstPrime,  final Class<T> type) throws ClassCastException\n\t                                                                                                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 2)\n\tpublic static <T extends Comparable< ? super T>> int compareTo(final Object first, final Object firstPrime,  final Class<T> type) throws ClassCastException\n\t                                                                                                                         ^\nT cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tpublic static <X extends Comparable< ? super X>> int compareTo(final X first, final X firstPrime)\n\t               ^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n5. ERROR in X.java (at line 13)\n\t/** Tests the method{@link ComparableUtils#compareTo(Object, Object, Class)} and\n\t                                           ^^^^^^^^^\nJavadoc: The method compareTo(X, X) in the type ComparableUtils is not applicable for the arguments (Object, Object, Class)\n----------\n6. ERROR in X.java (at line 14)\n\t*  {@link ComparableUtils#compareTo(Object, Object)}.\n\t                          ^^^^^^^^^\nJavadoc: The method compareTo(X, X) in the type ComparableUtils is not applicable for the arguments (Object, Object)\n----------\n");
    }

    public void testBug83127a() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Test#add(T) \n * @see #add(T)\n * @see Test#Test(T)\n * @see #Test(T)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (T)\"\n *   - method binding = Test.add(Object)\n *   - parameter binding = T of A\n */\npublic class Test<T> {\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Test#add(T) \n\t                ^\nJavadoc: T cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see #add(T)\n\t            ^\nJavadoc: T cannot be resolved to a type\n----------\n3. ERROR in Test.java (at line 4)\n\t* @see Test#Test(T)\n\t                 ^\nJavadoc: T cannot be resolved to a type\n----------\n4. ERROR in Test.java (at line 5)\n\t* @see #Test(T)\n\t             ^\nJavadoc: T cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 11)\n\tpublic class Test<T> {\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n6. ERROR in Test.java (at line 12)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n7. ERROR in Test.java (at line 13)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n8. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n9. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n10. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n11. ERROR in Test.java (at line 19)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n12. ERROR in Test.java (at line 19)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n13. ERROR in Test.java (at line 20)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127b() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Sub#add(T)\n * @see Sub#Sub(T)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (T)\"\n *   - method binding = Test.add(Object)\n *   - parameter binding = T of A\n *     -> Do we need to change this as T natually resolved to TypeVariable?\n *        As compiler raises a warning, it's perhaps not a problem now...\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Sub#add(T)\n\t               ^\nJavadoc: T cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Sub#Sub(T)\n\t               ^\nJavadoc: T cannot be resolved to a type\n----------\n3. ERROR in Test.java (at line 11)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 12)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 13)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 18)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 19)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 19)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 20)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127c() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Sub#add(E) \n * @see Sub#Sub(E)\n *   - warning = \"E cannot be resolved to a type\"\n *   - method binding = null\n *   - parameter binding = null\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Sub#add(E) \n\t               ^\nJavadoc: E cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Sub#Sub(E)\n\t               ^\nJavadoc: E cannot be resolved to a type\n----------\n3. ERROR in Test.java (at line 8)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 9)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 10)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 17)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127d() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(E)\n * @see Unrelated1#Unrelated1(E)\n *   - warning = \"E cannot be resolved to a type\"\n *   - method binding = null\n *   - parameter binding = null\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Unrelated1.java (at line 1)\n\tpublic class Unrelated1<E extends Number> {\n\t                        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in Unrelated1.java (at line 2)\n\tpublic Unrelated1(E e) {}\n\t                  ^\nE cannot be resolved to a type\n----------\n3. ERROR in Unrelated1.java (at line 3)\n\tpublic boolean add(E e) { return false; }\n\t                   ^\nE cannot be resolved to a type\n----------\n----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(E)\n\t                      ^\nJavadoc: E cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(E)\n\t                             ^\nJavadoc: E cannot be resolved to a type\n----------\n3. ERROR in Test.java (at line 8)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 9)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 10)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 17)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127e() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Object)\n * @see Unrelated1#Unrelated1(Object)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (Object)\"\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Object\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Unrelated1.java (at line 1)\n\tpublic class Unrelated1<E extends Number> {\n\t                        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in Unrelated1.java (at line 2)\n\tpublic Unrelated1(E e) {}\n\t                  ^\nE cannot be resolved to a type\n----------\n3. ERROR in Unrelated1.java (at line 3)\n\tpublic boolean add(E e) { return false; }\n\t                   ^\nE cannot be resolved to a type\n----------\n----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(Object)\n\t                  ^^^\nJavadoc: The method add(Object) is undefined for the type Unrelated1\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(Object)\n\t                  ^^^^^^^^^^^^^^^^^^\nJavadoc: The constructor Unrelated1(Object) is undefined\n----------\n3. ERROR in Test.java (at line 9)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 10)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 11)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 15)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 16)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 17)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127f() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Number)\n * @see Unrelated1#Unrelated1(Number)\n *   - no warning\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Number\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Unrelated1.java (at line 1)\r\n\tpublic class Unrelated1<E extends Number> {\r\n\t                        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in Unrelated1.java (at line 2)\r\n\tpublic Unrelated1(E e) {}\r\n\t                  ^\nE cannot be resolved to a type\n----------\n3. ERROR in Unrelated1.java (at line 3)\r\n\tpublic boolean add(E e) { return false; }\r\n\t                   ^\nE cannot be resolved to a type\n----------\n----------\n1. ERROR in Test.java (at line 2)\r\n\t* @see Unrelated1#add(Number)\r\n\t                  ^^^\nJavadoc: The method add(Number) is undefined for the type Unrelated1\n----------\n2. ERROR in Test.java (at line 3)\r\n\t* @see Unrelated1#Unrelated1(Number)\r\n\t                  ^^^^^^^^^^^^^^^^^^\nJavadoc: The constructor Unrelated1(Number) is undefined\n----------\n3. ERROR in Test.java (at line 8)\r\n\tpublic class Test<T>{\r\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 9)\r\n\tTest(T t) {}\r\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 10)\r\n\tpublic boolean add(T t) {\r\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 14)\r\n\tclass Sub<E extends Number> extends Test<E> {\r\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 14)\r\n\tclass Sub<E extends Number> extends Test<E> {\r\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 14)\r\n\tclass Sub<E extends Number> extends Test<E> {\r\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 15)\r\n\tSub (E e) {super(null);}\r\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 15)\r\n\tSub (E e) {super(null);}\r\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 16)\r\n\tpublic boolean add(E e) {\r\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127g() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Integer)\n * @see Unrelated1#Unrelated1(Integer)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (Integer)\"\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Integer\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Unrelated1.java (at line 1)\n\tpublic class Unrelated1<E extends Number> {\n\t                        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in Unrelated1.java (at line 2)\n\tpublic Unrelated1(E e) {}\n\t                  ^\nE cannot be resolved to a type\n----------\n3. ERROR in Unrelated1.java (at line 3)\n\tpublic boolean add(E e) { return false; }\n\t                   ^\nE cannot be resolved to a type\n----------\n----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(Integer)\n\t                  ^^^\nJavadoc: The method add(Integer) is undefined for the type Unrelated1\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(Integer)\n\t                  ^^^^^^^^^^^^^^^^^^^\nJavadoc: The constructor Unrelated1(Integer) is undefined\n----------\n3. ERROR in Test.java (at line 9)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 10)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 11)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n6. ERROR in Test.java (at line 16)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 16)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in Test.java (at line 16)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 17)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n10. ERROR in Test.java (at line 17)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n11. ERROR in Test.java (at line 18)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83127h() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated2.java", "public interface Unrelated2<E> {\n\tboolean add(E e);\n}\n", "Test.java", "/** \n * @see Unrelated2#add(T)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (T)\"\n *   - method binding = Unrelated2.add(Object)\n *   - parameter binding = T of A\n *     -> Do we need to change this as T natually resolved to TypeVariable?\n *        As compiler raises a warning, it's perhaps not a problem now...\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Unrelated2.java (at line 1)\n\tpublic interface Unrelated2<E> {\n\t                            ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in Unrelated2.java (at line 2)\n\tboolean add(E e);\n\t            ^\nE cannot be resolved to a type\n----------\n----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated2#add(T)\n\t                      ^\nJavadoc: T cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 10)\n\tpublic class Test<T>{\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n3. ERROR in Test.java (at line 11)\n\tTest(T t) {}\n\t     ^\nT cannot be resolved to a type\n----------\n4. ERROR in Test.java (at line 12)\n\tpublic boolean add(T t) {\n\t                   ^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 17)\n\tclass Sub<E extends Number> extends Test<E> {\n\t          ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n6. ERROR in Test.java (at line 17)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n7. ERROR in Test.java (at line 17)\n\tclass Sub<E extends Number> extends Test<E> {\n\t                                         ^\nE cannot be resolved to a type\n----------\n8. ERROR in Test.java (at line 18)\n\tSub (E e) {super(null);}\n\t     ^\nE cannot be resolved to a type\n----------\n9. ERROR in Test.java (at line 18)\n\tSub (E e) {super(null);}\n\t           ^^^^^^^^^^^^\nThe constructor Object(null) is undefined\n----------\n10. ERROR in Test.java (at line 19)\n\tpublic boolean add(E e) {\n\t                   ^\nE cannot be resolved to a type\n----------\n");
    }

    public void testBug83393a() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tpublic void foo(int a, int b) {} \n\tpublic void foo(int a, int... args) {}\n\tpublic void foo(String... args) {}\n\tpublic void foo(Exception str, boolean... args) {}\n}\n", "Valid.java", "/**\n * @see Test#foo(int, int)\n * @see Test#foo(int, int[])\n * @see Test#foo(int, int...)\n * @see Test#foo(String[])\n * @see Test#foo(String...)\n * @see Test#foo(Exception, boolean[])\n * @see Test#foo(Exception, boolean...)\n */\npublic class Valid {}\n"}, "----------\n1. ERROR in Test.java (at line 3)\r\n\tpublic void foo(int a, int... args) {}\r\n\t                       ^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in Test.java (at line 4)\r\n\tpublic void foo(String... args) {}\r\n\t                ^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n3. ERROR in Test.java (at line 5)\r\n\tpublic void foo(Exception str, boolean... args) {}\r\n\t                               ^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n");
    }

    public void testBug83393b() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tpublic void foo(int a, int b) {} \n\tpublic void foo(int a, int... args) {}\n\tpublic void foo(String... args) {}\n\tpublic void foo(Exception str, boolean... args) {}\n}\n", "Invalid.java", "/**\n * @see Test#foo(int)\n * @see Test#foo(int, int, int)\n * @see Test#foo()\n * @see Test#foo(String)\n * @see Test#foo(String, String)\n * @see Test#foo(Exception)\n * @see Test#foo(Exception, boolean)\n * @see Test#foo(Exception, boolean, boolean)\n */\npublic class Invalid {}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\tpublic void foo(int a, int... args) {}\n\t                       ^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in Test.java (at line 4)\n\tpublic void foo(String... args) {}\n\t                ^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n3. ERROR in Test.java (at line 5)\n\tpublic void foo(Exception str, boolean... args) {}\n\t                               ^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n----------\n1. ERROR in Invalid.java (at line 2)\n\t* @see Test#foo(int)\n\t            ^^^\nJavadoc: The method foo(int, int) in the type Test is not applicable for the arguments (int)\n----------\n2. ERROR in Invalid.java (at line 3)\n\t* @see Test#foo(int, int, int)\n\t            ^^^\nJavadoc: The method foo(int, int) in the type Test is not applicable for the arguments (int, int, int)\n----------\n3. ERROR in Invalid.java (at line 4)\n\t* @see Test#foo()\n\t            ^^^\nJavadoc: The method foo(String[]) in the type Test is not applicable for the arguments ()\n----------\n4. ERROR in Invalid.java (at line 5)\n\t* @see Test#foo(String)\n\t            ^^^\nJavadoc: The method foo(String[]) in the type Test is not applicable for the arguments (String)\n----------\n5. ERROR in Invalid.java (at line 6)\n\t* @see Test#foo(String, String)\n\t            ^^^\nJavadoc: The method foo(int, int) in the type Test is not applicable for the arguments (String, String)\n----------\n6. ERROR in Invalid.java (at line 7)\n\t* @see Test#foo(Exception)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean[]) in the type Test is not applicable for the arguments (Exception)\n----------\n7. ERROR in Invalid.java (at line 8)\n\t* @see Test#foo(Exception, boolean)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean[]) in the type Test is not applicable for the arguments (Exception, boolean)\n----------\n8. ERROR in Invalid.java (at line 9)\n\t* @see Test#foo(Exception, boolean, boolean)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean[]) in the type Test is not applicable for the arguments (Exception, boolean, boolean)\n----------\n");
    }

    public void testBug83804() {
        this.runNegativeTest(new String[]{"pack/package-info.java", "/**\n * Valid javadoc.\n * @see Test\n * @see Unknown\n * @see Test#foo()\n * @see Test#unknown()\n * @see Test#field\n * @see Test#unknown\n * @param unexpected\n * @throws unexpected\n * @return unexpected \n * @deprecated accepted by javadoc.exe although javadoc 1.5 spec does not say that's a valid tag\n * @other-tags are valid\n */\npackage pack;\n", "pack/Test.java", "/**\n * Invalid javadoc\n */\npackage pack;\npublic class Test {\n\tpublic int field;\n\tpublic void foo() {}\n}\n"}, "");
    }

    public void testBug95286_Default() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug95286_Private() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "private";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug95521() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n\n/** Test */\npublic class X implements I {\n\t/**\n\t * @see test.I#foo(java.lang.Class)\n\t */\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t\treturn null;\n\t}\n}\n/** Interface */\ninterface I {\n    /**\n     * @param <T>\n     * @param stuffClass \n     * @return stuff\n     */\n    public <T extends Object> G<T> foo(Class<T> stuffClass);\n}\n/** \n * @param <T>\n */\nclass G<T> {}\n"}, "----------\n1. ERROR in test\\X.java (at line 8)\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in test\\X.java (at line 8)\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t             ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n3. ERROR in test\\X.java (at line 8)\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t             ^\nT cannot be resolved to a type\n----------\n4. ERROR in test\\X.java (at line 8)\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t                          ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n5. ERROR in test\\X.java (at line 8)\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t                          ^\nT cannot be resolved to a type\n----------\n6. ERROR in test\\X.java (at line 15)\n\t* @param <T>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n7. ERROR in test\\X.java (at line 19)\n\tpublic <T extends Object> G<T> foo(Class<T> stuffClass);\n\t        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n8. ERROR in test\\X.java (at line 19)\n\tpublic <T extends Object> G<T> foo(Class<T> stuffClass);\n\t                            ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n9. ERROR in test\\X.java (at line 19)\n\tpublic <T extends Object> G<T> foo(Class<T> stuffClass);\n\t                            ^\nT cannot be resolved to a type\n----------\n10. ERROR in test\\X.java (at line 19)\n\tpublic <T extends Object> G<T> foo(Class<T> stuffClass);\n\t                                         ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n11. ERROR in test\\X.java (at line 19)\n\tpublic <T extends Object> G<T> foo(Class<T> stuffClass);\n\t                                         ^\nT cannot be resolved to a type\n----------\n12. ERROR in test\\X.java (at line 22)\n\t* @param <T>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n13. ERROR in test\\X.java (at line 24)\n\tclass G<T> {}\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void testBug95521b() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n\n/** Test */\npublic class X {\n    /**\n     * @param <T>\n     * @param classT \n     */\n\tpublic <T> X(Class<T> classT) {\n\t}\n    /**\n     * @param <T>\n     * @param classT\n     * @return classT\n     */\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t\treturn classT;\n\t}\n}\n/** Super class */\nclass Y extends X {\n\t/**\n\t * @see X#X(java.lang.Class)\n\t */\n\tpublic <T> Y(Class<T> classT) {\n\t\tsuper(classT);\n\t}\n\n\t/**\n\t * @see X#foo(java.lang.Class)\n\t */\n    public <T extends Object> Class<T> foo(Class<T> stuffClass) {\n    \treturn null;\n    }\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @param <T>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in test\\X.java (at line 9)\n\tpublic <T> X(Class<T> classT) {\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n3. ERROR in test\\X.java (at line 9)\n\tpublic <T> X(Class<T> classT) {\n\t                   ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n4. ERROR in test\\X.java (at line 9)\n\tpublic <T> X(Class<T> classT) {\n\t                   ^\nT cannot be resolved to a type\n----------\n5. ERROR in test\\X.java (at line 12)\n\t* @param <T>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n6. ERROR in test\\X.java (at line 16)\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n7. ERROR in test\\X.java (at line 16)\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t                 ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n8. ERROR in test\\X.java (at line 16)\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t                 ^\nT cannot be resolved to a type\n----------\n9. ERROR in test\\X.java (at line 16)\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t                              ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n10. ERROR in test\\X.java (at line 16)\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t                              ^\nT cannot be resolved to a type\n----------\n11. ERROR in test\\X.java (at line 25)\n\tpublic <T> Y(Class<T> classT) {\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n12. ERROR in test\\X.java (at line 25)\n\tpublic <T> Y(Class<T> classT) {\n\t                   ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n13. ERROR in test\\X.java (at line 25)\n\tpublic <T> Y(Class<T> classT) {\n\t                   ^\nT cannot be resolved to a type\n----------\n14. ERROR in test\\X.java (at line 32)\n\tpublic <T extends Object> Class<T> foo(Class<T> stuffClass) {\n\t        ^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n15. ERROR in test\\X.java (at line 32)\n\tpublic <T extends Object> Class<T> foo(Class<T> stuffClass) {\n\t                                ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n16. ERROR in test\\X.java (at line 32)\n\tpublic <T extends Object> Class<T> foo(Class<T> stuffClass) {\n\t                                ^\nT cannot be resolved to a type\n----------\n17. ERROR in test\\X.java (at line 32)\n\tpublic <T extends Object> Class<T> foo(Class<T> stuffClass) {\n\t                                             ^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n18. ERROR in test\\X.java (at line 32)\n\tpublic <T extends Object> Class<T> foo(Class<T> stuffClass) {\n\t                                             ^\nT cannot be resolved to a type\n----------\n");
    }

    public void testBug96237_Public01() {
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Public02() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"}, "----------\n1. ERROR in comment6\\Invalid.java (at line 4)\r\n\t* @see Inner\r\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Public03() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\def\\Test.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Public04() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6b\\Test.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Public05() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"}, "----------\n1. ERROR in test\\a\\Test.java (at line 3)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\a\\Test.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public06() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"}, "----------\n1. ERROR in test\\b\\Test.java (at line 3)\n\t* @see Inner.Level2\n\t       ^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\b\\Test.java (at line 4)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\b\\Test.java (at line 8)\n\t* @see Level2\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\b\\Test.java (at line 9)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public07() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in test\\c\\Test.java (at line 3)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\c\\Test.java (at line 4)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\c\\Test.java (at line 9)\n\t* @see Level3\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\c\\Test.java (at line 10)\n\t* @see Level2.Level3\n\t       ^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n5. ERROR in test\\c\\Test.java (at line 11)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n6. ERROR in test\\c\\Test.java (at line 12)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public08() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"}, "----------\n1. ERROR in test\\d\\Test.java (at line 3)\n\t* @see Secondary\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\d\\Test.java (at line 4)\n\t* @see Reference\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Private01() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Private02() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"}, "----------\n1. ERROR in comment6\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in comment6\\Invalid.java (at line 9)\n\t* See also {@link Inner} \n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private03() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\def\\Test.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private04() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6b\\Test.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private05() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"});
    }

    public void testBug96237_Private06() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"});
    }

    public void testBug96237_Private07() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"});
    }

    public void testBug96237_Private08() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"});
    }

    public void testBug101283a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @param <T>  \n\t * @param <F>\n\t */\n\tstatic class Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T, F> {\n\t               ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <T>  \n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <F>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                   ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void testBug101283b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @see T Variable \n\t * @see F Variable\n\t */\n\tstatic class Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T, F> {\n\t               ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t* @see T Variable \n\t       ^\nJavadoc: T cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\t* @see F Variable\n\t       ^\nJavadoc: F cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                   ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void testBug101283c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @param <T>  \n\t * @param <F>\n\t */\n\tclass Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T, F> {\n\t               ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t* @param <T>  \n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <F>\n\t         ^^^\nJavadoc: Invalid param tag name\n----------\n4. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t            ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void testBug101283d() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @see T Variable \n\t * @see F Variable\n\t */\n\tclass Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T, F> {\n\t               ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t* @see T Variable \n\t       ^\nJavadoc: T cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\t* @see F Variable\n\t       ^\nJavadoc: F cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t            ^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }

    public void testBug101283g() {
        this.reportMissingJavadocTags = "disabled";
        this.runConformTest(new String[]{"test/X.java", "package test;\npublic class X {\n\tint foo() { return 0; }\n\tclass XX extends X2 {\n\t\tint bar() {\n\t\t\treturn foo();\n\t\t}\n\t}\n}\nclass X2 {\n\tint foo() {\n\t\treturn 0;\n\t}\n}\n", "test/Y.java", "package test;\npublic class Y {\n\tint foo;\n\tclass YY extends Y2 {\n\t/**\n\t *  @see #foo\n\t */\n\t\tint bar() {\n\t\t\treturn foo;\n\t\t}\n\t}\n}\nclass Y2 {\n\tint foo;\n}\n"});
    }

    public void testBug112346() {
        this.runNegativeTest(new String[]{"Test.java", "/**\n * Test references\n * @see Test#field\n * @see Test#foo()\n */\npublic class Test<T> {\n\tT field;\n\tT foo() { return null; }\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\t* @see Test#field\n\t            ^^^^^\nJavadoc: field cannot be resolved or is not a field\n----------\n2. ERROR in Test.java (at line 4)\n\t* @see Test#foo()\n\t            ^^^\nJavadoc: The method foo() is undefined for the type Test\n----------\n3. ERROR in Test.java (at line 6)\n\tpublic class Test<T> {\n\t                  ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n4. ERROR in Test.java (at line 7)\n\tT field;\n\t^\nT cannot be resolved to a type\n----------\n5. ERROR in Test.java (at line 8)\n\tT foo() { return null; }\n\t^\nT cannot be resolved to a type\n----------\n");
    }

    public void testBug119857() {
        this.runNegativeTest(new String[]{"DefaultInformationControl.java", "public class DefaultInformationControl {\n\tpublic interface IInformationPresenter {\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t * @deprecated As of 3.2, replaced by {@link IInformationPresenterExtension#updatePresentation(String, int, int)}\n\t\t * \t\t\t\tsee bug https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 for details.\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n\t/**\n\t * An information presenter determines the style presentation\n\t * of information displayed in the default information control.\n\t * The interface can be implemented by clients.\n\t * \n\t * @since 3.2\n\t */\n\tpublic interface IInformationPresenterExtension {\n\t\t\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t * <p>\n\t\t * Replaces {@link IInformationPresenter#updatePresentation(String, int, int)}\n\t\t * <em>Make sure that you do not pass in a <code>Display</code></em> until\n\t\t * https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 is fixed.\n\t\t * </p>\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n}\n"}, "----------\n1. ERROR in DefaultInformationControl.java (at line 14)\n\t* @deprecated As of 3.2, replaced by {@link IInformationPresenterExtension#updatePresentation(String, int, int)}\n\t                                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in DefaultInformationControl.java (at line 34)\n\t* Replaces {@link IInformationPresenter#updatePresentation(String, int, int)}\n\t                  ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug119857_Fields() {
        this.runNegativeTest(new String[]{"TestFields.java", "/**\n * @see MyInnerClass#foo\n */\npublic class TestFields {\n    /**\n     * @see MyInnerClass#foo\n     */\n    public class MyInnerClass {\n            Object foo;\n    }\n}"}, "----------\n1. ERROR in TestFields.java (at line 6)\n\t* @see MyInnerClass#foo\n\t       ^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug119857_Methods() {
        this.runNegativeTest(new String[]{"TestMethods.java", "/**\n * @see MyInnerClass#foo()\n * @see MyInnerInterface#foo()\n */\npublic class TestMethods {\n    /**\n     * @see MyInnerInterface#foo()\n     */\n    public class MyInnerClass {\n            public void foo() {}\n    }\n    /**\n     * @see MyInnerClass#foo()\n     */\n    public interface MyInnerInterface {\n            public void foo();\n    }\n}"}, "----------\n1. ERROR in TestMethods.java (at line 7)\n\t* @see MyInnerInterface#foo()\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in TestMethods.java (at line 13)\n\t* @see MyInnerClass#foo()\n\t       ^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug119857_Types() {
        this.runNegativeTest(new String[]{"TestTypes.java", "/**\n * @see MyInnerClass\n * @see MyInnerInterface\n */\npublic class TestTypes {\n\t/**\n\t * @see MyInnerInterface\n\t */\n\tpublic class MyInnerClass {\n\t        public void foo() {}\n\t}\n\t/**\n\t * @see MyInnerClass\n\t */\n\tpublic interface MyInnerInterface {\n\t        public void foo();\n\t}\n}"}, "----------\n1. ERROR in TestTypes.java (at line 7)\n\t* @see MyInnerInterface\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in TestTypes.java (at line 13)\n\t* @see MyInnerClass\n\t       ^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug119857_Private01() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"});
    }

    public void testBug119857_Public01() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 8)\r\n\t* @see Inner#foo()\r\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug119857_Private02() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in test\\Test.java (at line 9)\r\n\t* @see Inner1#foo()\r\n\t       ^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug119857_Public02() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"});
    }

    public void testBug119857_Public03() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic static class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 9)\n\t* @see Inner1#foo()\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug145007() {
        this.runNegativeTest(new String[]{"TestClass.java", "class TestClass<T> {\n    static class Test1 {\n        /**\n         * A simple method that demonstrates tag problems\n         * \n         * @return a string\n         * @throws MyException\n         *             if something goes wrong\n         */\n        public String getString() throws MyException {\n            throw new MyException();\n        }\n    }\n\n    static class MyException extends Exception {\n        private static final long serialVersionUID = 1L;\n    }\n}"}, "----------\n1. ERROR in TestClass.java (at line 1)\r\n\tclass TestClass<T> {\r\n\t                ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n");
    }
}

