/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class LocalVariableTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public LocalVariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LocalVariableTest.buildAllCompliancesTestSuite(LocalVariableTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n        int foo(){\n                int i;\n                return 1;\n        }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n    String temp;\n    try {\n      return;\n    }\n    catch (Exception e){\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n    String temp;\n    try {\n      return;\n    }\n    catch (Exception e) {\n    }\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  {\n     int i = 1;\n    System.out.println(i);\n  }\n  X(int j){\n  }\n}\n"});
    }

    public void test005() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int j;\n  void f1() {\n    int l;\n    switch (j) {\n      case 0 :\n        l = 10;\n\t\t l++;\n        break;\n      case 1 :\n        l = 20;\n        break;\n      case 2 :\n        l = 30;\n        break;\n      default :\n        l = 10;\n        break;\n    }\n  }\n  public static void main(String args[]) {\n  }\n}\n"});
    }

    public void test006() {
        this.runConformTest(new String[]{"p/Truc.java", "package p;\npublic class Truc{\n   void foo(){\n      final int i; \n\t   i = 1;\n      if (false) i = 2;\n   } \n\tpublic static void main(java.lang.String[] args) {\n  \t\tSystem.out.println(\"SUCCESS\"); \n\t}\t\n}"}, "SUCCESS");
    }

    public void test007() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nimport p.helper.Y;\nclass A extends Y {\n  class Y {\n    int j = i;// i is a protected member inherited from Y\n  }\n}", "p/helper/Y.java", "package p.helper;\npublic class Y {\n  protected int i = 10;\n  public inner in = new inner();\n    \n  protected class inner {\n    public int  f() {\n      return 20;\n    }\n  }\n}"});
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass Y {\n\t\tY innerY;\n\n\t\tint longMemberName;\n\t}\n\n\tstatic public void main(String args[]) {\n\t\tY y;\n\t\tSystem.out.println(y.innerY.longMemberName);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(y.innerY.longMemberName);\n\t                   ^\nThe local variable y may not have been initialized\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass Y {\n\t\tint longMemberName;\n\t}\n\n\tstatic public void main(String args[]) {\n\t\tY y;\n\t\tSystem.out.println(y.longMemberName);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(y.longMemberName);\n\t                   ^\nThe local variable y may not have been initialized\n----------\n");
    }

    public void test010() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        this.runConformTest(new String[]{"p/X.java", "package p;\n/**\n * @see Y\n */\npublic class X {\n}", "p/Y.java", "package p;\nclass Z {\n}"}, "", null, true, null, options, null);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = 2;\n                if (true) {\n                        int x = 4;\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint x = 4;\n\t    ^\nDuplicate local variable x\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = x = 0;\n                if (true) {\n                        int x = x = 1;\n                }\n        }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tint x = x = 0;\n\t    ^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n2. ERROR in X.java (at line 5)\n\tint x = x = 1;\n\t    ^\nDuplicate local variable x\n----------\n3. WARNING in X.java (at line 5)\n\tint x = x = 1;\n\t    ^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = 2;\n                try {\n                \t\n                } catch(Exception x) {\n                } catch(Exception e) {\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t} catch(Exception x) {\n\t                  ^\nDuplicate parameter x\n----------\n2. ERROR in X.java (at line 7)\n\t} catch(Exception e) {\n\t        ^^^^^^^^^\nUnreachable catch block for Exception. It is already handled by the catch block for Exception\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tint x = 0;\n\t\tString x = \"\";\n\t\tx.toString();\n\t  }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString x = \"\";\n\t       ^\nDuplicate local variable x\n----------\n");
    }

    public void test015() {
        Map options = this.getCompilerOptions();
        if (this.complianceLevel.equals("1.3")) {
            return;
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static boolean test() {\n                boolean b = false;\n                assert b = true;\n                return false;\n        }\n        public static void main(String[] args) {\n                test();\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, options, null);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.LocalVariableTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

