/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.eval.target;

import java.util.Hashtable;

public class CodeSnippetClassLoader
extends ClassLoader {
    static boolean DEVELOPMENT_MODE = false;
    Hashtable loadedClasses = new Hashtable();

    private Class delegateLoadClass(String name) throws ClassNotFoundException {
        ClassLoader myLoader = this.getClass().getClassLoader();
        if (myLoader == null) {
            return Class.forName(name);
        }
        return myLoader.loadClass(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (DEVELOPMENT_MODE) {
            try {
                return this.delegateLoadClass(name);
            }
            catch (ClassNotFoundException e) {
                Class clazz = this.makeClass(name, resolve);
                if (clazz == null) {
                    throw e;
                }
                return clazz;
            }
        }
        Class clazz = this.makeClass(name, resolve);
        if (clazz == null) {
            return this.delegateLoadClass(name);
        }
        return clazz;
    }

    Class loadIfNeeded(String className) {
        Class clazz = null;
        if (!this.supportsHotCodeReplacement()) {
            clazz = this.findLoadedClass(className);
        }
        if (clazz == null) {
            try {
                clazz = this.loadClass(className, true);
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return clazz;
    }

    private Class makeClass(String name, boolean resolve) {
        Object o = this.loadedClasses.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof Class) {
            return (Class)o;
        }
        byte[] classDefinition = (byte[])o;
        Class<?> clazz = this.defineClass(null, classDefinition, 0, classDefinition.length);
        if (resolve) {
            this.resolveClass(clazz);
        }
        this.loadedClasses.put(name, clazz);
        return clazz;
    }

    void storeClassDefinition(String className, byte[] classDefinition) {
        Object clazz = this.loadedClasses.get(className);
        if (clazz == null || this.supportsHotCodeReplacement()) {
            this.loadedClasses.put(className, classDefinition);
        }
    }

    protected boolean supportsHotCodeReplacement() {
        return false;
    }
}

