/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.future.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;

public class AmbiguousMethodTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public AmbiguousMethodTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AmbiguousMethodTest.buildComparableTestSuite(AmbiguousMethodTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.future.compiler.regression.AmbiguousMethodTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test000() {
        this.runConformTest(new String[]{"Test.java", "public class Test { public static void main(String[] args) { new B().foo(new C()); } }\nclass A { void foo(A a) {} }\nclass B extends A { void foo(B b) { System.out.println(1); } }\nclass C extends B {}"}, "1");
    }

    public void test000a() {
        this.runConformTest(new String[]{"Test.java", "public class Test { public static void main(String[] args) { new Subtype<String>().foo(1, \"works\"); } }\nclass Supertype<T1> { <U1> void foo(U1 u, T1 t) {} }\nclass Subtype <T2> extends Supertype<T2> { <U3> void foo(U3 u, T2 t) { System.out.println(t); } }"}, "works");
    }

    public void test001() {
        this.runConformTest(new String[]{"C.java", "public class C { public static void main(String[] args) { new B().m(\"works\"); } }\nclass B extends A { @Override <T extends Comparable<T>> void m(T t) { System.out.println(t); } }\nabstract class A { abstract <T extends Comparable<T>> void m(T t); }"}, "works");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic interface I1<E1> { void method(E1 o); }\n\tstatic interface I2<E2> { void method(E2 o); }\n\tstatic interface I3<E3, E4> extends I1<E3>, I2<E4> {}\n\tstatic class Class1 implements I3<String, String> {\n\t\tpublic void method(String o) { System.out.println(o); }\n\t}\n\tpublic static void main(String[] args) {\n\t\tI3<String, String> i = new Class1();\n\t\ti.method(\"works\");\n\t}\n}"}, "works");
    }

    public void test002a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic interface I1<E> { void method(E o); }\n\tstatic interface I2<E> { void method(E o); }\n\tstatic interface I3<E> extends I1<E>, I2<E> {}\n\tstatic class Class1 implements I3<String> {\n\t\tpublic void method(String o) { System.out.println(o); }\n\t}\n\tpublic static void main(String[] args) {\n\t\tI3<String> i = new Class1();\n\t\ti.method(\"works\");\n\t}\n}"}, "works");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() { new BB().test(); } }\nclass AA<T> { void test() {} }\nclass BB extends AA<CC> { <U> void test() {} }\nclass CC {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X { void foo() { new BB().test(); } }\n\t                                       ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. ERROR in X.java (at line 3)\n\tclass BB extends AA<CC> { <U> void test() {} }\n\t                                   ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n");
    }

    public void test003a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid singleMatch() { System.out.print(new BB().test(new N(), new Integer(1))); }\n\tvoid betterMatch() { System.out.print(new CC().test(new N(), new Integer(1))); }\n\tvoid worseMatch() { System.out.print(new DD().test(new N(), new Integer(1))); }\n\tpublic static void main(String[] s) {\n\t\tnew X().singleMatch();\n\t\tnew X().betterMatch();\n\t\tnew X().worseMatch();\n\t}\n}\nclass AA<T> { int test(T t, Number num) { return 1; } }\nclass BB extends AA<N> { @Override int test(N n, Number num) { return 2; } }\nclass CC extends AA<M> { <U extends Number> int test(N n, U u) { return 3; } }\nclass DD extends AA<N> { <U extends Number> int test(M m, U u) { return 4; } }\nclass M {}\nclass N extends M {}"}, "231");
    }

    public void test003b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid ambiguous() { new BB().test(new N()); }\n\tvoid exactMatch() { new CC().test(new N()); }\n}\nclass AA<T> { void test(T t) {} }\nclass BB extends AA<N> { <U> void test(N n) {} }\nclass CC extends AA<N> { @Override void test(N n) {} }\nclass M {}\nclass N extends M {}"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tvoid ambiguous() { new BB().test(new N()); }\r\n\t                            ^^^^\nThe method test(N) is ambiguous for the type BB\n----------\n");
    }

    public void test003c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid ambiguous() { new BB().test(new N(), new Integer(1)); }\n}\nclass AA<T> { void test(T t, Integer i) {} }\nclass BB extends AA<M> { <U extends Number> void test(N n, U u) {} }\nclass M {}\nclass N extends M {}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid ambiguous() { new BB().test(new N(), new Integer(1)); }\n\t                            ^^^^\nThe method test(N, Integer) is ambiguous for the type BB\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer> m) {\n\t\tm.id(new Integer(111));\n\t}\n}\nclass C<T extends Number> { public void id(T t) {} }\nclass M<TT> extends C<Integer> { public <ZZ> void id(Integer i) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tm.id(new Integer(111));\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer>\n----------\n");
    }

    public void test004a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer> m) {\n\t\tm.id(new Integer(111));\n\t}\n}\nclass C<T extends Number> { public void id(T t) {} }\nclass M<TT> extends C<Integer> { public void id(Integer i) {} }\n"}, "");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <S extends A> void foo() { }\n\t\t <N extends B> N foo() { return null; }\n\t\t void test () {\n\t\t \tnew X().foo();\n\t\t }\n}\nclass A {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew X().foo();\n\t        ^^^\nThe method foo() is ambiguous for the type X\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   void test() {\n   \tnew Y<Object>().foo(\"X\");\n   \tnew Y<Object>().foo2(\"X\");\n   }\n\t<U1> U1 foo(U1 t) {return null;}\n\t<U2> U2 foo2(U2 t) {return null;}\n}\nclass Y<T2> extends X<T2> {\n\tvoid foo(T2 t) {}\n\t<U3> void foo2(T2 t) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Y<Object>().foo(\"X\");\n\t                ^^^\nThe method foo(Object) is ambiguous for the type Y<Object>\n----------\n2. ERROR in X.java (at line 4)\n\tnew Y<Object>().foo2(\"X\");\n\t                ^^^^\nThe method foo2(Object) is ambiguous for the type Y<Object>\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"B.java", "public class B {\n   public static void main(String[] args) {\n   \tnew M().foo(new Integer(1), 2);\n   \tnew N().foo(new Integer(1), 2);\n   }\n}interface I { void foo(Number arg1, Number arg2); }\nclass M {\n\tpublic void foo(int arg1, int arg2) {}\n\tpublic void foo(Number arg1, Number arg2) {}\n}\nclass N implements I {\n\tpublic void foo(int arg1, int arg2) {}\n\tpublic void foo(Number arg1, Number arg2) {}\n}\n"}, "----------\n1. ERROR in B.java (at line 3)\r\n\tnew M().foo(new Integer(1), 2);\r\n\t        ^^^\nThe method foo(int, int) is ambiguous for the type M\n----------\n2. ERROR in B.java (at line 4)\r\n\tnew N().foo(new Integer(1), 2);\r\n\t        ^^^\nThe method foo(int, int) is ambiguous for the type N\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"AA.java", "public class AA {\n   public static void main(String[] a) { System.out.print(new C().test(new T())); }\n}class S {}\nclass T extends S {}\nclass B { <U extends S> int test(U u) {return -1;} }\nclass C extends B { @Override int test(S s) {return 1;} }"}, "1");
    }

    public void test008a() {
        this.runNegativeTest(new String[]{"A.java", "public class A { void check() { new C().test(new T()); } }\nclass S {}\nclass T extends S {}\nclass B { int test(S s) {return 1;} }\nclass C extends B { <U extends S> int test(U u) {return -1;} }"}, "----------\n1. ERROR in A.java (at line 1)\n\tpublic class A { void check() { new C().test(new T()); } }\n\t                                        ^^^^\nThe method test(T) is ambiguous for the type C\n----------\n2. ERROR in A.java (at line 5)\n\tclass C extends B { <U extends S> int test(U u) {return -1;} }\n\t                                      ^^^^^^^^^\nName clash: The method test(U) of type C has the same erasure as test(S) of type B but does not override it\n----------\n");
    }

    public void test009() {
        this.runConformTest(new String[]{"T.java", "import java.util.*;\npublic class T {\n   void test() {\n   \tOrderedSet<String> os = null;\n   \tos.add(\"hello\");\n   \tOrderedSet<Integer> os2 = null;\n   \tos2.add(1);\n   }\n}interface OrderedSet<E> extends List<E>, Set<E> { boolean add(E o); }\n"}, "");
    }

    public void _test010a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic <L1 extends Listener & ErrorListener> Object createParser(L1 l) { return null; }\n  \tstatic <L2 extends ErrorListener & Listener> Object createParser(L2 l) { return null; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tcreateParser(new A());\n   }\n}"}, "----------\n1. ERROR in X.java (at line 4)\r\n\tstatic <L1 extends Listener & ErrorListener> Object createParser(L1 l) { return null; }\r\n\t                                                    ^^^^^^^^^^^^^^^^^^\nMethod createParser(L1) has the same erasure createParser(X.Listener) as another method in type X\n----------\n2. ERROR in X.java (at line 5)\r\n\tstatic <L2 extends ErrorListener & Listener> Object createParser(L2 l) { return null; }\r\n\t                                                    ^^^^^^^^^^^^^^^^^^\nMethod createParser(L2) has the same erasure createParser(X.ErrorListener) as another method in type X\n----------\n3. ERROR in X.java (at line 8)\r\n\tcreateParser(new A());\r\n\t^^^^^^^^^^^^\nThe method createParser(A) is undefined for the type X\n----------\n");
    }

    public void _test010b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic <L1 extends Listener> int createParser(L1 l) { return 1; }\n  \tstatic <L2 extends ErrorListener & Listener> int createParser(L2 l) { return 2; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tSystem.out.print(createParser(new A()));\n   }\n}"}, "2");
    }

    public void _test010c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic int createParser(Listener l) { return 1; }\n  \tstatic <L extends ErrorListener & Listener> int createParser(L l) { return 2; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tSystem.out.print(createParser(new A()));\n   }\n}"}, "2");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A extends Number> extends Y<A> {\n\t<T> void foo(A n, T t) throws ExOne {}\n\tvoid test(X<Integer> x) throws ExTwo { x.foo(new Integer(1), new Integer(2)); }\n\tvoid test2(X x) throws ExTwo { x.foo(new Integer(1), new Integer(2)); }\n}\nclass Y<C extends Number> {\n\tvoid foo(C x, C n) throws ExTwo {}\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid test2(X x) throws ExTwo { x.foo(new Integer(1), new Integer(2)); }\n\t           ^\nX is a raw type. References to generic type X<A> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tvoid test2(X x) throws ExTwo { x.foo(new Integer(1), new Integer(2)); }\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method foo(Number, Number) belongs to the raw type Y. References to generic type Y<C> should be parameterized\n----------\n");
    }

    public void test011a() {
        this.runConformTest(new String[]{"Combined.java", "public class Combined<A, B> {\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\tvoid pickOne(Combined<Integer,Integer> c) throws ExOne { c.pickOne(\"test\"); }\n\t<T extends Number> void pickTwo(Number n, T t) throws ExOne {}\n\tvoid pickTwo(A x, Number n) throws ExTwo {}\n\tvoid pickTwo(Combined<Integer,Integer> c) throws ExTwo { c.pickTwo(new Integer(1), 2); }\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, "");
    }

    public void test011b() {
        this.runNegativeTest(new String[]{"Test1.java", "public class Test1<AA, BB> {\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, "----------\n1. WARNING in Test1.java (at line 4)\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n\t                                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation pickOne(Comparable) of the generic method pickOne(T) of type Test1<Integer,Integer>\n----------\n2. WARNING in Test1.java (at line 4)\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n\t                                                                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"XX.java", "public class XX {\n\tpublic static void main(String[] s) { System.out.println(new B().id(new Integer(1))); }\n}\nclass A<T extends Number> { public int id(T t) {return 2;} }\nclass B extends A<Integer> { public int id(Integer i) {return 1;} }"}, "1");
    }

    public void test012a() {
        this.runNegativeTest(new String[]{"XX.java", "public class XX {\n\tpublic static void main(String[] s) { System.out.println(new B().id(new Integer(1))); }\n}\nclass A<T extends Number> { public int id(T t) {return 2;} }\nclass B extends A<Integer> { public <ZZ> int id(Integer i) {return 1;} }"}, "----------\n1. ERROR in XX.java (at line 2)\r\n\tpublic static void main(String[] s) { System.out.println(new B().id(new Integer(1))); }\r\n\t                                                                 ^^\nThe method id(Integer) is ambiguous for the type B\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<E extends A> void m(E e) { System.out.print(1); }\n\t<E extends B> void m(E e) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tnew X().m(new A());\n\t\tnew X().m(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "12");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid a(G x) { System.out.print(1); }\n\tvoid b(F x) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tG<C> g = null;\n\t\tnew X().a(h);\n\t\tnew X().a(g);\n\t\tnew X().b(h);\n\t\tnew X().b(g);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "1122");
    }

    public void test014a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid a(G<C> x) { System.out.print(1); }\n\tvoid b(F<C> x) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tH h = null;\n\t\tG g = null;\n\t\tnew X().a(h);\n\t\tnew X().a(g);\n\t\tnew X().b(h);\n\t\tnew X().b(g);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "1122");
    }

    public void test014b() {
        this.runConformTest(new String[]{"X0.java", "public class X0 {\n\tvoid two(G x) { System.out.print(1); }\n\tvoid two(F<A> x) { System.out.print(2); }\n\tvoid three(G x) { System.out.print(3); }\n\tvoid three(F<B> x) { System.out.print(4); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X0().two(h);\n\t\tnew X0().three(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "13");
    }

    public void test014c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid a(G x) {}\n\tvoid a(F<C> x) {}\n\tvoid b(G<C> x) {}\n\tvoid b(F x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().a(h);\n\t\tnew X().b(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. WARNING in X.java (at line 2)\r\n\tvoid a(G x) {}\r\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\r\n\tvoid b(F x) {}\r\n\t       ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\r\n\tnew X().a(h);\r\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n");
    }

    public void test014d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid one(G<B> x) {}\n\tvoid one(F<B> x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().one(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. ERROR in X.java (at line 6)\r\n\tnew X().one(h);\r\n\t        ^^^\nThe method one(G<B>) in the type X is not applicable for the arguments (H<C>)\n----------\n");
    }

    public void test014e() {
        this.runConformTest(new String[]{"X1.java", "public class X1 {\n\tvoid two(G<C> x) { System.out.print(1); }\n\tvoid two(F<B> x) { System.out.print(2); }\n\tvoid three(G<B> x) { System.out.print(3); }\n\tvoid three(F<C> x) { System.out.print(4); }\n\tvoid four(G<C> x) { System.out.print(5); }\n\tvoid four(F<C> x) { System.out.print(6); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X1().two(h);\n\t\tnew X1().three(h);\n\t\tnew X1().four(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "145");
    }

    public void test014f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<E1, E2 extends B> void three(G<E2> x) {}\n\t<E3 extends C> void three(F<E3> x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().three(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. ERROR in X.java (at line 6)\r\n\tnew X().three(h);\r\n\t        ^^^^^\nThe method three(G<C>) is ambiguous for the type X\n----------\n");
    }

    public void test014g() {
        this.runConformTest(new String[]{"X3.java", "public class X3 {\n\t<E1, E2 extends B> void one(G<E2> x) { System.out.print(1); }\n\t<E3 extends B> void one(F<E3> x) { System.out.print(2); }\n\t<E1, E2 extends C> void two(G<E2> x) { System.out.print(3); }\n\t<E3 extends B> void two(F<E3> x) { System.out.print(4); }\n\t<E1, E2 extends C> void four(G<E2> x) { System.out.print(5); }\n\t<E3 extends C> void four(F<E3> x) { System.out.print(6); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X3().one(h);\n\t\tnew X3().two(h);\n\t\tnew X3().four(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "135");
    }

    public void test014h() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid x(G x) { System.out.print(true); }\n\tvoid x(F x) { System.out.print(false); }\n\tvoid x2(G<C> x) { System.out.print(true); }\n\tvoid x2(F<C> x) { System.out.print(false); }\n\tvoid a(G x) {}\n\tvoid a(F<C> x) {}\n\tvoid a2(G x) {}\n\t<T extends C> void a2(F<T> x) {}\n\tvoid a3(G x) {}\n\t<T extends F<C>> void a3(T x) {}\n\tvoid a4(G x) {}\n\t<T extends C, S extends F<T>> void a4(S x) {}\n\t<T extends G> void a5(T x) {}\n\tvoid a5(F<C> x) {}\n\tvoid b(G<C> x) { System.out.print(true); }\n\tvoid b(F x) { System.out.print(false); }\n\tvoid b2(G<C> x) { System.out.print(true); }\n\t<T extends F> void b2(T x) { System.out.print(false); }\n\t<T extends C> void b3(G<T> x) { System.out.print(true); }\n\tvoid b3(F x) { System.out.print(false); }\n\t<T extends G<C>> void b4(T x) { System.out.print(true); }\n\tvoid b4(F x) { System.out.print(false); }\n\t<T extends C, S extends G<T>> void b5(S x) { System.out.print(true); }\n\tvoid b5(F x) { System.out.print(false); }\n\tvoid c(G x) { System.out.print(true); }\n\t<T extends C> void c(F x) { System.out.print(false); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tH hraw = null;\n\t\tnew X().x(h);\n\t\tnew X().x(hraw);\n\t\tnew X().x2(h);\n\t\tnew X().x2(hraw);\n\t\tnew X().b(h);\n\t\tnew X().b(hraw);\n\t\tnew X().b2(h);\n\t\tnew X().b2(hraw);\n\t\tnew X().b3(h);\n\t\tnew X().b3(hraw);\n\t\tnew X().b4(h);\n\t\tnew X().b4(hraw);\n\t\tnew X().b5(h);\n\t\tnew X().b5(hraw);\n\t\tnew X().c(h);\n\t\tnew X().c(hraw);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "truetruetruetruetruetruetruetruetruetruetruetruetruetruetruetrue");
        this.runNegativeTest(new String[]{"Y.java", "public class Y extends X {\n\tpublic static void ambiguousCases() {\n\t\tH<C> h = null;\n\t\tH hraw = null;\n\t\tnew X().a(h);\n\t\tnew X().a(hraw);\n\t\tnew X().a2(h);\n\t\tnew X().a2(hraw);\n\t\tnew X().a3(h);\n\t\tnew X().a3(hraw);\n\t\tnew X().a4(h);\n\t\tnew X().a4(hraw);\n\t\tnew X().a5(h);\n\t\tnew X().a5(hraw);\n\t}\n}\n"}, "----------\n1. WARNING in Y.java (at line 4)\n\tH hraw = null;\n\t^\nH is a raw type. References to generic type H<T3> should be parameterized\n----------\n2. ERROR in Y.java (at line 5)\n\tnew X().a(h);\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n3. ERROR in Y.java (at line 6)\n\tnew X().a(hraw);\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n4. ERROR in Y.java (at line 7)\n\tnew X().a2(h);\n\t        ^^\nThe method a2(G) is ambiguous for the type X\n----------\n5. ERROR in Y.java (at line 8)\n\tnew X().a2(hraw);\n\t        ^^\nThe method a2(G) is ambiguous for the type X\n----------\n6. ERROR in Y.java (at line 9)\n\tnew X().a3(h);\n\t        ^^\nThe method a3(G) is ambiguous for the type X\n----------\n7. ERROR in Y.java (at line 10)\n\tnew X().a3(hraw);\n\t        ^^\nThe method a3(G) is ambiguous for the type X\n----------\n8. ERROR in Y.java (at line 11)\n\tnew X().a4(h);\n\t        ^^\nThe method a4(G) is ambiguous for the type X\n----------\n9. ERROR in Y.java (at line 12)\n\tnew X().a4(hraw);\n\t        ^^\nThe method a4(G) is ambiguous for the type X\n----------\n10. ERROR in Y.java (at line 13)\n\tnew X().a5(h);\n\t        ^^\nThe method a5(H<C>) is ambiguous for the type X\n----------\n11. ERROR in Y.java (at line 14)\n\tnew X().a5(hraw);\n\t        ^^\nThe method a5(H) is ambiguous for the type X\n----------\n", null, false);
    }

    public void test015() {
        this.runConformTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\ttry { ij.m(); } catch(E11 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "");
    }

    public void _test016() {
        this.runConformTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\ttry { ij.m(); } catch(E11 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E2, E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "");
    }

    public void _test016a() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\tij.m();\n\t\ttry { ij.m(); } catch(E2 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E2, E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "----------\n1. ERROR in E.java (at line 4)\r\n\tij.m();\r\n\t^^^^^^\nUnhandled exception type E11\n----------\n2. ERROR in E.java (at line 5)\r\n\ttry { ij.m(); } catch(E2 e) {}\r\n\t      ^^^^^^\nUnhandled exception type E11\n----------\n3. ERROR in E.java (at line 5)\r\n\ttry { ij.m(); } catch(E2 e) {}\r\n\t                      ^^\nUnreachable catch block for E2. This exception is never thrown from the try statement body\n----------\n");
    }

    public void test017() {
        this.runConformTest(new String[]{"AbstractFilter.java", "import java.util.*;\npublic class AbstractFilter<T> implements IFilter<T> {\n\tpublic final <E extends T> boolean selekt(E obj) { return true; }\n\tpublic final <E extends T> List<E> filter(List<E> elements) {\n\t\tif ((elements == null) || (elements.size() == 0)) return elements;\n\t\tList<E> okElements = new ArrayList<E>(elements.size());\n\t\tfor (E obj : elements) {\n\t\t\tif (selekt(obj)) okElements.add(obj);\n\t\t}\n\t\treturn okElements;\t}\n}\ninterface IFilter<T> {\n\t<E extends T> boolean selekt(E obj);\n\t<E extends T> List<E> filter(List<E> elements);\n}"}, "");
    }

    public void test018() {
        this.runConformTest(new String[]{"Y.java", "class X<T extends Object> {\n  public static <U extends Object> X<U> make(Class<U> clazz) {\n    System.out.print(false);\n    return new X<U>();\n  }\n}\npublic class Y<V extends String> extends X<V> {\n  public static <W extends String> Y<W> make(Class<W> clazz) {\n    System.out.print(true);\n    return new Y<W>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y.make(String.class);\n  }\n}"}, "true");
    }

    public void test019() {
        this.runConformTest(new String[]{"Y.java", "class X<T extends Object> {\n  public static <U extends Object> X<U> make(Class<U> clazz) {\n    System.out.print(false);\n    return new X<U>();\n  }\n}\npublic class Y<V extends String> extends X<V> {\n  public static <W extends String> Y<W> make(Class<W> clazz) {\n    System.out.print(true);\n    return new Y<W>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y.make(getClazz());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, "true");
    }

    public void test020() {
        this.runConformTest(new String[]{"Y.java", "class X<T extends Object> {\n  public static <U extends Object> X<U> make(Class<U> clazz) {\n    System.out.print(true);\n    return new X<U>();\n  }\n}\npublic class Y<V extends String> extends X<V> {\n  public static <W extends String> Y<W> make(Class<W> clazz) {\n    System.out.print(false);\n    return new Y<W>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y.make(getClazz().newInstance().getClass());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, "true");
    }

    public void test021() {
        this.runConformTest(new String[]{"Y.java", "class X<T extends Object> {\n}\npublic class Y<V extends String> extends X<V> {\n  public static <W extends String> Y<W> make(Class<W> clazz) {\n    System.out.print(true);\n    return new Y<W>();\n  }\n  public static <U extends Object> X<U> make(Class<U> clazz) {\n    System.out.print(false);\n    return new X<U>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y.make(getClazz());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, "true");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Object> {\n}\nclass Y<V extends String> extends X<V> {\n  public <W extends String> Y<W> make(Class<W> clazz) {\n    return new Y<W>();\n  }\n  public <U extends Object> X<U> make(Class<U> clazz) {\n    return new X<U>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y y = new Y();\n    y.make(String.class);\n    y.make(getClazz());\n    y.make(getClazz().newInstance().getClass());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y<V extends String> extends X<V> {\n\t                  ^^^^^^\nThe type parameter V should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. WARNING in X.java (at line 4)\n\tpublic <W extends String> Y<W> make(Class<W> clazz) {\n\t                  ^^^^^^\nThe type parameter W should not be bounded by the final type String. Final types cannot be further extended\n----------\n3. WARNING in X.java (at line 11)\n\tY y = new Y();\n\t^\nY is a raw type. References to generic type Y<V> should be parameterized\n----------\n4. WARNING in X.java (at line 11)\n\tY y = new Y();\n\t          ^\nY is a raw type. References to generic type Y<V> should be parameterized\n----------\n5. ERROR in X.java (at line 12)\n\ty.make(String.class);\n\t  ^^^^\nThe method make(Class) is ambiguous for the type Y\n----------\n6. ERROR in X.java (at line 13)\n\ty.make(getClazz());\n\t  ^^^^\nThe method make(Class) is ambiguous for the type Y\n----------\n7. ERROR in X.java (at line 14)\n\ty.make(getClazz().newInstance().getClass());\n\t  ^^^^\nThe method make(Class) is ambiguous for the type Y\n----------\n8. WARNING in X.java (at line 16)\n\tpublic static Class getClazz() {\n\t              ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static void staticFoo(Collection<?> p) {\n    System.out.print(1);\n  }\n  public static <T extends List<?>> void staticFoo(T p) {\n    System.out.print(2);\n  }\n  public void foo(Collection<?> p) {\n    System.out.print(1);\n  }\n  public <T extends List<?>> void foo(T p) {\n    System.out.print(2);\n  }\n  public void foo2(Collection<?> p) {\n    System.out.print(1);\n  }\n  public void foo2(List<?> p) {\n    System.out.print(2);\n  }\n  public static void main(String[] args) {\n    staticFoo(new ArrayList<String>(Arrays.asList(\"\")));\n    new X().foo(new ArrayList<String>(Arrays.asList(\"\")));\n    new X().foo2(new ArrayList<String>(Arrays.asList(\"\")));\n  }\n}"}, "222");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void foo(L1<?> p) {\n    System.out.println(1);\n  }\n  public static <T extends L2<?>> void foo(T p) {\n    System.out.println(2);\n  }\n  public static void main(String[] args) {\n    foo(new L3<String>());\n  }\n}", "L1.java", "public interface L1<T> {\n}", "L2.java", "public interface L2<T> extends L1<T> {\n}", "L3.java", "public class L3<T> implements L2<T> {\n  public L3() {\n  }\n}"}, "2");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  J m = new Y();  void foo() {\n    m.foo(1.0f);\n  }\n}", "I.java", "public interface I {\n  <T extends Number> T foo(final Number p);\n}", "J.java", "public interface J extends I {\n  Float foo(final Number p);\n}", "Y.java", "public class Y implements J {\n  public Float foo(final Number p){\n    return null;  }\n}"}, "");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    (new Y()).foo(1.0f);\n  }\n}", "I.java", "public interface I {\n  <T extends Number> T foo(final Number p);\n}", "J.java", "public interface J extends I {\n  Float foo(final Number p);\n}", "Y.java", "public class Y implements J {\n  public Float foo(final Number p){\n    return null;  }\n}"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"J.java", "public interface J {\n  <T extends Number> T foo(final Number p);\n  Float foo(final Number p);\n}"}, "----------\n1. ERROR in J.java (at line 2)\n\t<T extends Number> T foo(final Number p);\n\t                     ^^^^^^^^^^^^^^^^^^^\nDuplicate method foo(Number) in type J\n----------\n2. ERROR in J.java (at line 3)\n\tFloat foo(final Number p);\n\t      ^^^^^^^^^^^^^^^^^^^\nDuplicate method foo(Number) in type J\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface Irrelevant {}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends Irrelevant, I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "interface J {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "interface J {\n  Object foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "interface Irrelevant {}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends Irrelevant, I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements Irrelevant, I, J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\npublic abstract class X implements J {\n}\nabstract class XX extends Exception implements Cloneable {}"}, "");
    }

    public void test032a() {
        this.runConformTest(new String[]{"X.java", "class Z { }\nclass Y <U> extends Z { }interface I {\n  <T extends Y<T> & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\npublic abstract class X implements J {\n}\nabstract class XX extends Y<XX> implements Cloneable {}"}, "");
    }

    public void test032b() {
        this.runConformTest(new String[]{"X.java", "class A<T> { }interface I {\n  <T extends Exception & Cloneable> A<T> foo(Number n);\n}\ninterface J extends I {\n  A<XX> foo(Number n);\n}\npublic abstract class X implements J {\n}\nabstract class XX extends Exception implements Cloneable {}"}, "");
    }

    public void test032c() {
        this.runConformTest(new String[]{"X.java", "class A<T> { }interface I {\n  <T extends Exception & Cloneable> A<T> foo(Number n);\n}\ninterface J extends I {\n  <S extends XX>  A<S> foo(Number n);\n}\npublic abstract class X implements J {\n}\nabstract class XX extends Exception implements Cloneable {}"}, "");
    }

    public void test032d() {
        this.runConformTest(new String[]{"X.java", "class A<T> { }interface I {\n  A<XX> foo(Number n);\n}\ninterface J extends I {\n  <T extends Exception & Cloneable> A<T> foo(Number n);\n}\npublic abstract class X implements J {\n}\nabstract class XX extends Exception implements Cloneable {}"}, "");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\npublic abstract class X implements J {\n  void foo() {\n  }\n  public XX foo(Number n) {\n    return null;\n  }\n}\nabstract class XX extends Exception implements Cloneable {}"}, "");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\ninterface K {\n  NullPointerException foo(Number n);\n}\npublic abstract class X implements J, K {\n}\nabstract class XX extends Exception implements Cloneable {}"}, "----------\n1. WARNING in X.java (at line 5)\n\tXX foo(Number n);\n\t^^\nType safety: The return type XX for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n2. ERROR in X.java (at line 10)\n\tpublic abstract class X implements J, K {\n\t                      ^\nThe return type is incompatible with K.foo(Number), J.foo(Number)\n----------\n");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(Number n);\n}\nabstract class J {\n  abstract String foo(Number n);\n}\npublic class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n  public String foo(Number n) {\n    return null;\n  }\n}"}, "");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(Number n);\n}\nabstract class J {\n  abstract String foo(Number n);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    String s = ((J) this).foo(0.0f);\n  }\n}"}, "");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    Object o = ((I) this).foo(0.0f);\n  }\n}"}, "");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    String s = ((I) this).foo(0.0f);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = ((I) this).foo(0.0f);\n\t           ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to String\n----------\n");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}\nclass Z extends X {\n  @Override  public String foo(float f) {\n    return null;\n  }\n}"}, "");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}\nclass Z extends X {\n  @Override\n  public Object foo(float f) {\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 14)\n\tpublic Object foo(float f) {\n\t       ^^^^^^\nThe return type is incompatible with J.foo(float)\n----------\n");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "interface I<E> {}\nclass Y<E> {}\npublic class X<E extends Y<E>> implements I<E> {\n  public static <E extends Y<E>> X<E> bar(X<E> s) {\n    return null;\n  }\n  public static <E extends Y<E>> X<E> bar(I<E> c) {\n    return null;\n  }\n  public static <E extends Y<E>> X<E> foo(X<E> s) {\n    X<E> result = bar(s);\n    return result;\n  }\n}"}, "");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "abstract class Y<T> implements I<T> {\n}\ninterface I<T> { \n}\ninterface J<T> {\n}\nclass X {\n  public static <V extends J<? super V>> V foo(final I<V> a)\n  {\n    return null;\n  }\n  public static <V extends J<? super V>> V foo(final Y<V> a)\n  {\n    return null;\n  }\n  public static <V extends J<? super V>> void test(final Y<V> a)\n  {\n    foo(a);\n  }\n}"}, "");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "abstract class Y<T, U> implements I<T, U> {\n}\ninterface I<T, U> { \n}\ninterface J<T, U> {\n}\nclass X {\n  public static <V extends J<V, W>, W extends J<V, W>> V foo(final I<V, W> a)\n  {\n    return null;\n  }\n  public static <V extends J<V, W>, W extends J<V, W>> V foo(final Y<V, W> a)\n  {\n    return null;\n  }\n  public static <V extends J<V, W>, W extends J<V, W>> void test(final Y<V, W> a)\n  {\n    foo(a);\n  }\n}"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n  }\n}\ninterface I {\n  public int method();\n}\ninterface J {\n  public boolean method();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends I & J> {\n\t               ^\nThe return type is incompatible with J.method(), I.method()\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n    t.method();\n    t.bar();\n    if (t.CONSTANT > 0);\n  }\n}\ninterface I {\n  public int method();\n  void bar();\n}\ninterface J {\n  public boolean method();\n  static final int CONSTANT = 0;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends I & J> {\n\t               ^\nThe return type is incompatible with J.method(), I.method()\n----------\n2. ERROR in X.java (at line 3)\n\tt.method();\n\t  ^^^^^^\nThe method method() is ambiguous for the type T\n----------\n3. WARNING in X.java (at line 5)\n\tif (t.CONSTANT > 0);\n\t      ^^^^^^^^\nThe static field J.CONSTANT should be accessed in a static way\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  public int method();\n}\ninterface J {\n  public boolean method();\n}\nclass X implements I, J {\n  public int method() {\n    return 0;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic int method() {\n\t       ^^^\nThe return type is incompatible with J.method()\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n  }\n}\ninterface I {\n  public int method();\n}\ninterface J {\n  public int method();\n}\n"}, "");
    }
}

