/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;

public class ASTVisitorTest
extends TestCase {
    AST ast;
    SimpleName N1;
    String N1S;
    SimpleName N2;
    String N2S;
    SimpleName N3;
    String N3S;
    SimpleName N4;
    String N4S;
    Expression E1;
    String E1S;
    Expression E2;
    String E2S;
    Type T1;
    String T1S;
    Type T2;
    String T2S;
    ParameterizedType PT1;
    String PT1S;
    Statement S1;
    String S1S;
    Statement S2;
    Block B1;
    String B1S;
    String S2S;
    SingleVariableDeclaration V1;
    String V1S;
    SingleVariableDeclaration V2;
    String V2S;
    VariableDeclarationFragment W1;
    String W1S;
    VariableDeclarationFragment W2;
    String W2S;
    FieldDeclaration FD1;
    String FD1S;
    FieldDeclaration FD2;
    String FD2S;
    PackageDeclaration PD1;
    String PD1S;
    ImportDeclaration ID1;
    String ID1S;
    ImportDeclaration ID2;
    String ID2S;
    TypeDeclaration TD1;
    String TD1S;
    TypeDeclaration TD2;
    String TD2S;
    JSdoc JD1;
    String JD1S;
    TagElement TAG1;
    String TAG1S;
    TextElement TEXT1;
    String TEXT1S;
    MemberRef MBREF1;
    String MBREF1S;
    FunctionRef MTHREF1;
    String MTHREF1S;
    FunctionRefParameter MPARM1;
    String MPARM1S;
    LineComment LC1;
    String LC1S;
    BlockComment BC1;
    String BC1S;
    AnonymousClassDeclaration ACD1;
    String ACD1S;
    TypeParameter TP1;
    String TP1S;
    TypeParameter TP2;
    String TP2S;
    String MVP1S;
    String MVP2S;
    Modifier MOD1;
    String MOD1S;
    Modifier MOD2;
    String MOD2S;
    String ANO1S;
    String ANO2S;
    String EC1S;
    String EC2S;
    final StringBuffer b = new StringBuffer();
    int API_LEVEL;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTVisitorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTVisitorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> c = clazz2;
        Method[] methods = c.getMethods();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (methods[i].getName().startsWith("test")) {
                suite.addTest((Test)new ASTVisitorTest(methods[i].getName(), 2));
                suite.addTest((Test)new ASTVisitorTest(methods[i].getName(), 3));
            }
            ++i;
        }
        return suite;
    }

    public ASTVisitorTest(String name, int apiLevel) {
        super(name);
        this.API_LEVEL = apiLevel;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ast = AST.newAST((int)this.API_LEVEL);
        this.N1 = this.ast.newSimpleName("N");
        this.N1S = "[(nSNNnS)]";
        this.N2 = this.ast.newSimpleName("M");
        this.N2S = "[(nSMMnS)]";
        this.N3 = this.ast.newSimpleName("O");
        this.N3S = "[(nSOOnS)]";
        this.N4 = this.ast.newSimpleName("P");
        this.N4S = "[(nSPPnS)]";
        this.E1 = this.ast.newSimpleName("X");
        this.E1S = "[(nSXXnS)]";
        this.E2 = this.ast.newSimpleName("Y");
        this.E2S = "[(nSYYnS)]";
        this.T1 = this.ast.newSimpleType((Name)this.ast.newSimpleName("Z"));
        this.T1S = "[(tS[(nSZZnS)]tS)]";
        this.T2 = this.ast.newSimpleType((Name)this.ast.newSimpleName("X"));
        this.T2S = "[(tS[(nSXXnS)]tS)]";
        this.S1 = this.ast.newContinueStatement();
        this.S1S = "[(sCNsCN)]";
        this.S2 = this.ast.newBreakStatement();
        this.S2S = "[(sBRsBR)]";
        this.B1 = this.ast.newBlock();
        this.B1S = "[(sBsB)]";
        this.V1 = this.ast.newSingleVariableDeclaration();
        this.V1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        this.V1.setName(this.ast.newSimpleName("a"));
        this.V1S = "[(VD[(tPintinttP)][(nSaanS)]VD)]";
        this.V2 = this.ast.newSingleVariableDeclaration();
        this.V2.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BYTE));
        this.V2.setName(this.ast.newSimpleName("b"));
        this.V2S = "[(VD[(tPbytebytetP)][(nSbbnS)]VD)]";
        this.W1 = this.ast.newVariableDeclarationFragment();
        this.W1.setName(this.ast.newSimpleName("a"));
        this.W1S = "[(VS[(nSaanS)]VS)]";
        this.W2 = this.ast.newVariableDeclarationFragment();
        this.W2.setName(this.ast.newSimpleName("b"));
        this.W2S = "[(VS[(nSbbnS)]VS)]";
        VariableDeclarationFragment temp = this.ast.newVariableDeclarationFragment();
        temp.setName(this.ast.newSimpleName("f"));
        this.FD1 = this.ast.newFieldDeclaration(temp);
        this.FD1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        this.FD1S = "[(FD[(tPintinttP)][(VS[(nSffnS)]VS)]FD)]";
        temp = this.ast.newVariableDeclarationFragment();
        temp.setName(this.ast.newSimpleName("g"));
        this.FD2 = this.ast.newFieldDeclaration(temp);
        this.FD2.setType((Type)this.ast.newPrimitiveType(PrimitiveType.CHAR));
        this.FD2S = "[(FD[(tPcharchartP)][(VS[(nSggnS)]VS)]FD)]";
        this.PD1 = this.ast.newPackageDeclaration();
        this.PD1.setName((Name)this.ast.newSimpleName("p"));
        this.PD1S = "[(PD[(nSppnS)]PD)]";
        this.ID1 = this.ast.newImportDeclaration();
        this.ID1.setName((Name)this.ast.newSimpleName("i"));
        this.ID1S = "[(ID[(nSiinS)]ID)]";
        this.ID2 = this.ast.newImportDeclaration();
        this.ID2.setName((Name)this.ast.newSimpleName("j"));
        this.ID2S = "[(ID[(nSjjnS)]ID)]";
        this.TD1 = this.ast.newTypeDeclaration();
        this.TD1.setName(this.ast.newSimpleName("c"));
        this.TD1S = "[(TD[(nSccnS)]TD)]";
        this.TD2 = this.ast.newTypeDeclaration();
        this.TD2.setName(this.ast.newSimpleName("d"));
        this.TD2S = "[(TD[(nSddnS)]TD)]";
        this.ACD1 = this.ast.newAnonymousClassDeclaration();
        this.ACD1S = "[(ACDACD)]";
        this.JD1 = this.ast.newJSdoc();
        this.JD1S = "[(JDJD)]";
        this.LC1 = this.ast.newLineComment();
        this.LC1S = "[(//*//)]";
        this.BC1 = this.ast.newBlockComment();
        this.BC1S = "[(/**/)]";
        this.TAG1 = this.ast.newTagElement();
        this.TAG1.setTagName("@foo");
        this.TAG1S = "[(TG@foo@fooTG)]";
        this.TEXT1 = this.ast.newTextElement();
        this.TEXT1.setText("foo");
        this.TEXT1S = "[(TXfoofooTX)]";
        this.MBREF1 = this.ast.newMemberRef();
        this.MBREF1.setName(this.ast.newSimpleName("p"));
        this.MBREF1S = "[(MBREF[(nSppnS)]MBREF)]";
        this.MTHREF1 = this.ast.newFunctionRef();
        this.MTHREF1.setName(this.ast.newSimpleName("p"));
        this.MTHREF1S = "[(MTHREF[(nSppnS)]MTHREF)]";
        this.MPARM1 = this.ast.newFunctionRefParameter();
        this.MPARM1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.CHAR));
        this.MPARM1S = "[(MPARM[(tPcharchartP)]MPARM)]";
        if (this.ast.apiLevel() >= 3) {
            this.PT1 = this.ast.newParameterizedType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Z")));
            this.PT1S = "[(tM[(tS[(nSZZnS)]tS)]tM)]";
            this.TP1 = this.ast.newTypeParameter();
            this.TP1.setName(this.ast.newSimpleName("x"));
            this.TP1S = "[(tTP[(nSxxnS)]tTP)]";
            this.TP2 = this.ast.newTypeParameter();
            this.TP2.setName(this.ast.newSimpleName("y"));
            this.TP2S = "[(tTP[(nSyynS)]tTP)]";
            this.MOD1 = this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            this.MOD1S = "[(MODpublicpublicMOD)]";
            this.MOD2 = this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
            this.MOD2S = "[(MODfinalfinalMOD)]";
        }
    }

    protected void tearDown() throws Exception {
        this.ast = null;
        super.tearDown();
    }

    public String getName() {
        String name = super.getName();
        switch (this.API_LEVEL) {
            case 2: {
                name = "JLS2 - " + name;
                break;
            }
            case 3: {
                name = "JLS3 - " + name;
            }
        }
        return name;
    }

    public void testSimpleName() {
        Name x1 = this.ast.newName(new String[]{"Z"});
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(nSZZnS)]".equals(result));
    }

    public void testQualifiedName() {
        Name x1 = this.ast.newName(new String[]{"X", "Y"});
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(nQ[(nSXXnS)][(nSYYnS)]nQ)]".equals(result));
    }

    public void testPrimitiveType() {
        PrimitiveType x1 = this.ast.newPrimitiveType(PrimitiveType.CHAR);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(tPcharchartP)]".equals(result));
    }

    public void testSimpleType() {
        SimpleType x1 = this.ast.newSimpleType(this.ast.newName(new String[]{"Z"}));
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(tS[(nSZZnS)]tS)]".equals(result));
    }

    public void testArrayType() {
        PrimitiveType x0 = this.ast.newPrimitiveType(PrimitiveType.CHAR);
        ArrayType x1 = this.ast.newArrayType((Type)x0);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(tA[(tPcharchartP)]tA)]".equals(result));
    }

    public void testParameterizedType() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        ParameterizedType x1 = this.ast.newParameterizedType(this.T1);
        x1.typeArguments().add(this.T2);
        x1.typeArguments().add(this.PT1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(tM" + this.T1S + this.T2S + this.PT1S + "tM)]"));
    }

    public void testQualifiedType() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        QualifiedType x1 = this.ast.newQualifiedType(this.T1, this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(tQ" + this.T1S + this.N1S + "tQ)]"));
    }

    public void testWildcardType() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        WildcardType x1 = this.ast.newWildcardType();
        x1.setBound(this.T1, true);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(tW" + this.T1S + "tW)]"));
    }

    public void testArrayAccess() {
        ArrayAccess x1 = this.ast.newArrayAccess();
        x1.setArray(this.E1);
        x1.setIndex(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eAA" + this.E1S + this.E2S + "eAA)]"));
    }

    public void testArrayCreation() {
        ArrayCreation x1 = this.ast.newArrayCreation();
        x1.setType(this.ast.newArrayType(this.T1));
        x1.dimensions().add(this.E1);
        x1.dimensions().add(this.E2);
        x1.setInitializer(this.ast.newArrayInitializer());
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eAC[(tA" + this.T1S + "tA)]" + this.E1S + this.E2S + "[(eAIeAI)]eAC)]"));
    }

    public void testArrayInitializer() {
        ArrayInitializer x1 = this.ast.newArrayInitializer();
        x1.expressions().add(this.E1);
        x1.expressions().add(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eAI" + this.E1S + this.E2S + "eAI)]"));
    }

    public void testAssertStatement() {
        AssertStatement x1 = this.ast.newAssertStatement();
        x1.setExpression(this.E1);
        x1.setMessage(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sAS" + this.E1S + this.E2S + "sAS)]"));
    }

    public void testAssignment() {
        Assignment x1 = this.ast.newAssignment();
        x1.setLeftHandSide(this.E1);
        x1.setRightHandSide(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(=" + this.E1S + this.E2S + "=)]"));
    }

    public void testBlock() {
        Block x1 = this.ast.newBlock();
        x1.statements().add(this.S1);
        x1.statements().add(this.S2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sB" + this.S1S + this.S2S + "sB)]"));
        v1.setVisitingChildren(false);
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sBsB)]"));
    }

    public void testBlockComment() {
        BlockComment x1 = this.ast.newBlockComment();
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(/**/)]".equals(result));
    }

    public void testBooleanLiteral() {
        BooleanLiteral x1 = this.ast.newBooleanLiteral(true);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eBLtruetrueeBL)]"));
    }

    public void testBreakStatement() {
        BreakStatement x1 = this.ast.newBreakStatement();
        x1.setLabel(this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sBR" + this.N1S + "sBR)]"));
    }

    public void testCastExpression() {
        CastExpression x1 = this.ast.newCastExpression();
        x1.setType(this.T1);
        x1.setExpression(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eCS" + this.T1S + this.E1S + "eCS)]"));
    }

    public void testCatchClause() {
        CatchClause x1 = this.ast.newCatchClause();
        x1.setException(this.V1);
        x1.setBody(this.B1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(cc" + this.V1S + this.B1S + "cc)]"));
    }

    public void testCharacterLiteral() {
        CharacterLiteral x1 = this.ast.newCharacterLiteral();
        x1.setCharValue('q');
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eCL'q''q'eCL)]"));
    }

    public void testClassInstanceCreation() {
        ClassInstanceCreation x1 = this.ast.newClassInstanceCreation();
        x1.setExpression(this.E1);
        if (this.ast.apiLevel() == 2) {
            x1.setName((Name)this.N1);
        } else {
            x1.typeArguments().add(this.PT1);
            x1.setType(this.T1);
        }
        x1.setAnonymousClassDeclaration(this.ACD1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eCI" + this.E1S + this.N1S + this.ACD1S + "eCI)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eCI" + this.E1S + this.PT1S + this.T1S + this.ACD1S + "eCI)]"));
        }
    }

    public void testAnonymousClassDeclaration() {
        AnonymousClassDeclaration x1 = this.ast.newAnonymousClassDeclaration();
        x1.bodyDeclarations().add(this.FD1);
        x1.bodyDeclarations().add(this.FD2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(ACD" + this.FD1S + this.FD2S + "ACD)]"));
    }

    public void testCompilationUnit() {
        JavaScriptUnit x1 = this.ast.newJavaScriptUnit();
        x1.setPackage(this.PD1);
        x1.imports().add(this.ID1);
        x1.imports().add(this.ID2);
        x1.types().add(this.TD1);
        x1.types().add(this.TD2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(CU" + this.PD1S + this.ID1S + this.ID2S + this.TD1S + this.TD2S + "CU)]"));
        v1.setVisitingChildren(false);
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(CUCU)]"));
    }

    public void testConditionalExpression() {
        ConditionalExpression x1 = this.ast.newConditionalExpression();
        x1.setExpression(this.E1);
        x1.setThenExpression(this.E2);
        x1.setElseExpression((Expression)this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eCO" + this.E1S + this.E2S + this.N1S + "eCO)]"));
    }

    public void testConstructorInvocation() {
        ConstructorInvocation x1 = this.ast.newConstructorInvocation();
        if (this.ast.apiLevel() >= 3) {
            x1.typeArguments().add(this.PT1);
        }
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sCI" + this.E1S + this.E2S + "sCI)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sCI" + this.PT1S + this.E1S + this.E2S + "sCI)]"));
        }
    }

    public void testContinueStatement() {
        ContinueStatement x1 = this.ast.newContinueStatement();
        x1.setLabel(this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sCN" + this.N1S + "sCN)]"));
    }

    public void testDoStatement() {
        DoStatement x1 = this.ast.newDoStatement();
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sDO" + this.S1S + this.E1S + "sDO)]"));
    }

    public void testEmptyStatement() {
        EmptyStatement x1 = this.ast.newEmptyStatement();
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sEMsEM)]"));
    }

    public void testExpressionStatement() {
        ExpressionStatement x1 = this.ast.newExpressionStatement(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sEX" + this.E1S + "sEX)]"));
    }

    public void testFieldAccess() {
        FieldAccess x1 = this.ast.newFieldAccess();
        x1.setExpression(this.E1);
        x1.setName(this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eFA" + this.E1S + this.N1S + "eFA)]"));
    }

    public void testFieldDeclaration() {
        FieldDeclaration x1 = this.ast.newFieldDeclaration(this.W1);
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(FD" + this.JD1S + this.T1S + this.W1S + this.W2S + "FD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(FD" + this.JD1S + this.MOD1S + this.MOD2S + this.T1S + this.W1S + this.W2S + "FD)]"));
        }
    }

    public void testForStatement() {
        ForStatement x1 = this.ast.newForStatement();
        x1.initializers().add(this.E1);
        x1.initializers().add(this.E2);
        x1.setExpression((Expression)this.N1);
        x1.updaters().add(this.N2);
        x1.updaters().add(this.N3);
        x1.setBody(this.S1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sFR" + this.E1S + this.E2S + this.N1S + this.N2S + this.N3S + this.S1S + "sFR)]"));
    }

    public void testEnhancedForStatement() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        EnhancedForStatement x1 = this.ast.newEnhancedForStatement();
        x1.setParameter(this.V1);
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sEFR" + this.V1S + this.E1S + this.S1S + "sEFR)]"));
    }

    public void testIfStatement() {
        IfStatement x1 = this.ast.newIfStatement();
        x1.setExpression(this.E1);
        x1.setThenStatement(this.S1);
        x1.setElseStatement(this.S2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sIF" + this.E1S + this.S1S + this.S2S + "sIF)]"));
    }

    public void testImportDeclaration() {
        ImportDeclaration x1 = this.ast.newImportDeclaration();
        x1.setName((Name)this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(ID" + this.N1S + "ID)]"));
    }

    public void testInfixExpression() {
        InfixExpression x1 = this.ast.newInfixExpression();
        x1.setOperator(InfixExpression.Operator.PLUS);
        x1.setLeftOperand(this.E1);
        x1.setRightOperand(this.E2);
        x1.extendedOperands().add(this.N1);
        x1.extendedOperands().add(this.N2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eIN+" + this.E1S + this.E2S + this.N1S + this.N2S + "+eIN)]"));
    }

    public void testInstanceofExpression() {
        InstanceofExpression x1 = this.ast.newInstanceofExpression();
        x1.setLeftOperand(this.E1);
        x1.setRightOperand(this.T1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eIO" + this.E1S + this.T1S + "eIO)]"));
    }

    public void testInitializer() {
        Initializer x1 = this.ast.newInitializer();
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setBody(this.B1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(IN" + this.JD1S + this.B1S + "IN)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(IN" + this.JD1S + this.MOD1S + this.MOD2S + this.B1S + "IN)]"));
        }
    }

    public void testJavadoc() {
        JSdoc x1 = this.ast.newJSdoc();
        x1.tags().add(this.TAG1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(JDJD)]".equals(result));
        v1 = new TestVisitor(false);
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(JDJD)]".equals(result));
        v1 = new TestVisitor(true);
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)("[(JD" + this.TAG1S + "JD)]").equals(result));
    }

    public void testLabeledStatement() {
        LabeledStatement x1 = this.ast.newLabeledStatement();
        x1.setLabel(this.N1);
        x1.setBody(this.S1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sLA" + this.N1S + this.S1S + "sLA)]"));
    }

    public void testLineComment() {
        LineComment x1 = this.ast.newLineComment();
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(////)]".equals(result));
    }

    public void testMemberRef() {
        MemberRef x1 = this.ast.newMemberRef();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(MBREF" + this.N1S + this.N2S + "MBREF)]"));
    }

    public void testMethodDeclaration() {
        FunctionDeclaration x1 = this.ast.newFunctionDeclaration();
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() == 2) {
            x1.setReturnType(this.T1);
        } else {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
            x1.typeParameters().add(this.TP1);
            x1.setReturnType2(this.T1);
        }
        x1.setName(this.N1);
        x1.parameters().add(this.V1);
        x1.parameters().add(this.V2);
        x1.thrownExceptions().add(this.N2);
        x1.thrownExceptions().add(this.N3);
        x1.setBody(this.B1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(MD" + this.JD1S + this.T1S + this.N1S + this.V1S + this.V2S + this.N2S + this.N3S + this.B1S + "MD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(MD" + this.JD1S + this.MOD1S + this.MOD2S + this.TP1S + this.T1S + this.N1S + this.V1S + this.V2S + this.N2S + this.N3S + this.B1S + "MD)]"));
        }
    }

    public void testMethodInvocation() {
        FunctionInvocation x1 = this.ast.newFunctionInvocation();
        x1.setExpression((Expression)this.N1);
        if (this.ast.apiLevel() >= 3) {
            x1.typeArguments().add(this.PT1);
        }
        x1.setName(this.N2);
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eMI" + this.N1S + this.N2S + this.E1S + this.E2S + "eMI)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eMI" + this.N1S + this.PT1S + this.N2S + this.E1S + this.E2S + "eMI)]"));
        }
    }

    public void testMethodRef() {
        FunctionRef x1 = this.ast.newFunctionRef();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        x1.parameters().add(this.MPARM1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(MTHREF" + this.N1S + this.N2S + this.MPARM1S + "MTHREF)]"));
    }

    public void testMethodRefParameter() {
        FunctionRefParameter x1 = this.ast.newFunctionRefParameter();
        x1.setType(this.T1);
        x1.setName(this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(MPARM" + this.T1S + this.N1S + "MPARM)]"));
    }

    public void testModifier() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        Modifier x1 = this.ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(MODprivateprivateMOD)]"));
    }

    public void testNullLiteral() {
        NullLiteral x1 = this.ast.newNullLiteral();
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eNLeNL)]"));
    }

    public void testNumberLiteral() {
        NumberLiteral x1 = this.ast.newNumberLiteral("1.0");
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eNU1.01.0eNU)]"));
    }

    public void testParenthesizedExpression() {
        ParenthesizedExpression x1 = this.ast.newParenthesizedExpression();
        x1.setExpression(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(ePA" + this.E1S + "ePA)]"));
    }

    public void testPostfixExpression() {
        PostfixExpression x1 = this.ast.newPostfixExpression();
        x1.setOperand(this.E1);
        x1.setOperator(PostfixExpression.Operator.INCREMENT);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(ePO++" + this.E1S + "++ePO)]"));
    }

    public void testPrefixExpression() {
        PrefixExpression x1 = this.ast.newPrefixExpression();
        x1.setOperand(this.E1);
        x1.setOperator(PrefixExpression.Operator.INCREMENT);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(ePR++" + this.E1S + "++ePR)]"));
    }

    public void testReturnStatement() {
        ReturnStatement x1 = this.ast.newReturnStatement();
        x1.setExpression(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sRT" + this.E1S + "sRT)]"));
    }

    public void testStringLiteral() {
        StringLiteral x1 = this.ast.newStringLiteral();
        x1.setLiteralValue("H");
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eSLHHeSL)]"));
    }

    public void testSuperConstructorInvocation() {
        SuperConstructorInvocation x1 = this.ast.newSuperConstructorInvocation();
        x1.setExpression((Expression)this.N1);
        if (this.ast.apiLevel() >= 3) {
            x1.typeArguments().add(this.PT1);
        }
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sSC" + this.N1S + this.E1S + this.E2S + "sSC)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sSC" + this.N1S + this.PT1S + this.E1S + this.E2S + "sSC)]"));
        }
    }

    public void testSuperFieldAccess() {
        SuperFieldAccess x1 = this.ast.newSuperFieldAccess();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eSF" + this.N1S + this.N2S + "eSF)]"));
    }

    public void testSuperMethodInvocation() {
        SuperMethodInvocation x1 = this.ast.newSuperMethodInvocation();
        x1.setQualifier((Name)this.N1);
        if (this.ast.apiLevel() >= 3) {
            x1.typeArguments().add(this.PT1);
        }
        x1.setName(this.N2);
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eSM" + this.N1S + this.N2S + this.E1S + this.E2S + "eSM)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eSM" + this.N1S + this.PT1S + this.N2S + this.E1S + this.E2S + "eSM)]"));
        }
    }

    public void testSwitchCase() {
        SwitchCase x1 = this.ast.newSwitchCase();
        x1.setExpression(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sSC" + this.E1S + "sSC)]"));
    }

    public void testSwitchStatement() {
        SwitchStatement x1 = this.ast.newSwitchStatement();
        x1.setExpression(this.E1);
        x1.statements().add(this.S1);
        x1.statements().add(this.S2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sSW" + this.E1S + this.S1S + this.S2S + "sSW)]"));
    }

    public void testTagElement() {
        TagElement x1 = this.ast.newTagElement();
        x1.setTagName("x");
        x1.fragments().add(this.TAG1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)("[(TGx" + this.TAG1S + "xTG)]").equals(result));
    }

    public void testTextElement() {
        TextElement x1 = this.ast.newTextElement();
        x1.setText("x");
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)"[(TXxxTX)]".equals(result));
    }

    public void testThisExpression() {
        ThisExpression x1 = this.ast.newThisExpression();
        x1.setQualifier((Name)this.N1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eTH" + this.N1S + "eTH)]"));
    }

    public void testThrowStatement() {
        ThrowStatement x1 = this.ast.newThrowStatement();
        x1.setExpression(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sTR" + this.E1S + "sTR)]"));
    }

    public void testTryStatement() {
        TryStatement x1 = this.ast.newTryStatement();
        x1.setBody(this.B1);
        CatchClause c1 = this.ast.newCatchClause();
        c1.setException(this.V1);
        c1.setBody(this.ast.newBlock());
        x1.catchClauses().add(c1);
        CatchClause c2 = this.ast.newCatchClause();
        c2.setException(this.V2);
        c2.setBody(this.ast.newBlock());
        x1.catchClauses().add(c2);
        x1.setFinally(this.ast.newBlock());
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sTY" + this.B1S + "[(cc" + this.V1S + "[(sBsB)]" + "cc)]" + "[(cc" + this.V2S + "[(sBsB)]" + "cc)]" + "[(sBsB)]" + "sTY)]"));
    }

    public void testTypeDeclaration() {
        TypeDeclaration x1 = this.ast.newTypeDeclaration();
        x1.setJavadoc(this.JD1);
        x1.setName(this.N1);
        if (this.ast.apiLevel() == 2) {
            x1.setSuperclass((Name)this.N2);
            x1.superInterfaces().add(this.N3);
            x1.superInterfaces().add(this.N4);
        } else {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
            x1.typeParameters().add(this.TP1);
            x1.setSuperclassType((Type)this.PT1);
            x1.superInterfaceTypes().add(this.T1);
            x1.superInterfaceTypes().add(this.T2);
        }
        x1.bodyDeclarations().add(this.FD1);
        x1.bodyDeclarations().add(this.FD2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(TD" + this.JD1S + this.N1S + this.N2S + this.N3S + this.N4S + this.FD1S + this.FD2S + "TD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(TD" + this.JD1S + this.MOD1S + this.MOD2S + this.N1S + this.TP1S + this.PT1S + this.T1S + this.T2S + this.FD1S + this.FD2S + "TD)]"));
        }
    }

    public void testTypeDeclarationStatement() {
        TypeDeclarationStatement x1 = this.ast.newTypeDeclarationStatement(this.TD1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sTD" + this.TD1S + "sTD)]"));
    }

    public void testTypeLiteral() {
        TypeLiteral x1 = this.ast.newTypeLiteral();
        x1.setType(this.T1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(eTL" + this.T1S + "eTL)]"));
    }

    public void testSingleVariableDeclaration() {
        SingleVariableDeclaration x1 = this.ast.newSingleVariableDeclaration();
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.setName(this.N1);
        x1.setInitializer(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(VD" + this.T1S + this.N1S + this.E1S + "VD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(VD" + this.MOD1S + this.MOD2S + this.T1S + this.N1S + this.E1S + "VD)]"));
        }
    }

    public void testVariableDeclarationFragment() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        x1.setName(this.N1);
        x1.setInitializer(this.E1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(VS" + this.N1S + this.E1S + "VS)]"));
    }

    public void testVariableDeclarationExpression() {
        VariableDeclarationExpression x1 = this.ast.newVariableDeclarationExpression(this.W1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eVD" + this.T1S + this.W1S + this.W2S + "eVD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(eVD" + this.MOD1S + this.MOD2S + this.T1S + this.W1S + this.W2S + "eVD)]"));
        }
    }

    public void testVariableDeclarationStatement() {
        VariableDeclarationStatement x1 = this.ast.newVariableDeclarationStatement(this.W1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        if (this.ast.apiLevel() == 2) {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sVD" + this.T1S + this.W1S + this.W2S + "sVD)]"));
        } else {
            ASTVisitorTest.assertTrue((boolean)result.equals("[(sVD" + this.MOD1S + this.MOD2S + this.T1S + this.W1S + this.W2S + "sVD)]"));
        }
    }

    public void testWhileStatement() {
        WhileStatement x1 = this.ast.newWhileStatement();
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        TestVisitor v1 = new TestVisitor();
        this.b.setLength(0);
        x1.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[(sWH" + this.E1S + this.S1S + "sWH)]"));
    }

    public void testPrePost() {
        SimpleName n1 = this.ast.newSimpleName("a");
        SimpleName n2 = this.ast.newSimpleName("b");
        QualifiedName q = this.ast.newQualifiedName((Name)n1, n2);
        TestVisitor v1 = new TestVisitor(){

            public void preVisit(ASTNode node) {
                ASTVisitorTest.this.b.append("[");
                switch (node.getNodeType()) {
                    case 40: {
                        ASTVisitorTest.this.b.append("q");
                        break;
                    }
                    case 42: {
                        ASTVisitorTest.this.b.append(((SimpleName)node).getIdentifier());
                    }
                }
            }

            public void postVisit(ASTNode node) {
                switch (node.getNodeType()) {
                    case 40: {
                        ASTVisitorTest.this.b.append("q");
                        break;
                    }
                    case 42: {
                        ASTVisitorTest.this.b.append(((SimpleName)node).getIdentifier());
                    }
                }
                ASTVisitorTest.this.b.append("]");
            }
        };
        this.b.setLength(0);
        q.accept((ASTVisitor)v1);
        String result = this.b.toString();
        ASTVisitorTest.assertTrue((boolean)result.equals("[q(nQ[a(nSaanS)a][b(nSbbnS)b]nQ)q]"));
    }

    public void testTraverseAndModify() {
        final TypeDeclaration typeDeclaration = this.ast.newTypeDeclaration();
        typeDeclaration.setName(this.N1);
        FunctionDeclaration methodDeclaration = this.ast.newFunctionDeclaration();
        methodDeclaration.setName(this.ast.newSimpleName("M1"));
        typeDeclaration.bodyDeclarations().add(0, methodDeclaration);
        final FunctionDeclaration methodDeclaration2 = this.ast.newFunctionDeclaration();
        methodDeclaration2.setName(this.ast.newSimpleName("M2"));
        typeDeclaration.bodyDeclarations().add(1, methodDeclaration2);
        FunctionDeclaration methodDeclaration3 = this.ast.newFunctionDeclaration();
        methodDeclaration3.setName(this.ast.newSimpleName("M3"));
        typeDeclaration.bodyDeclarations().add(2, methodDeclaration3);
        TestVisitor v1 = new TestVisitor(){

            public boolean visit(FunctionDeclaration node) {
                if (node == methodDeclaration2) {
                    FunctionDeclaration methodDeclaration4 = ASTVisitorTest.this.ast.newFunctionDeclaration();
                    methodDeclaration4.setName(ASTVisitorTest.this.ast.newSimpleName("M4"));
                    typeDeclaration.bodyDeclarations().add(0, methodDeclaration4);
                }
                return super.visit(node);
            }
        };
        this.b.setLength(0);
        typeDeclaration.accept((ASTVisitor)v1);
        ASTVisitorTest.assertEquals((String)"wrong output", (String)"[(TD[(nSNNnS)][(MD[(tPvoidvoidtP)][(nSM1M1nS)]MD)][(MD[(tPvoidvoidtP)][(nSM2M2nS)]MD)][(MD[(tPvoidvoidtP)][(nSM3M3nS)]MD)]TD)]", (String)this.b.toString());
    }

    public void testTraverseAndModify_2() {
        final TypeDeclaration typeDeclaration = this.ast.newTypeDeclaration();
        typeDeclaration.setName(this.N1);
        FunctionDeclaration methodDeclaration = this.ast.newFunctionDeclaration();
        methodDeclaration.setName(this.ast.newSimpleName("M1"));
        typeDeclaration.bodyDeclarations().add(0, methodDeclaration);
        final FunctionDeclaration methodDeclaration2 = this.ast.newFunctionDeclaration();
        methodDeclaration2.setName(this.ast.newSimpleName("M2"));
        typeDeclaration.bodyDeclarations().add(1, methodDeclaration2);
        FunctionDeclaration methodDeclaration3 = this.ast.newFunctionDeclaration();
        methodDeclaration3.setName(this.ast.newSimpleName("M3"));
        typeDeclaration.bodyDeclarations().add(2, methodDeclaration3);
        TestVisitor v1 = new TestVisitor(){

            public boolean visit(FunctionDeclaration node) {
                if (node == methodDeclaration2) {
                    FunctionDeclaration methodDeclaration4 = ASTVisitorTest.this.ast.newFunctionDeclaration();
                    methodDeclaration4.setName(ASTVisitorTest.this.ast.newSimpleName("M4"));
                    typeDeclaration.bodyDeclarations().add(3, methodDeclaration4);
                }
                return super.visit(node);
            }
        };
        this.b.setLength(0);
        typeDeclaration.accept((ASTVisitor)v1);
        ASTVisitorTest.assertEquals((String)"wrong output", (String)"[(TD[(nSNNnS)][(MD[(tPvoidvoidtP)][(nSM1M1nS)]MD)][(MD[(tPvoidvoidtP)][(nSM2M2nS)]MD)][(MD[(tPvoidvoidtP)][(nSM3M3nS)]MD)][(MD[(tPvoidvoidtP)][(nSM4M4nS)]MD)]TD)]", (String)this.b.toString());
    }

    public void testTraverseAndModify_3() {
        final InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        TestVisitor v1 = new TestVisitor(){

            public boolean visit(SimpleName node) {
                infixExpression.setRightOperand((Expression)ASTVisitorTest.this.ast.newNumberLiteral("22"));
                return super.visit(node);
            }
        };
        this.b.setLength(0);
        infixExpression.accept((ASTVisitor)v1);
        ASTVisitorTest.assertEquals((String)"wrong output", (String)"[(eIN+[(nSiinS)][(eNU2222eNU)]+eIN)]", (String)this.b.toString());
    }

    public void testTraverseAndModify_4() {
        final InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        TestVisitor v1 = new TestVisitor(){

            public boolean visit(NumberLiteral node) {
                infixExpression.setLeftOperand((Expression)ASTVisitorTest.this.ast.newSimpleName("j"));
                return super.visit(node);
            }
        };
        this.b.setLength(0);
        infixExpression.accept((ASTVisitor)v1);
        ASTVisitorTest.assertEquals((String)"wrong output", (String)"[(eIN+[(nSiinS)][(eNU1010eNU)]+eIN)]", (String)this.b.toString());
    }

    class TestVisitor
    extends ASTVisitor {
        boolean visitTheKids = true;
        boolean visitDocTags;

        TestVisitor() {
            this(false);
        }

        TestVisitor(boolean visitDocTags) {
            super(visitDocTags);
            this.visitDocTags = visitDocTags;
        }

        public boolean isVisitingChildren() {
            return this.visitTheKids;
        }

        public void setVisitingChildren(boolean visitChildren) {
            this.visitTheKids = visitChildren;
        }

        public boolean visit(SimpleName node) {
            ASTVisitorTest.this.b.append("(nS");
            ASTVisitorTest.this.b.append(node.getIdentifier());
            return this.isVisitingChildren();
        }

        public void endVisit(SimpleName node) {
            ASTVisitorTest.this.b.append(node.getIdentifier());
            ASTVisitorTest.this.b.append("nS)");
        }

        public boolean visit(QualifiedName node) {
            ASTVisitorTest.this.b.append("(nQ");
            return this.isVisitingChildren();
        }

        public void endVisit(QualifiedName node) {
            ASTVisitorTest.this.b.append("nQ)");
        }

        public boolean visit(SimpleType node) {
            ASTVisitorTest.this.b.append("(tS");
            return this.isVisitingChildren();
        }

        public void endVisit(SimpleType node) {
            ASTVisitorTest.this.b.append("tS)");
        }

        public boolean visit(ArrayType node) {
            ASTVisitorTest.this.b.append("(tA");
            return this.isVisitingChildren();
        }

        public void endVisit(ArrayType node) {
            ASTVisitorTest.this.b.append("tA)");
        }

        public boolean visit(PrimitiveType node) {
            ASTVisitorTest.this.b.append("(tP");
            ASTVisitorTest.this.b.append(node.getPrimitiveTypeCode().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(PrimitiveType node) {
            ASTVisitorTest.this.b.append(node.getPrimitiveTypeCode().toString());
            ASTVisitorTest.this.b.append("tP)");
        }

        public boolean visit(ParameterizedType node) {
            ASTVisitorTest.this.b.append("(tM");
            return this.isVisitingChildren();
        }

        public void endVisit(ParameterizedType node) {
            ASTVisitorTest.this.b.append("tM)");
        }

        public boolean visit(QualifiedType node) {
            ASTVisitorTest.this.b.append("(tQ");
            return this.isVisitingChildren();
        }

        public void endVisit(QualifiedType node) {
            ASTVisitorTest.this.b.append("tQ)");
        }

        public boolean visit(WildcardType node) {
            ASTVisitorTest.this.b.append("(tW");
            return this.isVisitingChildren();
        }

        public void endVisit(WildcardType node) {
            ASTVisitorTest.this.b.append("tW)");
        }

        public boolean visit(ArrayAccess node) {
            ASTVisitorTest.this.b.append("(eAA");
            return this.isVisitingChildren();
        }

        public void endVisit(ArrayAccess node) {
            ASTVisitorTest.this.b.append("eAA)");
        }

        public boolean visit(ArrayCreation node) {
            ASTVisitorTest.this.b.append("(eAC");
            return this.isVisitingChildren();
        }

        public void endVisit(ArrayCreation node) {
            ASTVisitorTest.this.b.append("eAC)");
        }

        public boolean visit(ArrayInitializer node) {
            ASTVisitorTest.this.b.append("(eAI");
            return this.isVisitingChildren();
        }

        public void endVisit(ArrayInitializer node) {
            ASTVisitorTest.this.b.append("eAI)");
        }

        public boolean visit(AssertStatement node) {
            ASTVisitorTest.this.b.append("(sAS");
            return this.isVisitingChildren();
        }

        public void endVisit(AssertStatement node) {
            ASTVisitorTest.this.b.append("sAS)");
        }

        public boolean visit(Assignment node) {
            ASTVisitorTest.this.b.append("(");
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(Assignment node) {
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            ASTVisitorTest.this.b.append(")");
        }

        public boolean visit(Block node) {
            ASTVisitorTest.this.b.append("(sB");
            return this.isVisitingChildren();
        }

        public void endVisit(Block node) {
            ASTVisitorTest.this.b.append("sB)");
        }

        public boolean visit(BooleanLiteral node) {
            ASTVisitorTest.this.b.append("(eBL");
            ASTVisitorTest.this.b.append(node.booleanValue() ? "true" : "false");
            return this.isVisitingChildren();
        }

        public void endVisit(BooleanLiteral node) {
            ASTVisitorTest.this.b.append(node.booleanValue() ? "true" : "false");
            ASTVisitorTest.this.b.append("eBL)");
        }

        public boolean visit(BreakStatement node) {
            ASTVisitorTest.this.b.append("(sBR");
            return this.isVisitingChildren();
        }

        public void endVisit(BreakStatement node) {
            ASTVisitorTest.this.b.append("sBR)");
        }

        public boolean visit(CastExpression node) {
            ASTVisitorTest.this.b.append("(eCS");
            return this.isVisitingChildren();
        }

        public void endVisit(CastExpression node) {
            ASTVisitorTest.this.b.append("eCS)");
        }

        public boolean visit(CatchClause node) {
            ASTVisitorTest.this.b.append("(cc");
            return this.isVisitingChildren();
        }

        public void endVisit(CatchClause node) {
            ASTVisitorTest.this.b.append("cc)");
        }

        public boolean visit(CharacterLiteral node) {
            ASTVisitorTest.this.b.append("(eCL");
            ASTVisitorTest.this.b.append(node.getEscapedValue());
            return this.isVisitingChildren();
        }

        public void endVisit(CharacterLiteral node) {
            ASTVisitorTest.this.b.append(node.getEscapedValue());
            ASTVisitorTest.this.b.append("eCL)");
        }

        public boolean visit(ClassInstanceCreation node) {
            ASTVisitorTest.this.b.append("(eCI");
            return this.isVisitingChildren();
        }

        public void endVisit(ClassInstanceCreation node) {
            ASTVisitorTest.this.b.append("eCI)");
        }

        public boolean visit(AnonymousClassDeclaration node) {
            ASTVisitorTest.this.b.append("(ACD");
            return this.isVisitingChildren();
        }

        public void endVisit(AnonymousClassDeclaration node) {
            ASTVisitorTest.this.b.append("ACD)");
        }

        public boolean visit(JavaScriptUnit node) {
            ASTVisitorTest.this.b.append("(CU");
            return this.isVisitingChildren();
        }

        public void endVisit(JavaScriptUnit node) {
            ASTVisitorTest.this.b.append("CU)");
        }

        public boolean visit(ConditionalExpression node) {
            ASTVisitorTest.this.b.append("(eCO");
            return this.isVisitingChildren();
        }

        public void endVisit(ConditionalExpression node) {
            ASTVisitorTest.this.b.append("eCO)");
        }

        public boolean visit(ConstructorInvocation node) {
            ASTVisitorTest.this.b.append("(sCI");
            return this.isVisitingChildren();
        }

        public void endVisit(ConstructorInvocation node) {
            ASTVisitorTest.this.b.append("sCI)");
        }

        public boolean visit(ContinueStatement node) {
            ASTVisitorTest.this.b.append("(sCN");
            return this.isVisitingChildren();
        }

        public void endVisit(ContinueStatement node) {
            ASTVisitorTest.this.b.append("sCN)");
        }

        public boolean visit(DoStatement node) {
            ASTVisitorTest.this.b.append("(sDO");
            return this.isVisitingChildren();
        }

        public void endVisit(DoStatement node) {
            ASTVisitorTest.this.b.append("sDO)");
        }

        public boolean visit(EmptyStatement node) {
            ASTVisitorTest.this.b.append("(sEM");
            return this.isVisitingChildren();
        }

        public void endVisit(EmptyStatement node) {
            ASTVisitorTest.this.b.append("sEM)");
        }

        public boolean visit(EnhancedForStatement node) {
            ASTVisitorTest.this.b.append("(sEFR");
            return this.isVisitingChildren();
        }

        public void endVisit(EnhancedForStatement node) {
            ASTVisitorTest.this.b.append("sEFR)");
        }

        public boolean visit(ExpressionStatement node) {
            ASTVisitorTest.this.b.append("(sEX");
            return this.isVisitingChildren();
        }

        public void endVisit(ExpressionStatement node) {
            ASTVisitorTest.this.b.append("sEX)");
        }

        public boolean visit(FieldAccess node) {
            ASTVisitorTest.this.b.append("(eFA");
            return this.isVisitingChildren();
        }

        public void endVisit(FieldAccess node) {
            ASTVisitorTest.this.b.append("eFA)");
        }

        public boolean visit(FieldDeclaration node) {
            ASTVisitorTest.this.b.append("(FD");
            return this.isVisitingChildren();
        }

        public void endVisit(FieldDeclaration node) {
            ASTVisitorTest.this.b.append("FD)");
        }

        public boolean visit(ForStatement node) {
            ASTVisitorTest.this.b.append("(sFR");
            return this.isVisitingChildren();
        }

        public void endVisit(ForStatement node) {
            ASTVisitorTest.this.b.append("sFR)");
        }

        public boolean visit(IfStatement node) {
            ASTVisitorTest.this.b.append("(sIF");
            return this.isVisitingChildren();
        }

        public void endVisit(IfStatement node) {
            ASTVisitorTest.this.b.append("sIF)");
        }

        public boolean visit(ImportDeclaration node) {
            ASTVisitorTest.this.b.append("(ID");
            return this.isVisitingChildren();
        }

        public void endVisit(ImportDeclaration node) {
            ASTVisitorTest.this.b.append("ID)");
        }

        public boolean visit(InfixExpression node) {
            ASTVisitorTest.this.b.append("(eIN");
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(InfixExpression node) {
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            ASTVisitorTest.this.b.append("eIN)");
        }

        public boolean visit(InstanceofExpression node) {
            ASTVisitorTest.this.b.append("(eIO");
            return this.isVisitingChildren();
        }

        public void endVisit(InstanceofExpression node) {
            ASTVisitorTest.this.b.append("eIO)");
        }

        public boolean visit(Initializer node) {
            ASTVisitorTest.this.b.append("(IN");
            return this.isVisitingChildren();
        }

        public void endVisit(Initializer node) {
            ASTVisitorTest.this.b.append("IN)");
        }

        public boolean visit(JSdoc node) {
            ASTVisitorTest.this.b.append("(JD");
            if (this.visitDocTags) {
                ASTVisitorTest.assertTrue((boolean)super.visit(node));
            } else {
                ASTVisitorTest.assertTrue((!super.visit(node) ? 1 : 0) != 0);
            }
            return this.isVisitingChildren() && super.visit(node);
        }

        public void endVisit(JSdoc node) {
            ASTVisitorTest.this.b.append("JD)");
        }

        public boolean visit(BlockComment node) {
            ASTVisitorTest.this.b.append("(/*");
            return this.isVisitingChildren();
        }

        public void endVisit(BlockComment node) {
            ASTVisitorTest.this.b.append("*/)");
        }

        public boolean visit(LineComment node) {
            ASTVisitorTest.this.b.append("(//");
            return this.isVisitingChildren();
        }

        public void endVisit(LineComment node) {
            ASTVisitorTest.this.b.append("//)");
        }

        public boolean visit(TagElement node) {
            ASTVisitorTest.this.b.append("(TG");
            ASTVisitorTest.this.b.append(node.getTagName());
            return this.isVisitingChildren();
        }

        public void endVisit(TagElement node) {
            ASTVisitorTest.this.b.append(node.getTagName());
            ASTVisitorTest.this.b.append("TG)");
        }

        public boolean visit(TextElement node) {
            ASTVisitorTest.this.b.append("(TX");
            ASTVisitorTest.this.b.append(node.getText());
            return this.isVisitingChildren();
        }

        public void endVisit(TextElement node) {
            ASTVisitorTest.this.b.append(node.getText());
            ASTVisitorTest.this.b.append("TX)");
        }

        public boolean visit(MemberRef node) {
            ASTVisitorTest.this.b.append("(MBREF");
            return this.isVisitingChildren();
        }

        public void endVisit(MemberRef node) {
            ASTVisitorTest.this.b.append("MBREF)");
        }

        public boolean visit(FunctionRef node) {
            ASTVisitorTest.this.b.append("(MTHREF");
            return this.isVisitingChildren();
        }

        public void endVisit(FunctionRef node) {
            ASTVisitorTest.this.b.append("MTHREF)");
        }

        public boolean visit(FunctionRefParameter node) {
            ASTVisitorTest.this.b.append("(MPARM");
            return this.isVisitingChildren();
        }

        public void endVisit(FunctionRefParameter node) {
            ASTVisitorTest.this.b.append("MPARM)");
        }

        public boolean visit(LabeledStatement node) {
            ASTVisitorTest.this.b.append("(sLA");
            return this.isVisitingChildren();
        }

        public void endVisit(LabeledStatement node) {
            ASTVisitorTest.this.b.append("sLA)");
        }

        public boolean visit(FunctionDeclaration node) {
            ASTVisitorTest.this.b.append("(MD");
            return this.isVisitingChildren();
        }

        public void endVisit(FunctionDeclaration node) {
            ASTVisitorTest.this.b.append("MD)");
        }

        public boolean visit(FunctionInvocation node) {
            ASTVisitorTest.this.b.append("(eMI");
            return this.isVisitingChildren();
        }

        public void endVisit(FunctionInvocation node) {
            ASTVisitorTest.this.b.append("eMI)");
        }

        public boolean visit(NullLiteral node) {
            ASTVisitorTest.this.b.append("(eNL");
            return this.isVisitingChildren();
        }

        public void endVisit(NullLiteral node) {
            ASTVisitorTest.this.b.append("eNL)");
        }

        public boolean visit(NumberLiteral node) {
            ASTVisitorTest.this.b.append("(eNU");
            ASTVisitorTest.this.b.append(node.getToken());
            return this.isVisitingChildren();
        }

        public void endVisit(NumberLiteral node) {
            ASTVisitorTest.this.b.append(node.getToken());
            ASTVisitorTest.this.b.append("eNU)");
        }

        public boolean visit(PackageDeclaration node) {
            ASTVisitorTest.this.b.append("(PD");
            return this.isVisitingChildren();
        }

        public void endVisit(PackageDeclaration node) {
            ASTVisitorTest.this.b.append("PD)");
        }

        public boolean visit(ParenthesizedExpression node) {
            ASTVisitorTest.this.b.append("(ePA");
            return this.isVisitingChildren();
        }

        public void endVisit(ParenthesizedExpression node) {
            ASTVisitorTest.this.b.append("ePA)");
        }

        public boolean visit(PostfixExpression node) {
            ASTVisitorTest.this.b.append("(ePO");
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(PostfixExpression node) {
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            ASTVisitorTest.this.b.append("ePO)");
        }

        public boolean visit(PrefixExpression node) {
            ASTVisitorTest.this.b.append("(ePR");
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(PrefixExpression node) {
            ASTVisitorTest.this.b.append(node.getOperator().toString());
            ASTVisitorTest.this.b.append("ePR)");
        }

        public boolean visit(ReturnStatement node) {
            ASTVisitorTest.this.b.append("(sRT");
            return this.isVisitingChildren();
        }

        public void endVisit(ReturnStatement node) {
            ASTVisitorTest.this.b.append("sRT)");
        }

        public boolean visit(SingleVariableDeclaration node) {
            ASTVisitorTest.this.b.append("(VD");
            return this.isVisitingChildren();
        }

        public void endVisit(SingleVariableDeclaration node) {
            ASTVisitorTest.this.b.append("VD)");
        }

        public boolean visit(StringLiteral node) {
            ASTVisitorTest.this.b.append("(eSL");
            ASTVisitorTest.this.b.append(node.getLiteralValue());
            return this.isVisitingChildren();
        }

        public void endVisit(StringLiteral node) {
            ASTVisitorTest.this.b.append(node.getLiteralValue());
            ASTVisitorTest.this.b.append("eSL)");
        }

        public boolean visit(SuperConstructorInvocation node) {
            ASTVisitorTest.this.b.append("(sSC");
            return this.isVisitingChildren();
        }

        public void endVisit(SuperConstructorInvocation node) {
            ASTVisitorTest.this.b.append("sSC)");
        }

        public boolean visit(SuperFieldAccess node) {
            ASTVisitorTest.this.b.append("(eSF");
            return this.isVisitingChildren();
        }

        public void endVisit(SuperFieldAccess node) {
            ASTVisitorTest.this.b.append("eSF)");
        }

        public boolean visit(SuperMethodInvocation node) {
            ASTVisitorTest.this.b.append("(eSM");
            return this.isVisitingChildren();
        }

        public void endVisit(SuperMethodInvocation node) {
            ASTVisitorTest.this.b.append("eSM)");
        }

        public boolean visit(SwitchCase node) {
            ASTVisitorTest.this.b.append("(sSC");
            return this.isVisitingChildren();
        }

        public void endVisit(SwitchCase node) {
            ASTVisitorTest.this.b.append("sSC)");
        }

        public boolean visit(SwitchStatement node) {
            ASTVisitorTest.this.b.append("(sSW");
            return this.isVisitingChildren();
        }

        public void endVisit(SwitchStatement node) {
            ASTVisitorTest.this.b.append("sSW)");
        }

        public boolean visit(ThisExpression node) {
            ASTVisitorTest.this.b.append("(eTH");
            return this.isVisitingChildren();
        }

        public void endVisit(ThisExpression node) {
            ASTVisitorTest.this.b.append("eTH)");
        }

        public boolean visit(ThrowStatement node) {
            ASTVisitorTest.this.b.append("(sTR");
            return this.isVisitingChildren();
        }

        public void endVisit(ThrowStatement node) {
            ASTVisitorTest.this.b.append("sTR)");
        }

        public boolean visit(TryStatement node) {
            ASTVisitorTest.this.b.append("(sTY");
            return this.isVisitingChildren();
        }

        public void endVisit(TryStatement node) {
            ASTVisitorTest.this.b.append("sTY)");
        }

        public boolean visit(TypeDeclaration node) {
            ASTVisitorTest.this.b.append("(TD");
            return this.isVisitingChildren();
        }

        public void endVisit(TypeDeclaration node) {
            ASTVisitorTest.this.b.append("TD)");
        }

        public boolean visit(TypeDeclarationStatement node) {
            ASTVisitorTest.this.b.append("(sTD");
            return this.isVisitingChildren();
        }

        public void endVisit(TypeDeclarationStatement node) {
            ASTVisitorTest.this.b.append("sTD)");
        }

        public boolean visit(TypeLiteral node) {
            ASTVisitorTest.this.b.append("(eTL");
            return this.isVisitingChildren();
        }

        public void endVisit(TypeLiteral node) {
            ASTVisitorTest.this.b.append("eTL)");
        }

        public boolean visit(TypeParameter node) {
            ASTVisitorTest.this.b.append("(tTP");
            return this.isVisitingChildren();
        }

        public void endVisit(TypeParameter node) {
            ASTVisitorTest.this.b.append("tTP)");
        }

        public boolean visit(VariableDeclarationExpression node) {
            ASTVisitorTest.this.b.append("(eVD");
            return this.isVisitingChildren();
        }

        public void endVisit(VariableDeclarationExpression node) {
            ASTVisitorTest.this.b.append("eVD)");
        }

        public boolean visit(VariableDeclarationFragment node) {
            ASTVisitorTest.this.b.append("(VS");
            return this.isVisitingChildren();
        }

        public void endVisit(VariableDeclarationFragment node) {
            ASTVisitorTest.this.b.append("VS)");
        }

        public boolean visit(VariableDeclarationStatement node) {
            ASTVisitorTest.this.b.append("(sVD");
            return this.isVisitingChildren();
        }

        public void endVisit(VariableDeclarationStatement node) {
            ASTVisitorTest.this.b.append("sVD)");
        }

        public boolean visit(WhileStatement node) {
            ASTVisitorTest.this.b.append("(sWH");
            return this.isVisitingChildren();
        }

        public void endVisit(WhileStatement node) {
            ASTVisitorTest.this.b.append("sWH)");
        }

        public boolean visit(Modifier node) {
            ASTVisitorTest.this.b.append("(MOD");
            ASTVisitorTest.this.b.append(node.getKeyword().toString());
            return this.isVisitingChildren();
        }

        public void endVisit(Modifier node) {
            ASTVisitorTest.this.b.append(node.getKeyword().toString());
            ASTVisitorTest.this.b.append("MOD)");
        }

        public void preVisit(ASTNode node) {
            ASTVisitorTest.this.b.append("[");
        }

        public void postVisit(ASTNode node) {
            ASTVisitorTest.this.b.append("]");
        }
    }
}

