/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;

class BindingsCollectorVisitor
extends ASTVisitor {
    private HashMap hashMap = new HashMap();
    private HashSet set = new HashSet();

    BindingsCollectorVisitor() {
        super(true);
    }

    private void collectBindings(ASTNode node, IBinding binding) {
        if (binding != null) {
            this.hashMap.put(node, binding);
        } else {
            this.set.add(node);
        }
    }

    public void endVisit(AnonymousClassDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ArrayAccess node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ArrayCreation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ArrayInitializer node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ArrayType node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(Assignment node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(BooleanLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(CastExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(CharacterLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ConditionalExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ConstructorInvocation node) {
        IFunctionBinding methodBinding = node.resolveConstructorBinding();
        this.collectBindings((ASTNode)node, (IBinding)methodBinding);
    }

    public void endVisit(FieldAccess node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ImportDeclaration node) {
        IBinding binding = node.resolveBinding();
        this.collectBindings((ASTNode)node, binding);
    }

    public void endVisit(InfixExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(InstanceofExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(MemberRef node) {
        IBinding binding = node.resolveBinding();
        this.collectBindings((ASTNode)node, binding);
    }

    public void endVisit(ListExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(FunctionDeclaration node) {
        IFunctionBinding methodBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)methodBinding);
    }

    public void endVisit(FunctionInvocation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(FunctionRef node) {
        IBinding binding = node.resolveBinding();
        this.collectBindings((ASTNode)node, binding);
    }

    public void endVisit(NullLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(NumberLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(PackageDeclaration node) {
        IPackageBinding packageBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)packageBinding);
    }

    public void endVisit(ParameterizedType node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ParenthesizedExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(PostfixExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(PrefixExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(PrimitiveType node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        this.collectBindings((ASTNode)node, binding);
    }

    public void endVisit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        this.collectBindings((ASTNode)node, binding);
    }

    public void endVisit(SimpleType node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(SingleVariableDeclaration node) {
        IVariableBinding variableBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)variableBinding);
    }

    public void endVisit(StringLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(SuperConstructorInvocation node) {
        IFunctionBinding methodBinding = node.resolveConstructorBinding();
        this.collectBindings((ASTNode)node, (IBinding)methodBinding);
    }

    public void endVisit(SuperFieldAccess node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(SuperMethodInvocation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(ThisExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(TypeDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(TypeLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(VariableDeclarationExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        this.collectBindings((ASTNode)node, (IBinding)typeBinding);
    }

    public void endVisit(VariableDeclarationFragment node) {
        IVariableBinding variableBinding = node.resolveBinding();
        this.collectBindings((ASTNode)node, (IBinding)variableBinding);
    }

    public HashMap getBindingsMap() {
        return this.hashMap;
    }

    public HashSet getUnresolvedNodesSet() {
        return this.set;
    }
}

