/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DecodeCodeFormatterPreferences
extends DefaultHandler {
    private boolean record;
    private Map entries;
    private String profileName;

    public static Map decodeCodeFormatterOptions(String fileName) {
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
            HashMap<Object, Object> options = new HashMap<Object, Object>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(line, "=");
                options.put(stringTokenizer.nextElement(), stringTokenizer.nextElement());
            }
            reader.close();
            return options;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Map decodeCodeFormatterOptions(String fileName, String profileName) {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            DecodeCodeFormatterPreferences preferences = new DecodeCodeFormatterPreferences(profileName);
            saxParser.parse(new File(fileName), (DefaultHandler)preferences);
            return preferences.getEntries();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map decodeCodeFormatterOptions(String zipFileName, String zipEntryName, String profileName) {
        ZipFile zipFile = null;
        BufferedInputStream inputStream = null;
        try {
            block18: {
                zipFile = new ZipFile(zipFileName);
                ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
                if (zipEntry == null) {
                    Object var8_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (zipFile == null) return null;
                        zipFile.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                DecodeCodeFormatterPreferences preferences = new DecodeCodeFormatterPreferences(profileName);
                saxParser.parse((InputStream)inputStream, (DefaultHandler)preferences);
                Map map = preferences.getEntries();
                Object var8_11 = null;
                try {}
                catch (IOException iOException) {}
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipFile == null) return map;
                zipFile.close();
                return map;
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    break block18;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    break block18;
                }
                catch (FactoryConfigurationError e) {
                    e.printStackTrace();
                    break block18;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {}
            catch (IOException iOException) {}
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (zipFile == null) return null;
        zipFile.close();
        return null;
    }

    DecodeCodeFormatterPreferences(String profileName) {
        this.profileName = profileName;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int attributesLength = attributes.getLength();
        if ("profile".equals(qName)) {
            int i = 0;
            while (i < attributesLength) {
                if ("name".equals(attributes.getQName(i)) && this.profileName.equals(attributes.getValue(i))) {
                    this.record = true;
                    this.entries = new HashMap();
                    break;
                }
                ++i;
            }
        } else if ("setting".equals(qName) && this.record && attributesLength == 2) {
            this.entries.put(attributes.getValue(0), attributes.getValue(1));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("profile".equals(qName) && this.record) {
            this.record = false;
        }
    }

    public Map getEntries() {
        return this.entries;
    }
}

