/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import junit.framework.ComparisonFailure;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.CompletionTestsRequestor2;
import org.eclipse.wst.jsdt.internal.codeassist.RelevanceConstants;

public abstract class AbstractJavaModelCompletionTests
extends AbstractJavaModelTests
implements RelevanceConstants {
    public static List COMPLETION_SUITES = null;
    protected static IJavaScriptProject COMPLETION_PROJECT;
    Hashtable oldOptions;
    IJavaScriptUnit wc = null;

    public AbstractJavaModelCompletionTests(String name) {
        super(name);
    }

    protected void addLibrary(String projectName, String jarName, String sourceZipName, String docZipName, boolean exported) throws JavaScriptModelException {
        IJavaScriptProject javaProject = this.getJavaProject(projectName);
        IProject project = javaProject.getProject();
        String projectPath = String.valueOf('/') + project.getName() + '/';
        IIncludePathAttribute[] extraAttributes = docZipName == null ? new IIncludePathAttribute[]{} : new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"javadoc_location", (String)("jar:platform:/resource" + projectPath + docZipName + "!/"))};
        this.addLibraryEntry(javaProject, (IPath)new Path(String.valueOf(projectPath) + jarName), (IPath)(sourceZipName == null ? null : new Path(String.valueOf(projectPath) + sourceZipName)), (IPath)(sourceZipName == null ? null : new Path("")), null, null, extraAttributes, exported);
    }

    protected void removeLibrary(String projectName, String jarName) throws CoreException, IOException {
        IJavaScriptProject javaProject = this.getJavaProject(projectName);
        IProject project = javaProject.getProject();
        String projectPath = String.valueOf('/') + project.getName() + '/';
        this.removeLibraryEntry(javaProject, new Path(String.valueOf(projectPath) + jarName));
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source) throws JavaScriptModelException {
        return super.getWorkingCopy(path, source, this.wcOwner, null);
    }

    protected CompletionResult complete(String path, String source, String completeBehind) throws JavaScriptModelException {
        return this.complete(path, source, false, completeBehind);
    }

    protected CompletionResult complete(String path, String source, boolean showPositions, String completeBehind) throws JavaScriptModelException {
        return this.complete(path, source, showPositions, completeBehind, null, null);
    }

    protected CompletionResult complete(String path, String source, boolean showPositions, String completeBehind, String tokenStartBehind, String token) throws JavaScriptModelException {
        this.wc = this.getWorkingCopy(path, source);
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(true, false, showPositions);
        String str = this.wc.getSource();
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        int tokenStart = -1;
        int tokenEnd = -1;
        if (tokenStartBehind != null && token != null) {
            tokenStart = str.lastIndexOf(tokenStartBehind) + tokenStartBehind.length();
            tokenEnd = tokenStart + token.length() - 1;
        }
        this.wc.codeComplete(cursorLocation, (CompletionRequestor)requestor, this.wcOwner);
        CompletionResult result = new CompletionResult();
        result.proposals = requestor.getResults();
        result.context = requestor.getContext();
        result.cursorLocation = cursorLocation;
        result.tokenStart = tokenStart;
        result.tokenEnd = tokenEnd;
        return result;
    }

    protected CompletionResult contextComplete(IJavaScriptUnit cu, int cursorLocation) throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(true, false, false, false);
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor, this.wcOwner);
        CompletionResult result = new CompletionResult();
        result.proposals = requestor.getResults();
        result.context = requestor.getContext();
        result.cursorLocation = cursorLocation;
        return result;
    }

    protected CompletionResult snippetContextComplete(IType type, String snippet, int insertion, int cursorLocation, boolean isStatic) throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(true, false, false, false);
        type.codeComplete(snippet.toCharArray(), insertion, cursorLocation, null, null, null, isStatic, (CompletionRequestor)requestor, this.wcOwner);
        CompletionResult result = new CompletionResult();
        result.proposals = requestor.getResults();
        result.context = requestor.getContext();
        result.cursorLocation = cursorLocation;
        return result;
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.oldOptions = JavaScriptCore.getOptions();
        AbstractJavaModelCompletionTests.waitUntilIndexesReady();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wcOwner = new WorkingCopyOwner(){};
    }

    public void tearDownSuite() throws Exception {
        JavaScriptCore.setOptions((Hashtable)this.oldOptions);
        this.oldOptions = null;
        if (COMPLETION_SUITES == null) {
            this.deleteProject("Completion");
        } else {
            COMPLETION_SUITES.remove(((Object)((Object)this)).getClass());
            if (COMPLETION_SUITES.size() == 0) {
                this.deleteProject("Completion");
                COMPLETION_SUITES = null;
            }
        }
        super.tearDownSuite();
    }

    protected void tearDown() throws Exception {
        if (this.wc != null) {
            this.wc.discardWorkingCopy();
            this.wc = null;
        }
        super.tearDown();
    }

    protected void assertResults(String expected, String actual) {
        try {
            AbstractJavaModelCompletionTests.assertEquals((String)expected, (String)actual);
        }
        catch (ComparisonFailure c) {
            System.out.println(actual);
            System.out.println();
            throw c;
        }
    }

    protected class CompletionResult {
        public String proposals;
        public String context;
        public int cursorLocation;
        public int tokenStart;
        public int tokenEnd;

        protected CompletionResult() {
        }
    }
}

