/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class AttachSourceTests
extends ModifyingResourceTests {
    private static final int AST_INTERNAL_JLS2 = 2;
    private IPackageFragmentRoot pkgFragmentRoot;
    private IType genericType;
    private IPackageFragment innerClasses;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.AttachSourceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return AttachSourceTests.buildModelTestSuite(clazz);
    }

    public AttachSourceTests(String name) {
        super(name);
    }

    public ASTNode runConversion(IClassFile classFile, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(classFile);
        parser.setResolveBindings(resolveBindings);
        parser.setWorkingCopyOwner(null);
        return parser.createAST(null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.attachSource(this.pkgFragmentRoot, "/AttachSourceTests/attachsrc.zip", "");
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("AttachSourceTests");
        this.addLibraryEntry("/AttachSourceTests/b153133.jar", false);
        this.pkgFragmentRoot = this.currentProject.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/attach.jar"));
        this.setUpGenericJar();
        this.setUpInnerClassesJar();
    }

    private void setUpGenericJar() throws IOException, CoreException {
        String[] pathAndContents = new String[]{"generic/X.js", "package generic;\npublic class X<T> {\n  void foo(X<T> x) {\n  }\n  <K, V> V foo(K key, V value) {\n    return value;\n  }\n  void foo(int i, X<Object[]> x) {\n  }\n  void foo(boolean b, X<? extends X> x) {\n  }\n  void foo(float f, X<?> x) {\n  }\n  void foo(Y<? extends Integer, ? extends Object> y) {\n  }\n  void foo(Z.Inner<Object> inner) {\n  }\n  void foo(AType<Object> t) {\n  }\n}\nclass Y<K, V> {\n}\nclass Z {\n  class Inner<E> {\n  }\n}\nclass AType<E> {\n}"};
        this.addLibrary("generic.jar", "genericsrc.zip", pathAndContents, "1.5");
        IFile jar = this.getFile("/AttachSourceTests/generic.jar");
        this.genericType = this.currentProject.getPackageFragmentRoot((IResource)jar).getPackageFragment("generic").getClassFile("X.class").getType();
    }

    private void setUpInnerClassesJar() throws IOException, CoreException {
        String[] pathAndContents = new String[]{"inner/X.js", "package inner;\npublic class X {\n  void foo() {\n    new X() {};\n    class Y {}\n    new Y() {\n      class Z {}\n    };\n    class W {\n      void bar() {\n        new W() {};\n      }\n    }\n    new Object() {\n      class U {\n        U(String s) {\n        }\n      }\n    };\n  }\n  class V {\n    V(String s) {\n    }\n  }\n}"};
        this.addLibrary("innerClasses.jar", "innerClassessrc.zip", pathAndContents, "1.4");
        IFile jar = this.getFile("/AttachSourceTests/innerClasses.jar");
        this.innerClasses = this.currentProject.getPackageFragmentRoot((IResource)jar).getPackageFragment("inner");
    }

    protected void tearDown() throws Exception {
        IPackageFragmentRoot[] roots = this.currentProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!(this.genericType != null && root.equals(this.genericType.getPackageFragment().getParent()) || this.innerClasses != null && root.equals(this.innerClasses.getParent()) || root.getKind() != 2)) {
                this.attachSource(root, null, null);
            }
            ++i;
        }
        super.tearDown();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(this.currentProject);
        super.tearDownSuite();
    }

    public void testASTParsing() throws JavaScriptModelException {
        this.attachSource(this.pkgFragmentRoot, "/AttachSourceTests/attachsrc.zip", "");
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        ASTNode node = this.runConversion(classFile, true);
        AttachSourceTests.assertNotNull((String)"No node", (Object)node);
        this.attachSource(this.pkgFragmentRoot, null, null);
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        AttachSourceTests.assertTrue((String)"source code should no longer exist for A", (cf.getSource() == null ? 1 : 0) != 0);
        try {
            node = this.runConversion(classFile, true);
            AttachSourceTests.assertTrue((String)"Should not be here", (boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            AttachSourceTests.assertTrue((boolean)true);
        }
    }

    public void testASTParsing2() throws JavaScriptModelException {
        this.attachSource(this.pkgFragmentRoot, "/AttachSourceTests/attachsrc.zip", "");
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        ASTNode node = this.runConversion(classFile, false);
        AttachSourceTests.assertNotNull((String)"No node", (Object)node);
        this.attachSource(this.pkgFragmentRoot, null, null);
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        AttachSourceTests.assertTrue((String)"source code should no longer exist for A", (cf.getSource() == null ? 1 : 0) != 0);
        try {
            node = this.runConversion(classFile, false);
            AttachSourceTests.assertTrue((String)"Should not be here", (boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            AttachSourceTests.assertTrue((boolean)true);
        }
    }

    public void testChangeSourceAttachmentFile() throws CoreException {
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        IFunction method = cf.getType().getFunction("foo", new String[0]);
        this.assertSourceEquals("unexpected initial source for foo()", "public void foo() {\n\t}", method.getSource());
        this.swapFiles("AttachSourceTests/attachsrc.zip", "AttachSourceTests/attachsrc.new.zip");
        this.assertSourceEquals("unexpected source for foo() after replacement", "public void foo() {\n\t\tSystem.out.println(\"foo\");\n\t}", method.getSource());
        this.deleteFile("AttachSourceTests/attachsrc.zip");
        this.assertSourceEquals("unexpected source for foo() after deletion", null, method.getSource());
        this.moveFile("AttachSourceTests/attachsrc.new.zip", "AttachSourceTests/attachsrc.zip");
        this.assertSourceEquals("unexpected source for foo() after addition", "public void foo() {\n\t}", method.getSource());
    }

    public void testClassFileGetElementAt01() throws JavaScriptModelException {
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        String source = classFile.getSource();
        IJavaScriptElement element = classFile.getElementAt(source.indexOf("class A"));
        this.assertElementEquals("Unexpected element", "A [in A.class [in x.y [in attach.jar [in AttachSourceTests]]]]", element);
    }

    public void testClassFileGetElementAt02() throws JavaScriptModelException {
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        String source = classFile.getSource();
        IJavaScriptElement element = classFile.getElementAt(source.indexOf("public A"));
        this.assertElementEquals("Unexpected element", "A() [in A [in A.class [in x.y [in attach.jar [in AttachSourceTests]]]]]", element);
    }

    public void testClassFileGetElementAt03() throws JavaScriptModelException {
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        String source = classFile.getSource();
        IJavaScriptElement element = classFile.getElementAt(source.indexOf("void foo"));
        this.assertElementEquals("Unexpected element", "foo() [in A [in A.class [in x.y [in attach.jar [in AttachSourceTests]]]]]", element);
    }

    public void testClassFileGetElementAt04() throws JavaScriptModelException {
        IClassFile classFile = this.innerClasses.getClassFile("X$V.class");
        String source = classFile.getSource();
        IJavaScriptElement element = classFile.getElementAt(source.indexOf("V(String s)"));
        this.assertElementEquals("Unexpected element", "V(inner.X, java.lang.String) [in V [in X$V.class [in inner [in innerClasses.jar [in AttachSourceTests]]]]]", element);
    }

    public void testClassFileInOutput() throws CoreException {
        IClassFile classFile = this.getClassFile("AttachSourceTests/src/A.class");
        String source = classFile.getSource();
        this.assertSourceEquals("Unexpected source", "public class A {\n}", source);
    }

    public void testClassRetrieval() throws JavaScriptModelException {
        IClassFile objectCF = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        AttachSourceTests.assertTrue((String)"source code does not exist for the entire attached compilation unit", (objectCF.getSource() != null ? 1 : 0) != 0);
    }

    public void testDetachSource() throws JavaScriptModelException {
        this.attachSource(this.pkgFragmentRoot, null, null);
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        AttachSourceTests.assertTrue((String)"source code should no longer exist for A", (cf.getSource() == null ? 1 : 0) != 0);
        AttachSourceTests.assertTrue((String)"name range should no longer exist for A", (cf.getType().getNameRange().getOffset() == -1 ? 1 : 0) != 0);
        AttachSourceTests.assertTrue((String)"source range should no longer exist for A", (cf.getType().getSourceRange().getOffset() == -1 ? 1 : 0) != 0);
        AttachSourceTests.assertTrue((String)"Source attachment path should be null", (this.pkgFragmentRoot.getSourceAttachmentPath() == null ? 1 : 0) != 0);
        AttachSourceTests.assertTrue((String)"Source attachment root path should be null", (this.pkgFragmentRoot.getSourceAttachmentRootPath() == null ? 1 : 0) != 0);
    }

    public void testGeneric1() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"QX<QT;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(X<T> x) {\n  }", method.getSource());
    }

    public void testGeneric2() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"QK;", "QV;"});
        this.assertSourceEquals("Unexpected source", "<K, V> V foo(K key, V value) {\n    return value;\n  }", method.getSource());
    }

    public void testGeneric3() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"I", "Lgeneric.X<[Ljava.lang.Object;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(int i, X<Object[]> x) {\n  }", method.getSource());
    }

    public void testGeneric4() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"Z", "Lgeneric.X<+Lgeneric.X;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(boolean b, X<? extends X> x) {\n  }", method.getSource());
    }

    public void testGeneric5() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"F", "Lgeneric.X<*>;"});
        this.assertSourceEquals("Unexpected source", "void foo(float f, X<?> x) {\n  }", method.getSource());
    }

    public void testGeneric6() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"Lgeneric.Y<+Ljava.lang.Integer;+Ljava.lang.Object;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(Y<? extends Integer, ? extends Object> y) {\n  }", method.getSource());
    }

    public void testGeneric7() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"Lgeneric.Z.Inner<Ljava.lang.Object;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(Z.Inner<Object> inner) {\n  }", method.getSource());
    }

    public void testGeneric8() throws JavaScriptModelException {
        IFunction method = this.genericType.getFunction("foo", new String[]{"Lgeneric.AType<Ljava.lang.Object;>;"});
        this.assertSourceEquals("Unexpected source", "void foo(AType<Object> t) {\n  }", method.getSource());
    }

    public void testGetNameRange01() throws JavaScriptModelException {
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        IFunction method = classFile.getType().getFunction("foo", null);
        this.assertSourceEquals("Unexpected name source", "foo", this.getNameSource(classFile.getSource(), (IJavaScriptElement)method));
    }

    public void testGetNameRange02() throws JavaScriptModelException {
        IClassFile classFile = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        this.assertSourceEquals("Unexpected name source", "A", this.getNameSource(classFile.getSource(), (IJavaScriptElement)classFile.getType()));
    }

    public void testGetNameRange03() throws JavaScriptModelException {
        IClassFile classFile = this.innerClasses.getClassFile("X$V.class");
        IFunction constructor = classFile.getType().getFunction("V", new String[]{"Linner.X;", "Ljava.lang.String;"});
        this.assertSourceEquals("Unexpected name source", "V", this.getNameSource(classFile.getSource(), (IJavaScriptElement)constructor));
    }

    public void testGetSourceAttachmentPath() throws JavaScriptModelException {
        IPath saPath = this.pkgFragmentRoot.getSourceAttachmentPath();
        AttachSourceTests.assertEquals((String)("Source attachment path not correct for root " + this.pkgFragmentRoot), (String)"/AttachSourceTests/attachsrc.zip", (String)saPath.toString());
        AttachSourceTests.assertEquals((String)"Source attachment root path should be empty", (Object)new Path(""), (Object)this.pkgFragmentRoot.getSourceAttachmentRootPath());
    }

    public void testGetSourceRange() throws JavaScriptModelException {
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        ISourceRange sourceRange = cf.getSourceRange();
        AttachSourceTests.assertTrue((String)"Class file should have associated source range", (sourceRange != null ? 1 : 0) != 0);
        AttachSourceTests.assertEquals((String)"Unexpected offset", (int)0, (int)sourceRange.getOffset());
        AttachSourceTests.assertEquals((String)"Unexpected length", (int)100, (int)sourceRange.getLength());
    }

    public void testGetSourceRangeInnerClass() throws JavaScriptModelException {
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A$Inner.class");
        ISourceRange sourceRange = cf.getSourceRange();
        AttachSourceTests.assertTrue((String)"Inner class file should have associated source range", (sourceRange != null ? 1 : 0) != 0);
        AttachSourceTests.assertEquals((String)"Unexpected offset", (int)0, (int)sourceRange.getOffset());
        AttachSourceTests.assertEquals((String)"Unexpected length", (int)100, (int)sourceRange.getLength());
    }

    public void testInnerClass1() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X.class").getType();
        this.assertSourceEquals("Unexpected source", "public class X {\n  void foo() {\n    new X() {};\n    class Y {}\n    new Y() {\n      class Z {}\n    };\n    class W {\n      void bar() {\n        new W() {};\n      }\n    }\n    new Object() {\n      class U {\n        U(String s) {\n        }\n      }\n    };\n  }\n  class V {\n    V(String s) {\n    }\n  }\n}", type.getSource());
    }

    public void testInnerClass2() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$1.class").getType();
        this.assertSourceEquals("Unexpected source", "X() {}", type.getSource());
    }

    public void testInnerClass3() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$2.class").getType();
        this.assertSourceEquals("Unexpected source", "Y() {\n      class Z {}\n    }", type.getSource());
    }

    public void testInnerClass4() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$3.class").getType();
        this.assertSourceEquals("Unexpected source", "W() {}", type.getSource());
    }

    public void testInnerClass5() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$1$Y.class").getType();
        this.assertSourceEquals("Unexpected source", "class Y {}", type.getSource());
    }

    public void testInnerClass6() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$1$W.class").getType();
        this.assertSourceEquals("Unexpected source", "class W {\n      void bar() {\n        new W() {};\n      }\n    }", type.getSource());
    }

    public void testInnerClass7() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$2$Z.class").getType();
        this.assertSourceEquals("Unexpected source", "class Z {}", type.getSource());
    }

    public void testInnerClass8() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$V.class").getType();
        this.assertSourceEquals("Unexpected source", "class V {\n    V(String s) {\n    }\n  }", type.getSource());
    }

    public void testInnerClass9() throws JavaScriptModelException {
        IType type = this.innerClasses.getClassFile("X$4$U.class").getType();
        this.assertSourceEquals("Unexpected source", "class U {\n        U(String s) {\n        }\n      }", type.getSource());
    }

    public void testLibFolder() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/AttachSourceTests/lib");
        this.attachSource(root, "/AttachSourceTests/srcLib", "");
        IClassFile cf = root.getPackageFragment("p").getClassFile("X.class");
        this.assertSourceEquals("Unexpected source for class file", "package p;\npublic class X {\n\tpublic void foo() {\n\t}\n}", cf.getSource());
    }

    public void testMethodRetrieval() throws JavaScriptModelException {
        IClassFile cf = this.pkgFragmentRoot.getPackageFragment("x.y").getClassFile("A.class");
        IFunction[] methods = cf.getType().getFunctions();
        int i = 0;
        while (i < methods.length) {
            IFunction method = methods[i];
            AttachSourceTests.assertTrue((String)("source code does not exist for the method " + method), (method.getSource() != null ? 1 : 0) != 0);
            AttachSourceTests.assertTrue((String)"method name range not correct", (method.getNameRange().getOffset() != -1 && method.getNameRange().getLength() != 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testPersistence() throws JavaScriptModelException {
        this.pkgFragmentRoot.close();
        this.testClassRetrieval();
        this.testMethodRetrieval();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectAsClassFolder1() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n}");
            IProject p1 = this.getProject("P1");
            p1.build(6, null);
            IJavaScriptProject javaProject = this.createJavaProject("P2", new String[]{""}, new String[]{"/P1"}, "");
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)p1);
            this.attachSource(root, "/P1", null);
            IClassFile cf = root.getPackageFragment("p").getClassFile("X.class");
            this.assertSourceEquals("Unexpected source for class file P1/p/X.class", "package p;\npublic class X {\n}", cf.getSource());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectAsClassFolder2() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFile("/P1/X.js", "public class X {\n}");
            IProject p1 = this.getProject("P1");
            p1.build(6, null);
            IJavaScriptProject javaProject = this.createJavaProject("P2", new String[]{""}, new String[]{"/P1"}, "");
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)p1);
            this.attachSource(root, "/P1", null);
            IClassFile cf = root.getPackageFragment("").getClassFile("X.class");
            this.assertSourceEquals("Unexpected source for class file P1/X.class", "public class X {\n}", cf.getSource());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectAsSourceAttachment() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("Test", new String[]{""}, new String[]{"/AttachSourceTests/test.jar"}, "");
            this.createFolder("/Test/test1");
            this.createFile("/Test/test1/Test.js", "package test1;\n\npublic class Test {}");
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/test.jar"));
            this.attachSource(root, "/Test", null);
            IClassFile cf = root.getPackageFragment("test1").getClassFile("Test.class");
            this.assertSourceEquals("Unexpected source for class file test1/Test.class", "package test1;\n\npublic class Test {}", cf.getSource());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("Test");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("Test");
    }

    public void testRootPath4() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/test.jar"));
        this.attachSource(root, "/AttachSourceTests/src.zip", "invalid");
        IClassFile cf = root.getPackageFragment("test1").getClassFile("Test.class");
        this.assertSourceEquals("Unexpected source for class file", "package test1;\n\npublic class Test {}", cf.getSource());
        root.close();
    }

    public void testRootPath5() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/update.jar"));
        this.attachSource(root, "/AttachSourceTests/src.zip", "invalid");
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("A.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\n\npublic class A {}", cf.getSource());
        cf = root.getPackageFragment("").getClassFile("B.class");
        this.assertSourceEquals("Unexpected source for class file", "public class B {}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath6() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/update.jar"));
        this.attachSource(root, "/AttachSourceTests/src.zip", null);
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("A.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\n\npublic class A {}", cf.getSource());
        cf = root.getPackageFragment("").getClassFile("B.class");
        this.assertSourceEquals("Unexpected source for class file", "public class B {}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath7() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/full.jar"));
        this.attachSource(root, "/AttachSourceTests/src.zip", null);
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("A.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\n\npublic class A {}", cf.getSource());
        cf = root.getPackageFragment("").getClassFile("B.class");
        this.assertSourceEquals("Unexpected source for class file", "public class B {}", cf.getSource());
        cf = root.getPackageFragment("test1").getClassFile("Test.class");
        this.assertSourceEquals("Unexpected source for class file", "package test1;\n\npublic class Test {}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath8() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/full.jar"));
        this.attachSource(root, "/AttachSourceTests/fullsrc.zip", null);
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("A.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\n\npublic class A {}", cf.getSource());
        cf = root.getPackageFragment("").getClassFile("B.class");
        this.assertSourceEquals("Unexpected source for class file", "public class B {}", cf.getSource());
        cf = root.getPackageFragment("test1").getClassFile("Test.class");
        this.assertSourceEquals("Unexpected source for class file", "package test1;\n\npublic class Test {}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath9() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/full.jar"));
        this.attachSource(root, "/AttachSourceTests/fullsrc.zip", "invalid");
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("A.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\n\npublic class A {}", cf.getSource());
        cf = root.getPackageFragment("").getClassFile("B.class");
        this.assertSourceEquals("Unexpected source for class file", "public class B {}", cf.getSource());
        cf = root.getPackageFragment("test1").getClassFile("Test.class");
        this.assertSourceEquals("Unexpected source for class file", "package test1;\n\npublic class Test {}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath10() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/test2.jar"));
        this.attachSource(root, "/AttachSourceTests/test2.jar", null);
        IClassFile cf = root.getPackageFragment("p").getClassFile("X.class");
        this.assertSourceEquals("Unexpected source for class file", "package p;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t}\n}", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    public void testRootPath12() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/test5.jar"));
        this.attachSource(root, "/AttachSourceTests/test5.jar", null);
        IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("X.class");
        this.assertSourceEquals("Unexpected source for class file", "package p1.p2;\npublic class X {\n}\n", cf.getSource());
        this.attachSource(root, null, null);
        root.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug110172() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("/AttachSourceTests");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/test6.jar"));
        AttachSourceTests.assertTrue((String)"Root doesn't exist", (boolean)root.exists());
        this.attachSource(root, "/AttachSourceTests/test6src.zip", null);
        try {
            IClassFile cf = root.getPackageFragment("p1.p2").getClassFile("X.class");
            AttachSourceTests.assertNotNull((Object)cf);
            String source = cf.getSource();
            AttachSourceTests.assertNotNull((String)"No source", (Object)source);
            IJavaScriptElement[] children = cf.getChildren();
            AttachSourceTests.assertEquals((String)"Wrong number of children", (int)1, (int)children.length);
            IJavaScriptElement element = children[0];
            AttachSourceTests.assertTrue((String)"Not a type", (boolean)(element instanceof IType));
            IType type = (IType)element;
            IJavaScriptElement[] members = type.getChildren();
            int length = members.length;
            AttachSourceTests.assertEquals((String)"Wrong number", (int)9, (int)length);
            int i = 0;
            while (i < length) {
                int end;
                element = members[i];
                AttachSourceTests.assertTrue((boolean)(element instanceof IMember));
                ISourceRange javadocRange = ((IMember)element).getJSdocRange();
                String elementName = element.getElementName();
                if ("f".equals(elementName)) {
                    AttachSourceTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start = javadocRange.getOffset();
                    end = javadocRange.getLength() + start - 1;
                    String javadocSource = source.substring(start, end);
                    AttachSourceTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("field f") != -1 ? 1 : 0) != 0);
                } else if ("foo".equals(elementName)) {
                    AttachSourceTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start = javadocRange.getOffset();
                    end = javadocRange.getLength() + start - 1;
                    String javadocSource = source.substring(start, end);
                    AttachSourceTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("method foo") != -1 ? 1 : 0) != 0);
                } else if ("A".equals(elementName)) {
                    AttachSourceTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start = javadocRange.getOffset();
                    end = javadocRange.getLength() + start - 1;
                    String javadocSource = source.substring(start, end);
                    AttachSourceTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("member type A") != -1 ? 1 : 0) != 0);
                } else if ("X".equals(elementName)) {
                    AttachSourceTests.assertTrue((String)"Not an IFunction", (boolean)(element instanceof IFunction));
                    IFunction method = (IFunction)element;
                    switch (method.getNumberOfParameters()) {
                        case 0: {
                            AttachSourceTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                            break;
                        }
                        case 1: {
                            AttachSourceTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                            int start = javadocRange.getOffset();
                            int end2 = javadocRange.getLength() + start - 1;
                            String javadocSource = source.substring(start, end2);
                            AttachSourceTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("constructor") != -1 ? 1 : 0) != 0);
                        }
                    }
                } else if ("f3".equals(elementName)) {
                    AttachSourceTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start = javadocRange.getOffset();
                    end = javadocRange.getLength() + start - 1;
                    String javadocSource = source.substring(start, end);
                    AttachSourceTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("Real") != -1 ? 1 : 0) != 0);
                } else if ("f2".equals(elementName)) {
                    AttachSourceTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                } else if ("foo2".equals(elementName)) {
                    AttachSourceTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                } else if ("B".equals(elementName)) {
                    AttachSourceTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_26 = null;
            this.attachSource(root, null, null);
            root.close();
            throw throwable;
        }
        {
            Object var17_27 = null;
        }
        this.attachSource(root, null, null);
        root.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug153133() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.currentProject.getPackageFragmentRoot((IResource)this.getFile("/AttachSourceTests/b153133.jar"));
        AttachSourceTests.assertTrue((String)"Root doesn't exist", (boolean)root.exists());
        try {
            IClassFile cf = root.getPackageFragment("test").getClassFile("Test.class");
            AttachSourceTests.assertNotNull((Object)cf);
            String source = cf.getSource();
            AttachSourceTests.assertNotNull((String)"No source", (Object)source);
            IJavaScriptElement[] children = cf.getChildren();
            AttachSourceTests.assertEquals((String)"Wrong number of children", (int)1, (int)children.length);
            IJavaScriptElement element = children[0];
            AttachSourceTests.assertTrue((String)"Not a type", (boolean)(element instanceof IType));
            IType type = (IType)element;
            IJavaScriptElement[] members = type.getChildren();
            int length = members.length;
            AttachSourceTests.assertEquals((String)"Wrong number", (int)7, (int)length);
            int i = 0;
            while (i < length) {
                AttachSourceTests.assertTrue((boolean)(members[i] instanceof IMember));
                if (((IMember)members[i]).getElementType() == 7) {
                    IType typeMember = (IType)members[i];
                    String typeName = typeMember.getElementName();
                    IFunction[] methods = typeMember.getFunctions();
                    AttachSourceTests.assertEquals((String)("Expected only one constructor defined in type " + typeName), (int)1, (int)methods.length);
                    AttachSourceTests.assertTrue((String)("Expected a constructor instead of a method in type " + typeName), (boolean)methods[0].isConstructor());
                    IFunction constructor = methods[0];
                    ISourceRange sourceRange = constructor.getSourceRange();
                    AttachSourceTests.assertTrue((String)("Constructor " + constructor.getElementName() + " has invalid offset: " + sourceRange), (sourceRange.getOffset() >= 0 ? 1 : 0) != 0);
                    AttachSourceTests.assertTrue((String)("Constructor " + constructor.getElementName() + " has invalid length: " + sourceRange), (sourceRange.getLength() > 0 ? 1 : 0) != 0);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.removeLibraryEntry(new Path("/JavaSearchBugs/lib/b148215.jar"));
            root.close();
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        this.removeLibraryEntry(new Path("/JavaSearchBugs/lib/b148215.jar"));
        root.close();
    }
}

