/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.IProblem;

public class CompletionTestsRequestor2
extends CompletionRequestor {
    private final char[] NULL_LITERAL = "null".toCharArray();
    private CompletionContext context;
    public int proposalsPtr = -1;
    private static final int PROPOSALS_INCREMENT = 10;
    private CompletionProposal[] proposals = new CompletionProposal[10];
    private IProblem problem;
    private boolean showParameterNames;
    private boolean showUniqueKeys;
    private boolean showPositions;
    private boolean shortContext;
    private boolean showMissingTypes;
    public boolean fDebug = false;

    public CompletionTestsRequestor2() {
        this(false, false);
    }

    public CompletionTestsRequestor2(boolean showParamNames) {
        this(showParamNames, false, false);
    }

    public CompletionTestsRequestor2(boolean showParamNames, boolean showUniqueKeys) {
        this(showParamNames, showUniqueKeys, false);
    }

    public CompletionTestsRequestor2(boolean showParamNames, boolean showUniqueKeys, boolean showPositions) {
        this(showParamNames, showUniqueKeys, showPositions, true, false);
    }

    public CompletionTestsRequestor2(boolean showParamNames, boolean showUniqueKeys, boolean showPositions, boolean shortContext) {
        this(showParamNames, showUniqueKeys, showPositions, shortContext, false);
    }

    public CompletionTestsRequestor2(boolean showParamNames, boolean showUniqueKeys, boolean showPositions, boolean shortContext, boolean showMissingTypes) {
        this.showParameterNames = showParamNames;
        this.showUniqueKeys = showUniqueKeys;
        this.showPositions = showPositions;
        this.shortContext = shortContext;
        this.showMissingTypes = showMissingTypes;
    }

    public void acceptContext(CompletionContext cc) {
        this.context = cc;
    }

    public void accept(CompletionProposal proposal) {
        int length = this.proposals.length;
        if (++this.proposalsPtr == length) {
            this.proposals = new CompletionProposal[length + 10];
            System.arraycopy(this.proposals, 0, this.proposals, 0, length);
        }
        this.proposals[this.proposalsPtr] = proposal;
    }

    public void allowAllRequiredProposals() {
        int i = 1;
        while (i <= 23) {
            int j = 1;
            while (j <= 23) {
                this.setAllowsRequiredProposals(i, j, true);
                ++j;
            }
            ++i;
        }
    }

    public void completionFailure(IProblem p) {
        this.problem = p;
    }

    public String getContext() {
        if (this.context == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.shortContext) {
            buffer.append("completion offset=");
            buffer.append(this.context.getOffset());
            buffer.append('\n');
            buffer.append("completion range=[");
            buffer.append(this.context.getTokenStart());
            buffer.append(", ");
            buffer.append(this.context.getTokenEnd());
            buffer.append("]\n");
            char[] token = this.context.getToken();
            buffer.append("completion token=");
            if (token == null) {
                buffer.append("null");
            } else {
                buffer.append('\"');
                buffer.append(token);
                buffer.append('\"');
            }
            buffer.append('\n');
            buffer.append("completion token kind=");
            int tokenKind = this.context.getTokenKind();
            if (tokenKind == 2) {
                buffer.append("TOKEN_KIND_STRING_LITERAL");
            } else if (tokenKind == 1) {
                buffer.append("TOKEN_KIND_NAME");
            } else {
                buffer.append("TOKEN_KIND_UNKNOWN");
            }
            buffer.append('\n');
        }
        char[][] expectedTypesSignatures = this.context.getExpectedTypesSignatures();
        buffer.append("expectedTypesSignatures=");
        if (expectedTypesSignatures == null) {
            buffer.append(this.NULL_LITERAL);
        } else {
            buffer.append('{');
            int i = 0;
            while (i < expectedTypesSignatures.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(expectedTypesSignatures[i]);
                ++i;
            }
            buffer.append('}');
        }
        buffer.append('\n');
        char[][] expectedTypesKeys = this.context.getExpectedTypesKeys();
        buffer.append("expectedTypesKeys=");
        if (expectedTypesSignatures == null) {
            buffer.append(this.NULL_LITERAL);
        } else {
            buffer.append('{');
            int i = 0;
            while (i < expectedTypesKeys.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(expectedTypesKeys[i]);
                ++i;
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    public String getProblem() {
        return this.problem == null ? "" : this.problem.getMessage();
    }

    public String getResults() {
        if (this.proposalsPtr < 0) {
            return "";
        }
        this.quickSort(this.proposals, 0, this.proposalsPtr);
        return this.getResultsWithoutSorting();
    }

    public String getReversedResults() {
        if (this.proposalsPtr < 0) {
            return "";
        }
        Arrays.sort(this.proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof CompletionProposal && o2 instanceof CompletionProposal) {
                    CompletionProposal p1 = (CompletionProposal)o1;
                    CompletionProposal p2 = (CompletionProposal)o2;
                    int relDif = p2.getRelevance() - p1.getRelevance();
                    if (relDif != 0) {
                        return relDif;
                    }
                    String name1 = CompletionTestsRequestor2.this.getElementName(p1);
                    String name2 = CompletionTestsRequestor2.this.getElementName(p2);
                    return name1.compareTo(name2);
                }
                return -1;
            }
        });
        return this.getResultsWithoutSorting();
    }

    public String getResultsWithoutSorting() {
        if (this.proposalsPtr < 0) {
            return "";
        }
        StringBuffer buffer = this.printProposal(this.proposals[0]);
        int i = 1;
        while (i <= this.proposalsPtr) {
            if (i > 0) {
                buffer.append('\n');
            }
            buffer.append(this.printProposal(this.proposals[i]));
            ++i;
        }
        return buffer.toString();
    }

    public String[] getStringsResult() {
        if (this.proposalsPtr < 0) {
            return new String[0];
        }
        String[] strings = new String[this.proposalsPtr + 1];
        int i = 0;
        while (i <= this.proposalsPtr) {
            strings[i] = this.printProposal(this.proposals[i]).toString();
            ++i;
        }
        return strings;
    }

    protected StringBuffer printProposal(CompletionProposal proposal) {
        StringBuffer buffer = new StringBuffer();
        return this.printProposal(proposal, 0, buffer);
    }

    protected StringBuffer printProposal(CompletionProposal proposal, int tab, StringBuffer buffer) {
        CompletionProposal[] requiredProposals;
        int i = 0;
        while (i < tab) {
            buffer.append("   ");
            ++i;
        }
        buffer.append(this.getElementName(proposal));
        buffer.append('[');
        switch (proposal.getKind()) {
            case 1: {
                buffer.append("ANONYMOUS_CLASS_DECLARATION");
                break;
            }
            case 2: {
                buffer.append("FIELD_REF");
                break;
            }
            case 3: {
                buffer.append("KEYWORD");
                break;
            }
            case 4: {
                buffer.append("LABEL_REF");
                break;
            }
            case 5: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 7: {
                buffer.append("FUNCTION_DECLARATION");
                if (!proposal.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 6: {
                buffer.append("FUNCTION_REF");
                if (!proposal.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 8: {
                buffer.append("PACKAGE_REF");
                break;
            }
            case 9: {
                buffer.append("TYPE_REF");
                break;
            }
            case 10: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 11: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 12: {
                buffer.append("METHOD_IMPORT");
                break;
            }
            case 13: {
                buffer.append("ANNOTATION_ATTRIBUTE_REF");
                break;
            }
            case 19: {
                buffer.append("JSDOC_BLOCK_TAG");
                break;
            }
            case 20: {
                buffer.append("JSDOC_INLINE_TAG");
                break;
            }
            case 14: {
                buffer.append("JSDOC_FIELD_REF");
                break;
            }
            case 15: {
                buffer.append("JSDOC_METHOD_REF");
                break;
            }
            case 16: {
                buffer.append("JSDOC_TYPE_REF");
                break;
            }
            case 18: {
                buffer.append("JSDOC_PARAM_REF");
                break;
            }
            case 17: {
                buffer.append("JSDOC_VALUE_REF");
                break;
            }
            case 21: {
                buffer.append("FIELD_IMPORT");
                break;
            }
            case 22: {
                buffer.append("METHOD_IMPORT");
                break;
            }
            case 23: {
                buffer.append("TYPE_IMPORT");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        buffer.append("]{");
        buffer.append(proposal.getCompletion() == null ? this.NULL_LITERAL : proposal.getCompletion());
        buffer.append(", ");
        buffer.append(proposal.getDeclarationSignature() == null ? this.NULL_LITERAL : proposal.getDeclarationSignature());
        buffer.append(", ");
        buffer.append(proposal.getSignature() == null ? this.NULL_LITERAL : proposal.getSignature());
        if (this.showUniqueKeys) {
            buffer.append(", ");
            buffer.append(proposal.getDeclarationKey() == null ? this.NULL_LITERAL : proposal.getDeclarationKey());
            buffer.append(", ");
            buffer.append(proposal.getKey() == null ? this.NULL_LITERAL : proposal.getKey());
        }
        buffer.append(", ");
        buffer.append(proposal.getName() == null ? this.NULL_LITERAL : proposal.getName());
        if (this.showParameterNames) {
            char[][] parameterNames = proposal.findParameterNames(null);
            buffer.append(", ");
            if (parameterNames == null || parameterNames.length <= 0) {
                buffer.append(this.NULL_LITERAL);
            } else {
                buffer.append("(");
                int i2 = 0;
                while (i2 < parameterNames.length) {
                    if (i2 > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(parameterNames[i2]);
                    ++i2;
                }
                buffer.append(")");
            }
        }
        if (this.showPositions) {
            buffer.append(", [");
            buffer.append(proposal.getReplaceStart());
            buffer.append(", ");
            buffer.append(proposal.getReplaceEnd());
            buffer.append("]");
        }
        buffer.append(", ");
        buffer.append(proposal.getRelevance());
        buffer.append('}');
        if (this.showMissingTypes && (requiredProposals = proposal.getRequiredProposals()) != null) {
            int length = requiredProposals.length;
            CompletionProposal[] completionProposalArray = requiredProposals;
            requiredProposals = new CompletionProposal[length];
            System.arraycopy(completionProposalArray, 0, requiredProposals, 0, length);
            this.quickSort(requiredProposals, 0, length - 1);
            int i3 = 0;
            while (i3 < length) {
                buffer.append('\n');
                this.printProposal(requiredProposals[i3], tab + 1, buffer);
                ++i3;
            }
        }
        return buffer;
    }

    protected CompletionProposal[] quickSort(CompletionProposal[] collection, int left, int right) {
        int original_left = left;
        int original_right = right;
        CompletionProposal mid = collection[(left + right) / 2];
        while (true) {
            if (this.compare(mid, collection[left]) > 0) {
                ++left;
                continue;
            }
            while (this.compare(mid, collection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                CompletionProposal tmp = collection[left];
                collection[left] = collection[right];
                collection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            collection = this.quickSort(collection, original_left, right);
        }
        if (left < original_right) {
            collection = this.quickSort(collection, left, original_right);
        }
        return collection;
    }

    protected int compare(CompletionProposal proposal1, CompletionProposal proposal2) {
        String completion2;
        String name2;
        int relDif = proposal1.getRelevance() - proposal2.getRelevance();
        if (relDif != 0) {
            return relDif;
        }
        String name1 = this.getElementName(proposal1);
        int nameDif = name1.compareTo(name2 = this.getElementName(proposal2));
        if (nameDif != 0) {
            return nameDif;
        }
        int kindDif = proposal1.getKind() - proposal2.getKind();
        if (kindDif != 0) {
            return kindDif;
        }
        String completion1 = new String(proposal1.getCompletion());
        int completionDif = completion1.compareTo(completion2 = new String(proposal2.getCompletion()));
        if (completionDif != 0) {
            return completionDif;
        }
        char[] temp = proposal1.getSignature();
        String signature1 = temp == null ? null : new String(temp);
        temp = proposal2.getSignature();
        String signature2 = temp == null ? null : new String(temp);
        int signatureDif = 0;
        if (signature1 != null && signature2 != null) {
            signatureDif = signature1.compareTo(signature2);
        }
        if (signatureDif != 0) {
            return signatureDif;
        }
        temp = proposal1.getDeclarationSignature();
        String declarationSignature1 = temp == null ? null : new String(temp);
        temp = proposal2.getDeclarationSignature();
        String declarationSignature2 = temp == null ? null : new String(temp);
        int declarationSignatureDif = 0;
        if (declarationSignature1 != null && declarationSignature2 != null) {
            declarationSignatureDif = declarationSignature1.compareTo(declarationSignature2);
        }
        if (declarationSignatureDif != 0) {
            return declarationSignatureDif;
        }
        return 0;
    }

    protected String getElementName(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 1: {
                return new String(Signature.getSignatureSimpleName((char[])proposal.getDeclarationSignature()));
            }
            case 9: 
            case 16: 
            case 23: {
                return new String(Signature.getSignatureSimpleName((char[])proposal.getSignature()));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return new String(proposal.getName());
            }
            case 8: {
                return new String(proposal.getDeclarationSignature());
            }
        }
        return "";
    }

    public String toString() {
        return this.getResults();
    }
}

