/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class EncodingTests
extends ModifyingResourceTests {
    IProject encodingProject;
    IJavaScriptProject encodingJavaProject;
    IFile utf8File;
    ISourceReference utf8Source;
    static String vmEncoding;
    static String wkspEncoding;
    static /* synthetic */ Class class$0;

    static {
        wkspEncoding = vmEncoding = System.getProperty("file.encoding");
    }

    public EncodingTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.EncodingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return EncodingTests.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        wkspEncoding = this.getWorkspaceRoot().getDefaultCharset();
        System.out.println("Encoding tests using Workspace charset: " + wkspEncoding + " and VM charset: " + vmEncoding);
        this.encodingJavaProject = this.setUpJavaProject("Encoding");
        this.encodingProject = (IProject)this.encodingJavaProject.getResource();
        this.utf8File = (IFile)this.encodingProject.findMember("src/testUTF8/Test.js");
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.getWorkspaceRoot().setDefaultCharset(null, null);
        this.deleteProject("Encoding");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.encodingProject.setDefaultCharset(null, null);
        if (this.utf8File.exists()) {
            this.utf8File.setCharset(null, null);
        }
        if (this.utf8Source != null) {
            ((IOpenable)this.utf8Source).close();
        }
        this.encodingJavaProject.close();
        super.tearDown();
    }

    void compareContents(IJavaScriptUnit cu, String encoding) throws JavaScriptModelException {
        this.compareContents(cu, encoding, false);
    }

    void compareContents(IJavaScriptUnit cu, String encoding, boolean bom) throws JavaScriptModelException {
        String source = cu.getSource();
        String systemSourceRenamed = Util.convertToIndependantLineDelimiter((String)source);
        IFile file = (IFile)cu.getUnderlyingResource();
        String renamedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)file));
        renamedContents = Util.convertToIndependantLineDelimiter((String)renamedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)renamedContents, (String)systemSourceRenamed);
        byte[] renamedSourceBytes = null;
        try {
            renamedSourceBytes = source.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        EncodingTests.assertNotNull((String)("Unsupported encoding: " + encoding), (Object)renamedSourceBytes);
        byte[] renamedEncodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)file);
        int start = bom ? IContentDescription.BOM_UTF_8.length : 0;
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)(renamedEncodedBytes.length - start), (int)renamedSourceBytes.length);
        int i = 0;
        int max = renamedSourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (renamedSourceBytes[i] == renamedEncodedBytes[i + start] ? 1 : 0) != 0);
            ++i;
        }
    }

    public boolean convertToIndependantLineDelimiter(File file) {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateCompilationUnitAndImportContainer() throws JavaScriptModelException, CoreException {
        String savedEncoding = null;
        try {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            savedEncoding = preferences.getString("encoding");
            String encoding = "UTF-8";
            preferences.setValue("encoding", encoding);
            ResourcesPlugin.getPlugin().savePluginPreferences();
            IJavaScriptProject newProject = this.createJavaProject("P", new String[]{""}, "");
            IPackageFragment pkg = this.getPackageFragment("P", "", "");
            String source = "public class A {\r\n\tpublic static main(String[] args) {\r\n\t\tSystem.out.println(\"\u00e9\");\r\n\t}\r\n}";
            IJavaScriptUnit cu = pkg.createCompilationUnit("A.js", source, false, (IProgressMonitor)new NullProgressMonitor());
            this.assertCreation((IJavaScriptElement)cu);
            cu.rename("B.js", true, (IProgressMonitor)new NullProgressMonitor());
            cu = pkg.getJavaScriptUnit("B.js");
            cu.rename("A.js", true, (IProgressMonitor)new NullProgressMonitor());
            cu = pkg.getJavaScriptUnit("A.js");
            byte[] tab = null;
            try {
                tab = cu.getSource().getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] encodedContents = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)newProject.getProject().getWorkspace().getRoot().getFile(cu.getPath()));
            EncodingTests.assertEquals((String)"wrong size of encoded string", (int)tab.length, (int)encodedContents.length);
            int i = 0;
            int max = tab.length;
            while (i < max) {
                EncodingTests.assertTrue((String)("wrong size of encoded character at" + i), (tab[i] == encodedContents[i] ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.deleteProject("P");
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            preferences.setValue("encoding", savedEncoding);
            ResourcesPlugin.getPlugin().savePluginPreferences();
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        this.deleteProject("P");
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("encoding", savedEncoding);
        ResourcesPlugin.getPlugin().savePluginPreferences();
    }

    public void test001() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test002() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test003() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(wkspEncoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
    }

    public void test004() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)vmEncoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test005() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)vmEncoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test006() throws JavaScriptModelException, CoreException {
        String encoding = wkspEncoding.equals(vmEncoding) ? ("UTF-8".equals(wkspEncoding) ? "Cp1252" : "UTF-8") : vmEncoding;
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test011() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test012() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test013() throws JavaScriptModelException, CoreException, UnsupportedEncodingException {
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(wkspEncoding);
        byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
    }

    public void test014() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)vmEncoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test015() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)vmEncoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test016() throws JavaScriptModelException, CoreException {
        String encoding = wkspEncoding.equals(vmEncoding) ? ("UTF-8".equals(wkspEncoding) ? "Cp1252" : "UTF-8") : vmEncoding;
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test021() throws JavaScriptModelException, CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("Encoding", "testUTF8.jar");
        this.utf8Source = root.getPackageFragment("testUTF8").getClassFile("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)vmEncoding));
        this.assertSourceEquals("Encoded UTF-8 source should have been decoded the same way!", source, encodedContents);
    }

    public void test022() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("Encoding", "testUTF8.jar");
        this.utf8Source = root.getPackageFragment("testUTF8").getClassFile("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test023() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        IFile zipFile = (IFile)this.encodingProject.findMember("testUTF8.zip");
        EncodingTests.assertNotNull((String)"Cannot find class file!", (Object)zipFile);
        zipFile.setCharset(encoding, null);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("Encoding", "testUTF8.jar");
        this.utf8Source = root.getPackageFragment("testUTF8").getClassFile("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
        zipFile.setCharset(null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test030() throws JavaScriptModelException, CoreException {
        Object workingCopy = null;
        try {
            try {
                String encoding = "UTF-8";
                this.createJavaProject("P", new String[]{""}, "");
                String initialContent = "/**\n */\npublic class Test {}";
                IFile file = this.createFile("P/Test.js", initialContent);
                file.setCharset(encoding, null);
                IJavaScriptUnit cu = this.getCompilationUnit("P/Test.js");
                String firstModif = "/**\n * Caract?res exotiques:\n * ?|#|?|?|?|?|?|?|?|?|??\n */\npublic class Test {}";
                cu.getBuffer().setContents(firstModif);
                cu.getBuffer().save(null, true);
                String source = cu.getBuffer().getContents();
                String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)file, (String)encoding));
                EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)source);
                byte[] sourceBytes = source.getBytes(encoding);
                byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)file);
                EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
                int i = 0;
                int max = sourceBytes.length;
                while (i < max) {
                    EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test031() throws JavaScriptModelException, CoreException {
        IJavaScriptUnit workingCopy = null;
        try {
            try {
                String encoding = "UTF-8";
                this.createJavaProject("P", new String[]{""}, "");
                String initialContent = "/**\n */\npublic class Test {}";
                IFile file = this.createFile("P/Test.js", initialContent);
                file.setCharset(encoding, null);
                IJavaScriptUnit cu = this.getCompilationUnit("P/Test.js");
                workingCopy = cu.getWorkingCopy(null);
                String secondModif = "/**\n * Caract?res exotiques:\n * ?|#|?|?|?|?|?|?|?|?|??\n * Autres caract?res exotiques:\n * ?|?|?|?|?|?\n */\npublic class Test {}";
                workingCopy.getBuffer().setContents(secondModif);
                workingCopy.commitWorkingCopy(true, null);
                String source = workingCopy.getBuffer().getContents();
                String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)file));
                EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)source);
                byte[] sourceBytes = source.getBytes(encoding);
                byte[] encodedBytes = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsByteArray((IFile)file);
                EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
                int i = 0;
                int max = sourceBytes.length;
                while (i < max) {
                    EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    public void test032() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getCompilationUnit(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        IFile bomFile = (IFile)this.encodingProject.findMember("src/testUTF8BOM/Test.js");
        IJavaScriptUnit bomSourceRef = this.getCompilationUnit(bomFile.getFullPath().toString());
        String bomSource = bomSourceRef.getSource();
        EncodingTests.assertEquals((String)"BOM UTF-8 source should be idtentical than UTF-8!", (String)source, (String)bomSource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test033() throws CoreException {
        try {
            this.createFolder("/Encoding/src/test68585");
            final String encoding = "UTF-8".equals(wkspEncoding) ? "Cp1252" : "UTF-8";
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFile file = null;
                    try {
                        file = EncodingTests.this.createFile("/Encoding/src/test68585/X.js", "package  test68585;\npublic class X {\n}\nclass Y\u00f4 {}", encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        return;
                    }
                    file.setCharset(wkspEncoding, null);
                }
            }, null);
            IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            this.search("Y\u00f4", 0, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("Should not get any result", "", (Object)resultCollector);
            this.getFile("/Encoding/src/test68585/X.js").setCharset(encoding, null);
            this.search("Y\u00f4", 0, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("Should have been reindexed", "src/test68585/X.java test68585.Y\u00f4 [Y\u00f4]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteFolder("/Encoding/src/test68585");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteFolder("/Encoding/src/test68585");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test034() throws CoreException, IOException {
        try {
            IFile file = this.createFile("/Encoding/Test34.txt", "acegikm");
            final InputStream fileStream = file.getContents();
            try {
                InputStream in = new InputStream(){
                    int current = -1;

                    public int read() throws IOException {
                        int result;
                        if (this.current != -1) {
                            result = this.current;
                            this.current = -1;
                        } else {
                            result = fileStream.read();
                            if (result == -1) {
                                return -1;
                            }
                            this.current = result + 1;
                        }
                        return result;
                    }
                };
                char[] result = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray((InputStream)in, (int)((int)file.getLocation().toFile().length()), (String)"UTF-8");
                this.assertSourceEquals("Unexpected source", "abcdefghijklmn", new String(result));
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                fileStream.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                fileStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.deleteFile("Encoding/Test34.txt");
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.deleteFile("Encoding/Test34.txt");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug66898() throws JavaScriptModelException, CoreException {
        String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        IFile file = (IFile)this.encodingProject.findMember("src/testBug66898/Test.js");
        file.setCharset(encoding, null);
        String fileName = file.getName();
        IJavaScriptUnit cu = this.getCompilationUnit(file.getFullPath().toString());
        this.createFolder("/Encoding/src/tmp");
        IPackageFragment packFrag = this.getPackageFragment("Encoding", "src", "tmp");
        try {
            cu.move((IJavaScriptElement)packFrag, null, null, false, null);
            IJavaScriptUnit destSource = packFrag.getJavaScriptUnit(fileName);
            IFile destFile = (IFile)destSource.getUnderlyingResource();
            EncodingTests.assertEquals((String)"Moved file should keep encoding", (String)encoding, (String)destFile.getCharset());
            this.compareContents(destSource, encoding);
            destSource.rename("TestUTF8.js", false, null);
            IJavaScriptUnit renamedSource = packFrag.getJavaScriptUnit("TestUTF8.js");
            IFile renamedFile = (IFile)renamedSource.getUnderlyingResource();
            EncodingTests.assertEquals((String)"Moved file should keep encoding", (String)encoding, (String)renamedFile.getCharset());
            this.compareContents(renamedSource, encoding);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug66898b() throws JavaScriptModelException, CoreException {
        final String encoding = "UTF-8".equals(vmEncoding) ? "Cp1252" : "UTF-8";
        final IFile file = (IFile)this.encodingProject.findMember("src/testBug66898b/Test.js");
        file.setCharset(encoding, null);
        final String fileName = file.getName();
        final IPackageFragment srcFolder = this.getPackageFragment("Encoding", "src", "testBug66898b");
        this.createFolder("/Encoding/src/tmp");
        final IPackageFragment tmpFolder = this.getPackageFragment("Encoding", "src", "tmp");
        try {
            IWorkspaceRunnable copy = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptUnit cu = EncodingTests.this.getCompilationUnit(file.getFullPath().toString());
                    cu.copy((IJavaScriptElement)tmpFolder, null, null, true, null);
                    cu.close();
                    IJavaScriptUnit dest = tmpFolder.getJavaScriptUnit(fileName);
                    IFile destFile = (IFile)dest.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Copied file should keep encoding", (String)encoding, (String)destFile.getCharset());
                    EncodingTests.this.compareContents(dest, encoding);
                }
            };
            JavaScriptCore.run((IWorkspaceRunnable)copy, null);
            IWorkspaceRunnable rename = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptUnit cu = tmpFolder.getJavaScriptUnit(fileName);
                    cu.rename("Renamed.js", true, null);
                    cu.close();
                    IJavaScriptUnit ren = tmpFolder.getJavaScriptUnit("Renamed.js");
                    IFile renFile = (IFile)ren.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Renamed file should keep encoding", (String)encoding, (String)renFile.getCharset());
                    EncodingTests.this.compareContents(ren, encoding);
                }
            };
            JavaScriptCore.run((IWorkspaceRunnable)rename, null);
            IWorkspaceRunnable move = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptUnit cu = tmpFolder.getJavaScriptUnit("Renamed.js");
                    cu.move((IJavaScriptElement)srcFolder, null, null, true, null);
                    cu.close();
                    IJavaScriptUnit moved = srcFolder.getJavaScriptUnit("Renamed.js");
                    IFile movedFile = (IFile)moved.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Renamed file should keep encoding", (String)encoding, (String)movedFile.getCharset());
                    EncodingTests.this.compareContents(moved, encoding);
                }
            };
            JavaScriptCore.run((IWorkspaceRunnable)move, null);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            IJavaScriptUnit cu = srcFolder.getJavaScriptUnit("Renamed.js");
            if (cu.exists()) {
                cu.delete(true, null);
            }
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        IJavaScriptUnit cu = srcFolder.getJavaScriptUnit("Renamed.js");
        if (cu.exists()) {
            cu.delete(true, null);
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    public void testBug70598() throws JavaScriptModelException, CoreException, IOException {
        IFile emptyFile = this.createFile("/Encoding/src/testUTF8BOM/Empty.js", new byte[0]);
        File file = new File(this.encodingProject.getLocation().toString(), emptyFile.getProjectRelativePath().toString());
        char[] fileContents = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent((File)file, (String)"UTF-8");
        EncodingTests.assertEquals((String)"We should not get any character!", (String)"", (String)new String(fileContents));
        char[] ifileContents = org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)emptyFile, (String)"UTF-8");
        EncodingTests.assertEquals((String)"We should not get any character!", (String)"", (String)new String(ifileContents));
        this.deleteFile(file);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug110576() throws JavaScriptModelException, CoreException {
        String os = System.getProperty("osgi.os");
        if (!"win32".equals(os)) {
            System.out.println("Bug 110576 is not tested under " + os + " os...");
            return;
        }
        IFile file = (IFile)this.encodingProject.findMember("src/testBug110576/Test.js");
        this.verifyUtf8BOM(file);
        String fileName = file.getName();
        IJavaScriptUnit testCU = this.getCompilationUnit(file.getFullPath().toString());
        this.createFolder("/Encoding/src/tmp");
        IPackageFragment tmpPackage = this.getPackageFragment("Encoding", "src", "tmp");
        try {
            testCU.copy((IJavaScriptElement)tmpPackage, null, null, false, null);
            IJavaScriptUnit copiedCU = tmpPackage.getJavaScriptUnit(fileName);
            IFile copiedFile = (IFile)copiedCU.getUnderlyingResource();
            this.verifyUtf8BOM(copiedFile);
            this.compareContents(copiedCU, "UTF-8", true);
            copiedCU.rename("TestUTF8.js", false, null);
            IJavaScriptUnit renamedCU = tmpPackage.getJavaScriptUnit("TestUTF8.js");
            IFile renamedFile = (IFile)renamedCU.getUnderlyingResource();
            this.verifyUtf8BOM(renamedFile);
            fileName = renamedFile.getName();
            this.compareContents(renamedCU, "UTF-8", true);
            this.createFolder("/Encoding/src/tmp/sub");
            IPackageFragment subPackage = this.getPackageFragment("Encoding", "src", "tmp.sub");
            renamedCU.move((IJavaScriptElement)subPackage, null, null, false, null);
            IJavaScriptUnit movedCU = subPackage.getJavaScriptUnit(fileName);
            IFile movedFile = (IFile)movedCU.getUnderlyingResource();
            this.verifyUtf8BOM(movedFile);
            this.compareContents(movedCU, "UTF-8", true);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    private void verifyUtf8BOM(IFile file) throws CoreException {
        EncodingTests.assertNull((String)"File should not have any explicit charset", (Object)file.getCharset(false));
        IContentDescription contentDescription = file.getContentDescription();
        EncodingTests.assertNotNull((String)"File should have a content description", (Object)contentDescription);
        EncodingTests.assertEquals((String)"Content description charset should be UTF-8", (String)"UTF-8", (String)contentDescription.getCharset());
        EncodingTests.assertNotNull((String)"File should be UTF-8 BOM!", (Object)contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK));
    }
}

