/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.Semaphore;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.processing.IJob;

public class SearchTests
extends ModifyingResourceTests
implements IJavaScriptSearchConstants {
    static final byte[] EMPTY_JAR;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[166];
        byArray[0] = 80;
        byArray[1] = 75;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 20;
        byArray[6] = 8;
        byArray[8] = 8;
        byArray[10] = 106;
        byArray[11] = -100;
        byArray[12] = 116;
        byArray[13] = 46;
        byArray[26] = 20;
        byArray[28] = 4;
        byArray[30] = 77;
        byArray[31] = 69;
        byArray[32] = 84;
        byArray[33] = 65;
        byArray[34] = 45;
        byArray[35] = 73;
        byArray[36] = 78;
        byArray[37] = 70;
        byArray[38] = 47;
        byArray[39] = 77;
        byArray[40] = 65;
        byArray[41] = 78;
        byArray[42] = 73;
        byArray[43] = 70;
        byArray[44] = 69;
        byArray[45] = 83;
        byArray[46] = 84;
        byArray[47] = 46;
        byArray[48] = 77;
        byArray[49] = 70;
        byArray[50] = -2;
        byArray[51] = -54;
        byArray[54] = -29;
        byArray[55] = -27;
        byArray[56] = 2;
        byArray[58] = 80;
        byArray[59] = 75;
        byArray[60] = 7;
        byArray[61] = 8;
        byArray[62] = -84;
        byArray[63] = -123;
        byArray[64] = -94;
        byArray[65] = 20;
        byArray[66] = 4;
        byArray[70] = 2;
        byArray[74] = 80;
        byArray[75] = 75;
        byArray[76] = 1;
        byArray[77] = 2;
        byArray[78] = 20;
        byArray[80] = 20;
        byArray[82] = 8;
        byArray[84] = 8;
        byArray[86] = 106;
        byArray[87] = -100;
        byArray[88] = 116;
        byArray[89] = 46;
        byArray[90] = -84;
        byArray[91] = -123;
        byArray[92] = -94;
        byArray[93] = 20;
        byArray[94] = 4;
        byArray[98] = 2;
        byArray[102] = 20;
        byArray[104] = 4;
        byArray[120] = 77;
        byArray[121] = 69;
        byArray[122] = 84;
        byArray[123] = 65;
        byArray[124] = 45;
        byArray[125] = 73;
        byArray[126] = 78;
        byArray[127] = 70;
        byArray[128] = 47;
        byArray[129] = 77;
        byArray[130] = 65;
        byArray[131] = 78;
        byArray[132] = 73;
        byArray[133] = 70;
        byArray[134] = 69;
        byArray[135] = 83;
        byArray[136] = 84;
        byArray[137] = 46;
        byArray[138] = 77;
        byArray[139] = 70;
        byArray[140] = -2;
        byArray[141] = -54;
        byArray[144] = 80;
        byArray[145] = 75;
        byArray[146] = 5;
        byArray[147] = 6;
        byArray[152] = 1;
        byArray[154] = 1;
        byArray[156] = 70;
        byArray[160] = 74;
        EMPTY_JAR = byArray;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.SearchTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SearchTests.buildModelTestSuite(clazz);
    }

    public SearchTests(String name) {
        super(name);
    }

    protected void assertAllTypes(int waitingPolicy, IProgressMonitor progressMonitor, String expected) throws JavaScriptModelException {
        this.assertAllTypes("Unexpected all types", null, waitingPolicy, progressMonitor, expected);
    }

    protected void assertAllTypes(String expected) throws JavaScriptModelException {
        this.assertAllTypes(3, null, expected);
    }

    protected void assertAllTypes(String message, IJavaScriptProject project, String expected) throws JavaScriptModelException {
        this.assertAllTypes(message, project, 3, null, expected);
    }

    protected void assertAllTypes(String message, IJavaScriptProject project, int waitingPolicy, IProgressMonitor progressMonitor, String expected) throws JavaScriptModelException {
        IJavaScriptSearchScope scope = project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
        SearchEngine searchEngine = new SearchEngine();
        SearchTypeNameRequestor requestor = new SearchTypeNameRequestor();
        searchEngine.searchAllTypeNames(null, 0, null, 2, 0, scope, (TypeNameRequestor)requestor, waitingPolicy, progressMonitor);
        String actual = requestor.toString();
        if (!expected.equals(actual)) {
            System.out.println(Util.displayString((String)actual, (int)3));
        }
        SearchTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertPattern(String expected, SearchPattern actualPattern) {
        String actual;
        String string = actual = actualPattern == null ? null : actualPattern.toString();
        if (!expected.equals(actual)) {
            System.out.print(actual == null ? "null" : Util.displayString((String)actual, (int)2));
            System.out.println(",");
        }
        SearchTests.assertEquals((String)"Unexpected search pattern", (String)expected, (String)actual);
    }

    protected void assertValidMatchRule(String pattern, int rule) {
        this.assertValidMatchRule(pattern, rule, rule);
    }

    protected void assertValidMatchRule(String pattern, int rule, int expected) {
        String expectedRule;
        int validated = SearchPattern.validateMatchRule((String)pattern, (int)rule);
        String validatedRule = BasicSearchEngine.getMatchRuleString((int)validated);
        if (!validatedRule.equals(expectedRule = BasicSearchEngine.getMatchRuleString((int)expected))) {
            System.out.println("Test " + this.getName());
            System.out.print("\tassertValidMatchRule(\"");
            System.out.print(pattern);
            System.out.print("\", ");
            System.out.print(validatedRule);
            System.out.println(");");
            SearchTests.assertEquals((String)(String.valueOf(pattern) + "' does not match expected match rule!"), (String)expectedRule, (String)validatedRule);
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P");
        this.createFolder("/P/x");
        this.createFile("/P/x/Foo.js", "function foo1(){\n}");
        this.createFile("/P/x/I.js", "var v;\n");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeClasspath() throws CoreException, Semaphore.TimeOutException {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        WaitingJob job = new WaitingJob();
        try {
            indexManager.disable();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SearchTests.this.createJavaProject("P1");
                    SearchTests.this.createFile("/P1/X.js", "function bar() {\n}");
                }
            }, null);
            indexManager.request((IJob)job);
            indexManager.enable();
            job.startingSem.acquire(30000L);
            IJavaScriptProject project = this.getJavaProject("P1");
            project.setRawIncludepath(new IIncludePathEntry[0], null);
            job.runningSem.release();
            this.assertAllTypes("Unexpected all types after removing source folder", project, "");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            job.runningSem.release();
            this.deleteProject("P1");
            indexManager.enable();
            throw throwable;
        }
        {
            Object var4_6 = null;
            job.runningSem.release();
        }
        this.deleteProject("P1");
        indexManager.enable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeClasspath2() throws CoreException {
        try {
            final IJavaScriptProject project = this.createJavaProject("P1", new String[]{""}, "bin");
            this.createFile("/P1/X.js", "function bar() {\n}");
            this.assertAllTypes("Unexpected types before changing the classpath", null, "X\njava.io.Serializable\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable\nx.y.Foo\nx.y.I");
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SearchTests.this.createFolder("/P1/src");
                    project.setRawIncludepath(SearchTests.this.createClasspath(new String[]{"/P1/src"}, false, false), null);
                }
            }, null);
            this.assertAllTypes("Unexpected types after changing the classpath", null, "java.io.Serializable\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable\nx.y.Foo\nx.y.I");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testConcurrentJob() throws CoreException, InterruptedException, IOException, Semaphore.TimeOutException {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        WaitingJob job = new WaitingJob();
        try {
            indexManager.disable();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SearchTests.this.createJavaProject("P1", new String[0], new String[]{"/P1/jclMin.jar"}, "bin");
                    SearchTests.this.createFile("/P1/jclMin.jar", EMPTY_JAR);
                }
            }, null);
            indexManager.request((IJob)job);
            indexManager.enable();
            job.startingSem.acquire(30000L);
            final IJavaScriptProject project = this.getJavaProject("P1");
            final boolean[] success = new boolean[1];
            final WaitUntilReadyMonitor monitor = new WaitUntilReadyMonitor();
            Thread thread = new Thread(){

                public void run() {
                    try {
                        SearchTests.this.assertAllTypes("Unexpected all types", project, 3, monitor, "java.io.Serializable\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable");
                    }
                    catch (JavaScriptModelException e) {
                        e.printStackTrace();
                        return;
                    }
                    success[0] = true;
                }
            };
            thread.setDaemon(true);
            thread.start();
            monitor.sem.acquire(30000L);
            this.getFile("/P1/jclMin.jar").setContents((InputStream)new FileInputStream(this.getExternalJCLPathString()), 0, null);
            job.runningSem.release();
            thread.join(10000L);
            SearchTests.assertTrue((String)"Failed to get all types", (boolean)success[0]);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            job.runningSem.release();
            this.deleteProject("P1");
            indexManager.enable();
            throw throwable;
        }
        {
            Object var7_9 = null;
            job.runningSem.release();
        }
        this.deleteProject("P1");
        indexManager.enable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNullProgressMonitor() throws CoreException, Semaphore.TimeOutException {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        WaitingJob job = new WaitingJob();
        try {
            indexManager.disable();
            indexManager.request((IJob)job);
            indexManager.enable();
            job.startingSem.acquire(30000L);
            boolean operationCanceled = false;
            try {
                this.assertAllTypes(2, null, "Should not get any type");
            }
            catch (OperationCanceledException operationCanceledException) {
                operationCanceled = true;
            }
            SearchTests.assertTrue((String)"Should throw an OperationCanceledException", (boolean)operationCanceled);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            job.runningSem.release();
            throw throwable;
        }
        {
            Object var4_6 = null;
            job.runningSem.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _testProjectLib() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P1", new String[0], new String[]{"/P1"}, "bin");
            this.createClassFile("/P1", "X.class", "public class X {}");
            IProject project = javaProject.getProject();
            project.close(null);
            SearchTests.waitUntilIndexesReady();
            project.open(null);
            this.assertAllTypes("Unexpected types in P1", javaProject, "X");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveOuterFolder() throws CoreException {
        try {
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptProject project = SearchTests.this.createJavaProject("P1");
                    project.setRawIncludepath(SearchTests.this.createClasspath(new String[]{"/P1/src1", "src2/", "/P1/src1/src2", ""}, false, true), (IPath)new Path("/P1/bin"), null);
                    SearchTests.this.createFolder("/P1/src1/src2");
                    SearchTests.this.createFile("/P1/src1/src2/X.js", "public class X {\n}");
                }
            }, null);
            IJavaScriptProject project = this.getJavaProject("P1");
            this.assertAllTypes("Unexpected all types after setup", project, "X");
            project.setRawIncludepath(this.createClasspath(new String[]{"/P1/src1/src2", ""}, false, true), null);
            this.assertAllTypes("Unexpected all types after removing outer folder", project, "X");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P1");
    }

    public void testSearchPatternCreation01() {
        SearchPattern searchPattern = this.createPattern("main(*)", 1, 2, true);
        this.assertPattern("MethodReferencePattern: main(*), pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation02() {
        SearchPattern searchPattern = this.createPattern("main(*) void", 1, 2, true);
        this.assertPattern("MethodReferencePattern: main(*) --> void, pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation03() {
        SearchPattern searchPattern = this.createPattern("main(String*) void", 1, 2, true);
        this.assertPattern("MethodReferencePattern: main(String*) --> void, pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation04() {
        SearchPattern searchPattern = this.createPattern("main(*[])", 1, 2, true);
        this.assertPattern("MethodReferencePattern: main(*[]), pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation05() {
        SearchPattern searchPattern = this.createPattern("java.lang.*.main ", 1, 2, true);
        this.assertPattern("MethodReferencePattern: java.lang.*.main(...), pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation06() {
        SearchPattern searchPattern = this.createPattern("java.lang.* ", 3, 2, true);
        this.assertPattern("ConstructorReferencePattern: java.lang.*(...), pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation07() {
        SearchPattern searchPattern = this.createPattern("X(*,*)", 3, 2, true);
        this.assertPattern("ConstructorReferencePattern: X(*, *), pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation08() {
        SearchPattern searchPattern = this.createPattern("main(String*,*) void", 1, 2, true);
        this.assertPattern("MethodReferencePattern: main(String*, *) --> void, pattern match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation10() {
        SearchPattern searchPattern = this.createPattern("x.y.z.Bar.field Foo", 4, 0, true);
        this.assertPattern("FieldDeclarationPattern: x.y.z.Bar.field --> Foo, exact match, case sensitive", searchPattern);
    }

    public void testSearchPatternCreation12() {
        IField field = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getField("field");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)field, 2);
        this.assertPattern("FieldReferencePattern: x.y.z.Foo.field --> int, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation13() {
        IField field = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getField("field");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)field, 0);
        this.assertPattern("FieldDeclarationPattern: x.y.z.Foo.field --> int, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation14() {
        IField field = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getField("field");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)field, 3);
        this.assertPattern("FieldCombinedPattern: x.y.z.Foo.field --> int, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation15() {
        IImportDeclaration importDecl = this.getCompilationUnit("/P/x/y/z/Foo.js").getImport("x.y.*");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)importDecl, 2);
        this.assertPattern("PackageReferencePattern: <x.y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation16() {
        IFunction method = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getFunction("bar", new String[0]);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)method, 0);
        this.assertPattern("MethodDeclarationPattern: x.y.z.Foo.bar() --> void, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation17() {
        IFunction method = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getFunction("bar", new String[0]);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)method, 2);
        this.assertPattern("MethodReferencePattern: x.y.z.Foo.bar() --> void, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation18() {
        IFunction method = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo").getFunction("bar", new String[0]);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)method, 3);
        this.assertPattern("MethodCombinedPattern: x.y.z.Foo.bar() --> void, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation19() {
        IType type = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)type, 0);
        this.assertPattern("TypeDeclarationPattern: pkg<x.y.z>, enclosing<>, type<Foo>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation20() {
        IType type = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)type, 2);
        this.assertPattern("TypeReferencePattern: qualification<x.y.z>, type<Foo>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation21() {
        IType type = this.getCompilationUnit("/P/x/y/z/I.js").getType("I");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)type, 1);
        this.assertPattern("SuperInterfaceReferencePattern: <I>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation22() {
        IType type = this.getCompilationUnit("/P/x/y/z/Foo.js").getType("Foo");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)type, 3);
        this.assertPattern("TypeDeclarationPattern: pkg<x.y.z>, enclosing<>, type<Foo>, exact match, case sensitive, erasure only\n| TypeReferencePattern: qualification<x.y.z>, type<Foo>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation23() {
        IPackageDeclaration pkg = this.getCompilationUnit("/P/x/y/z/Foo.js").getPackageDeclaration("x.y.z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)pkg, 2);
        this.assertPattern("PackageReferencePattern: <x.y.z>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation24() {
        IPackageFragment pkg = this.getPackage("/P/x/y/z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)pkg, 2);
        this.assertPattern("PackageReferencePattern: <x.y.z>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation25() {
        IImportDeclaration importDecl = this.getCompilationUnit("/P/x/y/z/Foo.js").getImport("java.util.Vector");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)importDecl, 2);
        this.assertPattern("TypeReferencePattern: qualification<java.util>, type<Vector>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation26() {
        IPackageFragment pkg = this.getPackage("/P/x/y/z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)pkg, 0);
        this.assertPattern("PackageDeclarationPattern: <x.y.z>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation27() {
        IPackageDeclaration pkg = this.getCompilationUnit("/P/x/y/z/Foo.js").getPackageDeclaration("x.y.z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)pkg, 0);
        this.assertPattern("PackageDeclarationPattern: <x.y.z>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation28() {
        IImportDeclaration importDecl = this.getCompilationUnit("/P/x/y/z/Foo.js").getImport("x.y.*");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)importDecl, 0);
        this.assertPattern("PackageDeclarationPattern: <x.y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation29() {
        IPackageFragment pkg = this.getPackage("/P/x/y/z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)pkg, 3);
        this.assertPattern("PackageDeclarationPattern: <x.y.z>, exact match, case sensitive, erasure only\n| PackageReferencePattern: <x.y.z>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation30() {
        LocalVariable localVar = new LocalVariable((JavaElement)this.getCompilationUnit("/P/X.js").getType("X").getFunction("foo", new String[0]), "var", 1, 2, 3, 4, "Z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localVar, 0);
        this.assertPattern("LocalVarDeclarationPattern: var [in foo() [in X [in X.java [in <default> [in <project root> [in P]]]]]], exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation31() {
        LocalVariable localVar = new LocalVariable((JavaElement)this.getCompilationUnit("/P/X.js").getType("X").getFunction("foo", new String[0]), "var", 1, 2, 3, 4, "Z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localVar, 2);
        this.assertPattern("LocalVarReferencePattern: var [in foo() [in X [in X.java [in <default> [in <project root> [in P]]]]]], exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation32() {
        LocalVariable localVar = new LocalVariable((JavaElement)this.getCompilationUnit("/P/X.js").getType("X").getFunction("foo", new String[0]), "var", 1, 2, 3, 4, "Z");
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localVar, 3);
        this.assertPattern("LocalVarCombinedPattern: var [in foo() [in X [in X.java [in <default> [in <project root> [in P]]]]]], exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation33() {
        IType localType = this.getCompilationUnit("/P/X.js").getType("X").getFunction("foo", new String[0]).getType("Y", 2);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localType, 0);
        this.assertPattern("TypeDeclarationPattern: pkg<>, enclosing<X.*>, type<Y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation34() {
        IType localType = this.getCompilationUnit("/P/X.js").getType("X").getFunction("foo", new String[0]).getType("Y", 3);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localType, 2);
        this.assertPattern("TypeReferencePattern: qualification<X.*>, type<Y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation35() {
        IType localType = this.getCompilationUnit("/P/X.js").getType("X").getInitializer(1).getType("Y", 2);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localType, 0);
        this.assertPattern("TypeDeclarationPattern: pkg<>, enclosing<X.*>, type<Y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternCreation36() {
        IType localType = this.getCompilationUnit("/P/X.js").getType("X").getInitializer(2).getType("Y", 3);
        SearchPattern searchPattern = this.createPattern((IJavaScriptElement)localType, 2);
        this.assertPattern("TypeReferencePattern: qualification<X.*>, type<Y>, exact match, case sensitive, erasure only", searchPattern);
    }

    public void testSearchPatternValidMatchRule01() {
        this.assertValidMatchRule("foo", 0, 0);
        this.assertValidMatchRule("foo", 1, 1);
        this.assertValidMatchRule("foo", 2, 0);
        this.assertValidMatchRule("foo", 3, 1);
        this.assertValidMatchRule("foo", 128, 9);
    }

    public void testSearchPatternValidMatchRule02() {
        this.assertValidMatchRule("CP*P", 0, 2);
        this.assertValidMatchRule("CP*P", 1, 2);
        this.assertValidMatchRule("CP*P", 2, 2);
        this.assertValidMatchRule("CP*P", 3, 2);
        this.assertValidMatchRule("CP*P", 128, 2);
    }

    public void testSearchPatternValidMatchRule03() {
        this.assertValidMatchRule("NPE", 128);
        this.assertValidMatchRule("NPE", 137, 128);
        this.assertValidMatchRule("nPE", 128);
        this.assertValidMatchRule("NuPoEx", 128);
        this.assertValidMatchRule("oF", 128);
    }

    public void testSearchPatternValidMatchRule04() {
        this.assertValidMatchRule("Nu/Po/Ex", 128, 9);
        this.assertValidMatchRule("Nu.Po.Ex", 129, 1);
    }

    public void testSearchPatternValidMatchRule05() {
        this.assertValidMatchRule("hashMap", 128);
        this.assertValidMatchRule("Hashmap", 128);
    }

    public static class SearchTypeNameRequestor
    extends TypeNameRequestor {
        Vector results = new Vector();

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            char[] typeName = CharOperation.concat((char[])CharOperation.concatWith((char[][])enclosingTypeNames, (char)'$'), (char[])simpleTypeName, (char)'$');
            this.results.addElement(new String(CharOperation.concat((char[])packageName, (char[])typeName, (char)'.')));
        }

        public String toString() {
            int length = this.results.size();
            String[] strings = new String[length];
            this.results.toArray(strings);
            org.eclipse.wst.jsdt.internal.core.util.Util.sort((String[])strings);
            StringBuffer buffer = new StringBuffer(100);
            int i = 0;
            while (i < length) {
                buffer.append(strings[i]);
                if (i != length - 1) {
                    buffer.append('\n');
                }
                ++i;
            }
            return buffer.toString();
        }

        public int size() {
            return this.results.size();
        }
    }

    class WaitUntilReadyMonitor
    implements IProgressMonitor {
        public Semaphore sem = new Semaphore();

        WaitUntilReadyMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void internalWorked(double work) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
            this.sem.release();
        }

        public void worked(int work) {
        }
    }

    class WaitingJob
    implements IJob {
        static final int MAX_WAIT = 30000;
        Semaphore startingSem = new Semaphore();
        Semaphore runningSem = new Semaphore();

        WaitingJob() {
        }

        public boolean belongsTo(String jobFamily) {
            return false;
        }

        public void cancel() {
        }

        public void ensureReadyToRun() {
        }

        public boolean execute(IProgressMonitor progress) {
            this.startingSem.release();
            try {
                this.runningSem.acquire(30000L);
            }
            catch (Semaphore.TimeOutException e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

