/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class TypeHierarchySerializationTests
extends AbstractJavaModelTests {
    private static final String PROJECTNAME = "TypeHierarchySerialization";
    IJavaScriptProject project;
    static /* synthetic */ Class class$0;

    public TypeHierarchySerializationTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.TypeHierarchySerializationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TypeHierarchySerializationTests.buildModelTestSuite(clazz);
    }

    private static void compare(String focus, ITypeHierarchy stored, ITypeHierarchy loaded) {
        if (stored instanceof RegionBasedTypeHierarchy) {
            TypeHierarchySerializationTests.assertTrue((String)("[" + focus + "] hierarchies are not the same"), (boolean)(loaded instanceof RegionBasedTypeHierarchy));
            TypeHierarchySerializationTests.compareRegionBasedTypeHierarchy(focus, (RegionBasedTypeHierarchy)stored, (RegionBasedTypeHierarchy)loaded);
        } else if (stored instanceof TypeHierarchy) {
            TypeHierarchySerializationTests.assertTrue((String)("[" + focus + "] hierarchies are not the same"), (boolean)(loaded instanceof TypeHierarchy));
            TypeHierarchySerializationTests.compareTypeHierarchy(focus, (TypeHierarchy)stored, (TypeHierarchy)loaded);
        }
    }

    private static void compareRegionBasedTypeHierarchy(String focus, RegionBasedTypeHierarchy stored, RegionBasedTypeHierarchy loaded) {
        TypeHierarchySerializationTests.compareTypeHierarchy(focus, (TypeHierarchy)stored, (TypeHierarchy)loaded);
    }

    private static void compareTypeHierarchy(String focus, TypeHierarchy stored, TypeHierarchy loaded) {
        IType type1 = stored.getType();
        IType type2 = loaded.getType();
        TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] focus are not the same"), (Object)type1, (Object)type2);
        Object[] allTypes1 = stored.getAllTypes();
        Object[] allTypes2 = loaded.getAllTypes();
        TypeHierarchySerializationTests.compare("[" + focus + "] all types are not the same", allTypes1, allTypes2);
        Object[] allClasses1 = stored.getAllClasses();
        Object[] allClasses2 = loaded.getAllClasses();
        TypeHierarchySerializationTests.compare("[" + focus + "] all classes are not the same", allClasses1, allClasses2);
        Object[] allInterfaces1 = stored.getAllInterfaces();
        Object[] allInterfaces2 = loaded.getAllInterfaces();
        TypeHierarchySerializationTests.compare("[" + focus + "] all interfaces are not the same", allInterfaces1, allInterfaces2);
        Object[] rootClasses1 = stored.getRootClasses();
        Object[] rootClasses2 = loaded.getRootClasses();
        TypeHierarchySerializationTests.compare("[" + focus + "] all roots are not the same", rootClasses1, rootClasses2);
        Object[] rootInterfaces1 = stored.getRootInterfaces();
        Object[] rootInterfaces2 = loaded.getRootInterfaces();
        TypeHierarchySerializationTests.compare("[" + focus + "] all roots are not the same", rootInterfaces1, rootInterfaces2);
        Object[] missingTypes1 = stored.missingTypes.toArray();
        Object[] missingTypes2 = loaded.missingTypes.toArray();
        TypeHierarchySerializationTests.compare("[" + focus + "] all missing types are not the same", missingTypes1, missingTypes2);
        int i = 0;
        while (i < allTypes1.length) {
            Object aType = allTypes1[i];
            int cachedFlags1 = stored.getCachedFlags((IType)aType);
            int cachedFlags2 = loaded.getCachedFlags((IType)aType);
            TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] flags are not the same for " + aType.getFullyQualifiedName()), (int)cachedFlags1, (int)cachedFlags2);
            IType superclass1 = stored.getSuperclass((IType)aType);
            IType superclass2 = loaded.getSuperclass((IType)aType);
            TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] superclass are not the same for " + aType.getFullyQualifiedName()), (Object)superclass1, (Object)superclass2);
            Object[] superInterfaces1 = stored.getSuperInterfaces((IType)aType);
            Object[] superInterfaces2 = loaded.getSuperInterfaces((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all super interfaces are not the same for " + aType.getFullyQualifiedName(), superInterfaces1, superInterfaces2);
            Object[] superTypes1 = stored.getSupertypes((IType)aType);
            Object[] superTypes2 = loaded.getSupertypes((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all super types are not the same for " + aType.getFullyQualifiedName(), superTypes1, superTypes2);
            Object[] subclasses1 = stored.getSubclasses((IType)aType);
            Object[] subclasses2 = loaded.getSubclasses((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all subclasses are not the same for " + aType.getFullyQualifiedName(), subclasses1, subclasses2);
            Object[] subtypes1 = stored.getSubtypes((IType)aType);
            Object[] subtypes2 = loaded.getSubtypes((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all subtypes are not the same for " + aType.getFullyQualifiedName(), subtypes1, subtypes2);
            Object[] extendingInterfaces1 = stored.getExtendingInterfaces((IType)aType);
            Object[] extendingInterfaces2 = loaded.getExtendingInterfaces((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all extending interfaces are not the same for " + aType.getFullyQualifiedName(), extendingInterfaces1, extendingInterfaces2);
            Object[] implementingClasses1 = stored.getImplementingClasses((IType)aType);
            Object[] implementingClasses2 = loaded.getImplementingClasses((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all implemeting classes are not the same for " + aType.getFullyQualifiedName(), implementingClasses1, implementingClasses2);
            ++i;
        }
    }

    private static void compare(String msg, Object[] types1, Object[] types2) {
        if (types1 == null) {
            TypeHierarchySerializationTests.assertTrue((String)msg, (types2 == null ? 1 : 0) != 0);
        } else {
            TypeHierarchySerializationTests.assertTrue((String)msg, (types2 != null ? 1 : 0) != 0);
            TypeHierarchySerializationTests.assertTrue((String)msg, (types1.length == types2.length ? 1 : 0) != 0);
            int i = 0;
            while (i < types1.length) {
                boolean found = false;
                int j = 0;
                while (j < types2.length) {
                    if (types1[i] == null && types1[j] == null) {
                        found = true;
                    } else if (types1[i] != null && types1[i].equals(types2[j])) {
                        found = true;
                    }
                    ++j;
                }
                TypeHierarchySerializationTests.assertTrue((String)msg, (boolean)found);
                ++i;
            }
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.project = this.setUpJavaProject(PROJECTNAME);
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECTNAME);
        super.tearDownSuite();
    }

    private static void testFocusHierarchy(IType type, IJavaScriptProject project) throws JavaScriptModelException {
        ITypeHierarchy h1 = type.newTypeHierarchy(project, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        h1.store((OutputStream)outputStream, null);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ITypeHierarchy h2 = type.loadTypeHierachy((InputStream)inputStream, null);
        TypeHierarchySerializationTests.compare(type.getFullyQualifiedName(), h1, h2);
        h2.refresh(null);
        TypeHierarchySerializationTests.compare(type.getFullyQualifiedName(), h1, h2);
    }

    public void test001() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "X.js");
        IType type = cu.getType("X");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test002() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "Y.js");
        IType type = cu.getType("Y");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test003() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "Z.js");
        IType type = cu.getType("Z");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test004() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I1.js");
        IType type = cu.getType("I1");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test005() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I2.js");
        IType type = cu.getType("I2");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test006() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I3.js");
        IType type = cu.getType("I3");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test007() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I4.js");
        IType type = cu.getType("I4");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test008() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I5.js");
        IType type = cu.getType("I5");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test009() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "I6.js");
        IType type = cu.getType("I6");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }
}

