/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingMoveTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingMoveTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingMoveTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingMoveTest.allTests();
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(1);
        types.remove(1);
        types.add(typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0002() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0002", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = (TypeDeclaration)types.get(1);
        types.remove(1);
        TypeDeclaration typeDeclaration2 = a.newTypeDeclaration();
        typeDeclaration2.setName(a.newSimpleName("A"));
        typeDeclaration2.bodyDeclarations().add(typeDeclaration1);
        types.add(typeDeclaration2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class A {\n");
        buf.append("    class Y {\n");
        buf.append("    \n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = (TypeDeclaration)types.get(1);
        types.remove(1);
        TypeDeclaration typeDeclaration2 = a.newTypeDeclaration();
        typeDeclaration2.setName(a.newSimpleName("A"));
        typeDeclaration2.bodyDeclarations().add(typeDeclaration1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = (TypeDeclaration)types.get(1);
        types.remove(1);
        types.add(typeDeclaration1);
        types.remove(2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0005() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0005", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0005;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = (TypeDeclaration)types.get(1);
        types.remove(1);
        types.add(1, typeDeclaration1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0005;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0006() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0006", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        types.remove(0);
        types.set(1, typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0007() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0007", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0007;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("    int i;\n");
        buf.append("    int foo() {\n");
        buf.append("        \n");
        buf.append("        return i;\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(1);
        types.remove(1);
        types.add(typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0007;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("    int i;\n");
        buf.append("    int foo() {\n");
        buf.append("        \n");
        buf.append("        return i;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0008() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0008", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0008;\n");
        buf.append("\n");
        buf.append("public class X extends Z1\n");
        buf.append("                        .Z2\n");
        buf.append("                            .Z3 {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = (TypeDeclaration)types.get(0);
        TypeDeclaration typeDeclaration2 = (TypeDeclaration)types.get(1);
        Name name = typeDeclaration1.getSuperclass();
        typeDeclaration1.setSuperclass(null);
        typeDeclaration2.setSuperclass(name);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0008;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y extends Z1\n");
        buf.append("                        .Z2\n");
        buf.append("                            .Z3 {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0009() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0009", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0009;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    void foo() {\n");
        buf.append("        bar1();\n");
        buf.append("        \n");
        buf.append("        //comment1\n");
        buf.append("        bar2();//comment2\n");
        buf.append("        //comment3\n");
        buf.append("        bar3();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        FunctionDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Block body = methodDeclaration.getBody();
        List statements = body.statements();
        Statement statement = (Statement)statements.get(1);
        statements.remove(1);
        statements.add(statement);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0009;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    void foo() {\n");
        buf.append("        bar1();\n");
        buf.append("        \n");
        buf.append("        //comment3\n");
        buf.append("        bar3();\n");
        buf.append("        //comment1\n");
        buf.append("        bar2();//comment2\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingMoveTest.assertEqualString(preview, buf.toString());
    }
}

