/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AcceptLicensesWizardPage;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.discovery.internal.ImageResource;
import org.eclipse.wst.server.discovery.internal.Messages;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.wizard.ErrorWizardPage;
import org.eclipse.wst.server.discovery.internal.wizard.ExtensionWizardPage;

public class ExtensionWizard
extends Wizard {
    protected ExtensionWizardPage extensionPage;
    protected AcceptLicensesWizardPage licensePage;
    protected ErrorWizardPage errorPage;
    protected IWizardPage nextPage;

    public ExtensionWizard() {
        this.setWindowTitle(Messages.wizExtensionTitle);
        this.setDefaultPageImageDescriptor(ImageResource.getImageDescriptor("wizard"));
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        super.addPages();
        Policy policy = new Policy();
        this.licensePage = new AcceptLicensesWizardPage(policy, new IInstallableUnit[0], null);
        this.licensePage.setWizard((IWizard)this);
        this.errorPage = new ErrorWizardPage();
        this.errorPage.setWizard((IWizard)this);
        this.extensionPage = new ExtensionWizardPage(this.licensePage, this.errorPage);
        this.extensionPage.setWizard((IWizard)this);
    }

    public int getPageCount() {
        if (this.nextPage != null) {
            return 2;
        }
        return 1;
    }

    public IWizardPage[] getPages() {
        if (this.nextPage != null) {
            return new IWizardPage[]{this.extensionPage, this.nextPage};
        }
        return new IWizardPage[]{this.extensionPage};
    }

    public boolean canFinish() {
        return this.licensePage.equals(this.nextPage) && this.licensePage.isPageComplete();
    }

    public IWizardPage getStartingPage() {
        return this.extensionPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (((Object)((Object)this.extensionPage)).equals(page)) {
            return this.nextPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.nextPage != null && this.nextPage.equals(page)) {
            return this.extensionPage;
        }
        return null;
    }

    public void setSecondPage(IWizardPage page) {
        this.nextPage = page;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ExtensionWizard.this.getContainer().updateButtons();
            }
        });
    }

    public boolean performFinish() {
        return ExtensionWizard.install(this.extensionPage.getExtension());
    }

    protected static boolean install(final Extension extension) {
        if (extension == null) {
            return false;
        }
        final boolean[] b = new boolean[1];
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                String msg = NLS.bind((String)Messages.installConfirm, (Object)extension.getName());
                b[0] = MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)Messages.dialogTitle, (String)msg);
            }
        });
        if (!b[0]) {
            return true;
        }
        String name = NLS.bind((String)Messages.installJobName, (Object)extension.getName());
        Job job = new Job(name){

            public IStatus run(IProgressMonitor monitor) {
                return extension.install(monitor);
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }
}

