/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class TextRegionListImpl
implements ITextRegionList {
    private static final int growthConstant = 2;
    private ITextRegion[] fRegions;
    private int fRegionsCount = 0;

    public TextRegionListImpl() {
    }

    public TextRegionListImpl(ITextRegionList regionList) {
        this();
        this.fRegions = (ITextRegion[])regionList.toArray().clone();
        this.fRegionsCount = this.fRegions.length;
    }

    public boolean add(ITextRegion region) {
        if (region == null) {
            return false;
        }
        this.ensureCapacity(this.fRegionsCount + 1);
        this.fRegions[this.fRegionsCount++] = region;
        return true;
    }

    public boolean addAll(int insertPos, ITextRegionList newRegions) {
        if (insertPos < 0 || insertPos > this.fRegionsCount) {
            throw new ArrayIndexOutOfBoundsException(insertPos);
        }
        int newRegionsSize = newRegions.size();
        this.ensureCapacity(this.fRegionsCount + newRegionsSize);
        int numMoved = this.fRegionsCount - insertPos;
        if (numMoved > 0) {
            System.arraycopy(this.fRegions, insertPos, this.fRegions, insertPos + newRegionsSize, numMoved);
        }
        int i = 0;
        while (i < newRegionsSize) {
            this.fRegions[insertPos++] = newRegions.get(i);
            ++i;
        }
        this.fRegionsCount += newRegionsSize;
        return newRegionsSize != 0;
    }

    public void clear() {
        this.fRegionsCount = 0;
    }

    private void ensureCapacity(int needed) {
        if (this.fRegions == null) {
            this.fRegions = new ITextRegion[needed];
            return;
        }
        int oldLength = this.fRegions.length;
        if (oldLength < needed) {
            ITextRegion[] oldAdapters = this.fRegions;
            ITextRegion[] newAdapters = new ITextRegion[needed + 2];
            System.arraycopy(oldAdapters, 0, newAdapters, 0, this.fRegionsCount);
            this.fRegions = newAdapters;
        }
    }

    public ITextRegion get(int index) {
        if (index < 0 || index > this.fRegionsCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.fRegions[index];
    }

    public int indexOf(ITextRegion region) {
        int result = -1;
        if (region != null && this.fRegions != null) {
            int i = 0;
            while (i < this.fRegions.length) {
                if (region.equals(this.fRegions[i])) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.fRegionsCount == 0;
    }

    public Iterator iterator() {
        if (this.size() == 0) {
            return new NullIterator();
        }
        return new RegionIterator();
    }

    public ITextRegion remove(int index) {
        ITextRegion oneToRemove = this.get(index);
        this.remove(oneToRemove);
        return oneToRemove;
    }

    public void remove(ITextRegion a) {
        if (this.fRegions == null || a == null) {
            return;
        }
        int newIndex = 0;
        ITextRegion[] newRegions = new ITextRegion[this.fRegionsCount];
        int oldRegionCount = this.fRegionsCount;
        boolean found = false;
        int oldIndex = 0;
        while (oldIndex < oldRegionCount) {
            ITextRegion candidate = this.fRegions[oldIndex];
            if (a == candidate) {
                --this.fRegionsCount;
                found = true;
            } else {
                newRegions[newIndex++] = this.fRegions[oldIndex];
            }
            ++oldIndex;
        }
        if (found) {
            this.fRegions = newRegions;
        }
    }

    public void removeAll(ITextRegionList regionList) {
        if (regionList != null) {
            int i = 0;
            while (i < regionList.size()) {
                this.remove(regionList.get(i));
                ++i;
            }
        }
    }

    public int size() {
        return this.fRegionsCount;
    }

    public ITextRegion[] toArray() {
        ITextRegion[] newArray = new ITextRegion[this.fRegionsCount];
        System.arraycopy(this.fRegions, 0, newArray, 0, this.fRegionsCount);
        return newArray;
    }

    private class NullIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("can not remove regions via iterator");
        }
    }

    private class RegionIterator
    implements Iterator {
        private ITextRegion[] fIteratorRegions;
        private int index = -1;
        private int maxindex = -1;

        public RegionIterator() {
            this.fIteratorRegions = TextRegionListImpl.this.toArray();
            this.maxindex = this.fIteratorRegions.length - 1;
        }

        public boolean hasNext() {
            return this.index < this.maxindex;
        }

        public Object next() {
            if (this.index >= this.maxindex) {
                throw new NoSuchElementException();
            }
            return this.fIteratorRegions[++this.index];
        }

        public void remove() {
            throw new UnsupportedOperationException("can not remove regions via iterator");
        }
    }
}

