/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSDouble
extends NumericType {
    private double _value;

    public XSDouble(double x) {
        this._value = x;
    }

    public XSDouble() {
        this(0.0);
    }

    public XSDouble(String init) throws DynamicError {
        try {
            this._value = new Double(init);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public static XSDouble parse_double(String i) {
        try {
            Double d = new Double(i);
            return new XSDouble(d);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSDouble d = XSDouble.parse_double(aat.string_value());
        if (d == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(d);
        return rs;
    }

    public String string_type() {
        return "xs:double";
    }

    public String type_name() {
        return "double";
    }

    public String string_value() {
        return "" + this._value;
    }

    public boolean nan() {
        return this._value == Double.NaN;
    }

    public boolean zero() {
        return this._value == 0.0;
    }

    public double double_value() {
        return this._value;
    }

    public boolean eq(AnyType aa) throws DynamicError {
        if (!(aa instanceof XSDouble)) {
            throw DynamicError.throw_type_error();
        }
        XSDouble d = (XSDouble)aa;
        return this.double_value() == d.double_value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return this.double_value() > val.double_value();
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return this.double_value() < val.double_value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSDouble)) {
            DynamicError.throw_type_error();
        }
        XSDouble val = (XSDouble)at;
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() + val.double_value()));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() - val.double_value()));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() * val.double_value()));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() / val.double_value()));
    }

    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        return ResultSequenceFactory.create_new(new XSInteger((int)(this.double_value() / val.double_value())));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)XSDouble.get_single_type(arg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() % val.double_value()));
    }

    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSDouble(-1.0 * this.double_value()));
    }

    public NumericType abs() {
        return new XSDouble(Math.abs(this.double_value()));
    }

    public NumericType ceiling() {
        return new XSDouble(Math.ceil(this.double_value()));
    }

    public NumericType floor() {
        return new XSDouble(Math.floor(this.double_value()));
    }

    public NumericType round() {
        return new XSDouble(Math.round(this.double_value()));
    }

    public NumericType round_half_to_even() {
        return new XSDouble(Math.rint(this.double_value()));
    }
}

