/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.contentassist.IContentAssistProposalRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistRequestFactory;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLElementContentAssistRequest;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLContentAssistProcessor
implements IContentAssistProcessor {
    private String errorMessage = "";
    private ITextViewer textViewer = null;
    private ArrayList<ICompletionProposal> xslProposals = new ArrayList();
    private ArrayList<ICompletionProposal> additionalProposals = new ArrayList();
    private IndexedRegion treeNode;
    private Node node;
    private IDOMNode xmlNode;
    private IStructuredDocumentRegion sdRegion;
    private ITextRegion completionRegion;
    private String matchString;
    private int cursorPosition;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.initializeProposalVariables(textViewer, documentPosition);
        ICompletionProposal[] xmlProposals = this.getXMLProposals();
        this.additionalProposals = this.getAdditionalXSLElementProposals();
        this.xslProposals = this.getXSLNamespaceProposals();
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
        this.addProposals(xmlProposals, proposalList);
        proposalList.addAll(this.additionalProposals);
        proposalList.addAll(this.xslProposals);
        ICompletionProposal[] combinedProposals = this.combineProposals(proposalList);
        if (combinedProposals == null || combinedProposals.length == 0) {
            this.setErrorMessage(Messages.NoContentAssistance);
        }
        return combinedProposals;
    }

    private void initializeProposalVariables(ITextViewer textViewer, int documentPosition) {
        this.textViewer = textViewer;
        this.cursorPosition = documentPosition;
        this.treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)this.cursorPosition);
        this.node = this.getActualDOMNode((Node)this.treeNode);
        this.xmlNode = (IDOMNode)this.node;
        this.sdRegion = this.getStructuredDocumentRegion();
        this.completionRegion = this.getCompletionRegion(this.cursorPosition, this.node);
        this.matchString = this.getMatchString(this.sdRegion, this.completionRegion, this.cursorPosition);
    }

    private ArrayList<ICompletionProposal> getXSLNamespaceProposals() {
        if (XSLCore.isXSLNamespace((Node)this.xmlNode)) {
            XSLContentAssistRequestFactory requestFactory = new XSLContentAssistRequestFactory(this.textViewer, this.cursorPosition, this.xmlNode, this.sdRegion, this.completionRegion, this.matchString);
            IContentAssistProposalRequest contentAssistRequest = requestFactory.getContentAssistRequest();
            this.xslProposals = contentAssistRequest.getCompletionProposals();
        }
        return this.xslProposals;
    }

    private ArrayList<ICompletionProposal> getAdditionalXSLElementProposals() {
        if (!XSLCore.isXSLNamespace((Node)this.xmlNode)) {
            this.additionalProposals = new XSLElementContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.cursorPosition, 0, this.matchString, this.textViewer).getCompletionProposals();
        }
        return this.additionalProposals;
    }

    private ICompletionProposal[] getXMLProposals() {
        XMLContentAssistProcessor processor = new XMLContentAssistProcessor();
        ICompletionProposal[] proposals = processor.computeCompletionProposals(this.textViewer, this.cursorPosition);
        return proposals;
    }

    private void addProposals(ICompletionProposal[] proposals, ArrayList<ICompletionProposal> proposalList) {
        if (proposals != null) {
            int cnt = 0;
            while (cnt < proposals.length) {
                proposalList.add(proposals[cnt]);
                ++cnt;
            }
        }
    }

    private ICompletionProposal[] combineProposals(ArrayList<ICompletionProposal> proposalList) {
        ICompletionProposal[] combinedProposals = new ICompletionProposal[proposalList.size()];
        proposalList.toArray(combinedProposals);
        return combinedProposals;
    }

    private Node getActualDOMNode(Node node) {
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    private IStructuredDocumentRegion getStructuredDocumentRegion() {
        return ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.textViewer, (int)this.cursorPosition);
    }

    protected ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    protected ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    private String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        String matchString = "";
        if (this.isNotMatchStringRegion(parent, aRegion, offset)) {
            return matchString;
        }
        if (this.hasMatchString(parent, aRegion, offset)) {
            matchString = this.extractMatchString(parent, aRegion, offset);
        }
        return matchString;
    }

    private boolean isNotMatchStringRegion(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null || parent == null) {
            return true;
        }
        String regionType = aRegion.getType();
        int totalRegionOffset = parent.getStartOffset(aRegion) + aRegion.getTextLength();
        return this.isCloseRegion(aRegion) || this.hasNoMatchString(offset, regionType, totalRegionOffset);
    }

    private boolean isCloseRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_CDATA_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_ATTLIST_DECL_CLOSE" || type == "XML_ELEMENT_DECL_CLOSE" || type == "XML_DOCTYPE_DECLARATION_CLOSE" || type == "XML_DECLARATION_CLOSE";
    }

    private boolean hasMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset;
    }

    private boolean hasNoMatchString(int offset, String regionType, int totalRegionOffset) {
        return regionType.equals("XML_CONTENT") || regionType.equals("XML_TAG_ATTRIBUTE_EQUALS") || regionType.equals("XML_TAG_OPEN") || offset > totalRegionOffset;
    }

    private String extractMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        String matchString = parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion));
        if (matchString.startsWith("\"")) {
            matchString = matchString.substring(1);
        }
        return matchString;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] completionProposals = new char[]{'\"', '\'', ':', '[', '{', '<'};
        return completionProposals;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

