/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.ZipLocation;

public class FileLocation
extends Location
implements IFileLocation {
    protected File file;

    public FileLocation(File file) {
        this(null, file.getAbsolutePath());
    }

    public FileLocation(FileLocation parent, String name) {
        super(parent, name);
        this.file = parent != null ? new File(parent.file, this.getName()) : new File(this.getName());
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public ILocationChildrenIterator childIterator() {
        if (this.file.isDirectory()) {
            final String[] children = this.file.list();
            return new ILocationChildrenIterator(){
                private int index = 0;

                public ILocation next() {
                    if (this.index < children.length) {
                        String child;
                        File childFile;
                        if ((childFile = new File(FileLocation.this.file, child = children[this.index++])).isDirectory()) {
                            return new FileLocation(FileLocation.this, child);
                        }
                        if (Location.isArchive(child)) {
                            return new ZipLocation(FileLocation.this, child);
                        }
                        return new FileLocation(FileLocation.this, child);
                    }
                    return null;
                }
            };
        }
        return new ILocationChildrenIterator(){

            public ILocation next() {
                return null;
            }
        };
    }

    public boolean hasChildren() {
        return this.file.isDirectory();
    }

    public File getFile() {
        return this.file;
    }

    public ILocation createSibling(String relativePath) {
        FileLocation parentLocation = (FileLocation)this.parent;
        File childFile = new File(parentLocation.file, relativePath);
        if (childFile.isDirectory()) {
            return new FileLocation(parentLocation, relativePath);
        }
        if (Location.isArchive(relativePath)) {
            return new ZipLocation(parentLocation, relativePath);
        }
        return new FileLocation(parentLocation, relativePath);
    }

    public ILocation createChild(String relativePath) {
        File childFile = new File(this.file, relativePath);
        if (childFile.isDirectory()) {
            return new FileLocation(this, relativePath);
        }
        if (Location.isArchive(relativePath)) {
            return new ZipLocation(this, relativePath);
        }
        return new FileLocation(this, relativePath);
    }

    public String getAbsolutePath() {
        if (this.parent == null) {
            return this.getName();
        }
        return String.valueOf(this.parent.getAbsolutePath()) + "/" + this.getName();
    }
}

