/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.internal.performance.eval.StatisticsUtil;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceMeter;

public abstract class InternalPerformanceMeter
extends PerformanceMeter {
    public static final int AVERAGE = -3;
    public static final int SIZE = -4;
    public static final int STDEV = -5;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    protected static final String VERBOSE_PERFORMANCE_METER_PROPERTY = "InternalPrintPerformanceResults";
    private String fScenarioId;
    private String fShortName;
    private Dimension[] fSummaryDimensions;
    private boolean fSummaryIsGlobal;
    private int fCommentType;
    private String fComment;

    public InternalPerformanceMeter(String scenarioId) {
        this.fScenarioId = scenarioId;
    }

    public void dispose() {
        this.fScenarioId = null;
    }

    public abstract Sample getSample();

    public String getScenarioName() {
        return this.fScenarioId;
    }

    public void commit() {
        Sample sample = this.getSample();
        if (sample != null) {
            if (this.fSummaryDimensions != null) {
                sample.tagAsSummary(this.fSummaryIsGlobal, this.fShortName, this.fSummaryDimensions, this.fCommentType, this.fComment);
            } else if (this.fComment != null) {
                sample.setComment(this.fCommentType, this.fComment);
            }
            Variations variations = PerformanceTestPlugin.getVariations();
            if (variations != null) {
                DB.store(variations, sample);
            }
            if (!DB.isActive() || System.getProperty(VERBOSE_PERFORMANCE_METER_PROPERTY) != null) {
                this.printSample(System.out, sample);
            }
        }
    }

    private void printSample(PrintStream ps, Sample sample) {
        ps.print("Scenario '" + this.getScenarioName() + "' ");
        DataPoint[] dataPoints = sample.getDataPoints();
        if (dataPoints.length > 0) {
            StatisticsSession s = new StatisticsSession(dataPoints);
            Dim[] dimensions = dataPoints[0].getDimensions();
            Arrays.sort(dimensions, new DimensionComparator());
            if (dimensions.length > 0) {
                Dim dimension;
                ArrayList<Dim> badDimensions = new ArrayList<Dim>();
                long n = s.getCount(dimensions[0]);
                MessageFormat format = new MessageFormat("({0,number,percent} in [{1}, {2}])");
                String spaces = "                                                                                                       ";
                ps.println("(average over " + n + " samples):");
                int i = 0;
                while (i < dimensions.length) {
                    block7: {
                        String sizeWarning;
                        dimension = dimensions[i];
                        double mean = s.getAverage(dimension);
                        String nameString = "  " + dimension.getName() + ":";
                        String meanString = dimension.getDisplayValue(mean);
                        int align = this.firstNonDigit(meanString);
                        meanString = String.valueOf(spaces.substring(0, 30 - align - nameString.length())) + meanString;
                        align = nameString.length() + meanString.length();
                        StatisticsUtil.Percentile percentile = StatisticsUtil.T95;
                        double[] confidenceInterval = s.getConfidenceInterval(dimension, percentile);
                        String confidenceString = n <= 2L ? " (no confidence)" : String.valueOf(spaces.substring(0, 40 - align)) + format.format(new Object[]{new Double(percentile.inside()), dimension.getDisplayValue(confidenceInterval[0]), dimension.getDisplayValue(confidenceInterval[1])});
                        align += confidenceString.length();
                        try {
                            sizeWarning = String.valueOf(spaces.substring(0, 70 - align)) + this.checkSampleSize(s, sample, dimension);
                        }
                        catch (CoreException coreException) {
                            badDimensions.add(dimension);
                            break block7;
                        }
                        ps.println(String.valueOf(nameString) + meanString + confidenceString + sizeWarning);
                    }
                    ++i;
                }
                if (!badDimensions.isEmpty()) {
                    ps.print("  Dimensions with unusable statistical properties: ");
                    Iterator iter = badDimensions.iterator();
                    while (iter.hasNext()) {
                        dimension = (Dim)iter.next();
                        ps.print(dimension.getName());
                        if (!iter.hasNext()) continue;
                        ps.print(", ");
                    }
                    ps.println();
                }
            }
        }
        ps.println();
    }

    private String checkSampleSize(StatisticsSession s, Sample sample, Dim dimension) throws CoreException {
        String baseName;
        double base;
        long sampleSize = s.getCount(dimension);
        double stdev = s.getStddev(dimension);
        double mean = s.getAverage(dimension);
        if (stdev == 0.0) {
            return "";
        }
        double effectSize = 4.0 * Math.sqrt(stdev * stdev / (double)sampleSize);
        if (stdev > Math.abs(mean)) {
            base = stdev;
            baseName = "stdev";
        } else {
            base = Math.abs(mean);
            baseName = "mean";
        }
        double fivePercentEffect = 0.05 * base;
        long requiredSampleSizeForFivePercentEffect = Math.round(16.0 * stdev * stdev / fivePercentEffect / fivePercentEffect + 0.5);
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(1);
        numberInstance.setMinimumFractionDigits(1);
        String measurableMsg = " Measurable effect: " + dimension.getDisplayValue(effectSize) + " (" + numberInstance.format(effectSize / stdev) + " SDs)";
        if (fivePercentEffect < effectSize) {
            measurableMsg = String.valueOf(measurableMsg) + " (required sample size for an effect of 5% of " + baseName + ": " + requiredSampleSizeForFivePercentEffect + ")";
        }
        return measurableMsg;
    }

    private int firstNonDigit(String string) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (!Character.isDigit(string.charAt(i)) && string.charAt(i) != '-' && string.charAt(i) != '.') {
                return i;
            }
            ++i;
        }
        return length;
    }

    void printSampleCSV(PrintStream ps, Sample sample) {
        DataPoint[] dataPoints = sample.getDataPoints();
        if (dataPoints.length > 0) {
            Dim[] dimensions = dataPoints[0].getDimensions();
            Arrays.sort(dimensions, new DimensionComparator());
            if (dimensions.length > 0) {
                int d = 0;
                while (d < dimensions.length) {
                    Dim dimension = dimensions[d];
                    ps.print(dimension.getName());
                    ps.print('\t');
                    ++d;
                }
                ps.println("scenario");
                int p = 0;
                while (p < dataPoints.length - 1) {
                    DataPoint before = dataPoints[p];
                    DataPoint after = dataPoints[p + 1];
                    int d2 = 0;
                    while (d2 < dimensions.length) {
                        Dim dimension = dimensions[d2];
                        long valBefore = before.getScalar(dimension).getMagnitude();
                        long valAfter = after.getScalar(dimension).getMagnitude();
                        ps.print(valAfter - valBefore);
                        ps.print('\t');
                        ++d2;
                    }
                    ps.print(sample.getShortname() != null ? sample.getShortname() : sample.getScenarioID());
                    ps.println();
                    p += 2;
                }
                ps.println();
            }
        }
    }

    public void tagAsSummary(boolean global, String shortName, Dimension[] dims) {
        this.fSummaryIsGlobal = global;
        this.fShortName = shortName;
        this.fSummaryDimensions = dims;
    }

    public void setComment(int commentType, String comment) {
        this.fCommentType = commentType;
        this.fComment = comment;
    }

    private static class DimensionComparator
    implements Comparator {
        private DimensionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Dim)o1).getId() - ((Dim)o2).getId();
        }
    }
}

