"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const server_1 = require("./lib/server");
if (process.argv.includes('--version')) {
    console.log(require('./package.json').version);
}
else {
    let ts;
    for (const arg of process.argv) {
        if (arg.startsWith('--tsdk=')) {
            const tsdk = arg.substring('--tsdk='.length);
            const tsPath = require.resolve('./typescript.js', { paths: [tsdk] });
            ts = require(tsPath);
            break;
        }
    }
    ts ??= require('typescript');
    (0, server_1.startServer)(ts);
}
//# sourceMappingURL=index.js.map