$NetBSD: patch-src_lib_reader.c,v 1.1 2018/03/15 19:51:08 khorben Exp $

Do not truncate pass-phrases without a newline character.

--- src/lib/reader.c.orig	2012-03-05 02:20:18.000000000 +0000
+++ src/lib/reader.c
@@ -160,6 +160,7 @@ int
 pgp_getpassphrase(void *in, char *phrase, size_t size)
 {
 	char	*p;
+	size_t	 len;
 
 	if (in == NULL) {
 		while ((p = getpass("netpgp passphrase: ")) == NULL) {
@@ -169,7 +170,10 @@ pgp_getpassphrase(void *in, char *phrase
 		if (fgets(phrase, (int)size, in) == NULL) {
 			return 0;
 		}
-		phrase[strlen(phrase) - 1] = 0x0;
+		len = strlen(phrase);
+		if (len >= 1 && phrase[len - 1] == '\n') {
+			phrase[len - 1] = '\0';
+		}
 	}
 	return 1;
 }
