/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.List;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;

public class JREDesc {
    private final Version version;
    private final URL location;
    private final String initialHeapSize;
    private final String maximumHeapSize;
    private final String vmArgs;
    private final List<ResourcesDesc> resources;

    public JREDesc(Version version, URL uRL, String string, String string2, String string3, List<ResourcesDesc> list) throws ParseException {
        this.version = version;
        this.location = uRL;
        this.vmArgs = string;
        JREDesc.checkHeapSize(string2);
        this.initialHeapSize = string2;
        JREDesc.checkHeapSize(string3);
        this.maximumHeapSize = string3;
        this.resources = list;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isPlatformVersion() {
        return this.getLocation() == null;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getMaximumHeapSize() {
        return this.maximumHeapSize;
    }

    public String getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public List<ResourcesDesc> getResourcesDesc() {
        return this.resources;
    }

    public String getVMArgs() {
        return this.vmArgs;
    }

    private static void checkHeapSize(String string) throws ParseException {
        if (string == null) {
            return;
        }
        boolean bl = true;
        char c = Character.toLowerCase(string.charAt(string.length() - 1));
        if (c < '0' || c > '9') {
            bl = false;
            if (c != 'k' && c != 'm') {
                throw new ParseException(Translator.R("PBadHeapSize", string));
            }
        }
        int n = string.length() - 1;
        if (!bl) {
            --n;
        }
        String string2 = string.substring(0, n);
        try {
            Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(Translator.R("PBadHeapSize", string), numberFormatException);
        }
    }
}

