/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URI;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.PropertyPermission;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.NullJnlpFileException;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDesc {
    public static final Object ALL_PERMISSIONS = "All";
    public static final Object SANDBOX_PERMISSIONS = "Sandbox";
    public static final Object J2EE_PERMISSIONS = "J2SE";
    private Object type;
    private String downloadHost;
    private final boolean grantAwtPermissions;
    private JNLPFile file;
    private final Policy customTrustedPolicy;
    private static Permission[] j2eePermissions = new Permission[]{new AWTPermission("accessClipboard"), new RuntimePermission("exitVM"), new RuntimePermission("loadLibrary"), new RuntimePermission("queuePrintJob"), new SocketPermission("*", "connect"), new SocketPermission("localhost:1024-", "accept, listen"), new FilePermission("*", "read, write"), new PropertyPermission("*", "read")};
    private static Permission[] sandboxPermissions = new Permission[]{new SocketPermission("localhost:1024-", "listen"), new PropertyPermission("java.version", "read"), new PropertyPermission("java.vendor", "read"), new PropertyPermission("java.vendor.url", "read"), new PropertyPermission("java.class.version", "read"), new PropertyPermission("os.name", "read"), new PropertyPermission("os.version", "read"), new PropertyPermission("os.arch", "read"), new PropertyPermission("file.separator", "read"), new PropertyPermission("path.separator", "read"), new PropertyPermission("line.separator", "read"), new PropertyPermission("java.specification.version", "read"), new PropertyPermission("java.specification.vendor", "read"), new PropertyPermission("java.specification.name", "read"), new PropertyPermission("java.vm.specification.vendor", "read"), new PropertyPermission("java.vm.specification.name", "read"), new PropertyPermission("java.vm.version", "read"), new PropertyPermission("java.vm.vendor", "read"), new PropertyPermission("java.vm.name", "read"), new PropertyPermission("javawebstart.version", "read"), new PropertyPermission("javaplugin.*", "read"), new PropertyPermission("jnlp.*", "read,write"), new PropertyPermission("javaws.*", "read,write"), new PropertyPermission("browser", "read"), new PropertyPermission("browser.*", "read"), new RuntimePermission("exitVM"), new RuntimePermission("stopThread")};
    private static Permission[] jnlpRIAPermissions = new Permission[]{new PropertyPermission("awt.useSystemAAFontSettings", "read,write"), new PropertyPermission("http.agent", "read,write"), new PropertyPermission("http.keepAlive", "read,write"), new PropertyPermission("java.awt.syncLWRequests", "read,write"), new PropertyPermission("java.awt.Window.locationByPlatform", "read,write"), new PropertyPermission("javaws.cfg.jauthenticator", "read,write"), new PropertyPermission("javax.swing.defaultlf", "read,write"), new PropertyPermission("sun.awt.noerasebackground", "read,write"), new PropertyPermission("sun.awt.erasebackgroundonresize", "read,write"), new PropertyPermission("sun.java2d.d3d", "read,write"), new PropertyPermission("sun.java2d.dpiaware", "read,write"), new PropertyPermission("sun.java2d.noddraw", "read,write"), new PropertyPermission("sun.java2d.opengl", "read,write"), new PropertyPermission("swing.boldMetal", "read,write"), new PropertyPermission("swing.metalTheme", "read,write"), new PropertyPermission("swing.noxp", "read,write"), new PropertyPermission("swing.useSystemFontSettings", "read,write")};

    public SecurityDesc(JNLPFile jNLPFile, Object object, String string) {
        if (jNLPFile == null) {
            throw new NullJnlpFileException();
        }
        this.file = jNLPFile;
        this.type = object;
        this.downloadHost = string;
        String string2 = "deployment.security.sandbox.awtwarningwindow";
        this.grantAwtPermissions = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty(string2));
        this.customTrustedPolicy = this.getCustomTrustedPolicy();
    }

    private Policy getCustomTrustedPolicy() {
        String string = "deployment.security.trusted.policy";
        String string2 = JNLPRuntime.getConfiguration().getProperty(string);
        Policy policy = null;
        if (string2 != null) {
            try {
                URI uRI = new URI("file://" + string2);
                policy = Policy.getInstance("JavaPolicy", new URIParameter(uRI));
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
        return policy;
    }

    public Object getSecurityType() {
        return this.type;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this.getSandBoxPermissions();
        if (ALL_PERMISSIONS.equals(this.type)) {
            permissionCollection = new Permissions();
            if (this.customTrustedPolicy == null) {
                permissionCollection.add(new AllPermission());
                return permissionCollection;
            }
            return this.customTrustedPolicy.getPermissions(codeSource);
        }
        if (J2EE_PERMISSIONS.equals(this.type)) {
            for (int i = 0; i < j2eePermissions.length; ++i) {
                permissionCollection.add(j2eePermissions[i]);
            }
        }
        return permissionCollection;
    }

    public PermissionCollection getSandBoxPermissions() {
        int n;
        Permissions permissions = new Permissions();
        for (n = 0; n < sandboxPermissions.length; ++n) {
            permissions.add(sandboxPermissions[n]);
        }
        if (this.grantAwtPermissions) {
            permissions.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        if (JNLPRuntime.isWebstartApplication()) {
            if (this.file == null) {
                throw new NullJnlpFileException("Can not return sandbox permissions, file is null");
            }
            if (this.file.isApplication()) {
                for (n = 0; n < jnlpRIAPermissions.length; ++n) {
                    permissions.add(jnlpRIAPermissions[n]);
                }
            }
        }
        if (this.downloadHost != null && this.downloadHost.length() > 0) {
            permissions.add(new SocketPermission(this.downloadHost, "connect, accept"));
        }
        return permissions;
    }

    public static String[] getJnlpRIAPermissions() {
        String[] stringArray = new String[jnlpRIAPermissions.length];
        for (int i = 0; i < jnlpRIAPermissions.length; ++i) {
            stringArray[i] = jnlpRIAPermissions[i].getName();
        }
        return stringArray;
    }
}

