/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.cache.Resource;

public class ResourceUrlCreator {
    protected final Resource resource;
    protected final DownloadOptions downloadOptions;

    public ResourceUrlCreator(Resource resource, DownloadOptions downloadOptions) {
        this.resource = resource;
        this.downloadOptions = downloadOptions;
    }

    public List<URL> getUrls() {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        URL uRL = null;
        if (this.downloadOptions.useExplicitPack() && this.downloadOptions.useExplicitVersion()) {
            uRL = ResourceUrlCreator.getUrl(this.resource, true, true);
            if (uRL != null) {
                linkedList.add(uRL);
            }
            if ((uRL = ResourceUrlCreator.getUrl(this.resource, false, true)) != null) {
                linkedList.add(uRL);
            }
            if ((uRL = ResourceUrlCreator.getUrl(this.resource, true, false)) != null) {
                linkedList.add(uRL);
            }
        } else if (this.downloadOptions.useExplicitPack()) {
            uRL = ResourceUrlCreator.getUrl(this.resource, true, false);
            if (uRL != null) {
                linkedList.add(uRL);
            }
        } else if (this.downloadOptions.useExplicitVersion() && (uRL = ResourceUrlCreator.getUrl(this.resource, false, true)) != null) {
            linkedList.add(uRL);
        }
        uRL = this.getVersionedUrl();
        linkedList.add(uRL);
        linkedList.add(this.resource.getLocation());
        return linkedList;
    }

    static URL getUrl(Resource resource, boolean bl, boolean bl2) {
        Object object;
        if (!bl && !bl2) {
            throw new IllegalArgumentException("either pack200 or version required");
        }
        String string = resource.getLocation().toString();
        int n = resource.getLocation().toString().lastIndexOf(47);
        if (n == -1) {
            return resource.getLocation();
        }
        String string2 = string.substring(n + 1);
        if (bl2 && resource.requestVersion != null) {
            object = string2.split("\\.", -1);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuilder.append(object[i]);
                if (i == ((String[])object).length - 2) {
                    stringBuilder.append("__V" + resource.requestVersion);
                }
                stringBuilder.append('.');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            string2 = stringBuilder.toString();
        }
        if (bl) {
            string2 = string2 + ".pack.gz";
        }
        string = string.substring(0, n + 1) + string2;
        try {
            object = new URL(string);
            return object;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected URL getVersionedUrl() {
        URL uRL = this.resource.getLocation();
        String string = ResourceUrlCreator.uriPartToString(uRL.getProtocol()) + "://";
        String string2 = ResourceUrlCreator.uriPartToString(uRL.getUserInfo());
        if (!string2.isEmpty()) {
            string2 = string2 + "@";
        }
        String string3 = ResourceUrlCreator.uriPartToString(uRL.getHost());
        String string4 = uRL.getPort() == -1 ? "" : ":" + String.valueOf(uRL.getPort());
        String string5 = ResourceUrlCreator.uriPartToString(uRL.getPath());
        String string6 = ResourceUrlCreator.uriPartToString(uRL.getQuery());
        if (!string6.isEmpty()) {
            string6 = "?" + string6;
        }
        if (this.resource.requestVersion != null && this.resource.requestVersion.isVersionId()) {
            string6 = !string6.isEmpty() ? string6 + "&" : "?" + string6;
            string6 = string6 + "version-id=" + this.resource.requestVersion;
        }
        try {
            URL uRL2 = new URL(string + string2 + string3 + string4 + string5 + string6);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private static String uriPartToString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

