/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.config.BasicValueValidators;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.SecurityValueValidator;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.Translator;

public class Defaults {
    static final String SYSTEM_HOME = System.getProperty("java.home");
    static final String SYSTEM_SECURITY = SYSTEM_HOME + File.separator + "lib" + File.separator + "security";
    static final String USER_CONFIG_HOME;
    public static final String USER_CACHE_HOME;
    static final String USER_SECURITY;
    static final String LOCKS_DIR;
    static final File userFile;

    public static Map<String, Setting<String>> getDefaults() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(userFile.toString());
        }
        Object[][] objectArrayArray = new Object[][]{{"deployment.user.cachedir", BasicValueValidators.getFilePathValidator(), USER_CACHE_HOME + File.separator + "cache"}, {"deployment.user.pcachedir", BasicValueValidators.getFilePathValidator(), USER_CACHE_HOME + File.separator + "pcache"}, {"deployment.system.cachedir", BasicValueValidators.getFilePathValidator(), null}, {"deployment.user.logdir", BasicValueValidators.getFilePathValidator(), USER_CONFIG_HOME + File.separator + "log"}, {"deployment.user.tmp", BasicValueValidators.getFilePathValidator(), USER_CACHE_HOME + File.separator + "tmp"}, {"deployment.user.locksdir", BasicValueValidators.getFilePathValidator(), LOCKS_DIR}, {"deployment.user.runningfile", BasicValueValidators.getFilePathValidator(), LOCKS_DIR + File.separator + "netx_running"}, {"deployment.user.security.policy", BasicValueValidators.getUrlValidator(), "file://" + USER_SECURITY + File.separator + "java.policy"}, {"deployment.user.security.trusted.cacerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.cacerts"}, {"deployment.user.security.trusted.jssecacerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.jssecacerts"}, {"deployment.user.security.trusted.certs", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.certs"}, {"deployment.user.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.jssecerts"}, {"deployment.user.security.trusted.clientauthcerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.clientcerts"}, {"deployment.system.security.policy", BasicValueValidators.getUrlValidator(), null}, {"deployment.system.security.cacerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "cacerts"}, {"deployment.system.security.jssecacerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "jssecacerts"}, {"deployment.system.security.trusted.certs", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.certs"}, {"deployment.system.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.jssecerts"}, {"deployment.system.security.trusted.clientautcerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.clientcerts"}, {"deployment.security.askgrantdialog.show", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.askgrantdialog.notinca", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.notinca.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.expired.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.jsse.hostmismatch.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.trusted.policy", BasicValueValidators.getFilePathValidator(), null}, {"deployment.security.sandbox.awtwarningwindow", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.sandbox.jnlp.enhanced", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.authenticator", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.proxy.type", BasicValueValidators.getRangedIntegerValidator(-1, 3), String.valueOf(3)}, {"deployment.proxy.same", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.proxy.auto.config.url", BasicValueValidators.getUrlValidator(), null}, {"deployment.proxy.bypass.list", null, null}, {"deployment.proxy.bypass.local", null, null}, {"deployment.proxy.http.host", null, null}, {"deployment.proxy.http.port", null, null}, {"deployment.proxy.https.host", null, null}, {"deployment.proxy.https.port", null, null}, {"deployment.proxy.ftp.host", null, null}, {"deployment.proxy.ftp.port", null, null}, {"deployment.proxy.socks.host", null, null}, {"deployment.proxy.socks.port", null, null}, {"deployment.proxy.override.hosts", null, null}, {"deployment.cache.max.size", BasicValueValidators.getRangedIntegerValidator(-1, Integer.MAX_VALUE), String.valueOf("-1")}, {"deployment.cache.jarcompression", BasicValueValidators.getRangedIntegerValidator(0, 10), String.valueOf(0)}, {"deployment.javapi.cache.enabled", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.console.startup.mode", BasicValueValidators.getStringValidator(new String[]{"DISABLE", "HIDE", "SHOW", "SHOW_PLUGIN_ONLY", "SHOW_JAVAWS_ONLY"}), "HIDE"}, {"deployment.log", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.headers", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.file", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.stdstreams", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.log.system", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.javaws.associations", BasicValueValidators.getRangedIntegerValidator(0, 3), String.valueOf(2)}, {"deployment.javaws.shortcut", BasicValueValidators.getStringValidator(new String[]{"ALWAYS", "ALWAYS_IF_HINTED", "ASK_USER", "ASK_IF_HINTED", "NEVER"}), "ASK_IF_HINTED"}, {"deployment.javaws.installURL", BasicValueValidators.getUrlValidator(), null}, {"deployment.javaws.autodownload", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.browser.path", BasicValueValidators.getFilePathValidator(), null}, {"deployment.javaws.update.timeout", BasicValueValidators.getRangedIntegerValidator(0, 10000), String.valueOf(500)}, {"deployment.plugin.jvm.arguments", null, null}, {"deployment.security.level", new SecurityValueValidator(), null}, {"deployment.jre.dir", null, null}};
        HashMap<String, Setting<String>> hashMap = new HashMap<String, Setting<String>>();
        for (int i = 0; i < objectArrayArray.length; ++i) {
            String string = (String)objectArrayArray[i][0];
            ValueValidator valueValidator = (ValueValidator)objectArrayArray[i][1];
            String string2 = (String)objectArrayArray[i][2];
            boolean bl = false;
            Setting<String> setting = new Setting<String>(string, Translator.R("Unknown"), bl, valueValidator, string2, string2, Translator.R("DCSourceInternal"));
            hashMap.put(string, setting);
        }
        return hashMap;
    }

    static {
        LOCKS_DIR = System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + File.separator + "netx" + File.separator + "locks";
        String string = System.getProperty("user.home") + File.separator + DeploymentConfiguration.DEPLOYMENT_CONFIG_DIR;
        String string2 = System.getProperty("user.home") + File.separator + DeploymentConfiguration.DEPLOYMENT_CACHE_DIR;
        String string3 = System.getenv("XDG_CONFIG_HOME");
        String string4 = System.getenv("XDG_CACHE_HOME");
        if (string3 != null) {
            string = string3 + File.separator + "icedtea-web";
        }
        if (string4 != null) {
            string2 = string4 + File.separator + "icedtea-web";
        }
        USER_CONFIG_HOME = string;
        USER_CACHE_HOME = string2;
        USER_SECURITY = USER_CONFIG_HOME + File.separator + "security";
        userFile = new File(USER_CONFIG_HOME + File.separator + "deployment.properties");
    }
}

