/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class DirectoryValidator {
    private final List<File> dirsToCheck;

    public DirectoryValidator(List<File> list) {
        this.dirsToCheck = list;
    }

    public DirectoryValidator() {
        String[] stringArray;
        this.dirsToCheck = new ArrayList<File>(6);
        DeploymentConfiguration deploymentConfiguration = JNLPRuntime.getConfiguration();
        for (String string : stringArray = new String[]{"deployment.user.cachedir", "deployment.user.pcachedir", "deployment.system.cachedir", "deployment.user.logdir", "deployment.user.tmp", "deployment.user.locksdir"}) {
            String string2 = deploymentConfiguration.getProperty(string);
            if (string2 == null) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "WARNING: key " + string + " has no value, setting to default value");
                string2 = Defaults.getDefaults().get(string).getValue();
            }
            if (string2 == null) {
                if (!JNLPRuntime.isDebug()) continue;
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "WARNING: key " + string + " has no value, skipping");
                continue;
            }
            File file = new File(string2);
            this.dirsToCheck.add(file);
        }
    }

    public DirectoryCheckResults ensureDirs() {
        return DirectoryValidator.ensureDirs(this.dirsToCheck);
    }

    static DirectoryCheckResults ensureDirs(List<File> list) {
        ArrayList<DirectoryCheckResult> arrayList = new ArrayList<DirectoryCheckResult>(list.size());
        for (File file : list) {
            DirectoryCheckResult directoryCheckResult;
            if (file.exists()) {
                directoryCheckResult = DirectoryValidator.testDir(file, true, true);
                arrayList.add(directoryCheckResult);
                continue;
            }
            if (!file.mkdirs()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "ERROR: Directory " + file.getAbsolutePath() + " does not exist and has not been created");
            } else {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "OK: Directory " + file.getAbsolutePath() + " did not exist but has been created");
            }
            directoryCheckResult = DirectoryValidator.testDir(file, true, true);
            arrayList.add(directoryCheckResult);
        }
        return new DirectoryCheckResults(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryCheckResult testDir(File file, boolean bl, boolean bl2) {
        DirectoryCheckResult directoryCheckResult = new DirectoryCheckResult(file);
        if (!file.exists()) {
            if (bl) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.notExistsMessage(file));
            }
            directoryCheckResult.exists = false;
        }
        if (!file.isDirectory()) {
            if (bl) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.notDirMessage(file));
            }
            directoryCheckResult.isDir = false;
        }
        File file2 = null;
        boolean bl3 = true;
        try {
            File[] fileArray;
            file2 = File.createTempFile("maindir", "check", file);
            if (!file2.exists()) {
                bl3 = false;
            }
            try {
                FileUtils.saveFile("ww", file2);
                fileArray = FileUtils.loadFileAsString(file2);
                if (!fileArray.trim().equals("ww")) {
                    bl3 = false;
                }
            }
            catch (Exception exception) {
                if (JNLPRuntime.isDebug()) {
                    exception.printStackTrace();
                }
                bl3 = false;
            }
            fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                bl3 = false;
            }
            file2.delete();
            if (file2.exists()) {
                bl3 = false;
            } else {
                boolean bl4 = file2.mkdir();
                if (!bl4) {
                    bl3 = false;
                }
                if (file2.exists()) {
                    if (bl2) {
                        DirectoryCheckResult directoryCheckResult2 = DirectoryValidator.testDir(file2, bl, false);
                        if (directoryCheckResult2.getFailures() != 0) {
                            directoryCheckResult.subDir = directoryCheckResult2;
                            bl3 = false;
                        }
                        file2.delete();
                        if (file2.exists()) {
                            bl3 = false;
                        }
                    }
                } else {
                    bl3 = false;
                }
            }
        }
        catch (Exception exception) {
            if (JNLPRuntime.isDebug()) {
                exception.printStackTrace();
            }
            bl3 = false;
        }
        finally {
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        }
        if (!bl3) {
            if (bl) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.wrongPermissionsMessage(file));
            }
            directoryCheckResult.correctPermissions = false;
        }
        return directoryCheckResult;
    }

    public static class DirectoryCheckResult {
        public boolean exists = true;
        public boolean isDir = true;
        public boolean correctPermissions = true;
        public DirectoryCheckResult subDir = null;
        private final File testedDir;

        public DirectoryCheckResult(File file) {
            this.testedDir = file;
        }

        public static String notExistsMessage(File file) {
            return Translator.R("DCmaindircheckNotexists", file.getAbsolutePath());
        }

        public static String notDirMessage(File file) {
            return Translator.R("DCmaindircheckNotdir", file.getAbsolutePath());
        }

        public static String wrongPermissionsMessage(File file) {
            return Translator.R("DCmaindircheckRwproblem", file.getAbsolutePath());
        }

        private static int booleanToInt(boolean bl) {
            if (bl) {
                return 1;
            }
            return 0;
        }

        public int getPasses() {
            int n = 0;
            if (this.subDir != null) {
                n = this.subDir.getPasses();
            }
            return DirectoryCheckResult.booleanToInt(this.exists) + DirectoryCheckResult.booleanToInt(this.isDir) + DirectoryCheckResult.booleanToInt(this.correctPermissions) + n;
        }

        public int getFailures() {
            int n = 3;
            if (this.subDir != null) {
                n = 2 * n;
            }
            return n - this.getPasses();
        }

        public String getMessage() {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.exists) {
                stringBuilder.append(DirectoryCheckResult.notExistsMessage(this.testedDir)).append("\n");
            }
            if (!this.isDir) {
                stringBuilder.append(DirectoryCheckResult.notDirMessage(this.testedDir)).append("\n");
            }
            if (!this.correctPermissions) {
                stringBuilder.append(DirectoryCheckResult.wrongPermissionsMessage(this.testedDir)).append("\n");
            }
            if (this.subDir != null && !(string = this.subDir.getMessage()).isEmpty()) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static class DirectoryCheckResults {
        public final List<DirectoryCheckResult> results;

        public DirectoryCheckResults(List<DirectoryCheckResult> list) {
            this.results = list;
        }

        public int getPasses() {
            int n = 0;
            for (DirectoryCheckResult directoryCheckResult : this.results) {
                n += directoryCheckResult.getPasses();
            }
            return n;
        }

        public int getFailures() {
            int n = 0;
            for (DirectoryCheckResult directoryCheckResult : this.results) {
                n += directoryCheckResult.getFailures();
            }
            return n;
        }

        public String getMessage() {
            return DirectoryCheckResults.resultsToString(this.results);
        }

        public String toString() {
            return this.getMessage();
        }

        public static String resultsToString(List<DirectoryCheckResult> list) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DirectoryCheckResult directoryCheckResult : list) {
                if (directoryCheckResult.getFailures() <= 0) continue;
                stringBuilder.append(directoryCheckResult.getMessage());
            }
            return stringBuilder.toString();
        }
    }
}

