/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPMatcher;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.NullJnlpFileException;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.IllegalResourceDescriptorException;
import net.sourceforge.jnlp.cache.NativeLibraryStorage;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.CachedJarFileCallback;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.LocateJnlpClassLoader;
import net.sourceforge.jnlp.runtime.ManageJnlpResources;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.JNLPAppVerifier;
import net.sourceforge.jnlp.security.PluginAppVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.tools.JarCertVerifier;
import net.sourceforge.jnlp.util.JarFile;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.misc.JarIndex;

public class JNLPClassLoader
extends URLClassLoader {
    public static final String TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";
    public static final String APPLICATION = "JNLP-INF/APPLICATION.JNLP";
    private boolean isSignedJNLP = false;
    private static Map<String, JNLPClassLoader> uniqueKeyToLoader = new ConcurrentHashMap<String, JNLPClassLoader>();
    private static Map<String, ReentrantLock> uniqueKeyToLock = new HashMap<String, ReentrantLock>();
    private NativeLibraryStorage nativeLibraryStorage;
    private AccessControlContext acc = AccessController.getContext();
    private List<Permission> resourcePermissions;
    private ApplicationInstance app = null;
    private JNLPClassLoader[] loaders = null;
    private boolean strict = true;
    private ResourceTracker tracker = new ResourceTracker(true);
    private UpdatePolicy updatePolicy;
    private JNLPFile file;
    private ResourcesDesc resources;
    private SecurityDesc security;
    private ArrayList<Permission> runtimePermissions = new ArrayList();
    private List<JARDesc> available = Collections.synchronizedList(new ArrayList());
    private final JarCertVerifier jcv;
    private SigningState signing = SigningState.NONE;
    private List<JarIndex> jarIndexes = Collections.synchronizedList(new ArrayList());
    private Set<String> classpaths = Collections.synchronizedSet(new HashSet());
    private Set<String> jarEntries = Collections.synchronizedSet(new TreeSet());
    private Map<URL, SecurityDesc> jarLocationSecurityMap = Collections.synchronizedMap(new HashMap());
    private Set<URL> alreadyTried = Collections.synchronizedSet(new HashSet());
    private CodeBaseClassLoader codeBaseLoader;
    private boolean foundMainJar = false;
    private String mainClass = null;
    private int useCount = 0;

    protected JNLPClassLoader(JNLPFile jNLPFile, UpdatePolicy updatePolicy) throws LaunchException {
        this(jNLPFile, updatePolicy, null);
    }

    protected JNLPClassLoader(JNLPFile jNLPFile, UpdatePolicy updatePolicy, String string) throws LaunchException {
        super(new URL[0], JNLPClassLoader.class.getClassLoader());
        OutputController.getLogger().log("New classloader: " + jNLPFile.getFileLocation());
        this.file = jNLPFile;
        this.updatePolicy = updatePolicy;
        this.resources = jNLPFile.getResources();
        this.nativeLibraryStorage = new NativeLibraryStorage(this.tracker);
        this.mainClass = string;
        jNLPFile.getManifestsAttributes().setLoader(this);
        AppVerifier appVerifier = jNLPFile instanceof PluginBridge && !((PluginBridge)jNLPFile).useJNLPHref() ? new PluginAppVerifier() : new JNLPAppVerifier();
        this.jcv = new JarCertVerifier(appVerifier);
        this.initializeExtensions();
        this.initializeResources();
        this.initializePermissions();
        this.setSecurity();
        this.installShutdownHooks();
    }

    private void installShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JNLPClassLoader.this.nativeLibraryStorage.cleanupTemporaryFolder();
            }
        });
    }

    private void setSecurity() throws LaunchException {
        URL uRL = null;
        uRL = this.file.getCodeBase() != null ? this.file.getCodeBase() : this.file.getResources().getMainJAR().getLocation();
        if (this.file instanceof PluginBridge) {
            this.security = this.getSigning() ? new SecurityDesc(this.file, SecurityDesc.ALL_PERMISSIONS, uRL.getHost()) : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, uRL.getHost());
        } else {
            if (!this.file.getSecurity().getSecurityType().equals(SecurityDesc.SANDBOX_PERMISSIONS) && !this.getSigning()) {
                if (this.jcv.allJarsSigned()) {
                    throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedJNLPAppDifferentCerts"), Translator.R("LSignedJNLPAppDifferentCertsInfo"));
                }
                throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedJarWithSecurity"), Translator.R("LUnsignedJarWithSecurityInfo"));
            }
            this.security = this.getSigning() ? this.file.getSecurity() : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, uRL.getHost());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReentrantLock getUniqueKeyLock(String string) {
        Map<String, ReentrantLock> map = uniqueKeyToLock;
        synchronized (map) {
            ReentrantLock reentrantLock = uniqueKeyToLock.get(string);
            if (reentrantLock == null) {
                reentrantLock = new ReentrantLock();
                uniqueKeyToLock.put(string, reentrantLock);
            }
            return reentrantLock;
        }
    }

    private static JNLPClassLoader createInstance(JNLPFile jNLPFile, UpdatePolicy updatePolicy, String string) throws LaunchException {
        JNLPClassLoader jNLPClassLoader;
        String string2 = jNLPFile.getUniqueKey();
        JNLPClassLoader jNLPClassLoader2 = uniqueKeyToLoader.get(string2);
        JNLPClassLoader jNLPClassLoader3 = new JNLPClassLoader(jNLPFile, updatePolicy, string);
        if (!jNLPClassLoader3.getSigning() && jNLPFile instanceof PluginBridge) {
            UnsignedAppletTrustConfirmation.checkUnsignedWithUserIfRequired((PluginBridge)jNLPFile);
        }
        if ((jNLPClassLoader = uniqueKeyToLoader.get(string2)) != null && jNLPClassLoader != jNLPClassLoader3) {
            if (jNLPClassLoader3.getSigning() && !jNLPClassLoader.getSigning() && !SecurityDialogs.showNotAllSignedWarningDialog(jNLPFile)) {
                throw new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedAppJarUsingUnsignedJar"), Translator.R("LSignedAppJarUsingUnsignedJarInfo"));
            }
            jNLPClassLoader3.merge(jNLPClassLoader);
            jNLPClassLoader.decrementLoaderUseCount();
        }
        if (jNLPClassLoader2 != null && jNLPClassLoader2 != jNLPClassLoader3) {
            jNLPClassLoader3.merge(jNLPClassLoader2);
        }
        return jNLPClassLoader3;
    }

    public static JNLPClassLoader getInstance(JNLPFile jNLPFile, UpdatePolicy updatePolicy) throws LaunchException {
        return JNLPClassLoader.getInstance(jNLPFile, updatePolicy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNLPClassLoader getInstance(JNLPFile jNLPFile, UpdatePolicy updatePolicy, String string) throws LaunchException {
        JNLPClassLoader jNLPClassLoader = null;
        JNLPClassLoader jNLPClassLoader2 = null;
        String string2 = jNLPFile.getUniqueKey();
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(string2);
        synchronized (reentrantLock) {
            jNLPClassLoader = uniqueKeyToLoader.get(string2);
            if (jNLPClassLoader == null || jNLPFile.isApplication() && !jNLPClassLoader.getJNLPFile().getFileLocation().equals(jNLPFile.getFileLocation())) {
                jNLPClassLoader2 = JNLPClassLoader.createInstance(jNLPFile, updatePolicy, string);
            } else {
                if (!jNLPFile.isApplication()) {
                    jNLPClassLoader2 = new JNLPClassLoader(jNLPFile, updatePolicy, string);
                    if (jNLPClassLoader != null) {
                        jNLPClassLoader.merge(jNLPClassLoader2);
                    }
                }
                jNLPClassLoader2 = jNLPClassLoader;
            }
            jNLPClassLoader2.incrementLoaderUseCount();
            uniqueKeyToLoader.put(string2, jNLPClassLoader2);
        }
        return jNLPClassLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNLPClassLoader getInstance(URL uRL, String string, Version version, ParserSettings parserSettings, UpdatePolicy updatePolicy, String string2) throws IOException, ParseException, LaunchException {
        JNLPClassLoader jNLPClassLoader;
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(string);
        synchronized (reentrantLock) {
            jNLPClassLoader = uniqueKeyToLoader.get(string);
            if (jNLPClassLoader == null || !uRL.equals(jNLPClassLoader.getJNLPFile().getFileLocation())) {
                JNLPFile jNLPFile = new JNLPFile(uRL, string, version, parserSettings, updatePolicy);
                jNLPClassLoader = JNLPClassLoader.getInstance(jNLPFile, updatePolicy, string2);
            }
        }
        return jNLPClassLoader;
    }

    void initializeExtensions() {
        ExtensionDesc[] extensionDescArray = this.resources.getExtensions();
        ArrayList<JNLPClassLoader> arrayList = new ArrayList<JNLPClassLoader>();
        arrayList.add(this);
        if (this.mainClass == null) {
            LaunchDesc launchDesc;
            LaunchDesc object = this.file.getLaunchInfo();
            if (object instanceof ApplicationDesc) {
                launchDesc = (ApplicationDesc)this.file.getLaunchInfo();
                this.mainClass = ((ApplicationDesc)launchDesc).getMainClass();
            } else if (object instanceof AppletDesc) {
                launchDesc = (AppletDesc)this.file.getLaunchInfo();
                this.mainClass = ((AppletDesc)launchDesc).getMainClass();
            }
        }
        for (ExtensionDesc extensionDesc : extensionDescArray) {
            try {
                String exception = this.getJNLPFile().getUniqueKey();
                JNLPClassLoader jNLPClassLoader = JNLPClassLoader.getInstance(extensionDesc.getLocation(), exception, extensionDesc.getVersion(), this.file.getParserSettings(), this.updatePolicy, this.mainClass);
                arrayList.add(jNLPClassLoader);
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
        this.loaders = arrayList.toArray(new JNLPClassLoader[arrayList.size()]);
    }

    void initializePermissions() {
        JARDesc[] jARDescArray;
        this.resourcePermissions = new ArrayList<Permission>();
        for (JARDesc jARDesc : jARDescArray = this.resources.getJARs()) {
            Permission permission = CacheUtil.getReadPermission(jARDesc.getLocation(), jARDesc.getVersion());
            if (permission == null) {
                OutputController.getLogger().log("Unable to add permission for " + jARDesc.getLocation());
            } else {
                OutputController.getLogger().log("Permission added: " + permission.toString());
            }
            if (permission == null) continue;
            this.resourcePermissions.add(permission);
        }
    }

    boolean isInvalidJar(JARDesc jARDesc) {
        File file = this.tracker.getCacheFile(jARDesc.getLocation());
        if (file == null) {
            return false;
        }
        boolean bl = false;
        try {
            JarFile jarFile = new JarFile(file.getAbsolutePath());
            jarFile.close();
        }
        catch (IOException iOException) {
            bl = true;
        }
        return bl;
    }

    private boolean shouldFilterInvalidJars() {
        if (this.file instanceof PluginBridge) {
            PluginBridge pluginBridge = (PluginBridge)this.file;
            return !pluginBridge.useJNLPHref();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void initializeResources() throws LaunchException {
        boolean bl;
        JARDesc[] jARDescArray;
        if (this.file instanceof PluginBridge) {
            jARDescArray = (JARDesc[])this.file;
            for (String object : jARDescArray.getCodeBaseFolders()) {
                try {
                    this.addToCodeBaseLoader(new URL(this.file.getCodeBase(), object));
                }
                catch (MalformedURLException malformedURLException) {
                    OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Problem trying to add folder to code base:");
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
                }
            }
        }
        if ((jARDescArray = this.resources.getJARs()).length == 0) {
            void exception;
            boolean bl2 = this.loaders.length > 1;
            boolean i = true;
            while (exception < this.loaders.length) {
                if (!this.loaders[exception].getSigning()) {
                    bl2 = false;
                    break;
                }
                ++exception;
            }
            if (bl2) {
                this.signing = SigningState.FULL;
            }
            this.foundMainJar = this.foundMainJar || this.hasMainInExtensions();
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (JARDesc jARDesc : jARDescArray) {
            this.available.add(jARDesc);
            if (jARDesc.isEager()) {
                arrayList.add(jARDesc);
            }
            this.tracker.addResource(jARDesc.getLocation(), jARDesc.getVersion(), this.file.getDownloadOptions(), jARDesc.isCacheable() ? JNLPRuntime.getDefaultUpdatePolicy() : UpdatePolicy.FORCE);
        }
        if (arrayList.size() == 0) {
            arrayList.add(jARDescArray[0]);
        }
        if (this.strict) {
            this.fillInPartJars(arrayList);
        }
        this.waitForJars(arrayList);
        if (this.shouldFilterInvalidJars()) {
            Iterator bl3 = arrayList.iterator();
            while (bl3.hasNext()) {
                JARDesc jARDesc = (JARDesc)bl3.next();
                if (!this.isInvalidJar(jARDesc)) continue;
                bl3.remove();
                this.tracker.removeResource(jARDesc.getLocation());
                this.available.remove(jARDesc);
            }
        }
        if (JNLPRuntime.isVerifying()) {
            try {
                this.jcv.add(arrayList, this.tracker);
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LFatalVerification"), Translator.R("LFatalVerificationInfo") + ": " + exception.getMessage());
            }
            if (this.jcv.isFullySigned()) {
                boolean bl4;
                this.signing = SigningState.FULL;
                this.checkForMain(arrayList);
                while (!this.foundMainJar && this.available != null && this.available.size() != 0) {
                    this.addNextResource();
                }
                this.foundMainJar = this.foundMainJar || this.hasMainInExtensions();
                boolean bl5 = bl4 = this.file.getLaunchInfo() != null && !this.foundMainJar && (this.available == null || this.available.size() == 0);
                if (!this.jcv.allJarsSigned() || bl4) {
                    this.checkNotAllSignedWithUser(this.file);
                    this.signing = SigningState.PARTIAL;
                }
                if (!this.isSignedJNLP && this.foundMainJar) {
                    this.file.setSignedJNLPAsMissing();
                }
                if (!this.jcv.isTriviallySigned()) {
                    this.checkTrustWithUser();
                }
            } else {
                this.signing = SigningState.NONE;
            }
        }
        boolean bl6 = false;
        boolean bl7 = false;
        for (JARDesc jARDesc : this.file.getResources().getJARs()) {
            File file;
            try {
                file = this.tracker.getCacheFile(jARDesc.getLocation());
            }
            catch (IllegalResourceDescriptorException illegalResourceDescriptorException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jARDesc.getLocation() + " is not a valid jar file. Continuing.");
                continue;
            }
            if (file == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jARDesc.getLocation() + " not found. Continuing.");
                continue;
            }
            SecurityDesc securityDesc = this.file.getSecurity();
            if (this.file instanceof PluginBridge) {
                URL uRL = null;
                uRL = this.file.getCodeBase() != null ? this.file.getCodeBase() : this.file.getResources().getMainJAR().getLocation();
                try {
                    if (JarCertVerifier.isJarSigned(jARDesc, new PluginAppVerifier(), this.tracker)) {
                        bl = true;
                        securityDesc = new SecurityDesc(this.file, SecurityDesc.ALL_PERMISSIONS, uRL.getHost());
                    } else {
                        bl7 = true;
                        securityDesc = new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, uRL.getHost());
                    }
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(exception);
                    securityDesc = new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, uRL.getHost());
                }
            }
            this.jarLocationSecurityMap.put(jARDesc.getLocation(), securityDesc);
        }
        if (bl && bl7) {
            this.checkNotAllSignedWithUser(this.file);
            this.signing = SigningState.PARTIAL;
        }
        this.activateJars(arrayList);
    }

    public String checkForAttributeInJars(List<JARDesc> list, Attributes.Name name) {
        if (list.isEmpty()) {
            return null;
        }
        String string = null;
        JARDesc jARDesc = ResourcesDesc.getMainJAR(list);
        string = this.getManifestAttribute(jARDesc.getLocation(), name);
        if (string != null) {
            return string;
        }
        JARDesc jARDesc2 = list.get(0);
        string = this.getManifestAttribute(jARDesc2.getLocation(), name);
        if (string != null) {
            return string;
        }
        for (JARDesc jARDesc3 : list) {
            String string2 = this.getManifestAttribute(jARDesc3.getLocation(), name);
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            string = null;
            break;
        }
        return string;
    }

    void checkForMain(List<JARDesc> list) throws LaunchException {
        Object object;
        if (this.mainClass == null && (object = this.file.getLaunchInfo()) != null) {
            this.mainClass = object.getMainClass();
        }
        if (this.mainClass == null) {
            this.mainClass = this.checkForAttributeInJars(list, Attributes.Name.MAIN_CLASS);
        }
        object = this.mainClass + ".class";
        for (JARDesc jARDesc : list) {
            try {
                File file = this.tracker.getCacheFile(jARDesc.getLocation());
                if (file == null) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jARDesc.getLocation() + " not found. Continuing.");
                    continue;
                }
                JarFile jarFile = new JarFile(file);
                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                    String string = jarEntry.getName().replaceAll("/", ".");
                    if (!string.equals(object)) continue;
                    this.foundMainJar = true;
                    this.verifySignedJNLP(jARDesc, jarFile);
                    break;
                }
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    String getMainClassName(URL uRL) {
        return this.getManifestAttribute(uRL, Attributes.Name.MAIN_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManifestAttribute(URL uRL, Attributes.Name name) {
        String string = null;
        File file = this.tracker.getCacheFile(uRL);
        if (file != null) {
            Manifest manifest;
            JarFile jarFile;
            block6: {
                jarFile = null;
                jarFile = new JarFile(file);
                manifest = jarFile.getManifest();
                if (manifest != null && manifest.getMainAttributes() != null) break block6;
                String string2 = null;
                StreamUtils.closeSilently(jarFile);
                return string2;
            }
            try {
                string = manifest.getMainAttributes().getValue(name);
            }
            catch (IOException iOException) {
                try {
                    string = null;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeSilently(jarFile);
                    throw throwable;
                }
                StreamUtils.closeSilently(jarFile);
            }
            StreamUtils.closeSilently(jarFile);
        }
        return string;
    }

    public boolean hasMainJar() {
        return this.foundMainJar;
    }

    private boolean hasMainInExtensions() {
        boolean bl = false;
        for (int i = 1; i < this.loaders.length && !bl; ++i) {
            bl = this.loaders[i].hasMainJar();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySignedJNLP(JARDesc jARDesc, JarFile jarFile) throws LaunchException {
        block10: {
            ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
            arrayList.add(jARDesc);
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            FileReader fileReader = null;
            FileReader fileReader2 = null;
            try {
                if (!this.jcv.isFullySigned()) break block10;
                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                    JNLPMatcher jNLPMatcher;
                    String string = jarEntry.getName().toUpperCase();
                    if (!string.equals(TEMPLATE) && !string.equals(APPLICATION)) continue;
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Creating Jar InputStream from JarEntry");
                    inputStream = jarFile.getInputStream(jarEntry);
                    inputStreamReader = new InputStreamReader(inputStream);
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Creating File InputStream from lauching JNLP file");
                    JNLPFile jNLPFile = this.getJNLPFile();
                    URL uRL = jNLPFile.getFileLocation();
                    File file = null;
                    file = uRL.getProtocol().toLowerCase().equals("file") ? new File(uRL.getPath()) : CacheUtil.getCacheFile(uRL, null);
                    fileReader2 = fileReader = new FileReader(file);
                    if (string.equals(APPLICATION)) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "APPLICATION.JNLP has been located within signed JAR. Starting verfication...");
                        jNLPMatcher = new JNLPMatcher(inputStreamReader, fileReader2, false);
                    } else {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "APPLICATION_TEMPLATE.JNLP has been located within signed JAR. Starting verfication...");
                        jNLPMatcher = new JNLPMatcher(inputStreamReader, fileReader2, true);
                    }
                    if (!jNLPMatcher.isMatch()) {
                        throw new JNLPMatcherException("Signed Application did not match launching JNLP File");
                    }
                    this.isSignedJNLP = true;
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Signed Application Verification Successful");
                    break;
                }
            }
            catch (JNLPMatcherException jNLPMatcherException) {
                throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedJNLPFileDidNotMatch"), Translator.R(jNLPMatcherException.getMessage()));
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
            }
            finally {
                StreamUtils.closeSilently(inputStream);
                StreamUtils.closeSilently(inputStreamReader);
                StreamUtils.closeSilently(fileReader);
                StreamUtils.closeSilently(fileReader2);
            }
        }
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Ending check for signed JNLP file...");
    }

    private void checkTrustWithUser() throws LaunchException {
        if (JNLPRuntime.isTrustAll()) {
            return;
        }
        if (this.jcv.isFullySigned() && !this.jcv.getAlreadyTrustPublisher()) {
            this.jcv.checkTrustWithUser(this.file);
        }
    }

    private void checkNotAllSignedWithUser(JNLPFile jNLPFile) throws LaunchException {
        boolean bl = true;
        if (JNLPRuntime.isTrustAll()) {
            bl = false;
        }
        if (bl && !SecurityDialogs.showNotAllSignedWarningDialog(jNLPFile)) {
            throw new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedAppJarUsingUnsignedJar"), Translator.R("LSignedAppJarUsingUnsignedJarInfo"));
        }
    }

    public void enableCodeBase() {
        this.addToCodeBaseLoader(this.file.getCodeBase());
    }

    public void setApplication(ApplicationInstance applicationInstance) {
        if (this.app != null) {
            OutputController.getLogger().log(new IllegalStateException("Application can only be set once"));
            return;
        }
        this.app = applicationInstance;
    }

    public ApplicationInstance getApplication() {
        return this.app;
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        try {
            Permissions permissions = new Permissions();
            if (this.security != null) {
                Object object = this.security.getSandBoxPermissions();
                if (codeSource == null) {
                    throw new NullPointerException("Code source was null");
                }
                if (codeSource.getCodeSigners() != null) {
                    Object object2;
                    if (codeSource.getLocation() == null) {
                        throw new NullPointerException("Code source location was null");
                    }
                    if (this.getCodeSourceSecurity(codeSource.getLocation()) == null) {
                        throw new NullPointerException("Code source security was null");
                    }
                    if (this.getCodeSourceSecurity(codeSource.getLocation()).getSecurityType() == null) {
                        OutputController.getLogger().log(new NullPointerException("Warning! Code source security type was null"));
                    }
                    if (SecurityDesc.ALL_PERMISSIONS.equals(object2 = this.getCodeSourceSecurity(codeSource.getLocation()).getSecurityType()) || SecurityDesc.J2EE_PERMISSIONS.equals(object2)) {
                        object = this.getCodeSourceSecurity(codeSource.getLocation()).getPermissions(codeSource);
                    }
                }
                for (Permission permission : Collections.list(((PermissionCollection)object).elements())) {
                    permissions.add(permission);
                }
            }
            for (Permission permission : this.resourcePermissions) {
                permissions.add(permission);
            }
            for (Permission permission : this.runtimePermissions) {
                permissions.add(permission);
            }
            if (codeSource.getLocation() != null && codeSource.getLocation().getHost().length() > 0) {
                permissions.add(new SocketPermission(codeSource.getLocation().getHost(), "connect, accept"));
            }
            return permissions;
        }
        catch (RuntimeException runtimeException) {
            OutputController.getLogger().log(runtimeException);
            throw runtimeException;
        }
    }

    protected void addPermission(Permission permission) {
        this.runtimePermissions.add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInPartJars(List<JARDesc> list) {
        for (JARDesc jARDesc : list) {
            String string = jARDesc.getPart();
            List<JARDesc> list2 = this.available;
            synchronized (list2) {
                for (JARDesc jARDesc2 : this.available) {
                    if (string == null || !string.equals(jARDesc2.getPart()) || list.contains(jARDesc2)) continue;
                    list.add(jARDesc2);
                }
            }
        }
    }

    protected void activateJars(final List<JARDesc> list) {
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JNLPClassLoader.this.waitForJars(list);
                for (JARDesc jARDesc : list) {
                    JNLPClassLoader.this.available.remove(jARDesc);
                    File file = JNLPClassLoader.this.tracker.getCacheFile(jARDesc.getLocation());
                    try {
                        JarFile jarFile;
                        URL uRL = jARDesc.getLocation();
                        if (file != null) {
                            uRL = file.toURL();
                            jarFile = new JarFile(file);
                            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                                if (jarEntry.getName().endsWith(".jar")) {
                                    int n;
                                    String string = file.getParent() + "/" + jarEntry.getName();
                                    File file2 = new File(string).getParentFile();
                                    if (!file2.isDirectory() && !file2.mkdirs()) {
                                        throw new RuntimeException(Translator.R("RNestedJarExtration"));
                                    }
                                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                                    byte[] byArray = new byte[1024];
                                    int n2 = n = inputStream.read(byArray);
                                    while (n > 0) {
                                        fileOutputStream.write(byArray, 0, n);
                                        n = inputStream.read(byArray);
                                        n2 += n;
                                    }
                                    inputStream.close();
                                    fileOutputStream.close();
                                    if (n2 <= 0) continue;
                                    JNLPClassLoader.this.tracker.addResource(new File(string).toURL(), null, null, null);
                                    URL uRL2 = JNLPClassLoader.this.file.getCodeBase();
                                    if (uRL2 == null) {
                                        uRL2 = JNLPClassLoader.this.file.getResources().getMainJAR().getLocation();
                                    }
                                    SecurityDesc securityDesc = null;
                                    securityDesc = JNLPClassLoader.this.jcv.isFullySigned() ? new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.ALL_PERMISSIONS, uRL2.getHost()) : new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.SANDBOX_PERMISSIONS, uRL2.getHost());
                                    try {
                                        URL uRL3 = new URL("file://" + string);
                                        URL uRL4 = new URL(jARDesc.getLocation().toString() + "!" + jarEntry.getName());
                                        CachedJarFileCallback.getInstance().addMapping(uRL4, uRL3);
                                        JNLPClassLoader.this.addURL(uRL4);
                                        JNLPClassLoader.this.jarLocationSecurityMap.put(uRL4, securityDesc);
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Unable to add extracted nested jar to classpath");
                                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
                                    }
                                }
                                JNLPClassLoader.this.jarEntries.add(jarEntry.getName());
                            }
                            jarFile.close();
                        }
                        JNLPClassLoader.this.addURL(jARDesc.getLocation());
                        if (file != null) {
                            JarIndex jarIndex;
                            CachedJarFileCallback.getInstance().addMapping(jARDesc.getLocation(), file.toURL());
                            jarFile = new JarFile(file.getAbsolutePath());
                            Manifest manifest = jarFile.getManifest();
                            if (JNLPClassLoader.this.file instanceof PluginBridge && !((PluginBridge)JNLPClassLoader.this.file).useJNLPHref()) {
                                JNLPClassLoader.this.classpaths.addAll(JNLPClassLoader.this.getClassPathsFromManifest(manifest, jARDesc.getLocation().getPath()));
                            }
                            if ((jarIndex = JarIndex.getJarIndex(jarFile, null)) != null) {
                                JNLPClassLoader.this.jarIndexes.add(jarIndex);
                            }
                            jarFile.close();
                        } else {
                            CachedJarFileCallback.getInstance().addMapping(jARDesc.getLocation(), jARDesc.getLocation());
                        }
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Activate jar: " + uRL);
                    }
                    catch (Exception exception) {
                        OutputController.getLogger().log(exception);
                    }
                    JNLPClassLoader.this.nativeLibraryStorage.addSearchJar(jARDesc.getLocation());
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, this.acc);
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = System.mapLibraryName(string);
        File file = this.nativeLibraryStorage.findLibrary(string2);
        if (file != null) {
            return file.toString();
        }
        String string3 = super.findLibrary(string);
        if (string3 != null) {
            return string3;
        }
        return this.findLibraryExt(string);
    }

    protected String findLibraryExt(String string) {
        for (JNLPClassLoader jNLPClassLoader : this.loaders) {
            String string2 = null;
            if (jNLPClassLoader != this) {
                string2 = jNLPClassLoader.findLibrary(string);
            }
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private void waitForJars(List<JARDesc> list) {
        URL[] uRLArray = new URL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            JARDesc jARDesc = list.get(i);
            uRLArray[i] = jARDesc.getLocation();
        }
        CacheUtil.waitForResources(this.app, this.tracker, uRLArray, this.file.getTitle());
    }

    protected Class<?> findLoadedClassAll(String string) {
        for (JNLPClassLoader jNLPClassLoader : this.loaders) {
            Class<?> clazz = null;
            clazz = jNLPClassLoader == this ? JNLPClassLoader.super.findLoadedClass(string) : jNLPClassLoader.findLoadedClassAll(string);
            if (clazz == null) continue;
            return clazz;
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findLoadedClassFromParent(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClassAll(string);
        if (clazz == null) {
            try {
                ClassLoader classLoader = this.getParent();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = this.loadClassExt(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Set<String> set = this.classpaths;
                    synchronized (set) {
                        for (String string2 : this.classpaths) {
                            JARDesc jARDesc;
                            try {
                                URL uRL = new URL(this.file.getCodeBase(), string2);
                                jARDesc = new JARDesc(uRL, null, null, false, true, false, true);
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new ClassNotFoundException(string, malformedURLException);
                            }
                            this.addNewJar(jARDesc);
                        }
                    }
                    clazz = this.loadClassExt(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    OutputController.getLogger().log(classNotFoundException2);
                    List<JarIndex> list = this.jarIndexes;
                    synchronized (list) {
                        for (JarIndex jarIndex : this.jarIndexes) {
                            LinkedList linkedList = jarIndex.get(string.replace('.', '/'));
                            if (linkedList == null) continue;
                            for (String string3 : linkedList) {
                                JARDesc jARDesc;
                                try {
                                    jARDesc = new JARDesc(new URL(this.file.getCodeBase(), string3), null, null, false, true, false, true);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new ClassNotFoundException(string);
                                }
                                try {
                                    this.addNewJar(jARDesc);
                                }
                                catch (Exception exception) {
                                    OutputController.getLogger().log(exception);
                                }
                            }
                            clazz = this.loadClassExt(string);
                        }
                    }
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    private void addNewJar(JARDesc jARDesc) {
        this.addNewJar(jARDesc, JNLPRuntime.getDefaultUpdatePolicy());
    }

    private void addNewJar(final JARDesc jARDesc, UpdatePolicy updatePolicy) {
        this.available.add(jARDesc);
        this.tracker.addResource(jARDesc.getLocation(), jARDesc.getVersion(), null, updatePolicy);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Permission permission = CacheUtil.getReadPermission(jARDesc.getLocation(), jARDesc.getVersion());
                JNLPClassLoader.this.resourcePermissions.add(permission);
                return null;
            }
        });
        final URL uRL = jARDesc.getLocation();
        URL uRL2 = this.tracker.getCacheURL(uRL);
        this.available.remove(jARDesc);
        try {
            final ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
            arrayList.add(jARDesc);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    JNLPClassLoader.this.jcv.add(arrayList, JNLPClassLoader.this.tracker);
                    JNLPClassLoader.this.checkTrustWithUser();
                    SecurityDesc securityDesc = JNLPClassLoader.this.jcv.isFullySigned() ? new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.ALL_PERMISSIONS, JNLPClassLoader.this.file.getCodeBase().getHost()) : new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.SANDBOX_PERMISSIONS, JNLPClassLoader.this.file.getCodeBase().getHost());
                    JNLPClassLoader.this.jarLocationSecurityMap.put(uRL, securityDesc);
                    return null;
                }
            });
            this.addURL(uRL);
            CachedJarFileCallback.getInstance().addMapping(uRL, uRL2);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        for (JNLPClassLoader jNLPClassLoader : this.loaders) {
            try {
                if (jNLPClassLoader == this) {
                    final String string2 = string;
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws ClassNotFoundException {
                            return JNLPClassLoader.super.findClass(string2);
                        }
                    }, this.getAccessControlContextForClassLoading());
                }
                return jNLPClassLoader.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassFormatError classFormatError) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, classFormatError);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            catch (NullJnlpFileException nullJnlpFileException) {
                throw new ClassNotFoundException(this.mainClass + " in main classloader ", nullJnlpFileException);
            }
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findClassNonRecursive(string);
        }
        throw new ClassNotFoundException(string);
    }

    private Class<?> loadClassExt(String string) throws ClassNotFoundException {
        this.addAvailable();
        try {
            return this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            while (true) {
                JNLPClassLoader jNLPClassLoader = null;
                try {
                    jNLPClassLoader = this.addNextResource();
                }
                catch (LaunchException launchException) {
                    throw new IllegalStateException(launchException);
                }
                if (jNLPClassLoader == null) {
                    throw new ClassNotFoundException(string);
                }
                try {
                    return jNLPClassLoader.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public URL findResource(String string) {
        URL uRL = null;
        try {
            Enumeration<URL> enumeration = this.findResources(string);
            if (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
            }
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(iOException);
        }
        if (uRL == null && this.codeBaseLoader != null) {
            uRL = this.codeBaseLoader.findResource(string);
        }
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        Enumeration<URL> enumeration = this.findResourcesBySearching(string);
        try {
            while (!enumeration.hasMoreElements() && this.addNextResource() != null) {
                enumeration = this.findResourcesBySearching(string);
            }
        }
        catch (LaunchException launchException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, launchException);
        }
        return enumeration;
    }

    private Enumeration<URL> findResourcesBySearching(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<URL> enumeration = null;
        for (JNLPClassLoader jNLPClassLoader : this.loaders) {
            Object object;
            if (jNLPClassLoader == this) {
                object = string;
                try {
                    enumeration = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>((String)object){
                        final /* synthetic */ String val$fName;
                        {
                            this.val$fName = string;
                        }

                        @Override
                        public Enumeration<URL> run() throws IOException {
                            return JNLPClassLoader.super.findResources(this.val$fName);
                        }
                    }, this.getAccessControlContextForClassLoading());
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                enumeration = jNLPClassLoader.findResources(string);
            }
            object = enumeration;
            try {
                arrayList.addAll(AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<URL>>((Enumeration)object){
                    final /* synthetic */ Enumeration val$fURLEnum;
                    {
                        this.val$fURLEnum = enumeration;
                    }

                    @Override
                    public Collection<URL> run() {
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        while (this.val$fURLEnum != null && this.val$fURLEnum.hasMoreElements()) {
                            arrayList.add((URL)this.val$fURLEnum.nextElement());
                        }
                        return arrayList;
                    }
                }, this.getAccessControlContextForClassLoading()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty() && this.codeBaseLoader != null) {
            enumeration = this.codeBaseLoader.findResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(arrayList);
    }

    public boolean resourceAvailableLocally(String string) {
        return this.jarEntries.contains(string);
    }

    protected void addAvailable() {
        for (int i = 1; i < this.loaders.length; ++i) {
            this.loaders[i].addAvailable();
        }
    }

    protected JNLPClassLoader addNextResource() throws LaunchException {
        if (this.available.size() == 0) {
            for (int i = 1; i < this.loaders.length; ++i) {
                JNLPClassLoader jNLPClassLoader = this.loaders[i].addNextResource();
                if (jNLPClassLoader == null) continue;
                return jNLPClassLoader;
            }
            return null;
        }
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        arrayList.add(this.available.get(0));
        this.fillInPartJars(arrayList);
        this.checkForMain(arrayList);
        this.activateJars(arrayList);
        return this;
    }

    @Deprecated
    public String getExtensionName() {
        String string = this.file.getInformation().getTitle();
        if (string == null) {
            string = this.file.getInformation().getDescription();
        }
        if (string == null && this.file.getFileLocation() != null) {
            string = this.file.getFileLocation().toString();
        }
        if (string == null && this.file.getCodeBase() != null) {
            string = this.file.getCodeBase().toString();
        }
        return string;
    }

    @Deprecated
    public String getExtensionHREF() {
        return this.file.getFileLocation().toString();
    }

    public boolean getSigning() {
        return this.signing == SigningState.FULL;
    }

    protected SecurityDesc getSecurity() {
        return this.security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecurityDesc getCodeSourceSecurity(URL uRL) {
        SecurityDesc securityDesc = this.jarLocationSecurityMap.get(uRL);
        Set<URL> set = this.alreadyTried;
        synchronized (set) {
            if (securityDesc == null && !this.alreadyTried.contains(uRL)) {
                this.alreadyTried.add(uRL);
                OutputController.getLogger().log("Application is trying to get permissions for " + uRL.toString() + ", which was not added by standard way. Trying to download and verify!");
                try {
                    JARDesc jARDesc = new JARDesc(uRL, null, null, false, false, false, false);
                    this.addNewJar(jARDesc);
                    securityDesc = this.jarLocationSecurityMap.get(uRL);
                }
                catch (Throwable throwable) {
                    OutputController.getLogger().log(throwable);
                    securityDesc = null;
                }
            }
        }
        if (securityDesc == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("LNoSecInstance", uRL.toString()));
        }
        return securityDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(JNLPClassLoader jNLPClassLoader) {
        try {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        catch (SecurityException securityException) {
            throw new SecurityException("JNLPClassLoader() may only be called from trusted sources!");
        }
        for (URL uRL : jNLPClassLoader.getURLs()) {
            this.addURL(uRL);
        }
        this.addToCodeBaseLoader(jNLPClassLoader.file.getCodeBase());
        for (File file : jNLPClassLoader.nativeLibraryStorage.getSearchDirectories()) {
            this.nativeLibraryStorage.addSearchDirectory(file);
        }
        Map<URL, SecurityDesc> map = this.jarLocationSecurityMap;
        synchronized (map) {
            for (URL uRL : jNLPClassLoader.jarLocationSecurityMap.keySet()) {
                this.jarLocationSecurityMap.put(uRL, jNLPClassLoader.jarLocationSecurityMap.get(uRL));
            }
        }
    }

    private void addToCodeBaseLoader(URL uRL) {
        if (uRL == null) {
            return;
        }
        if (!uRL.getFile().endsWith("/")) {
            throw new IllegalArgumentException("addToPathLoader only accepts path based URLs");
        }
        if (this.codeBaseLoader == null) {
            this.codeBaseLoader = new CodeBaseClassLoader(new URL[]{uRL}, this);
        } else {
            this.codeBaseLoader.addURL(uRL);
        }
    }

    private Set<String> getClassPathsFromManifest(Manifest manifest, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (manifest != null) {
            String[] stringArray;
            String string2 = manifest.getMainAttributes().getValue("Class-Path");
            if (string2 == null || string2.trim().length() == 0) {
                return hashSet;
            }
            for (String string3 : stringArray = string2.split(" +")) {
                if (string3.trim().length() == 0) continue;
                String string4 = "";
                int n = string.lastIndexOf("/");
                if (n != -1) {
                    string4 = string.substring(0, n + 1);
                }
                String string5 = string4 + string3;
                hashSet.add(string5);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(this.file.getUniqueKey());
        synchronized (reentrantLock) {
            ++this.useCount;
        }
    }

    JNLPClassLoader[] getLoaders() {
        return this.loaders;
    }

    void removeJars(JARDesc[] jARDescArray) {
        for (JARDesc jARDesc : jARDescArray) {
            try {
                this.tracker.removeResource(jARDesc.getLocation());
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Failed to remove resource from tracker, continuing..");
            }
            File file = CacheUtil.getCacheFile(jARDesc.getLocation(), null);
            String string = CacheUtil.getCacheParentDirectory(file.getAbsolutePath());
            File file2 = new File(string);
            OutputController.getLogger().log("Deleting cached file: " + file.getAbsolutePath());
            file.delete();
            OutputController.getLogger().log("Deleting cached directory: " + file2.getAbsolutePath());
            file2.delete();
        }
    }

    void initializeNewJarDownload(URL uRL, String string, Version version) {
        JARDesc[] jARDescArray;
        for (JARDesc jARDesc : jARDescArray = ManageJnlpResources.findJars(this, uRL, string, version)) {
            OutputController.getLogger().log("Downloading and initializing jar: " + jARDesc.getLocation().toString());
            this.addNewJar(jARDesc, UpdatePolicy.FORCE);
        }
    }

    boolean manageExternalJars(URL uRL, String string, DownloadAction downloadAction) {
        Version version;
        boolean bl = false;
        JNLPClassLoader jNLPClassLoader = LocateJnlpClassLoader.getLoaderByResourceUrl(this, uRL, string);
        Version version2 = version = string == null ? null : new Version(string);
        if (jNLPClassLoader != null) {
            bl = true;
        } else if (uRL.toString().startsWith(this.file.getCodeBase().toString())) {
            bl = true;
        } else if (SecurityDesc.ALL_PERMISSIONS.equals(this.security.getSecurityType())) {
            bl = true;
        }
        if (bl) {
            if (jNLPClassLoader == null) {
                jNLPClassLoader = this;
            }
            if (downloadAction == DownloadAction.DOWNLOAD_TO_CACHE) {
                JARDesc jARDesc = new JARDesc(uRL, version, null, false, true, false, true);
                OutputController.getLogger().log("Downloading and initializing jar: " + uRL.toString());
                jNLPClassLoader.addNewJar(jARDesc, UpdatePolicy.FORCE);
            } else if (downloadAction == DownloadAction.REMOVE_FROM_CACHE) {
                JARDesc[] jARDescArray = new JARDesc[]{new JARDesc(uRL, version, null, false, true, false, true)};
                jNLPClassLoader.removeJars(jARDescArray);
            } else if (downloadAction == DownloadAction.CHECK_CACHE) {
                return CacheUtil.isCached(uRL, version);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        String string = this.file.getUniqueKey();
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(string);
        synchronized (reentrantLock) {
            --this.useCount;
            if (this.useCount <= 0) {
                uniqueKeyToLoader.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlContext getAccessControlContextForClassLoading() {
        AccessControlContext accessControlContext = AccessController.getContext();
        try {
            accessControlContext.checkPermission(new AllPermission());
            return accessControlContext;
        }
        catch (AccessControlException accessControlException) {
            PermissionCollection permissionCollection = this.security.getSandBoxPermissions();
            for (Permission permission : this.resourcePermissions) {
                permissionCollection.add(permission);
            }
            Map<URL, SecurityDesc> map = this.jarLocationSecurityMap;
            synchronized (map) {
                for (URL uRL : this.jarLocationSecurityMap.keySet()) {
                    permissionCollection.add(new SocketPermission(uRL.getHost(), "connect, accept"));
                }
            }
            if (this.codeBaseLoader != null) {
                for (URL uRL : this.codeBaseLoader.getURLs()) {
                    permissionCollection.add(new SocketPermission(uRL.getHost(), "connect, accept"));
                }
            }
            ProtectionDomain protectionDomain = new ProtectionDomain(null, permissionCollection);
            return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public static class CodeBaseClassLoader
    extends URLClassLoader {
        JNLPClassLoader parentJNLPClassLoader;
        ConcurrentHashMap<String, URL[]> notFoundResources = new ConcurrentHashMap();

        public CodeBaseClassLoader(URL[] uRLArray, JNLPClassLoader jNLPClassLoader) {
            super(uRLArray, jNLPClassLoader);
            this.parentJNLPClassLoader = jNLPClassLoader;
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }

        Class<?> findClassNonRecursive(String string) throws ClassNotFoundException {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(string))) {
                throw new ClassNotFoundException(string);
            }
            try {
                final String string2 = string;
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return CodeBaseClassLoader.super.findClass(string2);
                    }
                }, this.parentJNLPClassLoader.getAccessControlContextForClassLoading());
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.notFoundResources.put(string, super.getURLs());
                throw new ClassNotFoundException("Could not find class " + string, privilegedActionException);
            }
            catch (NullJnlpFileException nullJnlpFileException) {
                this.notFoundResources.put(string, super.getURLs());
                throw new ClassNotFoundException("Could not find class " + string, nullJnlpFileException);
            }
        }

        @Override
        public Class<?> findClass(String string) throws ClassNotFoundException {
            return this.getParentJNLPClassLoader().findClass(string);
        }

        public Class<?> findLoadedClassFromParent(String string) {
            return this.findLoadedClass(string);
        }

        public JNLPClassLoader getParentJNLPClassLoader() {
            return this.parentJNLPClassLoader;
        }

        @Override
        public Enumeration<URL> findResources(String string) throws IOException {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(string))) {
                return new Vector(0).elements();
            }
            if (!string.startsWith("META-INF")) {
                Enumeration<URL> enumeration = super.findResources(string);
                if (!enumeration.hasMoreElements()) {
                    this.notFoundResources.put(string, super.getURLs());
                }
                return enumeration;
            }
            return new Vector(0).elements();
        }

        @Override
        public URL findResource(String string) {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(string))) {
                return null;
            }
            URL uRL = null;
            if (!string.startsWith("META-INF")) {
                try {
                    final String string2 = string;
                    uRL = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() {
                            return CodeBaseClassLoader.super.findResource(string2);
                        }
                    }, this.parentJNLPClassLoader.getAccessControlContextForClassLoading());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
                if (uRL == null) {
                    this.notFoundResources.put(string, super.getURLs());
                }
                return uRL;
            }
            return null;
        }
    }

    public static enum SigningState {
        FULL,
        PARTIAL,
        NONE;

    }

    public static enum DownloadAction {
        DOWNLOAD_TO_CACHE,
        REMOVE_FROM_CACHE,
        CHECK_CACHE;

    }
}

