/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.UnsignedAppletTrustWarningPanel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UnsignedAppletTrustConfirmation {
    private static final AppletStartupSecuritySettings securitySettings = AppletStartupSecuritySettings.getInstance();

    private static boolean unsignedConfirmationIsRequired() {
        return AppletSecurityLevel.ALLOW_UNSIGNED != securitySettings.getSecurityLevel();
    }

    private static boolean unsignedAppletsAreForbidden() {
        return AppletSecurityLevel.DENY_UNSIGNED == securitySettings.getSecurityLevel() || AppletSecurityLevel.DENY_ALL == securitySettings.getSecurityLevel();
    }

    public static ExecuteUnsignedApplet getStoredAction(PluginBridge pluginBridge) {
        ExecuteUnsignedApplet executeUnsignedApplet;
        UnsignedAppletActionStorage unsignedAppletActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        UnsignedAppletActionStorage unsignedAppletActionStorage2 = securitySettings.getUnsignedAppletActionGlobalStorage();
        UnsignedAppletActionEntry unsignedAppletActionEntry = UnsignedAppletTrustConfirmation.getMatchingItem(unsignedAppletActionStorage2, pluginBridge);
        UnsignedAppletActionEntry unsignedAppletActionEntry2 = UnsignedAppletTrustConfirmation.getMatchingItem(unsignedAppletActionStorage, pluginBridge);
        ExecuteUnsignedApplet executeUnsignedApplet2 = unsignedAppletActionEntry == null ? null : unsignedAppletActionEntry.getUnsignedAppletAction();
        ExecuteUnsignedApplet executeUnsignedApplet3 = executeUnsignedApplet = unsignedAppletActionEntry2 == null ? null : unsignedAppletActionEntry2.getUnsignedAppletAction();
        if (executeUnsignedApplet == ExecuteUnsignedApplet.ALWAYS || executeUnsignedApplet == ExecuteUnsignedApplet.NEVER) {
            return executeUnsignedApplet;
        }
        if (executeUnsignedApplet2 == ExecuteUnsignedApplet.ALWAYS || executeUnsignedApplet2 == ExecuteUnsignedApplet.NEVER) {
            return executeUnsignedApplet2;
        }
        return executeUnsignedApplet;
    }

    private static UnsignedAppletActionEntry getMatchingItem(UnsignedAppletActionStorage unsignedAppletActionStorage, PluginBridge pluginBridge) {
        return unsignedAppletActionStorage.getMatchingItem(UrlUtils.normalizeUrlAndStripParams(pluginBridge.getSourceLocation(), true).toString(), UrlUtils.normalizeUrlAndStripParams(pluginBridge.getCodeBase(), true).toString(), UnsignedAppletTrustConfirmation.toRelativePaths(pluginBridge.getArchiveJars(), pluginBridge.getCodeBase().toString()));
    }

    static List<String> toRelativePaths(List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (string2.startsWith(string)) {
                arrayList.add(string2.substring(string.length()));
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAppletAction(PluginBridge pluginBridge, ExecuteUnsignedApplet executeUnsignedApplet, boolean bl) {
        UnsignedAppletActionStorage unsignedAppletActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        unsignedAppletActionStorage.lock();
        try {
            UnsignedAppletActionEntry unsignedAppletActionEntry = UnsignedAppletTrustConfirmation.getMatchingItem(unsignedAppletActionStorage, pluginBridge);
            if (unsignedAppletActionEntry != null) {
                unsignedAppletActionEntry.setUnsignedAppletAction(executeUnsignedApplet);
                unsignedAppletActionEntry.setTimeStamp(new Date());
                unsignedAppletActionStorage.update(unsignedAppletActionEntry);
                return;
            }
            URL uRL = UrlUtils.normalizeUrlAndStripParams(pluginBridge.getCodeBase(), true);
            URL uRL2 = UrlUtils.normalizeUrlAndStripParams(pluginBridge.getSourceLocation(), true);
            UrlRegEx urlRegEx = new UrlRegEx("\\Q" + uRL + "\\E");
            UrlRegEx urlRegEx2 = new UrlRegEx(".*");
            List<String> list = null;
            if (!bl) {
                urlRegEx2 = new UrlRegEx("\\Q" + uRL2 + "\\E");
                list = UnsignedAppletTrustConfirmation.toRelativePaths(pluginBridge.getArchiveJars(), pluginBridge.getCodeBase().toString());
            }
            UnsignedAppletActionEntry unsignedAppletActionEntry2 = new UnsignedAppletActionEntry(executeUnsignedApplet, new Date(), urlRegEx2, urlRegEx, list);
            unsignedAppletActionStorage.add(unsignedAppletActionEntry2);
        }
        finally {
            unsignedAppletActionStorage.unlock();
        }
    }

    public static void checkUnsignedWithUserIfRequired(PluginBridge pluginBridge) throws LaunchException {
        boolean bl;
        if (UnsignedAppletTrustConfirmation.unsignedAppletsAreForbidden()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Not running unsigned applet at " + pluginBridge.getCodeBase() + " because unsigned applets are disallowed by security policy.");
            throw new LaunchException(pluginBridge, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletPolicyDenied"));
        }
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running unsigned applet at " + pluginBridge.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        ExecuteUnsignedApplet executeUnsignedApplet = UnsignedAppletTrustConfirmation.getStoredAction(pluginBridge);
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Stored action for unsigned applet at " + pluginBridge.getCodeBase() + " was " + (Object)((Object)executeUnsignedApplet));
        if (executeUnsignedApplet == ExecuteUnsignedApplet.ALWAYS) {
            bl = true;
        } else if (executeUnsignedApplet == ExecuteUnsignedApplet.NEVER) {
            bl = false;
        } else {
            UnsignedAppletTrustWarningPanel.UnsignedWarningAction unsignedWarningAction = SecurityDialogs.showUnsignedWarningDialog(pluginBridge);
            ExecuteUnsignedApplet executeUnsignedApplet2 = unsignedWarningAction.getAction();
            boolean bl2 = bl = executeUnsignedApplet2 == ExecuteUnsignedApplet.YES || executeUnsignedApplet2 == ExecuteUnsignedApplet.ALWAYS;
            if (executeUnsignedApplet2 != null) {
                UnsignedAppletTrustConfirmation.updateAppletAction(pluginBridge, executeUnsignedApplet2, unsignedWarningAction.rememberForCodeBase());
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Decided action for unsigned applet at " + pluginBridge.getCodeBase() + " was " + (Object)((Object)executeUnsignedApplet2));
        }
        if (!bl) {
            throw new LaunchException(pluginBridge, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletUserDenied"));
        }
    }
}

