/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class ControlCurve {
    protected Polygon pts;
    protected Polygon result;
    protected boolean withPoints = true;
    protected int selection = -1;
    static Font f = new Font("Courier", 0, 12);
    static final int EPSILON = 36;

    public ControlCurve() {
        this.pts = new Polygon();
    }

    public ControlCurve(Polygon polygon) {
        this.pts = polygon;
    }

    public Polygon getSourcePolygon() {
        return this.pts;
    }

    public void setSourcePolygon(Polygon polygon) {
        this.pts = polygon;
    }

    public Polygon calcualteResult() {
        return null;
    }

    public void calcualteAndSaveResult() {
        this.result = this.calcualteResult();
    }

    public void paint(Graphics graphics) {
        if (this.isWithPoints()) {
            FontMetrics fontMetrics = graphics.getFontMetrics(f);
            graphics.setFont(f);
            int n = fontMetrics.getAscent() / 2;
            for (int i = 0; i < this.pts.npoints; ++i) {
                String string = Integer.toString(i);
                int n2 = fontMetrics.stringWidth(string) / 2;
                graphics.drawString(Integer.toString(i), this.pts.xpoints[i] - n2, this.pts.ypoints[i] + n);
            }
        }
    }

    public int selectPoint(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        this.selection = -1;
        for (int i = 0; i < this.pts.npoints; ++i) {
            int n4 = ControlCurve.sqr(this.pts.xpoints[i] - n) + ControlCurve.sqr(this.pts.ypoints[i] - n2);
            if (n4 >= n3 || n4 >= 36) continue;
            n3 = n4;
            this.selection = i;
        }
        return this.selection;
    }

    static int sqr(int n) {
        return n * n;
    }

    public Polygon getResult() {
        return this.result;
    }

    public void resetResult() {
        this.result = null;
    }

    public int addPoint(int n, int n2) {
        this.pts.addPoint(n, n2);
        this.resetResult();
        this.selection = this.pts.npoints - 1;
        return this.selection;
    }

    public void setPoint(int n, int n2) {
        this.setPoint(this.selection, n, n2);
    }

    public void setPoint(int n, int n2, int n3) {
        if (n >= 0 && n < this.pts.npoints) {
            this.pts.xpoints[n] = n2;
            this.pts.ypoints[n] = n3;
            this.resetResult();
        }
    }

    public void removePoint(int n) {
        if (n >= 0 && n < this.pts.npoints) {
            --this.pts.npoints;
            for (int i = n; i < this.pts.npoints; ++i) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
            }
            this.resetResult();
        }
    }

    public void removePoint() {
        this.removePoint(this.selection);
    }

    public boolean isWithPoints() {
        return this.withPoints;
    }

    public void setWithPoints(boolean bl) {
        this.withPoints = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.pts.npoints; ++i) {
            stringBuilder.append(" ").append(this.pts.xpoints[i]).append(" ").append(this.pts.ypoints[i]);
        }
        return stringBuilder.toString();
    }

    void setSelection(int n) {
        this.selection = n;
    }
}

