/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Observable;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.BasePainter;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class ErrorPainter
extends BasePainter {
    private static final Color TEA_DEAD_COLOR = Color.darkGray;
    private static final Color BACKGROUND_DEAD_COLOR = Color.gray;
    private static final Color TEA_LEAFS_STALKS_DEAD_COLOR = new Color(100, 100, 100);
    private static final Color PLUGIN_DEAD_COLOR = Color.darkGray;
    private static final Color WATER_DEAD_COLOR = Color.darkGray;
    private static final Color PLAIN_TEXT_DEAD_COLOR = Color.white;
    private static final String ERROR_MESSAGE_KEY = "SPLASHerror";
    private static final String ERROR_FLY_MESSAGE_KEY = "SPLASH_ERROR";
    private static final Color ERROR_FLY_COLOR = Color.red;
    private Point errorCorner = null;
    private boolean errorIsFlying = false;
    private int errorFlyPercentage = 100;

    public static double interpol(double d, double d2, double d3, double d4) {
        return ErrorPainter.getRatio(d, d2) * (d4 - d3) + d3;
    }

    public static Color interpolateColor(double d, double d2, Color color, Color color2) {
        double d3 = ErrorPainter.interpol(d, d2, color2.getRed(), color.getRed());
        double d4 = ErrorPainter.interpol(d, d2, color2.getGreen(), color.getGreen());
        double d5 = ErrorPainter.interpol(d, d2, color2.getBlue(), color.getBlue());
        double d6 = ErrorPainter.interpol(d, d2, color2.getAlpha(), color.getAlpha());
        return new Color((int)d3, (int)d4, (int)d5, (int)d6);
    }

    public ErrorPainter(BasicComponentSplashScreen basicComponentSplashScreen) {
        this(basicComponentSplashScreen, false);
    }

    public ErrorPainter(BasicComponentSplashScreen basicComponentSplashScreen, boolean bl) {
        super(basicComponentSplashScreen);
        if (bl) {
            this.startErrorScream();
        }
    }

    public void startErrorScream() {
        this.errorIsFlying = true;
        this.getFlyingRedErrorTextThread().start();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.ensurePrerenderedStuff();
        if (this.errorIsFlying) {
            this.paintStillTo(graphics2D, this.master.getInformationElement(), this.master.getVersion());
        } else if (this.prerenderedStuff != null) {
            graphics2D.drawImage((Image)this.prerenderedStuff, 0, 0, null);
        }
        if (this.showNiceTexts) {
            this.paintNiceTexts(graphics2D);
        } else {
            this.paintPlainTexts(graphics2D);
        }
        if (this.errorIsFlying) {
            graphics2D.setClip(0, 0, this.master.getSplashWidth(), this.master.getSplashHeight());
            this.drawBigError(graphics2D);
        }
    }

    private void drawBigError(Graphics2D graphics2D) {
        Font font = new Font("Serif", 0, (int)ErrorPainter.scale(100.0, this.errorFlyPercentage, this.master.getSplashHeight()));
        graphics2D.setColor(ERROR_FLY_COLOR);
        graphics2D.setFont(font);
        this.drawTextAroundCenter(graphics2D, 0.0, this.geFlyingErrorMessage());
    }

    public Point getErrorCorner() {
        return this.errorCorner;
    }

    private void setColors() {
        this.teaColor = TEA_DEAD_COLOR;
        this.backgroundColor = BACKGROUND_DEAD_COLOR;
        this.teaLeafsStalksColor = TEA_LEAFS_STALKS_DEAD_COLOR;
        this.pluginColor = PLUGIN_DEAD_COLOR;
        this.waterColor = WATER_DEAD_COLOR;
    }

    private void interpolateColor(int n, int n2) {
        this.teaColor = ErrorPainter.interpolateColor(n, n2, TEA_LIVE_COLOR, TEA_DEAD_COLOR);
        this.backgroundColor = ErrorPainter.interpolateColor(n, n2, BACKGROUND_LIVE_COLOR, BACKGROUND_DEAD_COLOR);
        this.teaLeafsStalksColor = ErrorPainter.interpolateColor(n, n2, TEA_LEAFS_STALKS_LIVE_COLOR, TEA_LEAFS_STALKS_DEAD_COLOR);
        this.pluginColor = ErrorPainter.interpolateColor(n, n2, PLUGIN_LIVE_COLOR, PLUGIN_DEAD_COLOR);
        this.waterColor = ErrorPainter.interpolateColor(n, n2, WATER_LIVE_COLOR, WATER_DEAD_COLOR);
        this.plainTextColor = ErrorPainter.interpolateColor(n, n2, PLAIN_TEXT_LIVE_COLOR, PLAIN_TEXT_DEAD_COLOR);
    }

    @Override
    protected void paintStillTo(Graphics2D graphics2D, InformationElement informationElement, String string) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        FontMetrics fontMetrics = this.drawBase(graphics2D, informationElement, string);
        this.drawError(graphics2D, informationElement, string, fontMetrics);
        graphics2D.setRenderingHints(renderingHints);
    }

    private String getErrorMessage() {
        String string = Translator.R(ERROR_MESSAGE_KEY);
        return string;
    }

    private String geFlyingErrorMessage() {
        String string = Translator.R(ERROR_FLY_MESSAGE_KEY);
        return string;
    }

    private Thread getFlyingRedErrorTextThread() {
        Thread thread = new Thread(new FlyingRedErrorTextRunner(this));
        return thread;
    }

    private void drawError(Graphics2D graphics2D, InformationElement informationElement, String string, FontMetrics fontMetrics) {
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(this.getErrorMessage());
        int n3 = 5;
        graphics2D.setColor(this.backgroundColor);
        this.errorCorner = new Point(this.master.getSplashWidth() - n3 * 4 - n2, this.master.getSplashHeight() - n3 * 4 - n);
        if (this.errorCorner.x < 0) {
            this.errorCorner.x = 0;
        }
        graphics2D.fillRect(this.errorCorner.x, this.errorCorner.y, n3 * 4 + n2, n3 * 4 + n);
        graphics2D.setColor(this.plainTextColor);
        graphics2D.drawRect(this.errorCorner.x + n3, this.errorCorner.y + n3, n3 * 2 + n2, n3 * 2 + n);
        graphics2D.drawString(this.getErrorMessage(), this.errorCorner.x + 2 * n3, this.errorCorner.y + 5 * n3);
    }

    private final class FlyingRedErrorTextRunner
    extends Observable
    implements Runnable {
        private static final int FLYING_ERROR_PERCENTAGE_INCREMENT = -3;
        private static final int FLYING_ERROR_PERCENTAGE_MINIMUM = 5;
        private static final int FLYING_ERROR_PERCENTAGE_LOWER_BOUND = 80;
        private static final int FLYING_ERROR_PERCENTAGE_UPPER_BOUND = 90;
        private static final int FLYING_ERROR_DELAY = 75;

        private FlyingRedErrorTextRunner(ErrorPainter errorPainter2) {
            this.addObserver(errorPainter2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (ErrorPainter.this.errorIsFlying) {
                    ErrorPainter.this.errorFlyPercentage += -3;
                    ErrorPainter.this.interpolateColor(100, ErrorPainter.this.errorFlyPercentage);
                    if (ErrorPainter.this.errorFlyPercentage <= 5) {
                        ErrorPainter.this.errorIsFlying = false;
                        ErrorPainter.this.setColors();
                        ErrorPainter.this.prerenderedStuff = null;
                    }
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(75L);
                    if (ErrorPainter.this.errorFlyPercentage >= 90 || ErrorPainter.this.errorFlyPercentage <= 80) continue;
                    ErrorPainter.this.clearCachedWaterTextImage();
                    ErrorPainter.this.canWave = false;
                }
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
            finally {
                ErrorPainter.this.canWave = true;
                ErrorPainter.this.errorIsFlying = false;
                ErrorPainter.this.setColors();
                ErrorPainter.this.prerenderedStuff = null;
                ErrorPainter.this.master.repaint();
            }
        }
    }
}

