/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.NatCubic;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.TextOutlineRenderer;

public class TextWithWaterLevel
extends TextOutlineRenderer {
    private Color waterColor;
    private Color bgColor;
    private int percentageOfWater;
    private Random sea = new Random();
    private Polygon cachedPolygon;

    public TextWithWaterLevel(String string, Font font) {
        super(font, string);
        this.waterColor = Color.BLUE;
        this.bgColor = Color.white;
    }

    protected Point getFutureSize() {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        FontMetrics fontMetrics = bufferedImage.createGraphics().getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getText());
        int n2 = fontMetrics.getHeight();
        return new Point(n, n2);
    }

    public BufferedImage getBackground() {
        Point point = this.getFutureSize();
        int n = point.x;
        int n2 = point.y;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.bgColor);
        graphics2D.fillRect(0, 0, n, n2);
        if (this.cachedPolygon == null) {
            int n3 = n2 * this.percentageOfWater / 100;
            int n4 = 10;
            int n5 = 20;
            if (n3 > n4 / 2 + 1) {
                NatCubic natCubic = new NatCubic();
                for (int i = 0; i < n + 2 * n5; i += n5) {
                    natCubic.addPoint(i, n2 - n3 - n4 / 2 - this.sea.nextInt(n4));
                }
                this.cachedPolygon = natCubic.calcualteResult();
                this.cachedPolygon.addPoint(n, n2);
                this.cachedPolygon.addPoint(0, n2);
            }
        }
        graphics2D.setColor(this.waterColor);
        if (this.cachedPolygon != null) {
            graphics2D.fillPolygon(this.cachedPolygon);
        }
        return bufferedImage;
    }

    public Polygon getCachedPolygon() {
        return this.cachedPolygon;
    }

    public void setCachedPolygon(Polygon polygon) {
        this.cachedPolygon = polygon;
    }

    @Override
    public void cutTo(Graphics2D graphics2D, int n, int n2) {
        if (this.getImg() == null) {
            this.setImg(this.getBackground());
        }
        if (this.getImg() == null) {
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.getFont());
        graphics2D.setColor(this.getTextOutline());
        graphics2D.drawString(this.getText(), n, n2 - 2);
        graphics2D.drawString(this.getText(), n, n2 + 2);
        graphics2D.drawString(this.getText(), n - 2, n2);
        graphics2D.drawString(this.getText(), n + 2, n2);
        super.cutTo(graphics2D, n, n2);
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public void setWaterColor(Color color) {
        this.waterColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public int getPercentageOfWater() {
        return this.percentageOfWater;
    }

    public void setPercentageOfWater(int n) {
        this.percentageOfWater = n;
    }
}

