/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.InvalidJarHeaderException;

public class JarFile
extends java.util.jar.JarFile
implements Closeable {
    private static final byte[] ZIP_LOCAL_FILE_HEADER_SIGNATURE = new byte[]{80, 75, 3, 4};

    public JarFile(String string) throws IOException {
        super(string);
        JarFile.verifyZipHeader(new File(string));
    }

    public JarFile(String string, boolean bl) throws IOException {
        super(string, bl);
        JarFile.verifyZipHeader(new File(string));
    }

    public JarFile(File file) throws IOException {
        super(file);
        JarFile.verifyZipHeader(file);
    }

    public JarFile(File file, boolean bl) throws IOException {
        super(file, bl);
        JarFile.verifyZipHeader(file);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        super(file, bl, n);
        JarFile.verifyZipHeader(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyZipHeader(File file) throws IOException {
        if (!JNLPRuntime.isIgnoreHeaders()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                int n;
                byte[] byArray = new byte[ZIP_LOCAL_FILE_HEADER_SIGNATURE.length];
                for (n = 0; n < byArray.length; ++n) {
                    byArray[n] = 0;
                }
                n = ZIP_LOCAL_FILE_HEADER_SIGNATURE.length;
                int n2 = 0;
                int n3 = 0;
                while ((n3 = ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2)) != -1 && (n2 += n3) != n) {
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == ZIP_LOCAL_FILE_HEADER_SIGNATURE[i]) continue;
                    throw new InvalidJarHeaderException("Jar " + file.getName() + " do not heave valid header. You can skip this check by -Xignoreheaders");
                }
            }
        }
    }
}

