/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ScreenFinder {
    public static GraphicsDevice getCurrentScreen() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        return ScreenFinder.getScreenOnCoords(point);
    }

    public static Rectangle getCurrentScreenSizeWithoutBounds() {
        try {
            Point point = MouseInfo.getPointerInfo().getLocation();
            return ScreenFinder.getScreenOnCoordsWithoutBounds(point);
        }
        catch (HeadlessException headlessException) {
            OutputController.getLogger().log(headlessException);
            return new Rectangle(800, 600);
        }
    }

    public static void centerWindowsToCurrentScreen(Window window) {
        Rectangle rectangle = ScreenFinder.getCurrentScreenSizeWithoutBounds();
        window.setLocation(rectangle.x + (rectangle.width - window.getWidth()) / 2, rectangle.y + (rectangle.height - window.getHeight()) / 2);
    }

    public static GraphicsDevice getScreenOnCoords(Point point) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        GraphicsDevice graphicsDevice = null;
        for (GraphicsDevice graphicsDevice2 : graphicsDeviceArray) {
            GraphicsConfiguration[] graphicsConfigurationArray;
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = new GraphicsConfiguration[]{graphicsDevice2.getDefaultConfiguration()}) {
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                graphicsDevice = graphicsDevice2;
            }
        }
        if (graphicsDevice == null) {
            graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        }
        return graphicsDevice;
    }

    public static Rectangle getScreenOnCoordsWithoutBounds(Point point) {
        try {
            GraphicsDevice graphicsDevice = ScreenFinder.getScreenOnCoords(point);
            Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsDevice.getDefaultConfiguration());
            return new Rectangle((int)rectangle.getX() + insets.left, (int)rectangle.getY() + insets.top, (int)rectangle.getWidth() - insets.left, (int)rectangle.getHeight() - insets.bottom);
        }
        catch (HeadlessException headlessException) {
            OutputController.getLogger().log(headlessException);
            return new Rectangle(800, 600);
        }
    }
}

