/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.html.HTMLDocument;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.ConsoleOutputPaneModel;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.headers.ObservableMessagesProvider;

public class ConsoleOutputPane
extends JPanel
implements Observer {
    private ConsoleOutputPaneModel model;
    private int lastPostion;
    private DefaultHighlighter.DefaultHighlightPainter searchHighligh = new DefaultHighlighter.DefaultHighlightPainter(Color.blue);
    private Object lastSearchTag;
    ActionListener defaultActionSingleton = this.createDefaultAction();
    private AtomicBoolean done = new AtomicBoolean(true);
    private JButton apply;
    private JCheckBox autorefresh;
    private JCheckBox caseSensitive;
    private JButton copyPlain;
    private JButton copyRich;
    private JCheckBox highLight;
    private JEditorPane jEditorPane1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JCheckBox mark;
    private JRadioButton match;
    private JButton next;
    private JRadioButton notMatch;
    private JButton previous;
    private JButton refresh;
    private JTextField regExFilter;
    private JCheckBox regExLabel;
    private JCheckBox revertSort;
    private JTextField search;
    private JLabel searchLabel;
    private JCheckBox showCode;
    private JCheckBox showComplete;
    private JCheckBox showDate;
    private JCheckBox showDebug;
    private JCheckBox showErr;
    private JCheckBox showHeaders;
    private JButton showHide;
    private JCheckBox showIncomplete;
    private JCheckBox showInfo;
    private JCheckBox showJava;
    private JCheckBox showLevel;
    private JCheckBox showMessage;
    private JCheckBox showOrigin;
    private JCheckBox showOut;
    private JCheckBox showPlugin;
    private JCheckBox showPostInit;
    private JCheckBox showPreInit;
    private JCheckBox showThread1;
    private JCheckBox showThread2;
    private JCheckBox showUser;
    private JComboBox sortBy;
    private JLabel sortByLabel;
    private JLabel statistics;
    private JCheckBox wordWrap;
    private JPopupMenu insertChars;

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (!this.autorefresh.isSelected()) {
            this.statistics.setText(this.model.createStatisticHint());
            return;
        }
        boolean bl = this.model.shouldUpdate();
        if (!bl) {
            this.statistics.setText(this.model.createStatisticHint());
            return;
        }
        if (this.sortBy.getSelectedIndex() == 0) {
            this.updatePane(false);
        } else {
            this.refreshPane();
        }
    }

    public ConsoleOutputPane(ObservableMessagesProvider observableMessagesProvider) {
        this.model = new ConsoleOutputPaneModel(observableMessagesProvider);
        this.initComponents();
        this.regExFilter.setText(ConsoleOutputPaneModel.defaultPattern.pattern());
        if (!LogConfig.getLogConfig().isEnableHeaders()) {
            this.showHeaders.setSelected(false);
        }
        if (JNLPRuntime.isWebstartApplication()) {
            this.showPlugin.setSelected(false);
            this.showPreInit.setSelected(false);
            this.showPostInit.setSelected(false);
            this.showIncomplete.setSelected(false);
            this.showComplete.setSelected(false);
            this.showPlugin.setEnabled(false);
            this.showPreInit.setEnabled(false);
            this.showPostInit.setEnabled(false);
            this.showIncomplete.setEnabled(false);
            this.showComplete.setEnabled(false);
        }
        this.regExFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.colorize();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.colorize();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.colorize();
            }

            private void colorize() {
                try {
                    Pattern pattern;
                    String string = ConsoleOutputPane.this.regExFilter.getText();
                    ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern = pattern = Pattern.compile(string);
                    ConsoleOutputPane.this.regExLabel.setForeground(Color.green);
                }
                catch (Exception exception) {
                    ConsoleOutputPane.this.regExLabel.setForeground(Color.red);
                }
            }
        });
        this.regExFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (mouseEvent.getButton() != 3) {
                                ConsoleOutputPane.this.insertChars.setVisible(false);
                                return;
                            }
                            ConsoleOutputPane.this.insertChars.setLocation(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
                            ConsoleOutputPane.this.insertChars.setVisible(!ConsoleOutputPane.this.insertChars.isVisible());
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(exception);
                        }
                    }
                });
            }
        });
        this.regExFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 525) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConsoleOutputPane.this.insertChars.setLocation(ConsoleOutputPane.this.regExFilter.getLocationOnScreen());
                            ConsoleOutputPane.this.insertChars.setVisible(!ConsoleOutputPane.this.insertChars.isVisible());
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(exception);
                        }
                    }
                });
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.match);
        buttonGroup.add(this.notMatch);
        this.showHideActionPerformed(null);
        this.updateModel();
        this.refreshPane();
    }

    private ActionListener createDefaultAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.refreshAction(actionEvent);
            }
        };
    }

    private ActionListener getDefaultActionSingleton() {
        return this.defaultActionSingleton;
    }

    private synchronized void refreshPane() {
        if (this.highLight.isSelected()) {
            this.jEditorPane1.setContentType("text/html");
        } else {
            this.jEditorPane1.setContentType("text/plain");
        }
        this.model.lastUpdateIndex = 0;
        this.updatePane(true);
    }

    private synchronized void updatePane(final boolean bl) {
        if (!this.done.get()) {
            return;
        }
        this.done.set(false);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConsoleOutputPane.this.refreshPaneBody(bl);
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(exception);
                }
                finally {
                    ConsoleOutputPane.this.done.set(true);
                }
            }
        });
    }

    private synchronized void refreshPaneBody(boolean bl) throws BadLocationException, IOException {
        if (bl) {
            this.jEditorPane1.setText(this.model.importList(0));
        } else {
            String string = this.model.importList();
            if (this.highLight.isSelected()) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.jEditorPane1.getDocument();
                if (this.revertSort.isSelected()) {
                    hTMLDocument.insertAfterEnd(hTMLDocument.getRootElements()[0].getElement(0), string);
                } else {
                    hTMLDocument.insertBeforeEnd(hTMLDocument.getRootElements()[0], string);
                }
            } else if (this.revertSort.isSelected()) {
                this.jEditorPane1.setText(string + this.jEditorPane1.getText());
            } else {
                this.jEditorPane1.setText(this.jEditorPane1.getText() + string);
            }
        }
        this.jEditorPane1.setCaretPosition(0);
        if (this.mark.isSelected()) {
            this.markActionPerformed(null);
        }
        this.statistics.setText(this.model.createStatisticHint());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.showHeaders = new JCheckBox();
        this.showUser = new JCheckBox();
        this.showOrigin = new JCheckBox();
        this.showLevel = new JCheckBox();
        this.showDate = new JCheckBox();
        this.showThread1 = new JCheckBox();
        this.showThread2 = new JCheckBox();
        this.showMessage = new JCheckBox();
        this.showOut = new JCheckBox();
        this.showErr = new JCheckBox();
        this.showJava = new JCheckBox();
        this.showPlugin = new JCheckBox();
        this.showPreInit = new JCheckBox();
        this.sortByLabel = new JLabel();
        this.regExLabel = new JCheckBox();
        this.sortBy = new JComboBox();
        this.searchLabel = new JLabel();
        this.autorefresh = new JCheckBox();
        this.refresh = new JButton();
        this.apply = new JButton();
        this.regExFilter = new JTextField();
        ((PlainDocument)this.regExFilter.getDocument()).getDocumentProperties().remove("filterNewlines");
        this.copyPlain = new JButton();
        this.copyRich = new JButton();
        this.next = new JButton();
        this.previous = new JButton();
        this.search = new JTextField();
        this.caseSensitive = new JCheckBox();
        this.showIncomplete = new JCheckBox();
        this.highLight = new JCheckBox();
        this.wordWrap = new JCheckBox();
        this.showDebug = new JCheckBox();
        this.showInfo = new JCheckBox();
        this.showCode = new JCheckBox();
        this.statistics = new JLabel();
        this.showPostInit = new JCheckBox();
        this.showComplete = new JCheckBox();
        this.match = new JRadioButton();
        this.notMatch = new JRadioButton();
        this.revertSort = new JCheckBox();
        this.mark = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JTextPane();
        this.showHide = new JButton();
        this.showHeaders.setSelected(true);
        this.showHeaders.setText("Show headers:");
        this.showHeaders.addActionListener(this.getDefaultActionSingleton());
        this.showUser.setSelected(true);
        this.showUser.setText("user");
        this.showUser.addActionListener(this.getDefaultActionSingleton());
        this.showOrigin.setSelected(true);
        this.showOrigin.setText("origin");
        this.showOrigin.addActionListener(this.getDefaultActionSingleton());
        this.showLevel.setSelected(true);
        this.showLevel.setText("level");
        this.showLevel.addActionListener(this.getDefaultActionSingleton());
        this.showDate.setSelected(true);
        this.showDate.setText("date");
        this.showDate.addActionListener(this.getDefaultActionSingleton());
        this.showThread1.setSelected(true);
        this.showThread1.setText("thread 1");
        this.showThread1.addActionListener(this.getDefaultActionSingleton());
        this.showThread2.setSelected(true);
        this.showThread2.setText("thread 2");
        this.showThread2.addActionListener(this.getDefaultActionSingleton());
        this.showMessage.setSelected(true);
        this.showMessage.setText("Show messages");
        this.showMessage.addActionListener(this.getDefaultActionSingleton());
        this.showOut.setSelected(true);
        this.showOut.setText("std. Out");
        this.showOut.addActionListener(this.getDefaultActionSingleton());
        this.showErr.setSelected(true);
        this.showErr.setText("std. Err");
        this.showErr.addActionListener(this.getDefaultActionSingleton());
        this.showJava.setSelected(true);
        this.showJava.setText("java");
        this.showJava.addActionListener(this.getDefaultActionSingleton());
        this.showPlugin.setSelected(true);
        this.showPlugin.setText("plugin");
        this.showPlugin.addActionListener(this.getDefaultActionSingleton());
        this.showPreInit.setSelected(true);
        this.showPreInit.setText("pre-init");
        this.showPreInit.setToolTipText("plugin only");
        this.showPreInit.addActionListener(this.getDefaultActionSingleton());
        this.sortByLabel.setText("Sort by:");
        this.regExLabel.setText("Regular expression filter:");
        this.regExLabel.addActionListener(this.getDefaultActionSingleton());
        this.sortBy.setModel(new DefaultComboBoxModel<String>(new String[]{"As arrived (no sort)", "user", "origin", "level", "date", "code", "thread1", "thread2", "message"}));
        this.sortBy.addActionListener(this.getDefaultActionSingleton());
        this.searchLabel.setText("Search:");
        this.autorefresh.setSelected(true);
        this.autorefresh.setText("auto refresh");
        this.refresh.setText("refresh");
        this.refresh.addActionListener(this.getDefaultActionSingleton());
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ConsoleOutputPane)ConsoleOutputPane.this).model.usedPattern = ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern;
                ConsoleOutputPane.this.refreshAction(actionEvent);
            }
        });
        this.regExFilter.setText(".*");
        this.copyPlain.setText("Copy all (plain)");
        this.copyPlain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.copyPlainActionPerformed(actionEvent);
            }
        });
        this.copyRich.setText("Copy all (rich)");
        this.copyRich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.copyRichActionPerformed(actionEvent);
            }
        });
        this.next.setText("next>>>");
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.nextActionPerformed(actionEvent);
            }
        });
        this.previous.setText("<<<previous");
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.previousActionPerformed(actionEvent);
            }
        });
        this.caseSensitive.setText("case sensitive");
        this.showIncomplete.setSelected(true);
        this.showIncomplete.setText("incomplete");
        this.showIncomplete.setToolTipText("plugin only");
        this.showIncomplete.addActionListener(this.getDefaultActionSingleton());
        this.highLight.setSelected(true);
        this.highLight.setText("highlight");
        this.highLight.addActionListener(this.getDefaultActionSingleton());
        this.wordWrap.setText("word wrap");
        this.wordWrap.addActionListener(this.getDefaultActionSingleton());
        this.showDebug.setSelected(true);
        this.showDebug.setText("debug");
        this.showDebug.addActionListener(this.getDefaultActionSingleton());
        this.showInfo.setSelected(true);
        this.showInfo.setText("info");
        this.showInfo.addActionListener(this.getDefaultActionSingleton());
        this.showCode.setSelected(true);
        this.showCode.setText("code");
        this.showCode.addActionListener(this.getDefaultActionSingleton());
        this.statistics.setText("x/y");
        this.showPostInit.setSelected(true);
        this.showPostInit.setText("post-init");
        this.showPostInit.setToolTipText("plugin only");
        this.showPostInit.addActionListener(this.getDefaultActionSingleton());
        this.showComplete.setSelected(true);
        this.showComplete.setText("complete");
        this.showComplete.setToolTipText("plugin only");
        this.showComplete.addActionListener(this.getDefaultActionSingleton());
        this.match.setSelected(true);
        this.match.setText("match");
        this.match.addActionListener(this.getDefaultActionSingleton());
        this.notMatch.setText("not");
        this.notMatch.addActionListener(this.getDefaultActionSingleton());
        this.revertSort.setSelected(true);
        this.revertSort.setText("revert");
        this.revertSort.addActionListener(this.getDefaultActionSingleton());
        this.mark.setText("mark");
        this.mark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.markActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.showHeaders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showUser).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showOrigin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showLevel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showThread1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showThread2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.previous).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mark).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.next).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.wordWrap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highLight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyRich).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyPlain)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.search, -1, 438, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.caseSensitive)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.showMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showOut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showErr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showJava).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPlugin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDebug).addGap(6, 6, 6).addComponent(this.showInfo))).addGap(2, 2, 2).addComponent(this.statistics)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.showPreInit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPostInit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showIncomplete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showComplete)).addGroup(groupLayout.createSequentialGroup().addComponent(this.autorefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.revertSort).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sortBy, 0, 327, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.regExLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.match).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.notMatch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regExFilter, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.apply, -2, 106, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showHeaders).addComponent(this.showUser).addComponent(this.showLevel).addComponent(this.showDate).addComponent(this.showOrigin).addComponent(this.showCode).addComponent(this.showThread1).addComponent(this.showThread2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showMessage).addComponent(this.showOut).addComponent(this.showErr).addComponent(this.showJava).addComponent(this.showPlugin).addComponent(this.showDebug).addComponent(this.showInfo).addComponent(this.statistics)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showPreInit).addComponent(this.showIncomplete).addComponent(this.showPostInit).addComponent(this.showComplete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regExLabel).addComponent(this.regExFilter, -2, -1, -2).addComponent(this.apply).addComponent(this.match).addComponent(this.notMatch))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autorefresh).addComponent(this.refresh).addComponent(this.sortByLabel).addComponent(this.sortBy, -2, -1, -2).addComponent(this.revertSort))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.search, -2, -1, -2)).addComponent(this.caseSensitive)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previous).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyPlain).addComponent(this.copyRich).addComponent(this.highLight).addComponent(this.wordWrap)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mark).addComponent(this.next))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jEditorPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.showHide.setText("Hide");
        this.showHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.showHideActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 684, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.showHide, GroupLayout.Alignment.LEADING, -1, 672, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showHide).addContainerGap()));
        this.insertChars = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("insert \\t");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int n = ConsoleOutputPane.this.regExFilter.getCaretPosition();
                            StringBuilder stringBuilder = new StringBuilder(ConsoleOutputPane.this.regExFilter.getText());
                            stringBuilder.insert(n, "\t");
                            ConsoleOutputPane.this.regExFilter.setText(stringBuilder.toString());
                            ConsoleOutputPane.this.regExFilter.setCaretPosition(n + 1);
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(exception);
                        }
                    }
                });
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("insert \\n");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int n = ConsoleOutputPane.this.regExFilter.getCaretPosition();
                            StringBuilder stringBuilder = new StringBuilder(ConsoleOutputPane.this.regExFilter.getText());
                            stringBuilder.insert(n, "\n");
                            ConsoleOutputPane.this.regExFilter.setText(stringBuilder.toString());
                            ConsoleOutputPane.this.regExFilter.setCaretPosition(n + 1);
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(exception);
                        }
                    }
                });
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("reset default");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConsoleOutputPane.this.regExFilter.setText(ConsoleOutputPaneModel.defaultPattern.pattern());
                            ((ConsoleOutputPane)ConsoleOutputPane.this).model.usedPattern = ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern = ConsoleOutputPaneModel.defaultPattern;
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(exception);
                        }
                    }
                });
            }
        });
        this.insertChars.add(jMenuItem2);
        this.insertChars.add(jMenuItem);
        this.insertChars.add(jMenuItem3);
        this.validate();
    }

    private void refreshAction(ActionEvent actionEvent) {
        this.updateModel();
        this.refreshPane();
    }

    private void markActionPerformed(ActionEvent actionEvent) {
        int n = 0;
        if (!this.mark.isSelected()) {
            this.jEditorPane1.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Document document = this.jEditorPane1.getDocument();
            String string = this.search.getText();
            if (string.length() == 0) {
                this.jEditorPane1.getHighlighter().removeAllHighlights();
                return;
            }
            int n2 = 0;
            while (n2 + string.length() < document.getLength()) {
                String string2 = document.getText(n2, string.length());
                if (this.caseSensitive.isSelected() && string.equals(string2) || !this.caseSensitive.isSelected() && string.equalsIgnoreCase(string2)) {
                    ++n;
                    DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.orange);
                    this.jEditorPane1.getHighlighter().addHighlight(n2, n2 + string.length(), defaultHighlightPainter);
                }
                ++n2;
            }
            this.mark.setText("mark (" + n + ")");
        }
        catch (BadLocationException badLocationException) {
            OutputController.getLogger().log(badLocationException);
        }
    }

    private void previousActionPerformed(ActionEvent actionEvent) {
        try {
            Document document = this.jEditorPane1.getDocument();
            String string = this.search.getText();
            if (string.length() == 0) {
                this.lastPostion = document.getLength() - string.length() - 1;
                return;
            }
            for (int i = this.lastPostion; i >= 0; --i) {
                String string2 = document.getText(i, string.length());
                if ((!this.caseSensitive.isSelected() || !string.equals(string2)) && (this.caseSensitive.isSelected() || !string.equalsIgnoreCase(string2))) continue;
                if (this.lastSearchTag != null) {
                    this.jEditorPane1.getHighlighter().removeHighlight(this.lastSearchTag);
                }
                this.lastSearchTag = this.jEditorPane1.getHighlighter().addHighlight(i, i + string.length(), this.searchHighligh);
                this.jEditorPane1.setCaretPosition(i);
                this.lastPostion = i - string.length() - 1;
                return;
            }
            this.lastPostion = document.getLength() - string.length() - 1;
        }
        catch (BadLocationException badLocationException) {
            OutputController.getLogger().log(badLocationException);
        }
    }

    private void nextActionPerformed(ActionEvent actionEvent) {
        try {
            Document document = this.jEditorPane1.getDocument();
            String string = this.search.getText();
            if (string.length() == 0) {
                this.lastPostion = 0;
                return;
            }
            int n = this.lastPostion;
            while (n + string.length() < document.getLength()) {
                String string2 = document.getText(n, string.length());
                if (this.caseSensitive.isSelected() && string.equals(string2) || !this.caseSensitive.isSelected() && string.equalsIgnoreCase(string2)) {
                    if (this.lastSearchTag != null) {
                        this.jEditorPane1.getHighlighter().removeHighlight(this.lastSearchTag);
                    }
                    this.lastSearchTag = this.jEditorPane1.getHighlighter().addHighlight(n, n + string.length(), this.searchHighligh);
                    this.jEditorPane1.setCaretPosition(n);
                    this.lastPostion = n + 1;
                    return;
                }
                ++n;
            }
            this.lastPostion = 0;
        }
        catch (BadLocationException badLocationException) {
            OutputController.getLogger().log(badLocationException);
        }
    }

    private void showHideActionPerformed(ActionEvent actionEvent) {
        if (this.jPanel2.isVisible()) {
            this.jPanel2.setVisible(false);
            this.showHide.setText("Show controls");
        } else {
            this.jPanel2.setVisible(true);
            this.showHide.setText("Hide");
        }
    }

    private void copyPlainActionPerformed(ActionEvent actionEvent) {
        StringSelection stringSelection = new StringSelection(this.model.importList(false, 0));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void copyRichActionPerformed(ActionEvent actionEvent) {
        StringSelection stringSelection = new StringSelection(this.model.importList(true, 0));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                jFrame.setSize(800, 600);
                jFrame.setDefaultCloseOperation(3);
                ConsoleOutputPaneModel.TestMessagesProvider testMessagesProvider = new ConsoleOutputPaneModel.TestMessagesProvider();
                ConsoleOutputPane consoleOutputPane = new ConsoleOutputPane(testMessagesProvider);
                testMessagesProvider.getObservable().addObserver(consoleOutputPane);
                jFrame.getContentPane().add((Component)consoleOutputPane, "Center");
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }

    private void updateModel() {
        this.model.highLight = this.highLight.isSelected();
        this.model.matchPattern = this.match.isSelected();
        this.model.regExLabel = this.regExLabel.isSelected();
        this.model.revertSort = this.revertSort.isSelected();
        this.model.showCode = this.showCode.isSelected();
        this.model.showComplete = this.showComplete.isSelected();
        this.model.showDate = this.showDate.isSelected();
        this.model.showDebug = this.showDebug.isSelected();
        this.model.showErr = this.showErr.isSelected();
        this.model.showHeaders = this.showHeaders.isSelected();
        this.model.showIncomplete = this.showIncomplete.isSelected();
        this.model.showInfo = this.showInfo.isSelected();
        this.model.showJava = this.showJava.isSelected();
        this.model.showLevel = this.showLevel.isSelected();
        this.model.showMessage = this.showMessage.isSelected();
        this.model.showOrigin = this.showOrigin.isSelected();
        this.model.showOut = this.showOut.isSelected();
        this.model.showPlugin = this.showPlugin.isSelected();
        this.model.showPostInit = this.showPostInit.isSelected();
        this.model.showPreInit = this.showPreInit.isSelected();
        this.model.showThread1 = this.showThread1.isSelected();
        this.model.showThread2 = this.showThread2.isSelected();
        this.model.showUser = this.showUser.isSelected();
        this.model.sortBy = this.sortBy.getSelectedIndex();
        this.model.wordWrap = this.wordWrap.isSelected();
    }
}

