/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Random;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.headers.Header;
import net.sourceforge.jnlp.util.logging.headers.JavaMessage;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;
import net.sourceforge.jnlp.util.logging.headers.ObservableMessagesProvider;
import net.sourceforge.jnlp.util.logging.headers.PluginHeader;
import net.sourceforge.jnlp.util.logging.headers.PluginMessage;

public class ConsoleOutputPaneModel {
    static final Pattern defaultPattern = Pattern.compile("(m?)(.*\n*)*");
    ObservableMessagesProvider dataProvider;
    Pattern lastValidPattern;
    Pattern usedPattern;
    int lastUpdateIndex;
    int statisticsShown;
    private static final String HTMLCOLOR_DIMRED = "FF6666";
    private static final String HTMLCOLOR_MIDGRAY = "666666";
    private static final String HTMLCOLOR_SPARKRED = "FF0000";
    private static final String HTMLCOLOR_LIGHTGRAY = "AAAAAA";
    private static final String HTMLCOLOR_GREENYELLOW = "AAAA00";
    private static final String HTMLCOLOR_PINKYREAD = "FF0055";
    private static final String HTMLCOLOR_BLACK = "000000";
    boolean highLight;
    boolean matchPattern;
    boolean regExLabel;
    boolean revertSort;
    boolean showCode;
    boolean showComplete;
    boolean showDate;
    boolean showDebug;
    boolean showErr;
    boolean showHeaders;
    boolean showIncomplete;
    boolean showInfo;
    boolean showJava;
    boolean showLevel;
    boolean showMessage;
    boolean showOrigin;
    boolean showOut;
    boolean showPlugin;
    boolean showPostInit;
    boolean showPreInit;
    boolean showThread1;
    boolean showThread2;
    boolean showUser;
    int sortBy;
    boolean wordWrap;

    ConsoleOutputPaneModel(ObservableMessagesProvider observableMessagesProvider) {
        this.usedPattern = this.lastValidPattern = defaultPattern;
        this.dataProvider = observableMessagesProvider;
    }

    boolean shouldUpdate() {
        for (int i = this.lastUpdateIndex; i < this.dataProvider.getData().size(); ++i) {
            if (this.filtered(this.dataProvider.getData().get(i))) continue;
            return true;
        }
        return false;
    }

    String importList() {
        return this.importList(this.lastUpdateIndex);
    }

    String importList(int n) {
        return this.importList(this.highLight, n);
    }

    String importList(boolean bl, int n) {
        int n2 = n;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<div style='");
            if (!this.wordWrap) {
                stringBuilder.append("white-space:nowrap;");
            }
            stringBuilder.append("font-family:\"Monospaced\"'>");
        }
        List<MessageWithHeader> list = n == 0 ? this.preSort(this.dataProvider.getData()) : this.preSort(Collections.synchronizedList(this.dataProvider.getData().subList(n, this.dataProvider.getData().size())));
        this.lastUpdateIndex = this.dataProvider.getData().size();
        for (MessageWithHeader messageWithHeader : list) {
            if (this.filtered(messageWithHeader)) continue;
            if (bl) {
                stringBuilder.append("<div style='color:#");
                if (messageWithHeader.getHeader().isC && messageWithHeader.getHeader() instanceof PluginHeader) {
                    if (!((PluginHeader)messageWithHeader.getHeader()).preinit) {
                        if (messageWithHeader.getHeader().level.isError()) {
                            stringBuilder.append(HTMLCOLOR_DIMRED);
                        } else {
                            stringBuilder.append(HTMLCOLOR_MIDGRAY);
                        }
                    } else if (messageWithHeader.getHeader().level.isError()) {
                        stringBuilder.append(HTMLCOLOR_SPARKRED);
                    } else {
                        stringBuilder.append(HTMLCOLOR_LIGHTGRAY);
                    }
                } else if (messageWithHeader.getHeader().level.isWarning()) {
                    stringBuilder.append(HTMLCOLOR_GREENYELLOW);
                } else if (messageWithHeader.getHeader().level.isError()) {
                    stringBuilder.append(HTMLCOLOR_PINKYREAD);
                } else {
                    stringBuilder.append(HTMLCOLOR_BLACK);
                }
                stringBuilder.append("'>");
            }
            if (messageWithHeader instanceof PluginMessage && ((PluginMessage)messageWithHeader).wasError) {
                stringBuilder.append("{corrupted}");
            }
            String string = this.createLine(messageWithHeader);
            if (bl) {
                string = string.replaceAll("\n", "<br>\n");
                string = string.replaceAll("  ", "&nbsp; ");
                string = string.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            stringBuilder.append(string);
            if (bl) {
                stringBuilder.append("</div>");
            }
            stringBuilder.append("\n");
            ++n2;
        }
        if (bl) {
            stringBuilder.append("</div>");
        }
        this.statisticsShown = n2;
        return stringBuilder.toString();
    }

    String createLine(MessageWithHeader messageWithHeader) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.showHeaders) {
            stringBuilder.append(messageWithHeader.getHeader().toString(this.showUser, this.showOrigin, this.showLevel, this.showDate, this.showCode, this.showThread1, this.showThread2));
        }
        if (this.showMessage && this.showHeaders) {
            stringBuilder.append(": ");
        }
        if (this.showMessage) {
            stringBuilder.append(messageWithHeader.getMessage().toString());
        }
        return stringBuilder.toString();
    }

    List<MessageWithHeader> preSort(List<MessageWithHeader> list) {
        List<MessageWithHeader> list2;
        if (this.sortBy == 0) {
            if (this.revertSort) {
                list2 = Collections.synchronizedList(new ArrayList<MessageWithHeader>(list));
                Collections.reverse(list2);
            } else {
                list2 = list;
            }
        } else {
            list2 = Collections.synchronizedList(new ArrayList<MessageWithHeader>(list));
            switch (this.sortBy) {
                case 1: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().user.compareTo(messageWithHeader2.getHeader().user);
                        }
                    });
                    break;
                }
                case 2: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().getOrigin().compareTo(messageWithHeader2.getHeader().getOrigin());
                        }
                    });
                    break;
                }
                case 3: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().level.toString().compareTo(messageWithHeader2.getHeader().level.toString());
                        }
                    });
                    break;
                }
                case 4: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().date.compareTo(messageWithHeader2.getHeader().date);
                        }
                    });
                    break;
                }
                case 5: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().caller.compareTo(messageWithHeader2.getHeader().caller);
                        }
                    });
                    break;
                }
                case 6: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().thread1.compareTo(messageWithHeader2.getHeader().thread1);
                        }
                    });
                    break;
                }
                case 7: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getMessage().compareTo(messageWithHeader2.getMessage());
                        }
                    });
                    break;
                }
                case 8: {
                    Collections.sort(list2, new CatchedMessageWithHeaderComparator(){

                        @Override
                        public int body(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
                            return messageWithHeader.getHeader().thread2.compareTo(messageWithHeader2.getHeader().thread2);
                        }
                    });
                }
            }
        }
        return list2;
    }

    boolean filtered(MessageWithHeader messageWithHeader) {
        Object object;
        if (!this.showOut && messageWithHeader.getHeader().level.isOutput() && !messageWithHeader.getHeader().level.isWarning()) {
            return true;
        }
        if (!this.showErr && messageWithHeader.getHeader().level.isError() && !messageWithHeader.getHeader().level.isWarning()) {
            return true;
        }
        if (!this.showDebug && messageWithHeader.getHeader().level.isDebug()) {
            return true;
        }
        if (!this.showInfo && messageWithHeader.getHeader().level.isInfo()) {
            return true;
        }
        if (!this.showJava && !messageWithHeader.getHeader().isC) {
            return true;
        }
        if (!this.showPlugin && messageWithHeader.getHeader().isC) {
            return true;
        }
        if (messageWithHeader.getHeader() instanceof PluginHeader) {
            object = (PluginHeader)messageWithHeader.getHeader();
            if (!this.showPreInit && ((PluginHeader)object).preinit) {
                return true;
            }
            if (!this.showPostInit && !((PluginHeader)object).preinit) {
                return true;
            }
            if (!this.showIncomplete && messageWithHeader instanceof PluginMessage && ((PluginMessage)messageWithHeader).wasError) {
                return true;
            }
            if (!this.showComplete && messageWithHeader instanceof PluginMessage && !((PluginMessage)messageWithHeader).wasError) {
                return true;
            }
        }
        if (this.regExLabel) {
            object = this.createLine(messageWithHeader);
            if (this.matchPattern && !this.usedPattern.matcher((CharSequence)object).matches()) {
                return true;
            }
            if (!this.matchPattern && this.usedPattern.matcher((CharSequence)object).matches()) {
                return true;
            }
        }
        return false;
    }

    String createStatisticHint() {
        return this.statisticsShown + "/" + this.dataProvider.getData().size();
    }

    static class TestMessagesProvider
    extends Observable
    implements ObservableMessagesProvider {
        List<MessageWithHeader> data = new ArrayList<MessageWithHeader>();
        List<MessageWithHeader> origData = new ArrayList<MessageWithHeader>();

        @Override
        public List<MessageWithHeader> getData() {
            return this.data;
        }

        @Override
        public Observable getObservable() {
            return this;
        }

        public TestMessagesProvider() {
            this.createData();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(new Random().nextInt(2000));
                                TestMessagesProvider.this.data.add(TestMessagesProvider.this.origData.get(new Random().nextInt(TestMessagesProvider.this.origData.size())));
                                TestMessagesProvider.this.setChanged();
                                TestMessagesProvider.this.notifyObservers();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }

        void createData() {
            String[] stringArray;
            for (String string : stringArray = new String[]{"plugindebug 1384850630162925 [jvanek][ITW-C-PLUGIN][MESSAGE_DEBUG][Tue Nov 19 09:43:50 CET 2013][/home/jvanek/Desktop/icedtea-web/plugin/icedteanp/IcedTeaNPPlugin.cc:1204] ITNPP Thread# 140513434003264, gthread 0x7fcbd531f8c0:   PIPE: plugin read: plugin PluginProxyInfo reference 1 http://www.walter-fendt.de:80", "preinit_plugindebug 1384850630162920 [jvanek][ITW-C-PLUGIN][MESSAGE_DEBUG][Tue Nov 19 09:43:50 CET 2013][/home/jvanek/Desktop/icedtea-web/plugin/icedteanp/IcedTeaNPPlugin.cc:1204] ITNPP Thread# 140513434003264, gthread 0x7fcbd531f8c0:   PIPE: plugin read: plugin PluginProxyInfo reference 1 http://www.walter-fendt.de:80", "plugindebugX 1384850630162954 [jvanek][ITW-Cplugindebug 1384850630163008 [jvanek][ITW-C-PLUGIN][MESSAGE_DEBUG][Tue Nov 19 09:43:50 CET 2013][/home/jvanek/Desktop/icedtea-web/plugin/icedteanp/IcedTeaNPPlugin.cc:1124] ITNPP Thread# 140513434003264, gthread 0x7fcbd531f8c0: parts[0]=plugin, parts[1]=PluginProxyInfo, reference, parts[3]=1, parts[4]=http://www.walter-fendt.de:80 -- decoded_url=http://www.walter-fendt.de:80", "preinit_pluginerror 1384850630163294 [jvanek][ITW-C-PLUGIN][MESSAGE_ERROR][Tue Nov 19 09:43:50 CET 2013][/home/jvanek/Desktop/icedtea-web/plugin/icedteanp/IcedTeaNPPlugin.cc:1134] ITNPP Thread# 140513434003264, gthread 0x7fcbd531f8c0: Proxy info: plugin PluginProxyInfo reference 1 DIRECT", "pluginerror 1384850630163291 [jvanek][ITW-C-PLUGIN][MESSAGE_ERROR][Tue Nov 19 09:43:50 CET 2013][/home/jvanek/Desktop/icedtea-web/plugin/icedteanp/IcedTeaNPPlugin.cc:1134] ITNPP Thread# 140513434003264, gthread 0x7fcbd531f8c0: Proxy info: plugin PluginProxyInfo reference 1 DIRECT"}) {
                this.origData.add(new PluginMessage(string));
            }
            this.origData.add(new JavaMessage(new Header(OutputController.Level.ERROR_ALL, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 1"));
            this.origData.add(new JavaMessage(new Header(OutputController.Level.ERROR_DEBUG, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 3"));
            this.origData.add(new JavaMessage(new Header(OutputController.Level.WARNING_ALL, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 2"));
            this.origData.add(new JavaMessage(new Header(OutputController.Level.WARNING_DEBUG, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 4"));
            this.origData.add(new JavaMessage(new Header(OutputController.Level.MESSAGE_DEBUG, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 9"));
            this.origData.add(new JavaMessage(new Header(OutputController.Level.MESSAGE_ALL, Thread.currentThread().getStackTrace(), Thread.currentThread(), false), "message 0 - multilined \nsince beggining\n         later\nagain from beggingin\n               even later"));
            this.data.addAll(this.origData);
        }
    }

    private abstract class CatchedMessageWithHeaderComparator
    implements Comparator<MessageWithHeader> {
        private CatchedMessageWithHeaderComparator() {
        }

        @Override
        public int compare(MessageWithHeader messageWithHeader, MessageWithHeader messageWithHeader2) {
            try {
                int n = ConsoleOutputPaneModel.this.revertSort ? 1 : -1;
                return n * this.body(messageWithHeader, messageWithHeader2);
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }

        abstract int body(MessageWithHeader var1, MessageWithHeader var2);
    }
}

