/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.File;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.JavaConsole;

public class LogConfig {
    private String icedteaLogDir;
    private boolean enableLogging;
    private boolean enableHeaders;
    private boolean logToFile;
    private boolean logToStreams;
    private boolean logToSysLog;

    private LogConfig() {
        DeploymentConfiguration deploymentConfiguration = JNLPRuntime.getConfiguration();
        this.enableLogging = Boolean.parseBoolean(deploymentConfiguration.getProperty("deployment.log"));
        this.enableHeaders = Boolean.parseBoolean(deploymentConfiguration.getProperty("deployment.log.headers"));
        this.logToFile = Boolean.parseBoolean(deploymentConfiguration.getProperty("deployment.log.file"));
        this.logToStreams = Boolean.parseBoolean(deploymentConfiguration.getProperty("deployment.log.stdstreams"));
        this.logToSysLog = Boolean.parseBoolean(deploymentConfiguration.getProperty("deployment.log.system"));
        this.icedteaLogDir = deploymentConfiguration.getProperty("deployment.user.logdir");
        if (this.icedteaLogDir != null) {
            File file = new File(this.icedteaLogDir);
            if (file.isDirectory() || file.mkdirs()) {
                this.icedteaLogDir = this.icedteaLogDir + File.separator;
            } else {
                this.enableLogging = false;
            }
        }
    }

    public static LogConfig getLogConfig() {
        return LogConfigHolder.INSTANCE;
    }

    static synchronized void resetLogConfig() {
        LogConfigHolder.INSTANCE = new LogConfig();
    }

    public String getIcedteaLogDir() {
        return this.icedteaLogDir;
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    public boolean isLogToFile() {
        return this.logToFile;
    }

    public boolean isLogToStreams() {
        return this.logToStreams;
    }

    public boolean isLogToSysLog() {
        return this.logToSysLog;
    }

    public boolean isEnableHeaders() {
        return this.enableHeaders;
    }

    void setEnableHeaders(boolean bl) {
        this.enableHeaders = bl;
    }

    void setEnableLogging(boolean bl) {
        this.enableLogging = bl;
    }

    void setIcedteaLogDir(String string) {
        this.icedteaLogDir = string;
    }

    void setLogToFile(boolean bl) {
        this.logToFile = bl;
    }

    void setLogToStreams(boolean bl) {
        this.logToStreams = bl;
    }

    void setLogToSysLog(boolean bl) {
        this.logToSysLog = bl;
    }

    boolean isLogToConsole() {
        return JavaConsole.isEnabled();
    }

    private static class LogConfigHolder {
        private static volatile LogConfig INSTANCE = new LogConfig();

        private LogConfigHolder() {
        }
    }
}

