/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequest;
import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.RequestQueue;

public class PluginStreamHandler {
    private BufferedReader pluginInputReader;
    private BufferedWriter pluginOutputWriter;
    private RequestQueue queue = new RequestQueue();
    private PluginMessageConsumer consumer;
    private volatile boolean shuttingDown = false;

    public PluginStreamHandler(InputStream inputStream, OutputStream outputStream) {
        PluginDebug.debug("Current context CL=", Thread.currentThread().getContextClassLoader());
        PluginDebug.debug("Creating consumer...");
        this.consumer = new PluginMessageConsumer(this);
        this.pluginInputReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        this.pluginOutputWriter = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
    }

    public void startProcessing() {
        Thread thread = new Thread("PluginStreamHandlerListenerThread"){

            @Override
            public void run() {
                while (true) {
                    PluginDebug.debug("Waiting for data...");
                    String string = PluginStreamHandler.this.read();
                    if (string != null) {
                        PluginStreamHandler.this.consumer.queue(string);
                        continue;
                    }
                    try {
                        PluginStreamHandler.this.pluginInputReader.close();
                        PluginStreamHandler.this.pluginOutputWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    AppletSecurityContextManager.dumpStore(0);
                    PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                    JNLPRuntime.exit(0);
                }
            }
        };
        thread.start();
    }

    private int readPair(String string, int n, String[] stringArray) {
        int n2 = n;
        stringArray[0] = null;
        stringArray[1] = null;
        if (string.length() > n) {
            int n3 = string.indexOf(32, n);
            if (n3 == -1) {
                stringArray[0] = string.substring(n);
                n2 = string.length();
            } else {
                stringArray[0] = string.substring(n, n3);
                if (string.length() > n3 + 1) {
                    int n4 = string.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        stringArray[1] = string.substring(n3 + 1);
                        n2 = string.length();
                    } else {
                        stringArray[1] = string.substring(n3 + 1, n4);
                        n2 = n4 + 1;
                    }
                }
            }
        }
        PluginDebug.debug("readPair: '", stringArray[0], "' - '", stringArray[1], "' ", n2);
        return n2;
    }

    public void handleMessage(String string) throws PluginException {
        int n = -1;
        String string2 = null;
        String[] stringArray = null;
        String string3 = "";
        String[] stringArray2 = new String[2];
        int n2 = 0;
        int n3 = 0;
        n2 = this.readPair(string, n3, stringArray2);
        if (stringArray2[0] == null || stringArray2[1] == null) {
            return;
        }
        if (stringArray2[0].startsWith("plugin")) {
            this.handlePluginMessage(string);
            return;
        }
        String string4 = stringArray2[0];
        int n4 = Integer.parseInt(stringArray2[1]);
        n3 = n2;
        n2 = this.readPair(string, n3, stringArray2);
        if ("reference".equals(stringArray2[0])) {
            n = Integer.parseInt(stringArray2[1]);
            n3 = n2;
            n2 = this.readPair(string, n3, stringArray2);
        }
        if ("src".equals(stringArray2[0])) {
            string2 = stringArray2[1];
            n3 = n2;
            n2 = this.readPair(string, n3, stringArray2);
        }
        if ("privileges".equals(stringArray2[0])) {
            String string5 = stringArray2[1];
            stringArray = string5.split(",");
            n3 = n2;
        }
        if (string.length() > n3) {
            string3 = string.substring(n3);
        }
        try {
            PluginDebug.debug("Breakdown -- type: ", string4, " identifier: ", n4, " reference: ", n, " src: ", string2, " privileges: ", stringArray, " rest: \"", string3, "\"");
            if (string3.contains("JavaScriptGetWindow") || string3.contains("JavaScriptGetMember") || string3.contains("JavaScriptSetMember") || string3.contains("JavaScriptGetSlot") || string3.contains("JavaScriptSetSlot") || string3.contains("JavaScriptEval") || string3.contains("JavaScriptRemoveMember") || string3.contains("JavaScriptCall") || string3.contains("JavaScriptFinalize") || string3.contains("JavaScriptToString")) {
                this.finishCallRequest("reference " + n + " " + string3);
                return;
            }
            int n5 = n;
            String string6 = string3;
            if (string4.equals("instance")) {
                PluginAppletViewer.handleMessage(n4, n5, string6);
            } else if (string4.equals("context")) {
                PluginDebug.debug("Sending to PASC: ", n4, "/", n, " and ", string3);
                AppletSecurityContextManager.handleMessage(n4, n, string2, stringArray, string3);
            }
        }
        catch (Exception exception) {
            throw new PluginException(this, n4, n, exception);
        }
    }

    private void handlePluginMessage(String string) {
        if (string.equals("plugin showconsole")) {
            if (JavaConsole.isEnabled()) {
                JavaConsole.getConsole().showConsoleLater();
            } else {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("DPJavaConsoleDisabledHint"));
            }
        } else if (string.equals("plugin hideconsole")) {
            if (JavaConsole.isEnabled()) {
                JavaConsole.getConsole().hideConsoleLater();
            } else {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("DPJavaConsoleDisabledHint"));
            }
        } else {
            this.finishCallRequest(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCallRequest(PluginCallRequest pluginCallRequest) {
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.post(pluginCallRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCallRequest(String string) {
        PluginDebug.debug("DISPATCHCALLREQUESTS 1");
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            PluginDebug.debug("DISPATCHCALLREQUESTS 2");
            PluginCallRequest pluginCallRequest = this.queue.pop();
            if (this.queue.size() != 0) {
                int n = this.queue.size();
                int n2 = 0;
                while (!pluginCallRequest.serviceable(string)) {
                    PluginDebug.debug(pluginCallRequest, " cannot service ", string);
                    if (n2 >= n) {
                        throw new RuntimeException("Unable to find processor for message " + string);
                    }
                    this.queue.post(pluginCallRequest);
                    pluginCallRequest = this.queue.pop();
                    ++n2;
                }
            }
            PluginDebug.debug("DISPATCHCALLREQUESTS 3");
            if (pluginCallRequest != null) {
                PluginDebug.debug("DISPATCHCALLREQUESTS 5");
                PluginCallRequest pluginCallRequest2 = pluginCallRequest;
                synchronized (pluginCallRequest2) {
                    pluginCallRequest.parseReturn(string);
                    pluginCallRequest.notifyAll();
                }
                PluginDebug.debug("DISPATCHCALLREQUESTS 6");
                PluginDebug.debug("DISPATCHCALLREQUESTS 7");
            }
        }
        PluginDebug.debug("DISPATCHCALLREQUESTS 8");
    }

    private String read() {
        String string;
        block4: {
            string = null;
            try {
                string = this.pluginInputReader.readLine();
                PluginDebug.debug("  PIPE: appletviewer read: ", string);
                if (string != null && !string.equals("shutdown")) break block4;
                this.shuttingDown = true;
                try {
                    this.pluginInputReader.close();
                    this.pluginOutputWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                AppletSecurityContextManager.dumpStore(0);
                PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                JNLPRuntime.exit(0);
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        PluginDebug.debug("  PIPE: appletviewer wrote: ", string);
        BufferedWriter bufferedWriter = this.pluginOutputWriter;
        synchronized (bufferedWriter) {
            try {
                this.pluginOutputWriter.write(string + "\n", 0, string.length());
                this.pluginOutputWriter.write(0);
                this.pluginOutputWriter.flush();
            }
            catch (IOException iOException) {
                if (!this.shuttingDown) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
                }
                PluginDebug.debug("Unable to write to PIPE. APPLETVIEWER exiting");
                JNLPRuntime.exit(1);
            }
        }
    }
}

