/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import java.util.Vector;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCV9Instruction;

public class SPARCV9MembarInstruction
extends SPARCInstruction
implements SPARCV9Instruction {
    private final int mmask;
    private final int cmask;
    private final String description;

    public SPARCV9MembarInstruction(int mmask, int cmask) {
        super("membar");
        this.mmask = mmask & 0xF;
        this.cmask = cmask & 7;
        this.description = this.initDescription();
    }

    private String initDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        Vector<String> masks = new Vector<String>();
        if ((this.mmask & 1) != 0) {
            masks.add("#LoadLoad");
        }
        if ((this.mmask & 2) != 0) {
            masks.add("#StoreLoad");
        }
        if ((this.mmask & 4) != 0) {
            masks.add("#LoadStore");
        }
        if ((this.mmask & 8) != 0) {
            masks.add("#StoreStore");
        }
        if ((this.cmask & 1) != 0) {
            masks.add("#Lookaside");
        }
        if ((this.cmask & 2) != 0) {
            masks.add("#MemIssue");
        }
        if ((this.cmask & 4) != 0) {
            masks.add("#Sync");
        }
        Object[] tempMasks = masks.toArray();
        for (int i = 0; i < tempMasks.length - 1; ++i) {
            buf.append((String)tempMasks[i]);
            buf.append("| ");
        }
        buf.append((String)tempMasks[tempMasks.length - 1]);
        return buf.toString();
    }

    public int getMMask() {
        return this.mmask;
    }

    public int getCMask() {
        return this.cmask;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }
}

