<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-04-30  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Stefan Luka (Disney)
  * Troy Sobotka
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/Udl8yWjI2PqDQmxQ7P9IzKLVFfj197d7vKhT6jgaY9NMk4Qx-PtqhQl7j4T5UbcS.VZKJWfoBvSD3GkET>


**INTEGER PIXEL FORMAT SUPPORT**

   - We presented upgrades to the ImageDesc class, including adding the option
to deal with channel orderings other than RGB/RGBA, for example BGR, BGRA, ABGR.
   - We showed the updates to the CPU processing API
   - Dennis: Does the channel order affect the optimization?   Reply: No
   - Dennis: Is it possible to use a CPUProcessor on a different bit-depth than
it was created for?  Reply: No
   - Dennis: It would be nice to be able to specify a hint to be in a
lower-precision draft mode.
   - We introduced the new Optimization and Finalization flags options.
   - Mark: We need to be careful because apps could choose different
optimization settings leading to different user experience.  Reply: We will look
at adding an env var to give end-user control.
   - Being able to control optimization levels from the API would be useful for
debugging.
   - Mark: We need to be careful what features are exposed and document them
carefully.
   - The API has a clear recommended default call, so that should help encourage
consistency.
   - We reviewed the GPU API additions (similar to the new CPU API).
   - Dennis: Does the GPU have bit-depth control (we use 32f and 16f)?  Reply:
No, 32f only for now.
   - Kevin/Joseph: Is getOptimizedProcessor really returning an optimized result
(naming)?  Reply: Yes.
   - Mark: Looks good.

**DYNAMIC PROPERTIES (Issue #741)**

   - We discussed the large inefficiencies associated with the existing
DisplayTransform.
   - The current approch requires rebuilding/compiling the shader program, for
example, each time exposure is modified.
   - We presented the proposal for dynamic properties and an
ExposureContrastTransform as an example of how to use them.
   - Stefan: Could you elaborate on the contrast controls?  Reply: We provide
separate controls for a contrast in scene-referred space and a gamma in
display-referred space.
   - Troy: Does the power function control have a fulcrum?  Reply: Yes, we call
it a pivot.
   - Kevin/Mark: We have an explicit Log space for the show in our config that
may be used as a view.
   - Dennis: We're excited about dynamic properties.  We have a number of
transforms that need to be done outside OCIO right now for this reason, so this
would be very helpful.  We'd like to be able to parameterize an op.
   - Joseph: This would be helpful for ASC CDL too.
   - Stefan: What is the scope?  Reply: The immediate goal is to introduce the
capability and provide a very practical example of how to use it.
   - Mark: The optimizer will need to avoid collapsing any ops with dynamic
properties.  Reply: Absolutely.  (Finalize flags will provide control beyond the
default, e.g. batch rendering.)
   - Mark: Will apps add sliders for all ops that have been parameterized?
Reply: No, the dynamic aspect of each op needs to be specifically enabled first,
e.g. the config author needs to enable it.
   - Stefan: It's a nice feature but may add complexity that applications will
need to be aware of. The current situation is sometimes problematic, e.g.
differences between RV and Nuke, context switching.
   - Mark: What about just putting better exposure/contrast into the
DisplayTransform rather than add the new transform?  Reply: There is a question
about backwards compatibility with the DisplayTransform (e.g. upgrade or create
a new one).  To what extent are people using this today?
   - Stefan/Mark: We use DisplayTransform in Nuke and RV.
   - We discussed how the ExposureContrastTransform offers scene-linear, log,
and video modes.
   - Kevin: How does this work on CPU?  Reply: It works on both, the API is the
same regardless.  There will be a getDynamicProperty method on the Processor
object.
   - Mark: That returns a reference to a float?  Did you have to add a color
type?  Reply: It returns a dynamic property object.  Right now it just has a
float but there is a type enum with the idea that people could add other types. 
We are also looking at adding a bool.
   - Kevin: The properties are linked to a specific Processor instance?  Reply:
Yes
   - Mark: One of the core tenets of OCIO was that it represented a baked down
representation of a color pipeline.  Adding dynamic controls on top of that adds
a lot of complexity.  I'm wary to go down that path, the implications are not
clear.  Reply: We think the benefits outweigh the risks.  Please check out the
PR and give us your feedback.
   - Joseph: Having something that is fast and the same between CPU and GPU that
has dynamic properties is really intriguing.
   - Mark: We have generated a Processor for input and another for display, then
do our own code in the middle.  Perhaps we just need a library for making the
dynamic modifications in the working space, rather than put it in the Processor?
   - Kevin: You would then miss the opportunity to do some optimization.  We are
doing something similar to Mark in RV, would like to optimize it.
   - Mark: Is the idea that the op authors need to update to use dynamic
properties, so only the ops that are explicitly updated become dynamic?  Reply:
Yes.  For example, if you tried to enable dynamic on a matrix op it would fail
since the op doesn't have any dynamic properties.

**NAN/INF PREFERENCES**

   - We've added a lot of unit tests to document the NaN and Infinity handling
behavior for the different ops for both CPU and GPU.
   - Some GPUs don't fully obey IEEE floating-point standards.
   - Do you have preferences, for example should a NaN be preserved or flushed
to zero?
   - Mark:  Our expectation is to conform to the IEEE spec.  NaNs should stay
NaNs.  Going to a monitor you don't care, but file I/O you want them to be
preserved.
   - Kevin: Should that be an optimization setting?
   - Mark: The other option would be in the config, but it's probably better as
an optimization setting.

**TRANSFORM EQUALS METHOD**

   - Currently these are in the public API and we'd like to better understand
how they are used by people.  Currently the MatrixTransform "equals" method for
example does strict float==float comparisons.  Not clear what the use-case is
(it's not an ideal way to compare matrices).

**GENERAL DISCUSSION**

   - Mark: Any thought about adding YUV support?  Reply: OCIO could not undo
pixel subsampling, e.g. 4:2:2 to 4:4:4.  But for fully sampled YCbCr to RGB,
could do this already, just need to populate the matrix appropriately.
   - Kevin: I've come across GBR ordering.  Reply: We are putting in place the
infrastructure to support any ordering and implementing the most common cases. 
It will be straight-forward for someone to add additional cases.
   - Mark: I've been playing around with an open color math library.  It
generates matrices for various primaries.
   - Doug: Did you see the long thread about matrix libraries on the ASWF? 
Imath vs. Eigen, etc.
   - Mark: I did my own for now.  Also have another YAML file with tiered
definitions for common color spaces.  Allows an easy way to add new color spaces
from known primaries.  It's python.
   - Mark: I will do a demo at a future time.
