# Copied and tweaked version of ax_check_openssl intented for finding libtls.
# Based on version 10.
#
# SYNOPSIS
#
#   AX_CHECK_LIBTLS([action-if-found[, action-if-not-found]])
#
# DESCRIPTION
#
#   Look for libtls in a number of default spots, or in a user-selected
#   spot (via --with-libtls).  Sets
#
#     LIBTLS_INCLUDES to the include directives required
#     LIBTLS_LIBS to the -l directives required
#     LIBTLS_LDFLAGS to the -L or -R flags required
#
#   and calls ACTION-IF-FOUND or ACTION-IF-NOT-FOUND appropriately
#
# LICENSE
#
#   Copyright (c) 2009,2010 Zmanda Inc. <http://www.zmanda.com/>
#   Copyright (c) 2009,2010 Dustin J. Mitchell <dustin@zmanda.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 10

AC_DEFUN([AX_CHECK_LIBTLS], [
    found=false
    AC_ARG_WITH([libtls],
        [AS_HELP_STRING([--with-libtls=DIR],
            [root of the libtls directory])],
        [
            case "$withval" in
            "" | y | ye | yes | n | no)
            AC_MSG_ERROR([Invalid --with-libtls value])
              ;;
            *) ssldirs="$withval"
              ;;
            esac
        ], [
            # if pkg-config is installed and libtls has installed a .pc file,
            # then use that information and don't search ssldirs
            AC_CHECK_TOOL([PKG_CONFIG], [pkg-config])
            if test x"$PKG_CONFIG" != x""; then
                LIBTLS_LDFLAGS=`$PKG_CONFIG libtls --libs-only-L 2>/dev/null`
                if test $? = 0; then
                    LIBTLS_LIBS=`$PKG_CONFIG libtls --libs-only-l 2>/dev/null`
                    LIBTLS_INCLUDES=`$PKG_CONFIG libtls --cflags-only-I 2>/dev/null`
                    found=true
                fi
            fi

            # no such luck; use some default ssldirs
            if ! $found; then
                ssldirs="/usr/local/ssl /usr/lib/ssl /usr/ssl /usr/pkg /usr/local /usr"
            fi
        ]
        )


    if ! $found; then
        LIBTLS_INCLUDES=
        for ssldir in $ssldirs; do
            AC_MSG_CHECKING([for tls.h in $ssldir])
            if test -f "$ssldir/include/tls.h"; then
                LIBTLS_INCLUDES="-I$ssldir/include"
                LIBTLS_LDFLAGS="-L$ssldir/lib"
                LIBTLS_LIBS="-ltls"
                found=true
                AC_MSG_RESULT([yes])
                break
            else
                AC_MSG_RESULT([no])
            fi
        done

        # if the file wasn't found, well, go ahead and try the link anyway -- maybe
        # it will just work!
    fi

    # try the preprocessor and linker with our new flags,
    # being careful not to pollute the global LIBS, LDFLAGS, and CPPFLAGS

    AC_MSG_CHECKING([whether compiling and linking against libtls works])
    echo "Trying link with LIBTLS_LDFLAGS=$LIBTLS_LDFLAGS;" \
        "LIBTLS_LIBS=$LIBTLS_LIBS; LIBTLS_INCLUDES=$LIBTLS_INCLUDES" >&AS_MESSAGE_LOG_FD

    save_LIBS="$LIBS"
    save_LDFLAGS="$LDFLAGS"
    save_CPPFLAGS="$CPPFLAGS"
    LDFLAGS="$LDFLAGS $LIBTLS_LDFLAGS"
    LIBS="$LIBTLS_LIBS $LIBS"
    CPPFLAGS="$LIBTLS_INCLUDES $CPPFLAGS"
    AC_LINK_IFELSE(
        [AC_LANG_PROGRAM([#include <tls.h>], [tls_config_new()])],
        [
            AC_MSG_RESULT([yes])
            $1
        ], [
            AC_MSG_RESULT([no])
            $2
        ])
    CPPFLAGS="$save_CPPFLAGS"
    LDFLAGS="$save_LDFLAGS"
    LIBS="$save_LIBS"

    AC_SUBST([LIBTLS_INCLUDES])
    AC_SUBST([LIBTLS_LIBS])
    AC_SUBST([LIBTLS_LDFLAGS])
])
