// Code generated by go run ./scripts/blocked-services/main.go; DO NOT EDIT.

package filtering

// blockedService represents a single blocked service.
type blockedService struct {
	ID      string   `json:"id"`
	Name    string   `json:"name"`
	IconSVG []byte   `json:"icon_svg"`
	Rules   []string `json:"rules"`
	GroupID string   `json:"group_id"`
}

// serviceGroup represents single group of services.
type serviceGroup struct {
	ID string `json:"id"`
}

// blockedServices contains raw blocked service data.
var blockedServices = []blockedService{{
	ID:      "4chan",
	Name:    "4chan",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M33.25 2C31.311 2 29 3.724 29 11.928c0 4.614 1.237 8.92 1.29 9.101l.265.909.922-.215a32.132 32.132 0 0 0 5.472-1.907C39.37 18.711 45 15.614 45 10.75 45 8.098 43.789 5 40.375 5c-.996 0-1.807.356-2.387.736C36.868 4.038 35.13 2 33.25 2zM11.852 4C8.297 4 6 5.956 6 8.984c0 .975.355 1.752.746 2.325C5.044 12.389 3 14.129 3 16.25c0 1.428.97 4.75 9.943 4.75 5.104 0 8.958-1.248 9.12-1.3l.837-.276-.17-.865c-.042-.215-1.054-5.3-3.75-9.905C18.038 7.044 15.335 4 11.852 4zm8.22 24.057-.836.228c-.273.075-2.742.774-5.336 2.336-3.184 1.916-6.9 5.436-6.9 9.047C7 43.987 9.755 46 11.617 46a4.894 4.894 0 0 0 2.791-.877C15.383 46.262 17.144 48 19.316 48 22.957 48 23 41.027 23 40.957c0-6.061-2.477-11.86-2.582-12.103l-.346-.797zm16.67.943c-5.242 0-8.636 1.001-8.777 1.043l-.83.248.127.855c.02.138.518 3.416 1.88 6.627C31.395 43.078 34.483 46 37.845 46 42.704 46 44 43.161 44 41.484a4.94 4.94 0 0 0-.768-2.611C44.666 37.885 47 35.971 47 33.984 47 29.916 39.403 29 36.742 29z\"/></svg>"),
	Rules: []string{
		"||4cdn.org^",
		"||4chan.org^",
		"||4channel.org^",
	},
	GroupID: "social_network",
}, {
	ID:      "500px",
	Name:    "500px",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 5 14 L 2.5 26 L 6.800781 26 C 6.800781 26 7.699219 24.300781 10.199219 24.300781 C 12.699219 24.300781 14 26.199219 14 28.300781 C 14 30.402344 12.5 32.800781 10.199219 32.800781 C 7.898438 32.800781 6.5 30.398438 6.5 29 L 2 29 C 2 30.199219 3 36 10.199219 36 C 15.15625 36 17.417969 33.121094 18.015625 31.898438 C 19.386719 34.34375 21.992188 36 24.984375 36 C 27.253906 36 29.777344 34.808594 32.5 32.453125 C 35.222656 34.808594 37.746094 36 40.015625 36 C 44.417969 36 48 32.410156 48 28 C 48 23.589844 44.417969 20 40.015625 20 C 37.746094 20 35.222656 21.191406 32.5 23.546875 C 29.777344 21.191406 27.253906 20 24.984375 20 C 21.832031 20 19.105469 21.847656 17.8125 24.511719 C 17.113281 23.382813 15.414063 21 11.902344 21 C 8.101563 21 7.300781 22.597656 7.300781 22.597656 C 7.300781 22.597656 7.699219 21.300781 8.300781 18 L 17 18 L 17 14 Z M 24.984375 25 C 25.453125 25 26.800781 25.226563 29.230469 27.328125 L 30.011719 28 L 29.230469 28.671875 C 26.800781 30.773438 25.453125 31 24.984375 31 C 23.339844 31 22 29.652344 22 28 C 22 26.347656 23.339844 25 24.984375 25 Z M 40.015625 25 C 41.660156 25 43 26.347656 43 28 C 43 29.652344 41.660156 31 40.015625 31 C 39.546875 31 38.199219 30.773438 35.769531 28.671875 L 34.988281 28 L 35.769531 27.328125 C 38.199219 25.226563 39.546875 25 40.015625 25 Z\"/></svg>"),
	Rules: []string{
		"||500px.com^",
		"||500px.org^",
	},
	GroupID: "social_network",
}, {
	ID:      "9gag",
	Name:    "9GAG",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 44 14 C 44 13.644531 43.8125 13.316406 43.507813 13.136719 C 40.453125 11.347656 28.46875 4.847656 25.535156 3.136719 C 25.222656 2.957031 24.839844 2.957031 24.527344 3.136719 C 21.128906 5.117188 10.089844 11.621094 7.496094 13.136719 C 7.1875 13.316406 7 13.644531 7 14 L 7 20 C 7 20.378906 7.214844 20.722656 7.550781 20.894531 C 7.660156 20.949219 18.597656 26.453125 24.5 29.867188 C 24.8125 30.046875 25.195313 30.046875 25.507813 29.863281 C 27.269531 28.828125 29.117188 27.859375 30.902344 26.921875 C 32.253906 26.214844 33.636719 25.488281 35.003906 24.722656 C 35.007813 26.820313 35.003906 29.296875 35 30.40625 L 25 35.859375 L 14.480469 30.121094 C 14.144531 29.9375 13.730469 29.964844 13.417969 30.1875 L 6.417969 35.1875 C 6.140625 35.386719 5.980469 35.714844 6.003906 36.054688 C 6.023438 36.398438 6.214844 36.707031 6.515625 36.871094 L 24.542969 46.871094 C 24.695313 46.957031 24.859375 47 25.027344 47 C 25.195313 47 25.363281 46.957031 25.515625 46.875 L 43.484375 36.875 C 43.804688 36.695313 44 36.363281 44 36 C 44 36 43.992188 21.011719 44 14 Z M 25 20 L 18 16 L 25 12 L 32 16 Z\" /></svg>"),
	Rules: []string{
		"||9cache.com^",
		"||9gag.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "activision_blizzard",
	Name:    "Activision Blizzard",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-237 0 1572 1572\"><path d=\"m549.1.2 548.4 1571.4H798l-74.2-200H374.5l-74.3 200H.7zM626 1085.1l-83-274.3-82.9 274.3z\"/></svg>"),
	Rules: []string{
		"||activision.com^",
		"||activisionblizzard.com^",
		"||callofduty.com^",
		"||callofdutyleague.com^",
		"||codmwest.com^",
		"||demonware.net^",
	},
	GroupID: "gaming",
}, {
	ID:      "aliexpress",
	Name:    "AliExpress",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\"  viewBox=\"0 0 50 50\"><path d=\"M9 4C6.25 4 4 6.25 4 9v32c0 2.75 2.25 5 5 5h32c2.75 0 5-2.25 5-5V9c0-2.75-2.25-5-5-5H9zm0 2h32c1.668 0 3 1.332 3 3v3.38A3.973 3.973 0 0 0 41 11H9a3.973 3.973 0 0 0-3 1.38V9c0-1.668 1.332-3 3-3zm6 11a1 1 0 0 1 1 1c0 4.962 4.037 9 9 9s9-4.038 9-9a1 1 0 1 1 2 0c0 6.065-4.935 11-11 11s-11-4.935-11-11a1 1 0 0 1 1-1z\"/></svg>"),
	Rules: []string{
		"||ae-rus.net^",
		"||ae-rus.ru^",
		"||aliexpress.com^",
		"||aliexpress.ru^",
	},
	GroupID: "shopping",
}, {
	ID:      "amazon",
	Name:    "Amazon",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><path d=\"M16.2,4c-3.3,0-6.9,1.2-7.7,5.3C8.4,9.7,8.7,10,9,10l3.3,0.3c0.3,0,0.6-0.3,0.6-0.6c0.3-1.4,1.5-2.1,2.8-2.1c0.7,0,1.5,0.3,1.9,0.9c0.5,0.7,0.4,1.7,0.4,2.5v0.5c-2,0.2-4.6,0.4-6.5,1.2c-2.2,0.9-3.7,2.8-3.7,5.7c0,3.6,2.3,5.4,5.2,5.4c2.5,0,3.8-0.6,5.7-2.5c0.6,0.9,0.9,1.4,2,2.3c0.3,0.1,0.6,0.1,0.8-0.1v0c0.7-0.6,2-1.7,2.7-2.3c0.3-0.2,0.2-0.6,0-0.9c-0.6-0.9-1.3-1.6-1.3-3.2v-5.4c0-2.3,0.2-4.4-1.5-6C20.1,4.4,17.9,4,16.2,4z M17.1,14.3c0.3,0,0.6,0,0.9,0v0.8c0,1.3,0.1,2.5-0.6,3.7c-0.5,1-1.4,1.6-2.4,1.6c-1.3,0-2.1-1-2.1-2.5C12.9,15.2,14.9,14.5,17.1,14.3z M26.7,22.4c-0.9,0-1.9,0.2-2.7,0.8c-0.2,0.2-0.2,0.4,0.1,0.4c0.9-0.1,2.8-0.4,3.2,0.1s-0.4,2.3-0.7,3.1c-0.1,0.2,0.1,0.3,0.3,0.2c1.5-1.2,1.9-3.8,1.6-4.2C28.3,22.5,27.6,22.4,26.7,22.4z M3.7,22.8c-0.2,0-0.3,0.3-0.1,0.4c3.3,3,7.6,4.7,12.4,4.7c3.4,0,7.4-1.1,10.2-3.1c0.5-0.3,0.1-0.9-0.4-0.7c-3.1,1.3-6.4,1.9-9.5,1.9c-4.5,0-8.8-1.2-12.4-3.3C3.8,22.9,3.7,22.8,3.7,22.8z\" /></svg>"),
	Rules: []string{
		"||a2z.com^",
		"||a2z.org.cn^",
		"||aboutamazon.cn^",
		"||aboutamazon.co.uk^",
		"||aboutamazon.com.au^",
		"||aboutamazon.com^",
		"||aboutamazon.de^",
		"||aboutamazon.es^",
		"||aboutamazon.eu^",
		"||aboutamazon.fr^",
		"||aboutamazon.in^",
		"||aboutamazon.it^",
		"||aboutamazon.jp^",
		"||aboutamazon.pl^",
		"||acmvalidations.com^",
		"||acmvalidationsaws.com^",
		"||aesworkshops.com^",
		"||aiv-cdn.net^",
		"||alexa.com^",
		"||alexafund.cn^",
		"||alexafund.com.cn^",
		"||amaaozn.com^",
		"||amazon-adsystem.com^",
		"||amazon-fashions.com^",
		"||amazon-jp-recruiting.com^",
		"||amazon-lantern.com^",
		"||amazon-launchpad.com^",
		"||amazon.ae^",
		"||amazon.ca^",
		"||amazon.cn^",
		"||amazon.co.jp^",
		"||amazon.co.uk^",
		"||amazon.com.au^",
		"||amazon.com.be^",
		"||amazon.com.br^",
		"||amazon.com.mx^",
		"||amazon.com.tr^",
		"||amazon.com^",
		"||amazon.de^",
		"||amazon.es^",
		"||amazon.fr^",
		"||amazon.in^",
		"||amazon.it^",
		"||amazon.jobs^",
		"||amazon.jp^",
		"||amazon.nl^",
		"||amazon.red^",
		"||amazon.se^",
		"||amazon.sg^",
		"||amazon^",
		"||amazonalexavoxcon.com^",
		"||amazonauthorinsights.com^",
		"||amazonaws-china.com^",
		"||amazonaws.cn^",
		"||amazonaws.co.uk^",
		"||amazonaws.com.cn^",
		"||amazonaws.com^$dnstype=~CNAME",
		"||amazonaws.tv^",
		"||amazonbusiness.cn^",
		"||amazonbusiness.com.cn^",
		"||amazonbusiness.org^",
		"||amazonbusinessblog.com^",
		"||amazonchoice.cn^",
		"||amazonchoice.com.cn^",
		"||amazonchoices.cn^",
		"||amazonchoices.com.cn^",
		"||amazondevicesupport.com^",
		"||amazonfctours.com^",
		"||amazonianblog.com^",
		"||amazonimages.com^",
		"||amazoninspire.cn^",
		"||amazoninspire.com.cn^",
		"||amazonlaunchpad.cn^",
		"||amazonlaunchpad.com.cn^",
		"||amazonlaunchpad.com^",
		"||amazonlending.com.cn^",
		"||amazonliterarypartnership.com^",
		"||amazonlumberyard.wang^",
		"||amazonnow.cn^",
		"||amazonnow.com.cn^",
		"||amazonpay.com^",
		"||amazonpay.in^",
		"||amazonprimevideo.cn^",
		"||amazonprimevideo.com.cn^",
		"||amazonprimevideos.com^",
		"||amazonsdi.com^",
		"||amazonses.com^",
		"||amazonstudiosguilds.com^",
		"||amazontrust.com^",
		"||amazonvideo.cc^",
		"||amazonvideo.com^",
		"||amazonvideodirect.com^",
		"||amazonwebservices.com.cn^",
		"||amazonworkdocs.cn^",
		"||amazonworkdocs.com.cn^",
		"||amazonworkdocs.com^",
		"||amplifyapp.com^",
		"||amplifyframework.com^",
		"||amzn.asia^",
		"||amzn.com^",
		"||amzn.to^",
		"||amznl.com^",
		"||asfiovnxocqpcry.com.cn^",
		"||assoc-amazon.cn^",
		"||associates-amazon.com^",
		"||audible.com^",
		"||aws-border.cn^",
		"||aws-icp-domain-manager.cn^",
		"||aws-iot-hackathon.com^",
		"||aws^",
		"||awsapps.cn^",
		"||awsapps.com.cn^",
		"||awsautopilot.com^",
		"||awsautoscaling.com^",
		"||awsbraket.com^",
		"||awscommandlineinterface.com^",
		"||awsdns-*.co.uk^",
		"||awsdns-*.com^",
		"||awsdns-*.net^",
		"||awsdns-*.org^",
		"||awsdns-cn-*.biz^",
		"||awsdns-cn-*.cn^",
		"||awsdns-cn-*.top^",
		"||awsedstart.com^",
		"||awseducate.com^",
		"||awseducate.net^",
		"||awseducate.org^",
		"||awsglobalaccelerator.com^",
		"||awsloft-johannesburg.com^",
		"||awsloft-stockholm.com^",
		"||awssecworkshops.com^",
		"||awsstatic.cn^",
		"||awsstatic.com^",
		"||awsthinkbox.com^",
		"||awstrack.me^",
		"||awstrust.com^",
		"||boxofficemojo.com^",
		"||cdkworkshop.com^",
		"||cloudfront-cn.net^",
		"||cloudfront-test.cn^",
		"||cloudfront.cn^",
		"||cloudfront.net^",
		"||containersonaws.com^",
		"||createspace.com^",
		"||elasticbeanstalk.com^",
		"||gameon-masters.com^",
		"||gdansk-amazon.com^",
		"||images-amazon.com^",
		"||imdb.com^",
		"||imdb.to^",
		"||imdb^",
		"||kindle.cn^",
		"||kindle.co.jp^",
		"||kindle.co.uk^",
		"||kindle.com^",
		"||kindle.de^",
		"||kindle.es^",
		"||kindle.fr^",
		"||kindle.in^",
		"||kindle.it^",
		"||kindle.jp^",
		"||kindle^",
		"||kindleoasis.cn^",
		"||kindleoasis.com.cn^",
		"||kindleoasis.com^",
		"||kindleoasis.info^",
		"||kindleoasis.jp^",
		"||kindleoasis.org^",
		"||kindleoasis.us^",
		"||kindleoasisnews.com^",
		"||kindleproject.com^",
		"||media-amazon.com^",
		"||media-imdb.com^",
		"||nwcdcloud.cn^",
		"||nwcdcloud.com.cn^",
		"||nwcddns.cn^",
		"||nwcdinfosec.cn^",
		"||prime-video.com^",
		"||primeday.cn^",
		"||primeday.com.cn^",
		"||primeday.info^",
		"||primevideo.cc^",
		"||primevideo.com^",
		"||primevideo.info^",
		"||primevideo.org^",
		"||primevideo.tv^",
		"||route53.cn^",
		"||sagemaker.com.cn^",
		"||serving-sys.com^",
		"||siege-amazon.com^",
		"||ss2.us^",
		"||ssl-images-amazon.com^",
		"||thinkboxsoftware.com^",
		"||ueberamazon.de^",
		"||xn--cckwcxetd^",
		"||xn--jlq480n2rg^",
		"||yamaxun.cn^",
		"||yamaxun.com^",
		"||yamaxun^",
		"||z.cn^",
		"||zappos^",
	},
	GroupID: "shopping",
}, {
	ID:      "amazon_streaming",
	Name:    "Amazon Streaming",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><path d=\"M16.2,4c-3.3,0-6.9,1.2-7.7,5.3C8.4,9.7,8.7,10,9,10l3.3,0.3c0.3,0,0.6-0.3,0.6-0.6c0.3-1.4,1.5-2.1,2.8-2.1c0.7,0,1.5,0.3,1.9,0.9c0.5,0.7,0.4,1.7,0.4,2.5v0.5c-2,0.2-4.6,0.4-6.5,1.2c-2.2,0.9-3.7,2.8-3.7,5.7c0,3.6,2.3,5.4,5.2,5.4c2.5,0,3.8-0.6,5.7-2.5c0.6,0.9,0.9,1.4,2,2.3c0.3,0.1,0.6,0.1,0.8-0.1v0c0.7-0.6,2-1.7,2.7-2.3c0.3-0.2,0.2-0.6,0-0.9c-0.6-0.9-1.3-1.6-1.3-3.2v-5.4c0-2.3,0.2-4.4-1.5-6C20.1,4.4,17.9,4,16.2,4z M17.1,14.3c0.3,0,0.6,0,0.9,0v0.8c0,1.3,0.1,2.5-0.6,3.7c-0.5,1-1.4,1.6-2.4,1.6c-1.3,0-2.1-1-2.1-2.5C12.9,15.2,14.9,14.5,17.1,14.3z M26.7,22.4c-0.9,0-1.9,0.2-2.7,0.8c-0.2,0.2-0.2,0.4,0.1,0.4c0.9-0.1,2.8-0.4,3.2,0.1s-0.4,2.3-0.7,3.1c-0.1,0.2,0.1,0.3,0.3,0.2c1.5-1.2,1.9-3.8,1.6-4.2C28.3,22.5,27.6,22.4,26.7,22.4z M3.7,22.8c-0.2,0-0.3,0.3-0.1,0.4c3.3,3,7.6,4.7,12.4,4.7c3.4,0,7.4-1.1,10.2-3.1c0.5-0.3,0.1-0.9-0.4-0.7c-3.1,1.3-6.4,1.9-9.5,1.9c-4.5,0-8.8-1.2-12.4-3.3C3.8,22.9,3.7,22.8,3.7,22.8z\" /></svg>"),
	Rules: []string{
		"||aiv-delivery.net^",
		"||amazonmusic.com^",
		"||amazonprimevideo.cn^",
		"||amazonprimevideo.com.cn^",
		"||amazonprimevideos.com^",
		"||amazonvideo.cc^",
		"||amazonvideo.com^",
		"||amazonvideodirect.com^",
		"||atv-ext-eu.amazon.com^",
		"||atv-ext-fe.amazon.com^",
		"||atv-ext.amazon.com^",
		"||atv-ps-eu.amazon.co.uk^",
		"||atv-ps-eu.amazon.com^",
		"||atv-ps-fe.amazon.co.jp^",
		"||atv-ps-fe.amazon.com^",
		"||atv-ps.amazon.com^",
		"||av-eu.amazon.com^",
		"||av-na.amazon.com^",
		"||music.a2z.com^",
		"||music.amazon.co.uk^",
		"||music.amazon.com^",
		"||music.amazon.in^",
		"||prime-video.com^",
		"||primevideo.cc^",
		"||primevideo.com^",
		"||primevideo.info^",
		"||primevideo.org^",
		"||primevideo.tv^",
		"||video.a2z.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "amino",
	Name:    "Amino",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M9 4C6.24 4 4 6.24 4 9v32c0 2.76 2.24 5 5 5h32c2.76 0 5-2.24 5-5V9c0-2.76-2.24-5-5-5H9zm8.17 3.78a1.001 1.001 0 0 1 1.01 1c0 .37-.21.73-.57.9-.14.07-.29.1-.43.1a.987.987 0 0 1-.9-.56 1 1 0 0 1 .89-1.44zm15.66 0c.14 0 .29.03.43.1.36.17.56.53.56.9a.987.987 0 0 1-1 1c-.14 0-.29-.03-.43-.1a.998.998 0 0 1-.57-.9c0-.14.03-.29.1-.43a1 1 0 0 1 .91-.57zM13.77 9.93c.29 0 .58.13.78.38.15.18.22.4.22.62 0 .3-.13.59-.38.78a.963.963 0 0 1-.62.22c-.29 0-.58-.13-.78-.37a1.001 1.001 0 0 1 .78-1.63zm22.46 0c.22 0 .44.07.63.22a1.01 1.01 0 0 1 .15 1.41c-.2.24-.49.37-.78.37a.963.963 0 0 1-.62-.22.972.972 0 0 1-.38-.78c0-.22.07-.44.22-.62.2-.25.49-.38.78-.38zM25 10c8.27 0 15 6.73 15 15s-6.73 15-15 15-15-6.73-15-15 6.73-15 15-15zm-14.08 2.78a1.01 1.01 0 0 1 1.01 1 1.005 1.005 0 0 1-1.629.781 1 1 0 0 1 .619-1.782zm28.16 0c.29 0 .58.13.78.38.14.18.22.4.22.62 0 .29-.13.58-.38.78a1.005 1.005 0 0 1-1.629-.781 1.01 1.01 0 0 1 1.01-1zm-14.434 3.222a2.185 2.185 0 0 0-2.175 1.398l-5.09 13.59a.75.75 0 0 0 .7 1.01h1.458a.973.973 0 0 0 .75-.35c1.75-2 4.35-3.58 6.64-4.7l1.821 4.43a1.003 1.003 0 0 0 .92.62h1.25a.75.75 0 0 0 .7-1.01l-1.97-5.24c1.3-.52 2.19-.79 2.22-.79.8-.21 1.29-1.02 1.08-1.83a1.502 1.502 0 0 0-1.81-1.09c-.12.03-1.13.3-2.57.82l-2.01-5.35c-.25-.69-.79-1.25-1.5-1.44a2.223 2.223 0 0 0-.414-.068zm-15.867.187a1 1 0 0 1 1 1.01c0 .14-.03.292-.1.432a1.004 1.004 0 0 1-1.34.459.991.991 0 0 1-.458-1.33c.17-.36.528-.57.898-.57zm32.442 0c.37 0 .728.21.898.57a.985.985 0 0 1-.459 1.33 1.004 1.004 0 0 1-1.34-.459.971.971 0 0 1-.1-.43 1 1 0 0 1 1-1.01zM24.5 22.04c.24 0 .48.13.59.39l.66 1.622a27.9 27.9 0 0 0-1.61.83c-.543.304-1.09.633-1.63.988l1.4-3.44c.11-.26.35-.39.59-.39zM8.78 31.811c.37 0 .73.208.9.558a1 1 0 1 1-1.9.432c0-.36.2-.72.56-.89.14-.07.29-.1.44-.1zm32.44 0a.991.991 0 0 1 .898 1.43.995.995 0 0 1-1.329.47 1 1 0 0 1-.568-.91c0-.14.03-.292.1-.432.17-.35.53-.558.9-.558zm-30.3 3.41a1.005 1.005 0 0 1 1.01 1 1.01 1.01 0 0 1-1.01 1 1 1 0 0 1-.78-.381c-.14-.18-.22-.4-.22-.62 0-.29.13-.58.38-.78.18-.15.4-.22.62-.22zm28.16 0a1 1 0 1 1-.63 1.78.996.996 0 0 1-.38-.78 1.005 1.005 0 0 1 1.01-1zm-25.31 2.85c.22 0 .44.068.62.218.25.19.38.481.38.781 0 .22-.07.44-.22.62a1.002 1.002 0 0 1-1.41.16 1.01 1.01 0 0 1-.15-1.41c.2-.24.49-.37.78-.37zm22.46 0c.29 0 .58.128.78.368a1.001 1.001 0 0 1-.78 1.631c-.29 0-.58-.13-.78-.38a.958.958 0 0 1-.22-.62c0-.3.13-.59.38-.78a.963.963 0 0 1 .62-.22zm-19.05 2.15c.14 0 .29.03.43.1.36.17.57.53.57.9 0 .14-.03.29-.1.43a1.001 1.001 0 0 1-1.34.468.986.986 0 0 1-.56-.898.987.987 0 0 1 1-1zm15.64 0c.37 0 .73.198.9.558a1 1 0 1 1-1.9.442c0-.37.21-.73.57-.9.14-.07.29-.1.43-.1z\"/></svg>"),
	Rules: []string{
		"||aminoapps.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "apple_streaming",
	Name:    "Apple Streaming",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M33.375 0c-2.836.191-5.871 1.879-7.75 4.156-1.645 2.004-3.023 4.946-2.5 8-.469-.144-.895-.16-1.406-.344-1.395-.496-2.989-1.03-4.969-1.03-3.934 0-7.96 2.34-10.5 6.25C2.555 22.71 3.297 32.706 8.906 41.25c.989 1.5 2.14 3.137 3.563 4.438 1.422 1.3 3.14 2.292 5.156 2.312 1.723.02 2.922-.555 4-1.031 1.078-.477 2.082-.899 3.969-.907h.031c1.879-.015 2.852.399 3.906.876 1.055.476 2.242 1.078 3.969 1.062 2.055-.016 3.8-1.14 5.25-2.531 1.45-1.39 2.64-3.098 3.625-4.594 1.41-2.148 1.977-3.32 3.063-5.719a1.001 1.001 0 0 0-.563-1.344C41.32 32.47 39.293 29.325 39 26c-.293-3.324 1.113-6.746 4.656-8.688a1 1 0 0 0 .508-.675 1.007 1.007 0 0 0-.195-.825c-2.543-3.16-6.121-5.03-9.625-5.03-2.235 0-3.875.527-5.219 1.03-.223.086-.387.079-.594.157 1.364-.719 2.567-1.715 3.469-2.875 1.64-2.106 2.906-5.102 2.438-8.25A.999.999 0 0 0 33.374 0Zm-1.063 2.375c-.066 2.02-.757 3.996-1.906 5.469-1.203 1.547-3.226 2.617-5.187 2.937.035-1.941.8-3.953 1.968-5.375 1.227-1.484 3.258-2.554 5.125-3.031ZM16.75 12.781c1.613 0 2.906.418 4.281.906 1.375.489 2.824 1.063 4.532 1.063 1.667 0 2.988-.578 4.28-1.063 1.294-.484 2.583-.906 4.5-.906 2.505 0 5.212 1.301 7.344 3.563-3.414 2.41-5.011 6.168-4.687 9.812.324 3.684 2.543 7.18 6.188 9-.79 1.719-1.31 2.856-2.47 4.625-.956 1.457-2.093 3.051-3.343 4.25-1.25 1.2-2.574 1.957-3.906 1.969-1.285.012-2.016-.371-3.125-.875-1.11-.504-2.543-1.082-4.75-1.063-2.203.012-3.657.567-4.782 1.063s-1.863.887-3.156.875c-1.367-.012-2.636-.676-3.843-1.781-1.208-1.106-2.297-2.614-3.25-4.063-5.25-8-5.672-17.398-2.657-22.031 2.211-3.402 5.723-5.344 8.844-5.344Z\"/></svg>"),
	Rules: []string{
		"||applemusic.apple^",
		"||hls-svod-aoc-ve.itunes.g.aaplimg.com^",
		"||itun.es^",
		"||itunes.apple.com^",
		"||itunes.ca^",
		"||itunes.co.th^",
		"||itunes.co^",
		"||itunes.com^",
		"||itunes.es^",
		"||itunes.g.aaplimg.com^",
		"||itunes.hk^",
		"||itunes.mx^",
		"||itunes.org^",
		"||itunes.us^",
		"||music.apple.com^",
		"||tv.apple.com^",
		"||tv.g.apple.com^",
		"||tv.v.aaplimg.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "battle_net",
	Name:    "Battle.net",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M43.11 22.15s3.95.2 3.95-2.12c0-3.03-5.26-5.77-5.26-5.77s.83-1.74 1.34-2.72a37.3 37.3 0 0 0 2.09-5.65c.16-1.1-.09-1.44-.09-1.44-.35 2.34-4.17 9.09-4.47 9.32-3.72-1.75-8.83-2.23-8.83-2.23S26.84 1 22.13 1c-4.67 0-4.65 9.02-4.65 9.02s-1.32-2.56-2.97-2.56c-2.42 0-3.22 3.67-3.22 7.64a37.8 37.8 0 0 0-9.16 1.17c-.36.1-1.49.92-.97.82 1.04-.34 5.95-1.1 10.25-.72.24 3.77 2.44 8.68 2.44 8.68S9.13 31.9 9.13 36.78c0 1.29.56 3.64 3.95 3.64 2.84 0 6.03-1.7 6.63-2.06a6.33 6.33 0 0 0-.91 2.83c0 .54.31 2.06 2.5 2.06 2.82 0 5.96-2.16 5.96-2.16s2.96 4.93 5.5 7.2c.69.6 1.34.71 1.34.71s-2.52-2.43-5.84-8.68c3.08-1.9 6.3-6.4 6.3-6.4l3.3.01c4.6 0 11.11-.96 11.11-4.61 0-3.77-5.86-7.17-5.86-7.17Zm.52-2.26c0 1.33-1.27 1.3-1.27 1.3l-.97.08s-1.82-.97-2.93-1.41c0 0 1.72-2.65 2.12-3.4.3.18 3.05 1.9 3.05 3.43ZM24.43 6.3c2.15 0 5.23 5.1 5.23 5.1s-4.8-.44-8.76 1.89c.1-3.67 1.34-7 3.52-7Zm-8.56 4.13c.69 0 1.36.83 1.64 1.54 0 .47.24 3.2.24 3.2l-3.96-.16c0-3.57 1.4-4.58 2.08-4.58Zm-.4 24.8c-2.17 0-2.62-1.2-2.62-2.29 0-2.45 1.96-5.9 1.96-5.9s2.2 4.63 6.04 6.59a10.02 10.02 0 0 1-5.39 1.6Zm7.02 4.85c-1.52 0-1.7-.98-1.7-1.21 0-.7.55-1.54.55-1.54s2.55-1.73 2.71-1.91l1.89 3.52s-1.93 1.14-3.45 1.14Zm4.74-1.92c-.93-1.62-1.6-3.3-1.6-3.3s3.78.24 5.82-1.86a11.2 11.2 0 0 1-5.65 1.07c4.93-4.34 7.8-7.48 10.23-10.74a9.46 9.46 0 0 0-1.6-1.15c-1.46 1.76-7.16 7.86-12.45 10.88-6.69-3.64-8.09-14.38-8.23-16.6l3.65.34s-1.37 2.44-1.37 4.23c0 1.79.21 1.89.21 1.89s-.04-3.13 1.89-5.54c1.46 7.82 3 11.83 4.19 14.22.6-.25 1.74-.76 1.74-.76s-3.38-9.73-3.19-16.31a13.8 13.8 0 0 1 6.36-1.66c6.73 0 12.14 2.9 12.14 2.9l-2.12 2.95s-1.89-3.42-4.55-4.03c1.4 1.05 2.98 2.44 3.8 4.43a68.4 68.4 0 0 0-14.47-3.59c-.19.8-.17 1.94-.17 1.94s9.03 1.66 15.6 5.43c-.05 8.21-9 14.53-10.23 15.26Zm8.55-6.14s2.8-3.68 2.76-8.55c0 0 4.52 2.8 4.52 5.54 0 3.05-7.28 3-7.28 3Z\"/></svg>"),
	Rules: []string{
		"||battle.net^",
		"||battlenet.com.cn^",
		"||bnet.163.com^",
		"||bnet.cn^",
	},
	GroupID: "gaming",
}, {
	ID:      "betano",
	Name:    "Betano",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M9 3a1.0001 1.0001 0 0 0-1 1v42a1.0001 1.0001 0 0 0 1 1h17.7383c4.6 0 8.412-1.1874 11.0957-3.4395 2.6837-2.252 4.166-5.5679 4.166-9.494 0-5.0374-3.1967-8.9574-7.8125-10.422 3.3907-1.6449 5.7715-5.1833 5.7715-9.166 0-3.4752-1.3196-6.4288-3.7168-8.4297C33.845 4.048 30.4469 3 26.3379 3H9zm1 2h16.3379c3.769 0 6.6787.9611 8.623 2.584 1.9443 1.6228 2.998 3.9088 2.998 6.8945 0 3.8013-2.7237 7.2947-6.1718 8.045A1.0001 1.0001 0 0 0 31 23.5v.5a1.0001 1.0001 0 0 0 .871.9922c4.9067.6337 8.129 4.204 8.129 9.0742 0 3.4368-1.2203 6.0892-3.4531 7.9629C34.314 43.903 30.9943 45 26.7383 45H10V5zm7 4a1.0001 1.0001 0 0 0-1 1v12a1.0001 1.0001 0 0 0 1 1h6.0605c2.7307 0 4.9369-.546 6.5196-1.748S32 18.1768 32 16c0-2.1224-.7643-3.9577-2.1934-5.1816C28.3776 9.5944 26.3741 9 23.9961 9H17zm1 2h5.996c2.0451 0 3.5427.5096 4.5099 1.3379C29.473 13.1662 30 14.3314 30 16c0 1.7042-.5389 2.8304-1.629 3.6582C27.281 20.486 25.519 21 23.0606 21H18V11zm-1 15a1.0001 1.0001 0 0 0-1 1v13a1.0001 1.0001 0 0 0 1 1h7.629c2.8718 0 5.1969-.5884 6.8534-1.8887C33.139 37.811 34 35.8007 34 33.4277c0-2.3405-.902-4.3298-2.6074-5.5957C29.687 26.5662 27.3054 26 24.3418 26H17zm1 2h6.3418c2.7024 0 4.6504.5436 5.8574 1.4395C31.4062 30.3353 32 31.5613 32 33.4277c0 1.922-.5915 3.197-1.754 4.1094C29.0838 38.4496 27.223 39 24.629 39H18V28z\"/></svg>"),
	Rules: []string{
		"||betano.bg^",
		"||betano.ca^",
		"||betano.com^",
		"||betano.cz^",
		"||betano.de^",
		"||betano.ng^",
		"||betano.pt^",
	},
	GroupID: "gambling",
}, {
	ID:      "betfair",
	Name:    "Betfair",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"10 240 160 160\"><path d=\"M137.95 269.613H96.725V290.3H74.688l42.65 49.825L160 290.3h-22.05v-20.688M20.337 351.587h22.05v20.7h41.226v-20.712h22.05l-42.638-49.788-42.688 49.8\"/></svg>"),
	Rules: []string{
		"||betfair.com.au^",
		"||betfair.com^",
		"||betfair.es^",
		"||betfair.it^",
		"||betfair.ro^",
		"||betfair.se^",
	},
	GroupID: "gambling",
}, {
	ID:      "betway",
	Name:    "Betway",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -150 418 418\"><path d=\"M23.73 24.54a42.662 42.662 0 0 1 5.76-1.28 45.4 45.4 0 0 1 7-.48 30.89 30.89 0 0 1 12.88 2.58 27.47 27.47 0 0 1 9.56 7A31.091 31.091 0 0 1 64.82 43a41 41 0 0 1 2 13 42.17 42.17 0 0 1-2.78 16 29.33 29.33 0 0 1-7.8 11.18 32.71 32.71 0 0 1-11.86 6.58 49.611 49.611 0 0 1-15 2.17 76.328 76.328 0 0 1-16.14-1.56A93.775 93.775 0 0 1 0 86.51V0h23.73v24.54zm0 49.09a22 22 0 0 0 6.24.82 12.66 12.66 0 0 0 9.9-4.27c2.533-2.853 3.797-7.217 3.79-13.09 0-5.7-1.243-9.903-3.73-12.61a12.22 12.22 0 0 0-9.42-4.07 17.06 17.06 0 0 0-3.53.34 28 28 0 0 0-3.25.88v32zm69.02-11.8c.18 4 1.47 7.097 3.87 9.29a12.91 12.91 0 0 0 9.15 3.33 16.75 16.75 0 0 0 7.66-1.63 18.48 18.48 0 0 0 5.9-5l14.51 11.39a32.174 32.174 0 0 1-5 5 33.45 33.45 0 0 1-14.65 6.72 54.08 54.08 0 0 1-10.51.94 39.47 39.47 0 0 1-13.22-2.17 29.73 29.73 0 0 1-18.1-17.15 38.33 38.33 0 0 1-2.71-15 39.27 39.27 0 0 1 2.58-14.71 31.76 31.76 0 0 1 7-10.92A29.2 29.2 0 0 1 90 25.09a37.8 37.8 0 0 1 13.36-2.31c9.853 0 17.693 3.187 23.52 9.56s8.787 16.203 8.88 29.49H92.75zm20.75-12.61a13.52 13.52 0 0 0-3.19-8.33 8.74 8.74 0 0 0-6.71-3.06A9.65 9.65 0 0 0 96.48 41a13.52 13.52 0 0 0-3.6 8.27l20.62-.05zm21.69-8.4V24.28h9.36V7.59h23.73v16.69h10.06l5.86 16.54h-15.92v26.57a15.07 15.07 0 0 0 .74 5.29c.5 1.27 1.61 1.9 3.33 1.9A10.62 10.62 0 0 0 177 73.5a23.121 23.121 0 0 0 4-2.44l6.1 14.37a35.208 35.208 0 0 1-9.69 4.75 40.998 40.998 0 0 1-12.14 1.62 27.2 27.2 0 0 1-9.83-1.56 16 16 0 0 1-6.44-4.4 16.68 16.68 0 0 1-3.46-6.92 37.889 37.889 0 0 1-1-9.08v-29l-9.35-.02zm70.3 49.63L176.17 7.56h22.94l17 51.84 10.17-35.12h15.42l10.17 35.12 9.76-35.12h24.27l-23.46 66.17h-18.17l-10.44-34.72-10.3 34.72zm117.63 0-1.9-5.16a22.659 22.659 0 0 1-7.32 4.41 28.91 28.91 0 0 1-10.71 1.83 26.2 26.2 0 0 1-8.55-1.35 19.5 19.5 0 0 1-6.84-4 18.58 18.58 0 0 1-4.55-6.3 20.58 20.58 0 0 1-1.62-8.41 18.07 18.07 0 0 1 6.84-14.78 27.46 27.46 0 0 1 7.4-4.2 40.168 40.168 0 0 1 8.94-2.31c2.9-.45 5.58-.79 8.07-1s4.77-.39 6.85-.48v-1.64c0-2.72-.86-4.7-2.58-6a10 10 0 0 0-6.1-1.9 18.55 18.55 0 0 0-7.39 1.49 30.17 30.17 0 0 0-6.66 4.1L286.37 33a42.588 42.588 0 0 1 12.14-7.46 43.002 43.002 0 0 1 16.07-2.71c8.667 0 15.58 2.103 20.74 6.31s7.737 10.737 7.73 19.59v41.72h-19.93zm-3.39-30c-1.36.09-2.71.2-4.07.34s-2.76.34-4.2.61c-2.8.45-4.8 1.42-6 2.91a7.79 7.79 0 0 0-1.76 5 6.08 6.08 0 0 0 2 4.68 7.73 7.73 0 0 0 5.49 1.83 12.9 12.9 0 0 0 4.67-.81 15.638 15.638 0 0 0 3.87-2.17V60.45z\"/><path d=\"M349.12 97.77a23.76 23.76 0 0 0 4.48 1.9 15.88 15.88 0 0 0 4.74.81 7.93 7.93 0 0 0 4.14-1 7.19 7.19 0 0 0 2.64-3.39l3.8-8.54-28.07-63.27h25.76L380 62.92l13.29-38.64h24.4l-33.08 78.37c-2.347 5.507-5.533 9.393-9.56 11.66a28.49 28.49 0 0 1-14.17 3.39 39.2 39.2 0 0 1-9.49-1.08 50.372 50.372 0 0 1-8.27-2.85l6-16z\"/></svg>"),
	Rules: []string{
		"||betway.be^",
		"||betway.bet.ar^",
		"||betway.co.za^",
		"||betway.com.gh^",
		"||betway.com.ng^",
		"||betway.com^",
		"||betway.de^",
		"||betway.es^",
		"||betway.fr^",
		"||betway.it^",
		"||betway.mx^",
		"||betway.pl^",
		"||betway.se^",
		"||betwaygroup.com^",
		"||betwaysatta.com^",
		"||vietnambetway88.com^",
	},
	GroupID: "gambling",
}, {
	ID:      "bigo_live",
	Name:    "Bigo Live",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"3 3.5 41 41\" fill=\"currentColor\"><g fill=\"none\" stroke=\"currentColor\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><path d=\"M29.18 26.13c5.84-2.13 10.03-4.81 5.7-10.34.3-11.15-18.48-13.27-23.18-.61-.54 2.44-.36 7.7 1.48 11.92.68 1.6.15 8.1-2.23 5.16-1.12-1.52-2.16-1.58-2.6-1.42-2.14 3.95 3.39 7.32 4.6 7.34 3.02 3.5 5.59 3.07 7.77 3.23\"/><path d=\"M32.03 24.95c5 7.69 2.45 12.6-3.85 14.2M18.16 25.72c.97.92 2.4.74 3.38.06.19-1.83 1.67-1.76 1.92.11 1.2-.02 2.44-.16 2.67.7.14.9-.63 1.44-1.8 1.28.06 1.84-.86 1.78-2.93 1.6-.68.3-1.3.42-1.93.55m3.33-8.6c5.01 1.97 9.5 1.55 12.19-2.67\"/><ellipse cx=\"25.08\" cy=\"18.77\" rx=\"1.12\" ry=\"1.28\"/><ellipse cx=\"32.83\" cy=\"16.88\" rx=\".93\" ry=\"1.22\"/><path d=\"M20.52 40c6.87 13.72 14.2-18.17.53-6.2m13.52-4.57c11.28-7.01 2.68 13.07-1.86 8.09M25.83 6.57c-4.11-3.58-6.75-2.2-8.56 1.68-7.73-1.63-7.5 4.7-5.57 6.93-3.37 2.43-4.1 4.87.12 7.3-1.62.75-3.3 3.43 1.36 5.35-1.18.95-2.77 1.83-.12 3.4m24.07-15.36h2.63m-1.31-1.5v2.92\"/></g></svg>"),
	Rules: []string{
		"||bigo.sg^",
		"||bigo.tv^",
		"||bigolive.tv^",
		"||bigovideo.tv^",
	},
	GroupID: "streaming",
}, {
	ID:      "bilibili",
	Name:    "Bilibili",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\" fill=\"currentColor\"><path d=\"M36.5 12h-7.09l3.8-3.8a1 1 0 1 0-1.42-1.4L26.6 12H21.4l-5.2-5.2a1 1 0 1 0-1.42 1.4l3.8 3.8H12.5A5.5 5.5 0 0 0 7 17.5v15a5.5 5.5 0 0 0 5.5 5.5h2a1.5 1.5 0 1 0 3 0h14a1.5 1.5 0 1 0 3 0h2a5.5 5.5 0 0 0 5.5-5.5v-15a5.5 5.5 0 0 0-5.5-5.5ZM39 32.5a2.5 2.5 0 0 1-2.5 2.5h-24a2.5 2.5 0 0 1-2.5-2.5v-15a2.5 2.5 0 0 1 2.5-2.5h24a2.5 2.5 0 0 1 2.5 2.5v15Z\"/><path d=\"m29.08 19.58-.87 2.6 6.71 2.24.87-2.6-6.71-2.24Zm-8.16 0-6.7 2.23.86 2.61 6.71-2.23-.87-2.61Zm7.11 7.95c-.19.59-.64.9-1.32.9l-.24-.03c-.02 0-.05-.02-.07 0a1.99 1.99 0 0 1-1.06-.47 2.37 2.37 0 0 1-.94-1.48s-.3 1.18-.9 1.5l-.25.16-.04.02a2.47 2.47 0 0 1-1.09.28c-.56-.05-.94-.33-1.13-.82l-.07-.17-1.42.66.05.14a2.82 2.82 0 0 0 2.74 1.77c.92 0 1.66-.3 2.2-.91.56.6 1.3.9 2.22.9a2.82 2.82 0 0 0 2.76-1.84l.05-.12-1.43-.66-.06.17Z\"/></svg>"),
	Rules: []string{
		"|upos-hz-mirrorakam.akamaized.net^",
		"||acg.tv^",
		"||acgvideo.com^",
		"||animetamashi.cn^",
		"||animetamashi.com^",
		"||anitama.cn^",
		"||anitama.net^",
		"||b23.tv^",
		"||bigfun.cn^",
		"||bili22.cn^",
		"||bili2233.cn^",
		"||bili23.cn^",
		"||bili33.cn^",
		"||biliapi.com^",
		"||biliapi.net^",
		"||bilibili.cc^",
		"||bilibili.cn^",
		"||bilibili.com^",
		"||bilibili.net^",
		"||bilibili.tv^",
		"||bilibiligame.cn^",
		"||bilibiligame.co^",
		"||bilibiligame.net^",
		"||bilibilipay.cn^",
		"||bilibilipay.com^",
		"||bilicdn1.com^",
		"||bilicdn2.com^",
		"||bilicdn3.com^",
		"||bilicdn4.com^",
		"||bilicdn5.com^",
		"||biligame.co^",
		"||biligame.com^",
		"||biligame.net^",
		"||biligo.com^",
		"||biliimg.com^",
		"||biliintl.com^",
		"||bilivideo.cn^",
		"||bilivideo.com^",
		"||bilivideo.net^",
		"||dreamcast.hk^",
		"||hdslb.com^",
		"||hdslb.org^",
		"||im9.com^",
		"||maoercdn.com^",
		"||mincdn.com^",
		"||yo9.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "blaze",
	Name:    "Blaze",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-5 0 40 40\"><path d=\"m25.087 27.122-7.63 7.63a3.606 3.606 0 0 1-2.947 1.037 3.6 3.6 0 0 1-2.163-1.036l-7.63-7.631a3.603 3.603 0 0 1-1.058-2.553 3.6 3.6 0 0 1 1.058-2.556l7.63-7.63a3.605 3.605 0 0 1 2.86-1.046 3.61 3.61 0 0 1 2.25 1.045l7.63 7.631a3.601 3.601 0 0 1 1.058 2.553 3.6 3.6 0 0 1-1.058 2.556Zm4.225-5.226.007-.003-.037-.101c-.029-.074-.052-.149-.083-.222L24.571 9.112l-2.785 3.99L14.905 0S4.055 16.137 1.304 20.252h.005c-2.022 3.021-1.703 7.144.965 9.812l7.131 7.131a7.773 7.773 0 0 0 10.993 0l7.132-7.131c2.21-2.21 2.79-5.414 1.782-8.168Z\"/><path d=\"M14.902 17.182a2.244 2.244 0 1 0 0 4.488 2.244 2.244 0 0 0 0-4.488Zm0 10.283a2.244 2.244 0 1 0 0 4.488 2.244 2.244 0 0 0 0-4.488Zm5.141-5.142a2.244 2.244 0 1 0 0 4.489 2.244 2.244 0 0 0 0-4.489ZM7.516 24.567a2.245 2.245 0 1 0 4.489 0 2.245 2.245 0 0 0-4.49 0Z\"/></svg>"),
	Rules: []string{
		"||blaze.bet^",
		"||blaze.com.br^",
		"||blaze.com^",
		"||blazecareers.com^",
	},
	GroupID: "gambling",
}, {
	ID:      "blizzard_entertainment",
	Name:    "Blizzard Entertainment",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -32 128 128\"><path fill-rule=\"evenodd\" d=\"M105 2h3v1h2l2 1 1 1h3l1 1h4l1 1 2 2v1l1 3v4l1 2v6l-1 2v2l-1 3v2l-1 2v14l-1 2v1l-1 3-1 1h-3l-1 1h-6a5 5 0 0 0 1-6l2-1h-1l-1-3v-3a350 350 0 0 1 0-8l-1-3v-1l-1-1V9h1V6l-1-1-4-3Zm9 13v10h1v25a8 8 0 0 0 2-4l1-1 1-3V30l1-1v-2l1-1v-5l-1-2-2-3-1-1h-3Z\" clip-rule=\"evenodd\"/><path fill-rule=\"evenodd\" d=\"M101 24v1l2 1h1v2h1l1 2v5l1 2s0-1 0 0l1 7 1 2v7l-1 5h-2l-2-2-4-1 1-3 1-2a22 22 0 0 0-1-10l-1-4h-1l1-4-1-1-2-3v2l-1 1v3l1 6v4l1 1-1 3v4l1 1-1 2v4l-1-1a13 13 0 0 0-4-5l-2-2 2-5V27l-1-1v-4l-1-1v-5h-1a33 33 0 0 1 0-4l4-4h-2l-4-4h-1V3h10l2 1 2 1h1c2 0 2 1 3 2l2 3 1 3v1l-1 2v1a11 11 0 0 1-1 4l-4 3ZM96 9v13l1 1a3 3 0 0 0 1-1c1 0 2-1 2-3v-1l1-1v-3l-2-3-2-2h-1ZM26 3l1 1h1l2 3v5l1 1v2l-1 1v9l1 1 1 1-1 7v9l-1 1 1 1-1 1v8h3l1-1h7v-1h16v6l1 2h-6l-1-1h-2l-1-1H31a4 4 0 0 0-3-1l-1 1h-1l-1 1h-5l1-1a10 10 0 0 0 3-2v-9l1-1-1-1V35l1-1V21l-1-1v-4l1-1v-3l1-2-1-3h-1l-2-2-1-1 1-1h4Z\" clip-rule=\"evenodd\"/><path fill-rule=\"evenodd\" d=\"M84 60v-3l-1-2v-4l-3-2v-1l1-2a11 11 0 0 0 2-6l-1-1-3-2h-2v3l1 1h1l-1 2h-4l-2 1-2 1-1-2v-1l1-1 1-1 1-2v-5l1-1v-6l1-1v-3l1-1v-3l1-2 1-1-1-1 1-1 1-3 1-1V7l1-1c1-1 0-4 2-3l1 3 1 1 1 2v1l1 5 1 3v2l1 1v2l1 1v8l1 3v9l-1 1-2 5v3l-1 2v4l-1 1h-1Zm-4-36-1 1v2l-1 2v4l4 1h2v-7l-1-3-2-1-1-1v2Z\" clip-rule=\"evenodd\"/><path fill-rule=\"evenodd\" d=\"M77 4v1l-2 3v2l-1 2v1l-1 1-1 4v7h-1v2a5 5 0 0 1-1 2v2l-2 2v7l-1 2v2l-2 4v3-1h3v-1l3-1 1-1 3-2h3l1 1-1 1a3 3 0 0 0 0 1l1 1v5l-1 1h-7v-1h-2l-2 1h-4l-2 1-1-2v-2l1-1v-1l1-1-1-1 1-1v-2l1-2-1-2v-8l1-2 2-5-1-1 1-2v-1l1-1v-4l1-1 2-4v-2l1-1h-3V8h-1l-1 1-2 3-1 4h-1l-1-1v-2l1-1V4h16ZM32 4h9l1 2-3 2 1 2-1 1v13l1 2-1 2v6l-1 1v2l1 1v5l-1 1 1 2 1 1 2 1v2h-7l-2 1-1-1 3-2v-8a4 4 0 0 1 0-2l1-1v-3l-1-14v-2l1-1h-1V7l-2-1h-1l-1-1 1-1Zm12 0h14v15c-2 1-2 4-3 6v2c-1 0-3 1-2 4h-1l-2 3-1 2v3l-1 2-2 5h2l1-1h2l1-1c1-1 1-3 3-3l1-2 2-2h1l1 3h-1v1l-1 1v7h-8l-1 1-2-1h-3l-1-1 1-1v-3l-1-2 1-1-1-1 1-3v-2l1-2 1-3a7 7 0 0 1 2-4l1-4 2-2 2-3v-3h1l2-3V8l-3-1h-2l-1 1a3 3 0 0 0-2 3l-1 1v4l-1 1-1 1v-1l-1-1V4ZM17 22l1 1h1v3s0-1 0 0l2 1v5l1 2-1 8v3a6 6 0 0 1 0 2l-1 2-1 2-1 3-3 2-2 2-3 1-1-1-1 1H1l-1-1 2-1 1-4V26l1-1-1-3V11l1-1-1-1H2V8L1 7 0 6V5l1-1h15l1 1c2 0 3 1 3 2l1 3v6l-4 6Zm-6-11v9h1l1-2 2-1v-6h-1l-1-1h-2v1Zm0 19-1 1 1 2-1 3v9a2 2 0 0 0 0 1v6l-1 1 3-1 1-2h1v-4l1-4v-5l-1-1 1-3-1-1v-2s0 1 0 0v-1l-1-1a20 20 0 0 1-2-2v4Z\" clip-rule=\"evenodd\"/></svg>"),
	Rules: []string{
		"||battle.net^",
		"||battlenet.com.cn^",
		"||blizzard.cn^",
		"||blizzard.com^",
		"||blizzardgames.cn^",
		"||blz-contentstack.com^",
		"||blzstatic.cn^",
		"||bnet.163.com^",
		"||bnet.cn^",
	},
	GroupID: "gaming",
}, {
	ID:      "bluesky",
	Name:    "Bluesky",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -33 568 568\"><path d=\"M123.12 33.66C188.24 82.56 258.28 181.68 284 234.87c25.72-53.19 95.76-152.32 160.88-201.2C491.87-1.62 568-28.92 568 57.94c0 17.34-9.95 145.71-15.78 166.55-20.27 72.46-94.15 90.94-159.87 79.75 114.87 19.55 144.1 84.31 80.98 149.07-119.86 123-172.27-30.86-185.7-70.28-2.46-7.23-3.61-10.6-3.63-7.73-.02-2.88-1.17.5-3.63 7.73-13.43 39.42-65.84 193.27-185.7 70.28-63.11-64.76-33.9-129.52 80.98-149.07-65.72 11.18-139.6-7.3-159.87-79.75C9.95 203.66 0 75.3 0 57.95 0-28.91 76.14-1.61 123.12 33.66Z\"/></svg>"),
	Rules: []string{
		"||bsky.app^",
		"||bsky.social^",
	},
	GroupID: "social_network",
}, {
	ID:      "box",
	Name:    "Box",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -9 40 40\"><path d=\"M39.7 19.2c.5.7.4 1.6-.2 2.1-.7.5-1.7.4-2.2-.2l-3.5-4.5-3.4 4.4c-.5.7-1.5.7-2.2.2-.7-.5-.8-1.4-.3-2.1l4-5.2-4-5.2c-.5-.7-.3-1.7.3-2.2.7-.5 1.7-.3 2.2.3l3.4 4.5L37.3 7c.5-.7 1.4-.8 2.2-.3.7.5.7 1.5.2 2.2L35.8 14l3.9 5.2zm-18.2-.6c-2.6 0-4.7-2-4.7-4.6 0-2.5 2.1-4.6 4.7-4.6s4.7 2.1 4.7 4.6c-.1 2.6-2.2 4.6-4.7 4.6zm-13.8 0c-2.6 0-4.7-2-4.7-4.6 0-2.5 2.1-4.6 4.7-4.6s4.7 2.1 4.7 4.6c0 2.6-2.1 4.6-4.7 4.6zM21.5 6.4c-2.9 0-5.5 1.6-6.8 4-1.3-2.4-3.9-4-6.9-4-1.8 0-3.4.6-4.7 1.5V1.5C3.1.7 2.4 0 1.6 0 .7 0 0 .7 0 1.5v12.6c.1 4.2 3.5 7.5 7.7 7.5 3 0 5.6-1.7 6.9-4.1 1.3 2.4 3.9 4.1 6.8 4.1 4.3 0 7.8-3.4 7.8-7.7.1-4.1-3.4-7.5-7.7-7.5z\" /></svg>"),
	Rules: []string{
		"||box.com^",
		"||box.net^",
		"||boxcdn.net^",
		"||boxcloud.com^",
	},
	GroupID: "hosting",
}, {
	ID:      "canais_globo",
	Name:    "Canais Globo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 980 980\"><path d=\"M455.5 1.1a484.3 484.3 0 0 0-258 95.4 501.4 501.4 0 0 0-101.1 101A483.8 483.8 0 0 0 4 426.5 491.7 491.7 0 0 0 54.7 716a481.2 481.2 0 0 0 89.7 121.5C252.7 945.3 400 995.1 554 975.9c92.4-11.4 178-49.3 253.5-112 15-12.4 47.5-45.5 60.6-61.7A483.7 483.7 0 0 0 976 553.5a488.4 488.4 0 0 0-135.7-406.6A494.8 494.8 0 0 0 640.8 23.2 506.9 506.9 0 0 0 455.5 1.1zm-76.4 245.4c6.4 2.3 359.1 210.1 364.3 214.7 2.8 2.4 5.8 6.5 7.8 10.6 3.2 6.4 3.3 7.2 3.3 18.2s-.1 11.8-3.3 18.2c-2 4.1-5 8.2-7.8 10.6-6.7 5.9-358.7 212.7-365.3 214.6a42 42 0 0 1-29.1-2.6 46 46 0 0 1-18.6-19l-2.9-6.3v-431l2.9-6.2c2.7-6 9.5-13.6 15.7-17.6a44.3 44.3 0 0 1 33-4.2z\"/></svg>"),
	Rules: []string{
		"||canaisglobo.globo.com^",
		"||globosat.globo.com^",
		"||gsatmulti.globo.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "chatgpt",
	Name:    "ChatGPT",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M45.403 25.562c-.506-1.89-1.518-3.553-2.906-4.862 1.134-2.665.963-5.724-.487-8.237-1.391-2.408-3.636-4.131-6.322-4.851-1.891-.506-3.839-.462-5.669.088C28.276 5.382 25.562 4 22.647 4c-4.906 0-9.021 3.416-10.116 7.991-.01.001-.019-.003-.029-.002-2.902.36-5.404 2.019-6.865 4.549-1.391 2.408-1.76 5.214-1.04 7.9.507 1.891 1.519 3.556 2.909 4.865-1.134 2.666-.97 5.714.484 8.234 1.391 2.408 3.636 4.131 6.322 4.851.896.24 1.807.359 2.711.359 1.003 0 1.995-.161 2.957-.45C21.722 44.619 24.425 46 27.353 46c4.911 0 9.028-3.422 10.12-8.003 2.88-.35 5.431-2.006 6.891-4.535 1.39-2.408 1.759-5.214 1.039-7.9zM35.17 9.543c2.171.581 3.984 1.974 5.107 3.919 1.049 1.817 1.243 4 .569 5.967-.099-.062-.193-.131-.294-.19l-9.169-5.294a1.0072 1.0072 0 0 0-1.01.006l-10.198 6.041-.052-4.607 8.663-5.001C30.733 9.26 33 8.963 35.17 9.543zm-5.433 12.652.062 5.504-4.736 2.805-4.799-2.699-.062-5.504 4.736-2.805 4.799 2.699zm-15.502-7.783C14.235 9.773 18.009 6 22.647 6c2.109 0 4.092.916 5.458 2.488-.105.056-.214.103-.318.163l-9.17 5.294c-.312.181-.504.517-.5.877l.133 11.851-4.015-2.258V14.412zm-7.707 9.509c-.581-2.17-.282-4.438.841-6.383 1.06-1.836 2.823-3.074 4.884-3.474-.004.116-.018.23-.018.348V25c0 .361.195.694.51.872l10.329 5.81-3.964 2.348-8.662-5.002c-1.946-1.123-3.338-2.936-3.92-5.107zm8.302 16.536c-2.171-.581-3.984-1.974-5.107-3.919-1.053-1.824-1.249-4.001-.573-5.97.101.063.196.133.299.193l9.169 5.294a.9998.9998 0 0 0 1.01-.006l10.198-6.041.052 4.607-8.663 5.001c-1.946 1.125-4.214 1.424-6.385.841zm20.935-4.869c0 4.639-3.773 8.412-8.412 8.412-2.119 0-4.094-.919-5.459-2.494.105-.056.216-.098.32-.158l9.17-5.294c.312-.181.504-.517.5-.877l-.134-11.85 4.015 2.258v10.003zm6.866-3.126c-1.056 1.83-2.84 3.086-4.884 3.483.004-.12.018-.237.018-.357V25c0-.361-.195-.694-.51-.872l-10.329-5.81 3.964-2.348 8.662 5.002c1.946 1.123 3.338 2.937 3.92 5.107.581 2.17.282 4.438-.841 6.383z\"/></svg>"),
	Rules: []string{
		"||chatgpt.com^",
		"||oaistatic.com^",
		"||oaiusercontent.com^",
		"||openai.com^",
	},
	GroupID: "ai",
}, {
	ID:      "claro",
	Name:    "Claro",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -21 67 67\"><path d=\"M49.004 0c.933.01 1.866.002 2.8.003.003 2.842.001 5.684 0 8.525-.934.001-1.867.002-2.8.001 0-2.842-.002-5.686 0-8.529ZM55.2 9.622c2.564-2.63 5.1-5.292 7.662-7.926.657.69 1.334 1.36 1.978 2.064-2.535 2.654-5.096 5.282-7.632 7.933-.68-.679-1.339-1.38-2.008-2.07ZM6.091 8.06a7.942 7.942 0 0 1 2.155-.233c2.405-.058 4.742 1.202 6.232 3.131a8.516 8.516 0 0 1 1.514 3.12c-1.102.004-2.204 0-3.306 0-.486-1.001-1.23-1.893-2.2-2.413a4.756 4.756 0 0 0-1.728-.58c-.565-.012-1.142-.062-1.695.086a4.798 4.798 0 0 0-2.452 1.427c-.859.836-1.434 2.013-1.485 3.243-.11 1.171.105 2.399.749 3.384.619.944 1.494 1.73 2.53 2.135 1.739.666 3.843.265 5.174-1.095a6.18 6.18 0 0 0 1.118-1.604c1.098-.006 2.195-.006 3.292 0-.271 1.202-.863 2.316-1.611 3.27-.513.556-1.016 1.138-1.648 1.552-2.835 2.024-6.953 1.91-9.618-.379-.829-.73-1.586-1.572-2.107-2.57-.96-1.765-1.199-3.886-.859-5.863.286-1.676 1.135-3.22 2.305-4.4.987-1.065 2.25-1.868 3.64-2.21Zm11.58-.234h3.142c0 5.723.003 11.446-.002 17.169-1.047.002-2.093-.002-3.14-.001V7.826Zm9.493 3.417c.596-.125 1.205-.054 1.807-.07.698.062 1.398.166 2.062.41.665.24 1.35.54 1.817 1.111.548.676.742 1.574.785 2.435-.002 3.288.002 6.577-.002 9.866-1.062-.006-2.126.023-3.187-.015-.01-.447.009-.895-.007-1.341-.924.826-2.147 1.207-3.346 1.303-.756.135-1.54.013-2.261-.238a3.151 3.151 0 0 1-1.968-2.1c-.297-1.042-.235-2.183.112-3.204.377-1.04 1.285-1.78 2.284-2.117 1.28-.469 2.647-.541 3.97-.812.458 0 .91-.294 1.08-.74.123-.486.017-1.096-.397-1.405-.455-.311-1.011-.376-1.543-.392-.473.015-.973.02-1.392.28-.544.32-.788.956-.895 1.564-1.052-.023-2.105.001-3.157-.018.13-1.072.347-2.217 1.09-3.031.777-.943 1.982-1.392 3.148-1.486Zm2.316 7.423c-.622.149-1.234.34-1.866.44-.502.103-1.031.271-1.389.674-.497.608-.533 1.547-.148 2.224.168.31.5.463.809.574.997.2 2.091-.122 2.819-.864.746-.967.614-2.278.612-3.437-.294.097-.53.33-.837.389Zm11.644-7.032c.648-.164 1.284-.44 1.965-.375.007 1.111.065 2.224.043 3.337-.58-.083-1.184-.15-1.752.03-1.225.351-2.25 1.471-2.394 2.801-.008.293-.084.58-.087.873-.002 2.233.003 4.464 0 6.696-1.044-.002-2.09.008-3.134-.006-.012-4.395-.003-8.791.006-13.187 1.012-.01 2.023.03 3.035.068.001.543-.013 1.086.006 1.63.592-.819 1.369-1.527 2.312-1.867Zm7.824-.34c.466-.049.94-.095 1.409-.055 2.817.037 5.389 2.29 6.06 5.1.58 2.296.017 4.946-1.66 6.612-.97 1.086-2.302 1.823-3.714 2.044-.681.006-1.362.002-2.042.001-2.033-.296-3.8-1.735-4.802-3.557-1.042-2-1.046-4.535-.024-6.545.97-1.849 2.736-3.299 4.773-3.6Zm.253 3.255c-.938.22-1.737.902-2.215 1.757-.714 1.244-.6 2.94.29 4.06.907 1.354 2.77 1.811 4.194 1.117.828-.386 1.46-1.144 1.811-2.002.39-.985.32-2.141-.148-3.084-.492-.954-1.395-1.703-2.436-1.875-.497-.042-1.003-.057-1.496.027Zm9.407.496c2.796 0 5.594-.002 8.392.002-.002.963.002 1.927-.001 2.892-2.797-.004-5.593.006-8.39.001-.004-.965.003-1.93-.002-2.895Z\"/></svg>"),
	Rules: []string{
		"||claro.com.ar^",
		"||claro.com.br^",
		"||claro.com.co^",
		"||claro.com.do^",
		"||claro.com.ec^",
		"||claro.com.gt^",
		"||claro.com.hn^",
		"||claro.com.ni^",
		"||claro.com.pa^",
		"||claro.com.pe^",
		"||claro.com.py^",
		"||claro.com.sv^",
		"||claro.com.uy^",
		"||claro.com^",
		"||claro.cr^",
		"||claro.net.br^",
		"||claro.net.co^",
		"||clarochile.cl^",
		"||claromusica.com^",
		"||claropr.com^",
		"||clarovideo.com^",
		"||usclaro.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "claude",
	Name:    "Claude",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 40 40\"><path d=\"m7.8 26.3 7.7-4.4.1-.4v-.2h-1.8L9.4 21H5.5l-3.7-.2-1-.2-.8-1.2v-.6l.9-.5H2l2.5.3 3.8.2 2.7.2 4 .4h.7v-.3l-.2-.1-.1-.2-4-2.6-4.1-2.8L5 11.8 3.9 11l-.6-.8L3 8.6l1.1-1.2h1.4l.4.2 1.5 1.1 3.1 2.4 4.1 3 .6.6.3-.2v-.1l-.3-.5-2.2-4-2.4-4.1-1-1.7-.3-1A4.9 4.9 0 0 1 9 1.9L10.3.2 11 0l1.7.2.7.6 1 2.3L16 6.8l2.6 5 .7 1.5.4 1.4.2.4h.2v-.3l.2-2.8.4-3.4.4-4.5.1-1.2.7-1.5L23 .6l1 .4.8 1.2-.2.7-.4 3-1 4.8-.5 3.2h.3l.4-.4 1.6-2.1L27.8 8 29 6.6l1.4-1.5 1-.7H33l1.3 1.9-.6 1.9-1.7 2.2-1.5 1.9-2 2.8-1.4 2.2.2.2h.3l4.7-1 2.5-.5 3-.5 1.4.6.2.7-.6 1.3-3.2.8-3.8.8L26 21v.2l2.6.2h3.7l5 .4 1.3 1 .8 1-.1.8-2 1-2.7-.7-6.3-1.5-2.2-.5H26v.2l1.8 1.7 3.3 3 4.1 3.9.2 1-.5.7-.5-.1-3.7-2.7-1.4-1.3-3.1-2.7h-.3v.3l.8 1.1 3.8 5.8.2 1.8-.2.6-1 .3-1.1-.2-2.3-3.2-2.3-3.5-2-3.2-.1.1-1.1 12-.6.6-1.2.4-1-.7-.5-1.3.5-2.4.7-3.2.5-2.5.5-3.1.2-1v-.1h-.2L17 28.4l-3.6 4.9-2.8 3-.7.3-1.2-.6.2-1.1.6-1 4-5 2.3-3 1.5-1.9v-.2L6.7 30.6l-1.9.2L4 30l.1-1.2.4-.4 3.2-2.1Z\"/></svg>"),
	Rules: []string{
		"||anthropic.com^",
		"||claude.ai^",
	},
	GroupID: "ai",
}, {
	ID:      "cloudflare",
	Name:    "Cloudflare",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M38 10.813l-.906 3.78-1.907-3.405v1.718c2.899 2.301 4.926 5.79 5.126 9.688.699-.2 1.3-.188 2-.188 1.374 0 2.667.297 3.812.875l-1.031-.593 3.812-.875-3.812-.907L48.5 19h-3.813l2.813-2.688-3.688 1.094 2-3.312-3.312 2 1.094-3.688-2.688 2.781.094-3.874-2 3.28zM27 11c-5 0-9.414 2.992-11.313 7.594-.699-.399-1.687-.688-2.687-.688-3.2 0-5.906 2.606-5.906 5.907v.5c-3.899.3-7.094 3.68-7.094 7.78 0 .802.113 1.52.313 2.22.101.398.5.687 1 .687h47c.398 0 .675-.195.874-.594.5-1.101.813-2.207.813-3.406 0-4.2-3.488-7.594-7.688-7.594-.8 0-1.511.082-2.312.282l4.906 6.625-5.5-4.5L22 29.593l15.094-4.905L28.5 21.5l10.688 1.813v-.125C39.188 16.488 33.699 11 27 11zm19.781 12.656c.434.274.844.586 1.219.938h.5z\" /></svg>"),
	Rules: []string{
		"||argotunnel.com^",
		"||cf-ipfs.com^",
		"||cloudflare-dns.com^",
		"||cloudflare-ipfs.com^",
		"||cloudflare-quic.com^",
		"||cloudflare.com^",
		"||cloudflare.net^",
		"||cloudflare.tv^",
		"||cloudflareaccess.com^",
		"||cloudflareapps.com^",
		"||cloudflarebolt.com^",
		"||cloudflareclient.com^",
		"||cloudflareinsights.com^",
		"||cloudflareok.com^",
		"||cloudflarepreview.com^",
		"||cloudflareresolve.com^",
		"||cloudflaressl.com^",
		"||cloudflarestatus.com^",
		"||cloudflarestorage.com^",
		"||cloudflarestream.com^",
		"||cloudflaretest.com^",
		"||cloudflarewarp.com^",
		"||every1dns.net^",
		"||one.one.one^",
		"||pacloudflare.com^",
		"||pages.dev^",
		"||trycloudflare.com^",
		"||videodelivery.net^",
		"||warp.plus^",
		"||workers.dev^",
	},
	GroupID: "cdn",
}, {
	ID:      "clubhouse",
	Name:    "Clubhouse",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M29.8 4a1 1 0 0 0-.92.7 1 1 0 0 0 .36 1.1 31.2 31.2 0 0 1 6 6.02 1 1 0 1 0 1.6-1.2 33.2 33.2 0 0 0-6.4-6.4A1 1 0 0 0 29.8 4Zm-7.16 1.06c-.46 0-.87.3-.99.74a1 1 0 0 0 .5 1.15 31.13 31.13 0 0 1 11.13 10.6 1 1 0 1 0 1.7-1.07A33.12 33.12 0 0 0 23.11 5.2a.96.96 0 0 0-.48-.14ZM14.5 7.01a3.42 3.42 0 0 0-3.27 2.28l-.26-.27A3.49 3.49 0 0 0 8.5 8.01c-.9 0-1.8.34-2.48 1.01a3.51 3.51 0 0 0-.57 4.17c-.52.15-1.01.42-1.43.84a3.52 3.52 0 0 0 0 4.94l.27.27c-.46.16-.9.41-1.27.79a3.52 3.52 0 0 0 0 4.94l.88.88 16.47 16.47a9.01 9.01 0 0 0 12.72 0l4.23-4.22a9.94 9.94 0 0 0 2.3-3.59l2.63-7.08a8.03 8.03 0 0 1 1.84-2.87l1.74-1.73 1-1a4.02 4.02 0 0 0 0-5.66 4.02 4.02 0 0 0-5.66 0l-1 1-.7.71-4.2 4.2a2.98 2.98 0 0 1-4.24 0L17.9 8.96l-.94-.94a3.49 3.49 0 0 0-2.47-1.01Zm0 1.98c.38 0 .76.15 1.06.45l.94.94 13.1 13.1a5.02 5.02 0 0 0 7.08 0l4.2-4.18.7-.71 1-1c.8-.8 2.05-.8 2.83 0 .8.79.8 2.04 0 2.83l-2.73 2.73a10.03 10.03 0 0 0-2.3 3.58l-2.63 7.08a8.02 8.02 0 0 1-1.84 2.87l-4.23 4.23a6.99 6.99 0 0 1-9.9 0L4.44 23.56a1.5 1.5 0 0 1 0-2.12c.59-.59 1.45-.55 2.08.08l.1.09 8.2 8.37a1 1 0 0 0 .97.29 1 1 0 0 0 .46-1.68l-9.52-9.73-.01-.01-1.28-1.29a1.5 1.5 0 0 1 0-2.12c.6-.6 1.47-.58 2.08.03l9.18 9.17a1 1 0 0 0 1.69-.43 1 1 0 0 0-.28-.98L9 14.13l-.06-.07-1.5-1.5c-.6-.6-.6-1.53 0-2.12a1.5 1.5 0 0 1 2.12 0L20.8 21.67a1 1 0 0 0 1.68-.44 1 1 0 0 0-.27-.97l-8.7-8.7-.06-.06a1.4 1.4 0 0 1-.01-2.06c.3-.3.68-.45 1.06-.45ZM4.23 32a1 1 0 0 0-.82 1.51c3 5.18 7.36 9.46 12.59 12.37a1 1 0 0 0 1.51-.89 1 1 0 0 0-.54-.86A31.16 31.16 0 0 1 5.15 32.5a1.01 1.01 0 0 0-.92-.51Z\"/></svg>"),
	Rules: []string{
		"||clubhouse.com^",
		"||clubhouseapi.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "coolapk",
	Name:    "CoolApk",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 384 384\"><path fill-rule=\"evenodd\" d=\"M105.62 104.96c30-1.4 57 6.8 81 24.5a717.7 717.7 0 0 0 34.5 27.5l29-48c12-7.4 21-4.8 27 8l79 142c3 15-3.3 22-18.5 20.5a3007.8 3007.8 0 0 1-103-76 166.46 166.46 0 0 1 25.5-17.5 574.67 574.67 0 0 1 33 24l.5-1a1227.62 1227.62 0 0 0-33-58 2174.49 2174.49 0 0 0-33.5 54c-15 25-35 45.6-59.5 61.5a104.39 104.39 0 0 1-90 6c-41.3-23.1-57.1-58-47.5-104.5a89.1 89.1 0 0 1 75.5-63zm1 31c23-1.6 43.7 4.6 62 18.5a777.4 777.4 0 0 1 26 20.5 668.04 668.04 0 0 0 25.5-17 318.5 318.5 0 0 1-38 57 95.75 95.75 0 0 1-49.5 32.5c-32.5 7-56.4-4.2-71.5-33.5-9.8-30.7-1-54.5 26.5-71.5 6.2-2.9 12.5-5 19-6.5z\"/></svg>"),
	Rules: []string{
		"||coolapk.com^",
		"||coolapkmarket.com^",
		"||coolapkmarket.net^",
	},
	GroupID: "shopping",
}, {
	ID:      "crunchyroll",
	Name:    "Crunchyroll",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 25 3 C 12.85 3 3 12.85 3 25 C 3 40.188 13.387672 44.538609 20.388672 45.974609 C 20.427672 45.982609 20.465953 45.986328 20.501953 45.986328 C 21.006953 45.986328 21.206312 45.25525 20.695312 45.03125 C 13.285312 41.79025 8.0301562 34.327141 9.1601562 25.494141 C 10.256156 16.920141 17.244938 10.069141 25.835938 9.1191406 C 26.564937 9.0381406 27.287 9 28 9 C 35.541 9 42.044422 13.395672 45.107422 19.763672 C 45.206422 19.968672 45.382594 20.058594 45.558594 20.058594 C 45.853594 20.058594 46.144828 19.8075 46.048828 19.4375 C 44.302828 12.7105 39 3 25 3 z M 29 14 C 20.481 14 13.619625 21.101031 14.015625 29.707031 C 14.366625 37.346031 20.653016 43.631422 28.291016 43.982422 C 28.528016 43.994422 28.766 44 29 44 C 37.285 44 44 37.285 44 29 C 44 27.819 43.860563 26.670359 43.601562 25.568359 C 43.542563 25.319359 43.332234 25.183594 43.115234 25.183594 C 42.961234 25.183594 42.806266 25.251484 42.697266 25.396484 C 41.512266 26.976484 39.627 28 37.5 28 C 37.397 28 37.293453 27.997188 37.189453 27.992188 C 34.031453 27.845188 31.348203 25.317875 31.033203 22.171875 C 30.763203 19.477875 32.142297 17.082328 34.279297 15.861328 C 34.656297 15.646328 34.62475 15.100266 34.21875 14.947266 C 32.59375 14.340266 30.838 14 29 14 z M 44.296875 26.595703 L 44.300781 26.595703 L 44.296875 26.595703 z\"/></svg>"),
	Rules: []string{
		"||crunchyroll.com^",
		"||gccrunchyroll.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "dailymotion",
	Name:    "Dailymotion",
	IconSVG: []byte("<svg viewBox=\"0 0 24 24\" fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M13.551 11.485a2.327 2.327 0 0 0-2.328 2.332c0 1.314 1.013 2.313 2.441 2.313l-.012.002c1.192 0 2.193-.983 2.193-2.28.001-1.349-1.001-2.367-2.294-2.367z\"/><path d=\"M3 3v18h18V3H3zm15.52 15.605h-2.682v-1.058c-.825.81-1.667 1.103-2.786 1.103-1.142 0-2.124-.371-2.947-1.114-1.086-.956-1.648-2.227-1.648-3.701 0-1.351.524-2.561 1.507-3.506.878-.859 1.946-1.298 3.139-1.298 1.14 0 2.018.385 2.647 1.192V6.118l2.77-.574v-.002l.002.003h-.002v13.06z\"/></svg>"),
	Rules: []string{
		"||dailymotion.com^",
		"||dm-event.net^",
		"||dmcdn.net^",
	},
	GroupID: "streaming",
}, {
	ID:      "deepseek",
	Name:    "DeepSeek",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 30 30\"><path d=\"M29.7 5.8c-.3-.1-.5.2-.7.3l-.1.2c-.5.5-1 .8-1.7.8a3 3 0 0 0-2.7 1c-.2-1-.8-1.5-1.6-2-.4-.1-.9-.3-1.2-.7l-.4-1c0-.2-.1-.4-.3-.4-.3 0-.4.1-.5.3-.4.7-.5 1.5-.5 2.3a5 5 0 0 0 2.3 4.3c.1 0 .2.2.1.4l-.3 1c0 .2-.2.3-.4.2-.8-.4-1.5-.9-2.2-1.5-1-1-2-2.2-3.2-3a13.8 13.8 0 0 0-.9-.7c-1.2-1.2.2-2.1.5-2.3.3 0 .1-.5-1-.5-1 0-2 .4-3.3.9a3.8 3.8 0 0 1-.6.1 12 12 0 0 0-3.6 0 7.8 7.8 0 0 0-5.6 3.2 9.6 9.6 0 0 0-1.6 7.6c.5 2.8 2 5.2 4.2 7 2.3 2 5 2.9 8 2.7 1.9 0 4-.3 6.3-2.3a7.3 7.3 0 0 0 4.4.3c.9-.2.8-1 .5-1.2-2.4-.8-2.7-1.1-2.7-1.1 1.4-1.7 3.4-3.3 4.3-8.8v-1c0-.3 0-.3.2-.4a5.2 5.2 0 0 0 2-.6c1.7-1 2.4-2.5 2.6-4.3 0-.3 0-.6-.3-.8zm-15.2 17C11.9 20.6 10.6 20 10 20c-.5 0-.4.6-.3 1l.4.9c.2.2.3.5 0 .7-1 .6-2.4-.1-2.5-.2a12.2 12.2 0 0 1-5.7-9.7c0-.5.1-.7.6-.7a5.9 5.9 0 0 1 1.9 0c2.7.3 5 1.5 6.8 3.4 1.1 1 2 2.3 2.8 3.6a17.3 17.3 0 0 0 4.2 4.5c-1 0-2.7.1-3.8-.8zm1.2-8.1a.4.4 0 0 1 .5-.4.4.4 0 0 1 .3.4.4.4 0 0 1-.4.3.4.4 0 0 1-.4-.3zm4 2-.8.2c-.4 0-.8-.2-1-.4-.4-.2-.6-.4-.7-1V15c.1-.5 0-.7-.3-1l-.8-.2a.7.7 0 0 1-.4-.1c-.1 0-.2-.2-.1-.4l.2-.3c.5-.3 1-.2 1.5 0 .4.2.7.5 1.2 1l.9 1.1.5 1c.1.3 0 .5-.3.7z\"/></svg>"),
	Rules: []string{
		"||deepseek.com^",
	},
	GroupID: "ai",
}, {
	ID:      "deezer",
	Name:    "Deezer",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M18.81 4.16v3.03H24V4.16h-5.19zM6.27 8.38v3.027h5.189V8.38h-5.19zm12.54 0v3.027H24V8.38h-5.19zM6.27 12.594v3.027h5.189v-3.027h-5.19zm6.271 0v3.027h5.19v-3.027h-5.19zm6.27 0v3.027H24v-3.027h-5.19zM0 16.81v3.029h5.19v-3.03H0zm6.27 0v3.029h5.189v-3.03h-5.19zm6.271 0v3.029h5.19v-3.03h-5.19zm6.27 0v3.029H24v-3.03h-5.19Z\" /></svg>"),
	Rules: []string{
		"||deezer.com^",
		"||dzcdn.net^",
	},
	GroupID: "streaming",
}, {
	ID:      "directvgo",
	Name:    "DirecTV Go",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-2 0 20 20\"><path d=\"M17 9.97A10.12 10.12 0 0 1 6.82 20H.46a.44.44 0 0 1-.34-.16.42.42 0 0 1-.11-.36A5.03 5.03 0 0 1 5 15.32h1.82a5.16 5.16 0 0 0 5.17-5.35v-.36a5.2 5.2 0 0 0-5.25-4.93H5a5.1 5.1 0 0 1-3.57-1.46A4.98 4.98 0 0 1 0 .54.45.45 0 0 1 .1.16.45.45 0 0 1 .47 0h6.26C12.36 0 16.95 4.44 17 9.97z\"/><path d=\"M12 9.97a9.95 9.95 0 0 1-2.9 7.09A9.85 9.85 0 0 1 2.04 20H.45a.43.43 0 0 1-.34-.16.43.43 0 0 1-.1-.36 4.94 4.94 0 0 1 4.86-4.16h1.77a5.36 5.36 0 0 0 5.27-4.89 4.32 4.32 0 0 0 0-.49v-.3a5.36 5.36 0 0 0-5.34-4.96h-1.7A4.92 4.92 0 0 1 1.4 3.22 5.02 5.02 0 0 1 .01.54.46.46 0 0 1 .45 0h1.5c5.51-.02 10 4.44 10.05 9.97z\"/><path d=\"M4 10a3 3 0 1 0 6 0 3 3 0 0 0-6 0z\"/></svg>"),
	Rules: []string{
		"||directvgo.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "discord",
	Name:    "Discord",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M20.098 5.559C18.156 4 15.09 3.734 14.96 3.723a.493.493 0 0 0-.484.285c-.004.008-.172.504-.34.984 2.254.395 3.785 1.27 3.867 1.317a.8.8 0 1 1-.805 1.382C17.176 7.68 14.93 6.398 12 6.398c-2.93 0-5.176 1.282-5.2 1.293a.8.8 0 0 1-.805-1.383c.083-.046 1.622-.925 3.88-1.32-.172-.484-.348-.972-.352-.98a.487.487 0 0 0-.484-.285c-.129.011-3.195.273-5.16 1.855C2.852 6.528.8 12.074.8 16.871c0 .082.02.164.062.238 1.418 2.489 5.282 3.141 6.16 3.168h.016c.156 0 .3-.074.395-.199l.949-1.289c-2.086-.504-3.192-1.293-3.258-1.344a.799.799 0 0 1-.168-1.117.794.794 0 0 1 1.113-.172c.032.016 2.067 1.446 5.93 1.446 3.879 0 5.91-1.434 5.93-1.45a.8.8 0 0 1 .945 1.293c-.066.047-1.164.836-3.246 1.34l.937 1.293c.094.125.239.2.395.2h.016c.882-.028 4.742-.68 6.16-3.169a.477.477 0 0 0 .062-.242c0-4.793-2.05-10.34-3.101-11.308zM8.8 15.199c-.887 0-1.602-.894-1.602-2 0-1.105.715-2 1.602-2 .883 0 1.597.895 1.597 2 0 1.106-.714 2-1.597 2zm6.398 0c-.883 0-1.597-.894-1.597-2 0-1.105.714-2 1.597-2 .887 0 1.602.895 1.602 2 0 1.106-.715 2-1.602 2zm0 0\" /></svg>"),
	Rules: []string{
		"|hammerandchisel.ssl.zendesk.com^",
		"||airhorn.solutions^",
		"||airhornbot.com^",
		"||bigbeans.solutions^",
		"||dis.gd^",
		"||discord-activities.com^",
		"||discord.co^",
		"||discord.com^",
		"||discord.design^",
		"||discord.dev^",
		"||discord.gg^",
		"||discord.gift^",
		"||discord.gifts^",
		"||discord.media^",
		"||discord.new^",
		"||discord.store^",
		"||discord.tools^",
		"||discordactivities.com^",
		"||discordapp.com^",
		"||discordapp.io^",
		"||discordapp.net^",
		"||discordcdn.com^",
		"||discordmerch.com^",
		"||discordpartygames.com^",
		"||discordsays.com^",
		"||discordstatus.com^",
		"||watchanimeattheoffice.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "discoveryplus",
	Name:    "Discovery+",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"166 -24 320 320\"><path d=\"M346.4.1h-98.2v71.5a101 101 0 0 0-81.7 98.9c0 58.6 48.2 101 101.2 101h78.7c78.5 0 138.5-59.9 138.5-135.7C485 62.2 424.9.1 346.4.1Zm0 263.5h-78.7a93.3 93.3 0 0 1-11.5-185.7V8.1h90.2c68.5 0 130.5 52.9 130.5 127.7.1 77.2-61.9 127.8-130.5 127.8Z\"/><path d=\"M345.8 22h-77.3v56c45.5 0 92 37.7 92 93.2S315.3 251 315.3 251h30.5c61.5 0 117.7-45.1 117.7-114.4C463.5 66.1 403.1 22 345.8 22Z\"/><path d=\"M347.5 170a80 80 0 0 1-80 80 80 80 0 0 1-80-80 80 80 0 0 1 80-80 80 80 0 0 1 80 80z\"/></svg>"),
	Rules: []string{
		"||disco-api.com^",
		"||discoveryplus.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "disneyplus",
	Name:    "Disney+",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M19.986,25.212c0,0,0.562-0.878,1.545-1.264s0.667,0.562,0.141,0.948C21.144,25.282,20.617,25.388,19.986,25.212z M20.512,23.631c-0.913,0.176-1.194,0.667-1.089,1.194C19.564,24.404,20.512,23.632,20.512,23.631z M34.771,27.882 c-0.387,0.351-1.159,1.616-1.159,1.616s1.194-0.141,1.546-1.089C35.508,27.46,35.157,27.531,34.771,27.882z M10.398,28.83 c0.667,0.597,1.861,1.089,1.861,1.089l0.07-2.247c-0.526,0-1.755,0.316-2.072,0.386C9.941,28.127,9.73,28.233,10.398,28.83z M46,13 v24c0,4.963-4.038,9-9,9H13c-4.962,0-9-4.037-9-9V13c0-4.963,4.038-9,9-9h24C41.962,4,46,8.037,46,13z M13.541,21.934l0.572,0.223 c0.073,0.006,0.143-0.029,0.182-0.091c2.349-3.742,6.583-6.256,11.456-6.256c5.798,0,10.708,3.552,12.578,8.508 c0.029,0.076,0.1,0.127,0.182,0.127h0.596c0.07,0,0.12-0.071,0.097-0.137c-1.904-5.398-7.217-9.294-13.46-9.294 c-5.214,0-9.786,2.724-12.282,6.764C13.421,21.842,13.466,21.927,13.541,21.934z M15.911,23.843c-2.81-1.37-3.793-1.546-5.971-1.405 c-2.177,0.141-2.177,1.229-1.651,1.265c0.311,0.021,0.487,0.044,0.58,0.055c0.078,0.009,0.089-0.011,0.115-0.046 c0.022-0.03,0.032-0.075,0.043-0.102c0.019-0.049-0.003-0.099-0.047-0.118c-0.045-0.02-0.55-0.245-0.55-0.245 s2.74-0.702,6.146,0.948c3.406,1.65,4.285,3.793,3.337,4.847c-0.948,1.054-2.599,1.581-4.636,1.124 c-0.035-1.44,0.035-2.494,0.035-2.494s1.897-0.07,2.389,0.281c0.42,0.3,0.174,0.497-0.103,0.614 c-0.047,0.02-0.052,0.107-0.009,0.132c0.393,0.218,0.706,0.269,0.99-0.078c0.316-0.386,0.667-2.037-3.196-1.932 c-0.07-0.667,0.141-1.124-0.421-1.791C12.4,24.228,12.4,26.722,12.4,26.722s-1.44,0.21-2.634,1.054 c-1.194,0.843,2.458,2.88,2.458,2.88s0.07,0.913,0.597,1.019c0.527,0.105,0.492-0.667,0.492-0.667s3.16,0.913,5.269-0.948 C20.688,28.197,18.721,25.212,15.911,23.843z M19.74,25.844c0.562,0.247,1.65,0.071,2.353-0.632c0.702-0.702,1.019-2.002-0.21-1.932 c0,0-0.457-0.597-1.44-0.316c-0.983,0.281-2.212,1.581-1.334,2.423C19.108,25.773,19.214,26.511,19.74,25.844z M20.723,30.305 c0-0.527-0.035-2.634-0.106-3.056c-0.07-0.421-0.456-0.773-0.667-0.351c0,0-0.176,2.037-0.106,3.301 C19.88,30.727,20.723,30.831,20.723,30.305z M22.654,27.53c0.737-0.07,1.265-0.106,1.897-0.21c0.632-0.105,0.667-0.562,0.175-0.667 c0,0-1.932-0.421-3.231,0.421c-0.632,0.421-0.457,1.194-0.106,1.229c0.351,0.035,2.142,0.106,2.564,0.386 c0.421,0.281,0.527,0.492,0.07,0.773c-0.457,0.281-1.475,0.421-1.897,0.281c-0.421-0.141-0.562-0.878,0.21-0.492 c0.773,0.386,2.177-0.07,1.229-0.386c-0.948-0.316-1.72-0.245-2.212,0.106c-0.492,0.351,0.176,1.089,0.737,1.334 c0.562,0.245,1.616,0.316,2.248-0.07c0.632-0.386,0.948-1.861-0.07-2.107c-1.019-0.245-1.651-0.21-2.107-0.281 C21.706,27.776,21.917,27.601,22.654,27.53z M27.783,26.338c-1.089-1.265-0.528,0.525-0.457,0.841 c0.07,0.316,0.351,1.51,0.351,2.002c-0.351-0.527-0.913-1.581-1.405-2.072c-0.492-0.492-0.632-0.07-0.632-0.07 s-0.492,1.791-0.351,2.95c0.141,1.159,0.737,0.351,0.773,0c0.035-0.351,0.106-1.51,0.106-1.826c0.316,0.702,0.808,1.51,1.194,1.897 c0.386,0.386,0.773,0.141,0.913-0.21S28.872,27.602,27.783,26.338z M31.54,29.917c0.386-0.316-0.071-0.631-0.457-0.595 c-0.386,0.035-1.51,0.21-1.51,0.21l0.245-0.737c0,0,0.737,0.035,1.334-0.035s0.176-0.737-0.035-0.737c-0.21,0-0.983,0-0.983,0 l0.176-0.492c0,0,1.299-0.035,1.72-0.106c0.421-0.07-0.245-0.773-0.737-0.808c-0.492-0.035-1.546,0.106-2.248,0.245 c-0.702,0.141,0.457,0.667,0.457,0.667s-0.106,0.351-0.245,0.597c-0.421,0.07-0.386,0.316-0.245,0.632 c-0.281,0.737-0.421,1.651,0.386,1.932C30.206,30.97,31.154,30.232,31.54,29.917z M35.826,27.882 c0.105-1.476-1.23-1.159-1.757-0.632c-0.527,0.527-1.44,1.897-1.44,1.897c0.106-0.913,0.351-1.159,0.913-2.072 c0.48-0.78-0.281-0.492-0.281-0.492s-1.791,1.51-1.019,3.231c-0.527,1.299-1.37,3.16-0.141,4.144c0.316,0.21,0.21-0.421,0.316-0.773 c0.106-0.351,0.457-2.142,0.808-2.634C34.07,30.481,35.58,30.165,35.826,27.882z M42.004,27.786c0.003-0.063-0.05-0.115-0.115-0.115 h-2.114c-0.044-0.699-0.128-1.445-0.282-2.146c-0.009-0.039-0.041-0.07-0.081-0.073c-0.287,0-0.331,0.002-0.601,0.002 c-0.078,0.002-0.131,0.075-0.111,0.149c0.088,0.323,0.216,1.147,0.258,2.067H36.95c-0.062,0-0.114,0.051-0.117,0.112l-0.053,0.532 c-0.004,0.085,0.069,0.155,0.154,0.146l2.048,0.007c0.012,0.754,0.018,1.207-0.046,2.004c-0.008,0.053,0.033,0.098,0.087,0.101 c0.322,0.02,0.526,0.045,0.647,0.047c0.049,0.001,0.089-0.036,0.093-0.085c0.019-0.256,0.068-1.06,0.044-2.064l2.08,0.007 c0.065,0,0.117-0.053,0.117-0.118V27.786z\" /></svg>"),
	Rules: []string{
		"||disney-plus.net^",
		"||disney.playback.edge.bamgrid.com^",
		"||disneynow.com^",
		"||disneyplus.com^",
		"||hotstar.com^",
		"||media.dssott.com^",
		"||star.playback.edge.bamgrid.com^",
		"||starplus.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "douban",
	Name:    "Douban",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M36.54 18.51H13.315v8.012H36.54zM8.58 14.32h32.643v16.39H8.581zM5.146 5.754h39.516v4.193H5.145zm11.051 25.652c1.73 2.416 3.28 5.336 4.647 8.748h8.263c1.637-2.632 3.076-5.552 4.31-8.748l4.75 1.631c-1.241 2.694-2.581 5.07-4.003 7.117h11.615v4.147H4.028v-4.147h12.168c-1.117-2.203-2.568-4.574-4.371-7.117z\" /></svg>"),
	Rules: []string{
		"||douban.com^",
		"||douban.fm^",
		"||doubanio.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "dropbox",
	Name:    "Dropbox",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -2.5 30 30\"><path d=\"M7.7.32.48 4.92 7.7 9.5l7.22-4.6 7.23 4.6 7.22-4.6L22.15.32l-7.23 4.6L7.7.31Zm0 18.38L.48 14.1 7.7 9.5l7.22 4.6-7.22 4.6Z\"/><path d=\"m14.92 14.1 7.23-4.6 7.22 4.6-7.22 4.6-7.23-4.6Zm0 10.72-7.22-4.6 7.22-4.59 7.23 4.6-7.23 4.59Z\"/></svg>"),
	Rules: []string{
		"||addtodropbox.com^",
		"||app.hellosign.com^",
		"||dash.ai^",
		"||db.tt^",
		"||docsend.com^",
		"||dropbox-dns.com^",
		"||dropbox.com^",
		"||dropbox.tech^",
		"||dropbox.zendesk.com^",
		"||dropboxapi.com^",
		"||dropboxbusiness.com^",
		"||dropboxcaptcha.com^",
		"||dropboxforum.com^",
		"||dropboxforums.com^",
		"||dropboxinsiders.com^",
		"||dropboxlegal.com^",
		"||dropboxmail.com^",
		"||dropboxpartners.com^",
		"||dropboxstatic.com^",
		"||dropboxteam.com^",
		"||dropboxusercontent.com^",
		"||getdropbox.com^",
	},
	GroupID: "hosting",
}, {
	ID:      "ebay",
	Name:    "eBay",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 12.601563 13.671875 L 12.636719 24.058594 C 12.632813 22.457031 12.128906 18.101563 6.464844 18.097656 C 0.210938 18.097656 -0.03125 22.964844 0.00390625 24.230469 C 0.00390625 24.230469 -0.304688 29.917969 6.3125 29.917969 C 11.996094 29.917969 12.277344 26.347656 12.277344 26.347656 L 9.664063 26.355469 C 9.664063 26.355469 9.152344 28.320313 6.320313 28.265625 C 2.683594 28.199219 2.546875 24.675781 2.546875 24.675781 L 12.621094 24.675781 C 12.621094 24.675781 12.628906 24.566406 12.636719 24.425781 L 12.644531 26.960938 C 12.644531 26.960938 12.628906 28.507813 12.535156 29.53125 L 14.984375 29.53125 L 15.089844 28.039063 C 15.089844 28.039063 16.230469 29.917969 19.566406 29.917969 C 22.902344 29.917969 25.535156 27.863281 25.609375 24.050781 C 25.675781 20.242188 22.761719 18.117188 19.617188 18.097656 C 16.472656 18.082031 15.121094 19.960938 15.121094 19.960938 L 15.121094 13.671875 Z M 31.054688 18.046875 C 29.566406 18.097656 26.539063 18.558594 26.132813 21.460938 L 28.796875 21.460938 C 28.796875 21.460938 29 19.6875 31.703125 19.738281 C 34.257813 19.785156 34.722656 21.039063 34.707031 22.578125 C 34.707031 22.578125 32.519531 22.585938 31.785156 22.59375 C 30.46875 22.597656 25.863281 22.742188 25.433594 25.550781 C 24.917969 28.890625 27.898438 29.933594 30.230469 29.917969 C 32.5625 29.90625 33.890625 29.207031 34.878906 27.953125 L 34.984375 29.511719 L 37.300781 29.496094 C 37.300781 29.496094 37.242188 28.628906 37.25 26.90625 C 37.257813 25.1875 37.308594 23.65625 37.25 22.574219 C 37.183594 21.316406 37.304688 18.285156 31.875 18.0625 C 31.875 18.0625 31.550781 18.03125 31.054688 18.046875 Z M 35.871094 18.519531 L 41.675781 29.496094 L 39.4375 33.71875 L 42.265625 33.71875 L 50 18.519531 L 47.359375 18.519531 L 43.074219 27.046875 L 38.796875 18.519531 Z M 6.402344 19.765625 C 9.984375 19.761719 9.984375 22.949219 9.984375 22.949219 L 2.628906 22.949219 C 2.628906 22.949219 2.804688 19.765625 6.402344 19.765625 Z M 19.035156 19.800781 C 23.078125 19.699219 22.949219 24.097656 22.949219 24.097656 C 22.949219 24.097656 23.011719 28.167969 19.042969 28.21875 C 15.070313 28.269531 15.136719 24.011719 15.136719 24.011719 C 15.136719 24.011719 14.992188 19.90625 19.035156 19.800781 Z M 34.734375 24.265625 C 34.734375 24.269531 35.195313 28.371094 30.664063 28.3125 C 30.664063 28.3125 28.136719 28.3125 27.988281 26.296875 C 27.832031 24.140625 31.875 24.269531 31.875 24.269531 Z\" /></svg>"),
	Rules: []string{
		"|ebay-*.s3-us-west-1.amazonaws.com^",
		"||21centuryaccess.com^",
		"||4ebaytraders.com^",
		"||adcommerce.cn^",
		"||adcommerce.tv^",
		"||appforebay.cn^",
		"||appsonebay.net^",
		"||asebay.com^",
		"||baazee.com^",
		"||bidbay.com^",
		"||bidorbuyindia.com^",
		"||billpoint.com^",
		"||billpoint.info^",
		"||billpoint.tv^",
		"||billpoint.us^",
		"||billpointnewzealand.com^",
		"||blogebay.com^",
		"||bookclubcorner.com^",
		"||builtfromebay.com^",
		"||buyitnow.com^",
		"||buyitnow.net^",
		"||buyitnow.org^",
		"||buyitnow.tv^",
		"||buyitnowshop.net^",
		"||cafr.ca^",
		"||carebay.com^",
		"||cargigileads.com^",
		"||cebay.com^",
		"||collective99.com^",
		"||commerceos.com^",
		"||connectcommerce.cn^",
		"||connectcommerce.com.cn^",
		"||connectcommerce.hk^",
		"||connectcommerce.info^",
		"||connectcommerce.tv^",
		"||connectedcommerce.cn^",
		"||connectedcommerce.com^",
		"||connectedcommerce.tv^",
		"||crececonebay.com^",
		"||creditcardsbay.com^",
		"||cyber-bay.cn^",
		"||cyber-bay.com.cn^",
		"||cyber-bay.info^",
		"||cyber-bay.org^",
		"||dba.dk^",
		"||dealbay.com^",
		"||dealtime.com^",
		"||didce.com^",
		"||douya.org^",
		"||dreamtoplay.com^",
		"||e-bay.com^",
		"||e-bay.it^",
		"||e-bay.net^",
		"||eachpay.com^",
		"||eachpay.net^",
		"||ebahy.com^",
		"||ebay-authenticate.net^",
		"||ebay-confirm.com^",
		"||ebay-course.com^",
		"||ebay-cz.com^",
		"||ebay-delivery.com^",
		"||ebay-discoveries.com^",
		"||ebay-fashion.com^",
		"||ebay-inc.com^",
		"||ebay-inc.net^",
		"||ebay-inc.org^",
		"||ebay-online.com^",
		"||ebay-sales.com^",
		"||ebay-stories.com^",
		"||ebay-us.com^",
		"||ebay-vacation.com^",
		"||ebay.at^",
		"||ebay.be^",
		"||ebay.ca^",
		"||ebay.ch^",
		"||ebay.cn^",
		"||ebay.co.nz^",
		"||ebay.co.uk^",
		"||ebay.co.ve^",
		"||ebay.co.za^",
		"||ebay.com.ar^",
		"||ebay.com.au^",
		"||ebay.com.cn^",
		"||ebay.com.ec^",
		"||ebay.com.hk^",
		"||ebay.com.mt^",
		"||ebay.com.my^",
		"||ebay.com.ph^",
		"||ebay.com.sg^",
		"||ebay.com^",
		"||ebay.de^",
		"||ebay.es^",
		"||ebay.fr^",
		"||ebay.ie^",
		"||ebay.in^",
		"||ebay.it^",
		"||ebay.jp^",
		"||ebay.lt^",
		"||ebay.mn^",
		"||ebay.net.cn^",
		"||ebay.nl^",
		"||ebay.org.cn^",
		"||ebay.org^",
		"||ebay.ph^",
		"||ebay.pk^",
		"||ebay.pl^",
		"||ebay.sg^",
		"||ebay.us^",
		"||ebay.vn^",
		"||ebay.yn.cn^",
		"||ebay.zj.cn^",
		"||ebay25.com^",
		"||ebay68.com^",
		"||ebaya.com^",
		"||ebayads.com^",
		"||ebayads.net^",
		"||ebayadvertising.cn^",
		"||ebayadvertising.com^",
		"||ebayanunsios.net^",
		"||ebayauction.com^",
		"||ebayaustralia.com^",
		"||ebayauthenticate.com.cn^",
		"||ebaybags.com^",
		"||ebaybank.com^",
		"||ebaybenefits.com^",
		"||ebayboutique.com^",
		"||ebayca.com^",
		"||ebayca.org^",
		"||ebaycafe.com^",
		"||ebaycar.com^",
		"||ebaycareers.com^",
		"||ebaycbt.co.kr^",
		"||ebaycdn.net^",
		"||ebaychina.net^",
		"||ebayclassifieds.cn^",
		"||ebayclassifieds.com.cn^",
		"||ebayclassifieds.com^",
		"||ebayclassifieds.info^",
		"||ebayclassifieds.org^",
		"||ebayclassifieds.tv^",
		"||ebayclassifiedsgroup.com^",
		"||ebayclassifiedsgroup.com^",
		"||ebayclassifiedsgroup.info^",
		"||ebayclassifiedsgroup.org^",
		"||ebayclassifies.com^",
		"||ebayclub.com^",
		"||ebaycoins.com^",
		"||ebaycom.com^",
		"||ebaycommercenetwork.com^",
		"||ebaycourse.com^",
		"||ebayd.com^",
		"||ebayde.com^",
		"||ebaydesc.cn^",
		"||ebaydesc.com.cn^",
		"||ebaydlassifieds.com^",
		"||ebaydns.cn^",
		"||ebaydts.com^",
		"||ebayedu.com^",
		"||ebayeletro.com^",
		"||ebayenterprise.cn^",
		"||ebayenterprise.com.cn^",
		"||ebayenterprise.com^",
		"||ebayenterprise.info^",
		"||ebayenterprise.net^",
		"||ebayenterprise.tv^",
		"||ebayetc.com^",
		"||ebayexpress.sg^",
		"||ebayfashion.com^",
		"||ebayfashion.net^",
		"||ebayforcharity.org^",
		"||ebayforeclosure.org^",
		"||ebayfrance.com^",
		"||ebayglobalshipping.com^",
		"||ebaygroup.com^",
		"||ebayhabit.com^",
		"||ebayheels.com^",
		"||ebayhots.com^",
		"||ebayimg.com^",
		"||ebayinc.com^",
		"||ebayinc.net^",
		"||ebayinc.org^",
		"||ebayincconnectedcommerce.net^",
		"||ebayinkblog.com^",
		"||ebayinternetsalestax.com^",
		"||ebayit.com^",
		"||ebayjewelry.com^",
		"||ebayjob.com^",
		"||ebayla.org^",
		"||ebaylisting.com^",
		"||ebaylocal.net^",
		"||ebaylocationsdevacances.com^",
		"||ebaymag.com^",
		"||ebaymainstreet.com^",
		"||ebaymall.com^",
		"||ebaymarketplace.net^",
		"||ebaymotors.ca^",
		"||ebaymotors.cn^",
		"||ebaymotors.com.cn^",
		"||ebaymotors.com^",
		"||ebaymotors.org^",
		"||ebaymotorsblog.com^",
		"||ebaynow.com^",
		"||ebaynyc.com^",
		"||ebayon.com^",
		"||ebayon.net^",
		"||ebayoncampus.com^",
		"||ebayopen.com^",
		"||ebayopensource.com^",
		"||ebayopensource.net^",
		"||ebaypakistan.net^",
		"||ebaypark.com^",
		"||ebayparts.com^",
		"||ebaypedia.cn^",
		"||ebaypedia.com.cn^",
		"||ebayprivacycenter.com^",
		"||ebayqq.com^",
		"||ebayradio.com^",
		"||ebayrtm.com^",
		"||ebayseller.com^",
		"||ebayshoesstore.com^",
		"||ebayshop.com^",
		"||ebayshop111.com^",
		"||ebayshopping.cn^",
		"||ebayshopping.com.cn^",
		"||ebayshopping.org^",
		"||ebaysocial.com^",
		"||ebaysocial.ru^",
		"||ebaysoho.com^",
		"||ebaysohos.com^",
		"||ebaystatic.cn^",
		"||ebaystatic.com^",
		"||ebaystore.com^",
		"||ebaystore77.com^",
		"||ebaystores.cn^",
		"||ebaystyle.com^",
		"||ebaysweden.com^",
		"||ebayt.com^",
		"||ebaytechblog.com^",
		"||ebaytopratedseller.net^",
		"||ebaytrading.com^",
		"||ebaytradingassistant.com^",
		"||ebaytv.org^",
		"||ebayuae.net^",
		"||ebayvakantiehuizen.com^",
		"||ebayvalet.com^",
		"||ebayvietnam.net^",
		"||ebayworlds.com^",
		"||ebayy.com^",
		"||edisebay.com^",
		"||eebay.com^",
		"||epinions.com^",
		"||eu-consumer-empowerment.com^",
		"||expertmaker.com^",
		"||fairmarket.com^",
		"||fragrancebay.com^",
		"||francemail.com^",
		"||half.com.cn^",
		"||half.com^",
		"||half.tv^",
		"||halfcanada.com^",
		"||halfjapan.com^",
		"||handbagsoutletebay.com^",
		"||iebay.com^",
		"||irribay.com^",
		"||itsbetterwhenyouwinit.com^",
		"||liketwice.com^",
		"||liveauction.com^",
		"||milofetch.com^",
		"||musicbay.net^",
		"||myconstructionworld.net^",
		"||myebay.com^",
		"||nebay.net^",
		"||paisapay.cc^",
		"||paisapay.info^",
		"||paisapay.tv^",
		"||premobay.com^",
		"||privatemarketplaces.net^",
		"||privatemarketplaces.us^",
		"||prostores.cn^",
		"||prostores.com.cn^",
		"||prostores.com^",
		"||rethink.net^",
		"||shopibay.net^",
		"||shoping.com^",
		"||sourcingforebay.com.cn^",
		"||sourcingforebay.net^",
		"||sourcingforebay.tv^",
		"||speybay.com^",
		"||storesense.com^",
		"||svpply.com^",
		"||telebay.com^",
		"||telesell.com^",
		"||texttobuy.org^",
		"||theebayshop.com^",
		"||theopportunityproject.org^",
		"||towerauction.com^",
		"||vendu.com^",
		"||watch-ebay.org^",
		"||weareebay.com^",
		"||wwwdecide.com^",
		"||wwwebay.com^",
		"||wwwebay.net^",
		"||wwwwebay.com^",
		"||xindelu.com^",
		"||xn--3et96bj49ahpq.com^",
		"||xn--4vq475g.com^",
		"||xn--4vq477m.com^",
		"||xn--7hv594h.com^",
		"||xn--7hvy28f.cn^",
		"||xn--hb4aw0g.com^",
		"||xn--q41am8x.com^",
		"||xn--qoq462m.com^",
		"||xn--tkry91n.com^",
		"||xn--ubt498knmf.com^",
		"||xn--xsq421m.com^",
		"||xn--xsq605n.com^",
		"||xn--xsq959n.com^",
		"||xn--yf1at58a.com^",
		"||xxbay.com^",
		"||yibei.org^",
	},
	GroupID: "shopping",
}, {
	ID:      "electronic_arts",
	Name:    "Electronic Arts",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 1000 1000\"><path d=\"M500 1000C224.3 1000 0 775.7 0 500S224.3 0 500 0s500 224.3 500 500-224.3 500-500 500zm84.63-693.4H302.05l-42.87 68.9h282.25zm57.75.66L469.63 582.33H278.02l44.2-68.96h114.85l43.87-68.93h-265.5l-43.86 68.93h62.9L147.2 651.05h364.2L645.9 438.9l49.05 74.46h-44.23l-41.88 68.96H739.8l45.48 68.72h83.54z\"/></svg>"),
	Rules: []string{
		"||ea.com^",
		"||eamobile.com^",
		"||easports.com^",
		"||nearpolar.com^",
		"||swtor.com^",
		"||tnt-ea.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "epic_games",
	Name:    "Epic Games",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 10 3 C 6.69 3 4 5.69 4 9 L 4 41.240234 L 25 47.539062 L 46 41.240234 L 46 9 C 46 5.69 43.31 3 40 3 L 10 3 z M 11 8 L 15 8 L 15 11 L 11 11 L 11 18 L 14 18 L 14 21 L 11 21 L 11 28 L 15 28 L 15 31 L 11 31 C 9.34 31 8 29.66 8 28 L 8 11 C 8 9.34 9.34 8 11 8 z M 17 8 L 23 8 C 24.66 8 26 9.34 26 11 L 26 18 C 26 19.66 24.66 21 23 21 L 20 21 L 20 31 L 17 31 L 17 8 z M 28 8 L 31 8 L 31 31 L 28 31 L 28 8 z M 36 8 L 39 8 C 40.66 8 42 9.34 42 11 L 42 15 L 39 15 L 39 11 L 36 11 L 36 28 L 39 28 L 39 24 L 42 24 L 42 28 C 42 29.66 40.66 31 39 31 L 36 31 C 34.34 31 33 29.66 33 28 L 33 11 C 33 9.34 34.34 8 36 8 z M 20 11 L 20 18 L 23 18 L 23 11 L 20 11 z M 9 34 L 13 34 C 13.55 34 14 34.45 14 35 L 14 36 L 13 36 L 13 35.25 C 13 35.11 12.89 35 12.75 35 L 9.25 35 C 9.11 35 9 35.11 9 35.25 L 9 38.75 C 9 38.89 9.11 39 9.25 39 L 12.75 39 C 12.89 39 13 38.89 13 38.75 L 13 38 L 12 38 L 12 37 L 14 37 L 14 39 C 14 39.55 13.55 40 13 40 L 9 40 C 8.45 40 8 39.55 8 39 L 8 35 C 8 34.45 8.45 34 9 34 z M 18 34 L 19 34 L 22 40 L 21 40 L 20.5 39 L 16.5 39 L 16 40 L 15 40 L 18 34 z M 23 34 L 24 34 L 26 38 L 28 34 L 29 34 L 29 40 L 28 40 L 28 36 L 26.5 39 L 25.5 39 L 24 36 L 24 40 L 23 40 L 23 34 z M 30 34 L 35 34 L 35 35 L 31 35 L 31 36.5 L 33 36.5 L 33 37.5 L 31 37.5 L 31 39 L 35 39 L 35 40 L 30 40 L 30 34 z M 37 34 L 41 34 C 41.55 34 42 34.45 42 35 L 42 35.5 L 41 35.5 L 41 35.25 C 41 35.11 40.89 35 40.75 35 L 37.25 35 C 37.11 35 37 35.11 37 35.25 L 37 36.25 C 37 36.39 37.11 36.5 37.25 36.5 L 41 36.5 C 41.55 36.5 42 36.95 42 37.5 L 42 39 C 42 39.55 41.55 40 41 40 L 37 40 C 36.45 40 36 39.55 36 39 L 36 38.5 L 37 38.5 L 37 38.75 C 37 38.89 37.11 39 37.25 39 L 40.75 39 C 40.89 39 41 38.89 41 38.75 L 41 37.75 C 41 37.61 40.89 37.5 40.75 37.5 L 37 37.5 C 36.45 37.5 36 37.05 36 36.5 L 36 35 C 36 34.45 36.45 34 37 34 z M 18.5 35 L 17 38 L 20 38 L 18.5 35 z\"></path></svg>"),
	Rules: []string{
		"|cdn*-epicgames-*.file.myqcloud.com^",
		"|epicgames-download*-*.file.myqcloud.com^",
		"|epicgames-download*.akamaized.net^",
		"||eac-cdn.com^",
		"||easy.ac^",
		"||easyanticheat.net^",
		"||epicgames.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "espn",
	Name:    "ESPN",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M9.9 6a1 1 0 0 0-.98.89L7.9 15.86a1 1 0 0 0 1 1.11h34.66a1 1 0 0 0 .99-.88l1.02-8.98a1 1 0 0 0-1-1.11H9.91zM8.48 21a1 1 0 0 0-1 .89L5.02 43.92a1 1 0 0 0 .99 1.1h34.67a1 1 0 0 0 .99-.87l1.02-8.02a1 1 0 0 0-1-1.13H21.16l.48-4h20.49a1 1 0 0 0 .99-.87l1.02-8a1 1 0 0 0-1-1.13H8.48z\"/></svg>"),
	Rules: []string{
		"||es.pn^",
		"||espn.cl^",
		"||espn.co.uk^",
		"||espn.com.ar^",
		"||espn.com.au^",
		"||espn.com.co^",
		"||espn.com.ec^",
		"||espn.com.mx^",
		"||espn.com.pa^",
		"||espn.com.pe^",
		"||espn.com.uy^",
		"||espn.com.ve^",
		"||espn.com^",
		"||espn.in",
		"||espn.net^",
		"||espncdn.com^",
		"||espncricinfo.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "facebook",
	Name:    "Facebook",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 27 27\"><path d=\"M12 0C5.371 0 0 5.371 0 12c0 6.016 4.434 10.984 10.207 11.852V15.18H7.238v-3.153h2.969V9.926c0-3.473 1.691-5 4.578-5 1.387 0 2.117.105 2.461.148v2.754h-1.969c-1.226 0-1.652 1.164-1.652 2.473v1.726h3.594l-.489 3.153h-3.105v8.699C19.48 23.082 24 18.074 24 12c0-6.629-5.371-12-12-12zm0 0\" /></svg>"),
	Rules: []string{
		"|fbcdn-a.akamaihd.net^",
		"||aboutfacebook.com^",
		"||accessfacebookfromschool.com^",
		"||accountkit.com^",
		"||accountkit.com^",
		"||acebooik.com^",
		"||acebook.com^",
		"||advancediddetection.com^",
		"||askfacebook.net^",
		"||askfacebook.org^",
		"||atdmt2.com^",
		"||atlasdmt.com^",
		"||atlasonepoint.com^",
		"||atscaleconference.com^",
		"||botorch.org^",
		"||buck.build^",
		"||buckbuild.com^",
		"||buyingfacebooklikes.com^",
		"||careersatfb.com^",
		"||celebgramme.com^",
		"||china-facebook.com^",
		"||click-url.com^",
		"||como-hackearfacebook.com^",
		"||componentkit.org^",
		"||crowdtangle.com^",
		"||dacebook.com^",
		"||dlfacebook.com^",
		"||dotfacebook.com^",
		"||dotfacebook.net^",
		"||draftjs.org^",
		"||expresswifi.com^",
		"||f8.com^",
		"||faacebok.com^",
		"||faacebook.com^",
		"||faasbook.com^",
		"||facbebook.com^",
		"||facbeok.com^",
		"||facboo.com^",
		"||facbook.com^",
		"||facbool.com^",
		"||facboox.com^",
		"||faccebook.com^",
		"||faccebookk.com^",
		"||facdbook.com^",
		"||facdebook.com^",
		"||face-book.com^",
		"||faceabook.com^",
		"||facebboc.com^",
		"||facebbook.com^",
		"||facebboook.com^",
		"||facebcook.com^",
		"||facebdok.com^",
		"||facebgook.com^",
		"||facebhook.com^",
		"||facebkkk.com^",
		"||facebo-ok.com^",
		"||faceboak.com^",
		"||facebock.com^",
		"||facebocke.com^",
		"||facebof.com^",
		"||faceboik.com^",
		"||facebok.com^",
		"||facebokbook.com^",
		"||facebokc.com^",
		"||facebokk.com^",
		"||facebokok.com^",
		"||faceboks.com^",
		"||facebol.com^",
		"||facebolk.com^",
		"||facebomok.com^",
		"||faceboo.com^",
		"||facebooa.com^",
		"||faceboob.com^",
		"||faceboobok.com^",
		"||facebooc.com^",
		"||faceboock.com^",
		"||facebood.com^",
		"||facebooe.com^",
		"||faceboof.com^",
		"||facebooi.com^",
		"||facebooik.com^",
		"||facebooik.org^",
		"||facebooj.com^",
		"||facebook-corp.com^",
		"||facebook-covid-19.com^",
		"||facebook-ebook.com^",
		"||facebook-forum.com^",
		"||facebook-hardware.com^",
		"||facebook-inc.com^",
		"||facebook-login.com^",
		"||facebook-newsroom.com^",
		"||facebook-newsroom.org^",
		"||facebook-pmdcenter.com^",
		"||facebook-pmdcenter.net^",
		"||facebook-pmdcenter.org^",
		"||facebook-privacy.com^",
		"||facebook-program.com^",
		"||facebook-studio.com^",
		"||facebook-support.org^",
		"||facebook-texas-holdem.com^",
		"||facebook-texas-holdem.net^",
		"||facebook.br^",
		"||facebook.ca^",
		"||facebook.cc^",
		"||facebook.com^",
		"||facebook.design^",
		"||facebook.hu^",
		"||facebook.in^",
		"||facebook.net^",
		"||facebook.nl^",
		"||facebook.org^",
		"||facebook.se^",
		"||facebook.shop^",
		"||facebook.tv^",
		"||facebook.us^",
		"||facebook.wang^",
		"||facebook123.org^",
		"||facebook30.com^",
		"||facebook30.net^",
		"||facebook30.org^",
		"||facebook4business.com^",
		"||facebookads.com^",
		"||facebookadvertisingsecrets.com^",
		"||facebookappcenter.info^",
		"||facebookappcenter.net^",
		"||facebookappcenter.org^",
		"||facebookatschool.com^",
		"||facebookawards.com^",
		"||facebookblueprint.net^",
		"||facebookbrand.com^",
		"||facebookbrand.net^",
		"||facebookcanadianelectionintegrityinitiative.com^",
		"||facebookcareer.com^",
		"||facebookcheats.com^",
		"||facebookck.com^",
		"||facebookclub.com^",
		"||facebookcom.com^",
		"||facebookconnect.com^",
		"||facebookconsultant.org^",
		"||facebookcoronavirus.com^",
		"||facebookcovers.org^",
		"||facebookcredits.info^",
		"||facebookdating.net^",
		"||facebookdevelopergarage.com^",
		"||facebookdusexe.org^",
		"||facebookemail.com^",
		"||facebookenespanol.com^",
		"||facebookexchange.com^",
		"||facebookexchange.net^",
		"||facebookfacebook.com^",
		"||facebookflow.com^",
		"||facebookgames.com^",
		"||facebookgraphsearch.com^",
		"||facebookgraphsearch.info^",
		"||facebookgroups.com^",
		"||facebookhome.cc^",
		"||facebookhome.com^",
		"||facebookhome.info^",
		"||facebookhub.com^",
		"||facebooki.com^",
		"||facebookinc.com^",
		"||facebookland.com^",
		"||facebooklikeexchange.com^",
		"||facebooklive.com^",
		"||facebooklivestaging.net^",
		"||facebooklivestaging.org^",
		"||facebooklogin.com^",
		"||facebooklogin.info^",
		"||facebookloginhelp.net^",
		"||facebooklogs.com^",
		"||facebookmail.com^",
		"||facebookmail.tv^",
		"||facebookmanager.info^",
		"||facebookmarketing.info^",
		"||facebookmarketingpartner.com^",
		"||facebookmarketingpartners.com^",
		"||facebookmobile.com^",
		"||facebookmsn.com^",
		"||facebooknews.com^",
		"||facebooknfl.com^",
		"||facebooknude.com^",
		"||facebookofsex.com^",
		"||facebookook.com^",
		"||facebookpaper.com^",
		"||facebookpay.com^",
		"||facebookphonenumber.net^",
		"||facebookphoto.com^",
		"||facebookphotos.com^",
		"||facebookpmdcenter.com^",
		"||facebookpoke.net^",
		"||facebookpoke.org^",
		"||facebookpoker.info^",
		"||facebookpokerchips.info^",
		"||facebookporn.net^",
		"||facebookporn.org^",
		"||facebookporno.net^",
		"||facebookportal.com^",
		"||facebooks.com^",
		"||facebooksafety.com^",
		"||facebooksecurity.net^",
		"||facebookshop.com^",
		"||facebooksignup.net^",
		"||facebooksite.net^",
		"||facebookstories.com^",
		"||facebookstudios.net^",
		"||facebookstudios.org^",
		"||facebooksupplier.com^",
		"||facebooksuppliers.com^",
		"||facebookswagemea.com^",
		"||facebookswagstore.com^",
		"||facebooksz.com^",
		"||facebookthreads.net^",
		"||facebooktv.net^",
		"||facebooktv.org^",
		"||facebookvacation.com^",
		"||facebookw.com^",
		"||facebookwork.com^",
		"||facebookworld.com^",
		"||facebool.com^",
		"||facebool.info^",
		"||facebooll.com^",
		"||faceboom.com^",
		"||faceboon.com^",
		"||faceboonk.com^",
		"||faceboooik.com^",
		"||faceboook.com^",
		"||faceboop.com^",
		"||faceboot.com^",
		"||faceboox.com^",
		"||facebopk.com^",
		"||facebpook.com^",
		"||facebuk.com^",
		"||facebuok.com^",
		"||facebvook.com^",
		"||facebyook.com^",
		"||facebzook.com^",
		"||facecbgook.com^",
		"||facecbook.com^",
		"||facecbook.org^",
		"||facecook.com^",
		"||facecook.org^",
		"||facedbook.com^",
		"||faceebok.com^",
		"||faceebook.com^",
		"||faceebot.com^",
		"||facegbok.com^",
		"||facegbook.com^",
		"||faceobk.com^",
		"||faceobok.com^",
		"||faceobook.com^",
		"||faceook.com^",
		"||facerbooik.com^",
		"||facerbook.com^",
		"||facesbooc.com^",
		"||facesounds.com^",
		"||facetook.com^",
		"||facevbook.com^",
		"||facewbook.co^",
		"||facewook.com^",
		"||facfacebook.com^",
		"||facfebook.com^",
		"||faciometrics.com^",
		"||fackebook.com^",
		"||facnbook.com^",
		"||facrbook.com^",
		"||facvebook.com^",
		"||facwebook.com^",
		"||facxebook.com^",
		"||fadebook.com^",
		"||faebok.com^",
		"||faebook.com^",
		"||faebookc.com^",
		"||faeboook.com^",
		"||faecebok.com^",
		"||faesebook.com^",
		"||fafacebook.com^",
		"||faicbooc.com^",
		"||fasebokk.com^",
		"||fasebook.com^",
		"||faseboox.com^",
		"||fasttext.cc^",
		"||favebook.com^",
		"||faycbok.com^",
		"||fb.careers^",
		"||fb.com^",
		"||fb.gg^",
		"||fb.me^",
		"||fb.watch^",
		"||fbacebook.com^",
		"||fbbmarket.com^",
		"||fbboostyourbusiness.com^",
		"||fbcdn.com^",
		"||fbcdn.net^",
		"||fbf8.com^",
		"||fbfeedback.com^",
		"||fbhome.com^",
		"||fbidb.io^",
		"||fbinc.com^",
		"||fbinfer.com^",
		"||fbinnovation.com^",
		"||fblitho.com^",
		"||fbmarketing.com^",
		"||fbmessenger.com^",
		"||fbredex.com^",
		"||fbreg.com^",
		"||fbrell.com^",
		"||fbrpms.com^",
		"||fbsbx.com^",
		"||fbsbx.net^",
		"||fbsupport-covid.net^",
		"||fbthirdpartypixel.com^",
		"||fbthirdpartypixel.net^",
		"||fbthirdpartypixel.org^",
		"||fburl.com^",
		"||fbwat.ch^",
		"||fbworkmail.com^",
		"||fcacebook.com^",
		"||fcaebook.com^",
		"||fcebook.com^",
		"||fcebookk.com^",
		"||fcfacebook.com^",
		"||fdacebook.info^",
		"||feacboo.com^",
		"||feacbook.com^",
		"||feacbooke.com^",
		"||feacebook.com^",
		"||fecbbok.com^",
		"||fecbooc.com^",
		"||fecbook.com^",
		"||feceboock.com^",
		"||fecebook.net^",
		"||feceboox.com^",
		"||fececbook.com^",
		"||feook.com^",
		"||ferabook.com^",
		"||fescebook.com^",
		"||fesebook.com^",
		"||ffacebook.com^",
		"||fgacebook.com^",
		"||ficeboock.com^",
		"||flow.dev^",
		"||flow.org^",
		"||flowtype.org^",
		"||fmcebook.com^",
		"||fnacebook.com^",
		"||fosebook.com^",
		"||fpacebook.com^",
		"||fqcebook.com^",
		"||fracebook.com^",
		"||freeb.com^",
		"||freebasics.com^",
		"||freebasics.net^",
		"||freebs.com^",
		"||freefacebook.com^",
		"||freefacebook.net^",
		"||freefacebookads.net^",
		"||freefblikes.com^",
		"||freindfeed.com^",
		"||frescolib.org^",
		"||friendbook.info^",
		"||friendfed.com^",
		"||friendfeed-api.com^",
		"||friendfeed-media.com^",
		"||friendfeed.com^",
		"||friendfeedmedia.com^",
		"||fsacebok.com^",
		"||fscebook.com^",
		"||fundraisingwithfacebook.com^",
		"||funnyfacebook.org^",
		"||futureofbusinesssurvey.org^",
		"||gacebook.com^",
		"||gameroom.com^",
		"||gfacecbook.com^",
		"||groups.com^",
		"||hackerfacebook.com^",
		"||hackfacebook.com^",
		"||hackfacebookid.com^",
		"||hacklang.org^",
		"||hhvm.com^",
		"||hifacebook.info^",
		"||howtohackfacebook-account.com^",
		"||hsfacebook.com^",
		"||httpfacebook.com^",
		"||httpsfacebook.com^",
		"||httpwwwfacebook.com^",
		"||i.org^",
		"||internet.org^",
		"||klik.me^",
		"||liverail.com^",
		"||liverail.tv^",
		"||login-account.net^",
		"||m.me^",
		"||makeitopen.com^",
		"||markzuckerberg.com^",
		"||mcrouter.net^",
		"||mcrouter.org^",
		"||messenger.com^",
		"||messengerdevelopers.com^",
		"||midentsolutions.com^",
		"||mobilefacebook.com^",
		"||moneywithfacebook.com^",
		"||myfbfans.com^",
		"||nbabot.net^",
		"||newsfeed.com^",
		"||nextstop.com^",
		"||ogp.me^",
		"||online-deals.net^",
		"||opencreate.org^",
		"||opengraphprotocol.com^",
		"||opengraphprotocol.org^",
		"||parse.com^",
		"||pyrobot.org^",
		"||reachtheworldonfacebook.com^",
		"||react.com^",
		"||reactjs.com^",
		"||reactjs.org^",
		"||recoiljs.org^",
		"||redkix.com^",
		"||rocksdb.com^",
		"||rocksdb.net^",
		"||rocksdb.org^",
		"||rocksdb.org^",
		"||shopfacebook.com^",
		"||sportsfacebook.com^",
		"||sportstream.com^",
		"||supportfacebook.com^",
		"||terragraph.com^",
		"||thefacebook.com^",
		"||thefacebook.net^",
		"||thefind.com^",
		"||toplayerserver.com^",
		"||viewpointsfromfacebook.com^",
		"||whyfacebook.com^",
		"||workplace.com^",
		"||workplaceusecases.com^",
		"||worldhack.com^",
		"||www-facebook.com^",
		"||wwwfacebok.com^",
		"||wwwfacebook.com^",
		"||wwwmfacebook.com^",
		"||yogalayout.com^",
		"||zuckerberg.com^",
		"||zuckerberg.net^",
	},
	GroupID: "social_network",
}, {
	ID:      "fifa",
	Name:    "FIFA",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M0 8.06v7.88h2.49v-2.85H4.2l.68-1.72h-2.4v-1.6H5.4l.63-1.7zm6.8 0v7.88h2.46V8.06zm4.15 0v7.88h2.49v-2.85h1.72l.68-1.72h-2.4v-1.6h2.92l.64-1.7zm7.66 0-2.83 7.88h2.38l.3-1.06h2.77l.32 1.06H24l-2.84-7.88zm1.24 2.03.98 3.27H18.9z\"/></svg>"),
	Rules: []string{
		"||fifa.com^",
		"||fifaplus.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "flickr",
	Name:    "Flickr",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 9 4 C 6.2504839 4 4 6.2504839 4 9 L 4 41 C 4 43.749516 6.2504839 46 9 46 L 41 46 C 43.749516 46 46 43.749516 46 41 L 46 9 C 46 6.2504839 43.749516 4 41 4 L 9 4 z M 9 6 L 41 6 C 42.668484 6 44 7.3315161 44 9 L 44 41 C 44 42.668484 42.668484 44 41 44 L 9 44 C 7.3315161 44 6 42.668484 6 41 L 6 9 C 6 7.3315161 7.3315161 6 9 6 z M 16 17 C 11.59 17 8 20.59 8 25 C 8 29.41 11.59 33 16 33 C 20.41 33 24 29.41 24 25 C 24 20.59 20.41 17 16 17 z M 34 17 C 29.59 17 26 20.59 26 25 C 26 29.41 29.59 33 34 33 C 38.41 33 42 29.41 42 25 C 42 20.59 38.41 17 34 17 z\"/></svg>"),
	Rules: []string{
		"||flic.kr^",
		"||flickr.com^",
		"||flickr.net^",
		"||flickrprints.com^",
		"||flickrpro.com^",
		"||staticflickr.com^",
	},
	GroupID: "hosting",
}, {
	ID:      "globoplay",
	Name:    "Globoplay",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"30 -5 90 90\"><path d=\"M36.45 18.035a8.498 8.498 0 0 0-6.298 7.33 8.23 8.23 0 0 0 3.298 8.27 8.685 8.685 0 0 0 4.952 1.635 5.696 5.696 0 0 0 4.497-1.714c.06 2.704-1.139 4.685-4.319 4.784a10.012 10.012 0 0 1-5.556-1.535c-.901-.535-1.337-.376-1.793.535-.257.505-.505 1.04-.782 1.555-.397.723-.258 1.178.465 1.773a11.886 11.886 0 0 0 7.23 2.218c8.063 0 9.559-5.962 9.559-10.707V19.67c.02-1.753.079-1.654-2.457-1.654a3.16 3.16 0 0 0-1.584.238c-.327.258-.387.753-.387 1.535a6.601 6.601 0 0 0-6.825-1.753m2.469 13.153c-2.486-.02-4.319-1.654-4.319-4.556a4.15 4.15 0 0 1 4.338-4.467 4.19 4.19 0 0 1 4.16 4.507h-.02a4.16 4.16 0 0 1-4.144 4.516h-.015m76.025 14.606c-.644 1.872-1.337 3.705-1.981 5.557-.476 1.347-1.05 2.843-1.555 4.319 0 0-2.645-6.795-3.863-9.905a1.11 1.11 0 0 0-1.229-.852h-2.753c-1.436 0-1.496.079-.911 1.416 2.07 4.755 6.606 15.095 6.606 15.095-.387.923-.851 1.81-1.386 2.655a2.042 2.042 0 0 1-2.477.99c-1.674-.396-1.674-.376-2.486 1.199a8.951 8.951 0 0 0-.336.594c-.288.505-.466 1.178.138 1.496a5.717 5.717 0 0 0 3.387 1.137h.071c.088-.001.178-.004.266-.008 3.19 0 5.131-2.892 5.943-4.873 1.288-3.23 2.952-7.191 4.259-10.44 1.06-2.665 2.16-5.3 3.15-7.924.436-1.08.238-1.397-.931-1.397-.862 0-1.714.06-2.555 0a1.168 1.168 0 0 0-1.357.941M76.237 12.072V34.1c-.016.288.046.575.178.832.337.515 3.675.554 3.962 0 .238-.308.119-1.397.238-1.298a7.696 7.696 0 0 0 11.153-.892c2.703-2.931 2.684-8.775.237-11.746a8.19 8.19 0 0 0-6.517-3.25 6.754 6.754 0 0 0-4.507 1.813c-.02-.08-.06-5.28-.079-7.408 0-.882-.267-1.298-1.258-1.298-.733.06-1.317.02-2.17 0h-.065c-.806 0-1.172.36-1.172 1.219m8.486 19.155a4.25 4.25 0 0 1-3.92-4.555c.06-2.734 1.872-4.487 4.24-4.487a4.22 4.22 0 0 1 4.24 4.546 4.249 4.249 0 0 1-4.237 4.508 4.33 4.33 0 0 1-.323-.012m-23.521 15.39c0-1.297.079-1.693-1.278-1.693h-1.872c-.773-.11-1.05.267-1.05.99v22.098c0 .713.218 1.07.99 1.07h1.773c1.714 0 1.714 0 1.714-1.655v-6.933c.475.297.723.495 1.05.674a6.815 6.815 0 0 0 7.101.386 9.033 9.033 0 0 0 4.576-10.281c-.853-3.919-4.351-6.738-7.994-6.737-1.726 0-3.485.633-5.01 2.081m4.445 11.341a4.328 4.328 0 0 1-4.249-4.596 4.22 4.22 0 0 1 4.447-4.467c2.684.1 4.081 1.952 4.081 4.507a4.23 4.23 0 0 1-4.215 4.557h-.064M87.29 45.776a9.231 9.231 0 0 0-.753 14.738 7.084 7.084 0 0 0 5.2 1.832 6.24 6.24 0 0 0 4.557-2.06c0 1.734.317 1.734 1.892 1.734h1.377c.901.079 1.258-.377 1.258-1.209V46.033c0-.762-.278-1.258-1.16-1.159h-1.574c-1.753-.02-1.535 0-1.753 1.595l-.773-.495a6.925 6.925 0 0 0-4.269-1.47c-1.399 0-2.8.423-4.001 1.272m.564 7.626v-.04a4.279 4.279 0 0 1 4.16-4.487l.154.005a4.348 4.348 0 0 1 4.145 4.542 4.279 4.279 0 0 1-4.26 4.596l-.105.001c-2.372 0-4.094-1.972-4.094-4.617m-31.291-26.91a8.855 8.855 0 0 0 9.053 9.217 8.855 8.855 0 0 0 8.647-9.058c.001-.067.002-.133.001-.2a8.736 8.736 0 0 0-8.787-8.684h-.071a8.846 8.846 0 0 0-8.843 8.726m8.63 4.806a4.487 4.487 0 0 1-4.143-4.807c.002-.069.004-.138.01-.207a4.299 4.299 0 0 1 8.579.564v.06a4.358 4.358 0 0 1-4.32 4.397 4.08 4.08 0 0 1-.125-.008m30.527-4.665a8.816 8.816 0 1 0 17.63.258 8.816 8.816 0 0 0-8.686-8.945 8.817 8.817 0 0 0-8.944 8.686m4.478.377a4.378 4.378 0 0 1 4.17-4.863 4.259 4.259 0 0 1 4.437 4.487v.02a4.338 4.338 0 0 1-4.16 4.655h-.021a4.428 4.428 0 0 1-4.426-4.299M77.93 37.762c-1.228.02-1.397.198-1.397 1.436v21.514c0 .89.307 1.346 1.298 1.287.722-.04 1.446-.04 2.169 0 .822.04 1.139-.297 1.139-1.149V49.895c0-3.644-.02-7.31 0-10.974 0-.822-.297-1.159-1.139-1.159h-2.07ZM50.846 10.505c-.669.004-.913.505-.913 1.408v11.252c-.02 1.09-.02 2.199 0 3.21v7.923c-.02 1.317.812 1.694 1.713 1.317.456-.168 1.07-.485 1.377-.623 1.506-.674 1.446-1.21 1.446-2.427.06-6.25.06-13.045.06-19.126 0-1.595-.496-1.753-2.407-2.586-.528-.233-.942-.346-1.26-.348h-.016Z\"/></svg>"),
	Rules: []string{
		"||cloud-jarvis.globo.com^",
		"||globoplay.com.br^",
		"||globoplay.com^",
		"||globoplay.globo.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "gog",
	Name:    "GOG",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 34 34\"><path d=\"M31 31H3a3 3 0 0 1-3-3V3A3 3 0 0 1 3 0H31a3 3 0 0 1 3 3V28A3 3 0 0 1 31 31ZM4 24.5A1.5 1.5 0 0 0 5.5 26H11V24H6.5a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5H11V18H5.5A1.5 1.5 0 0 0 4 19.5Zm8-18A1.5 1.5 0 0 0 10.5 5h-5A1.5 1.5 0 0 0 4 6.5v5A1.5 1.5 0 0 0 5.5 13H9V11H6.5a.5.5 0 0 1-.5-.5v-3A.5.5 0 0 1 6.5 7h3a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-.5.5H4v2h6.5A1.5 1.5 0 0 0 12 14.5Zm0 13v5A1.5 1.5 0 0 0 13.5 26h5A1.5 1.5 0 0 0 20 24.5v-5A1.5 1.5 0 0 0 18.5 18h-5A1.5 1.5 0 0 0 12 19.5Zm9-13A1.5 1.5 0 0 0 19.5 5h-5A1.5 1.5 0 0 0 13 6.5v5A1.5 1.5 0 0 0 14.5 13h5A1.5 1.5 0 0 0 21 11.5Zm9 0A1.5 1.5 0 0 0 28.5 5h-5A1.5 1.5 0 0 0 22 6.5v5A1.5 1.5 0 0 0 23.5 13H27V11H24.5a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-.5.5H22v2h6.5A1.5 1.5 0 0 0 30 14.5ZM30 18H22.5A1.5 1.5 0 0 0 21 19.5V26h2V20.5a.5.5 0 0 1 .5-.5h1v6h2V20H28v6h2ZM18.5 11h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v3A.5.5 0 0 1 18.5 11Zm-4 9h3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-3A.5.5 0 0 1 14.5 20Z\" /></svg>"),
	Rules: []string{
		"||gog-cdn-lumen.secure2.footprint.net^",
		"||gog-statics.com^",
		"||gog.com^",
		"||gogalaxy.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "hbomax",
	Name:    "HBO Max",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M0 14v22h5v-9h3v9h5V14H8v8H5v-8H0zm15 0v22h8.4c3.1 0 5.7-2.3 6.2-5.4a11 11 0 1 0 0-11.2c-.5-3-3-5.4-6.2-5.4H15zm5 5h3a2 2 0 1 1 0 4h-3v-4zm19 0a6 6 0 1 1 0 12 6 6 0 0 1 0-12zm0 2a4 4 0 0 0-4 4 4 4 0 0 0 4 4 4 4 0 0 0 4-4 4 4 0 0 0-4-4zm-11 2.8v2.4c-.4-.5-1-1-2-1.2 1-.3 1.7-.8 2-1.3zm-8 4h3a2 2 0 1 1 0 4h-3v-4z\"/></svg>"),
	Rules: []string{
		"||hbo.com^",
		"||hbogo.co.th^",
		"||hbogo.com^",
		"||hbogo.eu^",
		"||hbogoasia.com^",
		"||hbogoasia.id^",
		"||hbogoasia.ph^",
		"||hbomax-images.warnermediacdn.com^",
		"||hbomax.com^",
		"||hbomaxcdn.com^",
		"||hbonow.com^",
		"||max.com^",
		"||maxgo.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "hulu",
	Name:    "Hulu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 0 15 L 0 34 L 4 34 L 4 25 C 4 24.5 4.398438 24 5 24 L 8 24 C 8.5 24 9 24.398438 9 25 L 9 34 L 13 34 L 13 24 C 13 21.800781 11.199219 20 9 20 L 4 20 L 4 15 Z M 30 15 L 30 34 L 34 34 L 34 15 Z M 15 20 L 15 30 C 15 32.199219 16.800781 34 19 34 L 24 34 C 26.199219 34 27.992188 32.199219 28.09375 30 L 28.09375 20 L 24.09375 20 L 24.09375 28.90625 C 24.09375 29.507813 23.601563 30 23 30 L 20.09375 30 C 19.492188 30 19 29.507813 19 28.90625 L 19 20 Z M 36 20 L 36 30 C 36 32.199219 37.800781 34 40 34 L 45 34 C 47.199219 34 49 32.199219 49 30 L 49 20 L 45 20 L 45 29 C 45 29.5 44.601563 30 44 30 L 41 30 C 40.5 30 40 29.601563 40 29 L 40 20 Z\" /></svg>"),
	Rules: []string{
		"||hulu.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "icloud_private_relay",
	Name:    "iCloud Private Relay",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M395.748 272.046c-.646-64.841 52.88-95.938 55.271-97.483-30.075-44.01-76.925-50.039-93.62-50.736-39.871-4.037-77.798 23.474-98.033 23.474-20.184 0-51.409-22.877-84.476-22.276-43.458.646-83.529 25.269-105.906 64.19-45.152 78.35-11.563 194.42 32.445 257.963 21.504 31.104 47.146 66.038 80.813 64.79 32.421-1.294 44.681-20.979 83.878-20.979 39.196 0 50.215 20.979 84.524 20.335 34.888-.648 56.991-31.699 78.347-62.898 24.694-36.084 34.862-71.019 35.462-72.812-.775-.354-68.031-26.119-68.705-103.568zM331.28 81.761C349.149 60.082 361.21 30.005 357.92 0c-25.739 1.048-56.938 17.145-75.405 38.775-16.57 19.188-31.075 49.813-27.188 79.218 28.734 2.242 58.065-14.602 75.953-36.232z\" /></svg>"),
	Rules: []string{
		"||mask-canary.icloud.com^$dnsrewrite=NXDOMAIN;;",
		"||mask-h2.icloud.com^$dnsrewrite=NXDOMAIN;;",
		"||mask.icloud.com^$dnsrewrite=NXDOMAIN;;",
	},
	GroupID: "privacy",
}, {
	ID:      "iheartradio",
	Name:    "iHeartRadio",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -4 33 33\"><path d=\"M23.997.25c-3.053 0-5.79 1.613-7.402 4.003C15.01 1.892 12.275.25 9.193.25A8.826 8.826 0 0 0 .35 9.092c0 3.11 1.958 5.328 4.003 7.402l8.007 7.575c.432.403 1.123.086 1.123-.49v-5.904c0-1.7 1.383-3.082 3.082-3.082 1.7 0 3.082 1.383 3.082 3.082v5.904c0 .576.69.864 1.123.49l8.007-7.575c2.045-2.074 4.003-4.291 4.003-7.402C32.84 4.196 28.893.25 23.997.25ZM8.587 15.918a.573.573 0 0 1-.46.202.688.688 0 0 1-.403-.144c-2.65-2.333-3.975-4.781-3.975-7.258v-.03c0-2.13 1.296-4.55 3.024-5.615a.607.607 0 1 1 .634 1.036c-1.383.864-2.448 2.88-2.448 4.58v.029c0 2.102 1.21 4.233 3.571 6.336.26.202.288.605.058.864Zm3.947-2.275a.618.618 0 0 1-.548.317.487.487 0 0 1-.288-.087c-1.785-1.008-2.995-2.966-2.995-4.896v-.029a4.925 4.925 0 0 1 2.65-4.378c.288-.144.662-.029.835.26.144.287.029.662-.26.835a3.664 3.664 0 0 0-1.987 3.283c0 1.498.95 3.053 2.362 3.83.288.173.375.548.23.865Zm4.06-1.584a2.643 2.643 0 0 1-2.65-2.65 2.644 2.644 0 0 1 2.65-2.65c1.47 0 2.65 1.181 2.65 2.65.03 1.469-1.18 2.65-2.65 2.65Zm4.926 1.814a.556.556 0 0 1-.288.087.652.652 0 0 1-.547-.317c-.173-.288-.058-.663.23-.836 1.411-.806 2.362-2.332 2.362-3.83 0-1.383-.778-2.65-1.988-3.283-.288-.144-.403-.519-.259-.836.144-.288.518-.403.835-.259a4.925 4.925 0 0 1 2.65 4.378v.029c0 1.9-1.21 3.86-2.995 4.867Zm7.949-5.184c0 2.477-1.325 4.925-3.975 7.258-.115.115-.259.144-.403.144a.573.573 0 0 1-.46-.202.602.602 0 0 1 .057-.864c2.362-2.102 3.571-4.234 3.571-6.336V8.66c0-1.728-1.065-3.744-2.448-4.58a.607.607 0 1 1 .634-1.036c1.728 1.094 3.024 3.514 3.024 5.616v.029Z\"/></svg>"),
	Rules: []string{
		"||937theriver.com^",
		"||iheart.com^",
		"||iheart.mx^",
		"||iheartmedia.com^",
		"||iheartradio.ca^",
		"||iheartradio.co.nz^",
		"||iheartradio.com^",
		"||ihrdev.com^",
		"||ihrhls.com^",
		"||ihrint.com^",
		"||ihrstage.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "imgur",
	Name:    "Imgur",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 50 50\"><path d=\"M 13.890625 4 C 8.440625 4 4 8.440625 4 13.890625 L 4 14 L 4 25.150391 L 4 36 C 4 41.511334 8.4886661 46 14 46 L 25.240234 46 L 36 46 L 36.109375 46 C 41.559375 46 46 41.559375 46 36.109375 L 46 36 L 46 14 L 46 13.890625 C 46 8.440625 41.559375 4 36.109375 4 L 36 4 L 14 4 L 13.890625 4 z M 30.650391 12.841797 C 32.240547 12.849766 33.879609 12.879687 35.599609 12.929688 C 36.589609 12.949687 37.410469 13.759531 37.480469 14.769531 C 37.880469 20.889531 37.589062 26.699063 37.039062 33.539062 C 36.969062 34.359063 36.559688 35.090547 35.929688 35.560547 C 35.919688 35.560547 35.910156 35.570312 35.910156 35.570312 L 27.287109 44 L 14 44 C 9.5693339 44 6 40.430666 6 36 L 6 23.175781 L 15.140625 14.150391 L 15.150391 14.150391 C 15.600391 13.700391 16.199141 13.419141 16.869141 13.369141 C 21.556641 12.986641 25.879922 12.817891 30.650391 12.841797 z M 30.029297 14.839844 C 25.569297 14.839844 21.459297 14.999375 17.029297 15.359375 C 16.569297 15.399375 16.399609 15.740859 16.349609 15.880859 C 16.299609 16.020859 16.209297 16.390937 16.529297 16.710938 L 21.490234 21.669922 L 12.789062 30.369141 C 13.169063 31.119141 14.099922 32.660234 15.919922 34.490234 C 17.749922 36.310234 19.289062 37.229141 20.039062 37.619141 L 28.730469 28.910156 L 33.699219 33.880859 C 34.019219 34.200859 34.379297 34.110547 34.529297 34.060547 C 34.669297 34.010547 35.009062 33.830859 35.039062 33.380859 C 35.589062 26.630859 35.870469 20.910156 35.480469 14.910156 C 33.580469 14.860156 31.779297 14.839844 30.029297 14.839844 z M 14.501953 20 C 14.450328 20 14.399406 20.028938 14.378906 20.085938 C 14.163906 20.686938 13.684938 21.159047 13.085938 21.373047 C 12.971938 21.413047 12.971937 21.580094 13.085938 21.621094 C 13.684937 21.837094 14.162906 22.315062 14.378906 22.914062 C 14.419906 23.028062 14.585953 23.028063 14.626953 22.914062 C 14.840953 22.316062 15.313063 21.837094 15.914062 21.621094 C 16.028062 21.580094 16.027109 21.415047 15.912109 21.373047 C 15.312109 21.160047 14.839 20.685938 14.625 20.085938 C 14.605 20.028938 14.553578 20 14.501953 20 z M 10.503906 24 C 10.417781 23.999875 10.332828 24.047578 10.298828 24.142578 C 9.9398281 25.143578 9.1425312 25.935016 8.1445312 26.291016 C 7.9535313 26.359016 7.9525781 26.635125 8.1425781 26.703125 C 9.1405781 27.063125 9.9398281 27.859422 10.298828 28.857422 C 10.366828 29.047422 10.642938 29.047422 10.710938 28.857422 C 11.066937 27.859422 11.856422 27.062125 12.857422 26.703125 C 13.047422 26.635125 13.047422 26.358016 12.857422 26.291016 C 11.857422 25.936016 11.066937 25.145531 10.710938 24.144531 C 10.677437 24.049031 10.590031 24.000125 10.503906 24 z M 10.501953 33 C 10.450328 33 10.399406 33.028938 10.378906 33.085938 C 10.163906 33.686938 9.6849375 34.159047 9.0859375 34.373047 C 8.9719375 34.413047 8.9719375 34.580094 9.0859375 34.621094 C 9.6849375 34.837094 10.162906 35.315063 10.378906 35.914062 C 10.419906 36.028062 10.585953 36.028062 10.626953 35.914062 C 10.840953 35.316063 11.313063 34.837094 11.914062 34.621094 C 12.028062 34.580094 12.027109 34.415047 11.912109 34.373047 C 11.312109 34.160047 10.839 33.685938 10.625 33.085938 C 10.605 33.028937 10.553578 33 10.501953 33 z M 29.001953 33 C 28.967453 33 28.933422 33.018641 28.919922 33.056641 C 28.775922 33.456641 28.455641 33.774016 28.056641 33.916016 C 27.980641 33.943016 27.980641 34.053078 28.056641 34.080078 C 28.455641 34.224078 28.775922 34.544359 28.919922 34.943359 C 28.947922 35.019359 29.056984 35.019359 29.083984 34.943359 C 29.225984 34.544359 29.543359 34.224078 29.943359 34.080078 C 30.019359 34.053078 30.019359 33.943016 29.943359 33.916016 C 29.543359 33.774016 29.225984 33.456641 29.083984 33.056641 C 29.070484 33.018641 29.036453 33 29.001953 33 z M 26.001953 36 C 25.933078 35.999875 25.865391 36.037281 25.837891 36.113281 C 25.550891 36.914281 24.911281 37.547031 24.113281 37.832031 C 23.960281 37.887031 23.961281 38.107109 24.113281 38.162109 C 24.912281 38.450109 25.549891 39.088719 25.837891 39.886719 C 25.892891 40.038719 26.113969 40.036766 26.167969 39.884766 C 26.452969 39.086766 27.085719 38.450109 27.886719 38.162109 C 28.038719 38.108109 28.037766 37.887031 27.884766 37.832031 C 27.083766 37.547031 26.452969 36.914281 26.167969 36.113281 C 26.140969 36.036781 26.070828 36.000125 26.001953 36 z M 9.0019531 38 C 8.9674531 38 8.9334219 38.018641 8.9199219 38.056641 C 8.7759219 38.456641 8.4556406 38.774016 8.0566406 38.916016 C 7.9806406 38.943016 7.9806406 39.053078 8.0566406 39.080078 C 8.4556406 39.224078 8.7759219 39.544359 8.9199219 39.943359 C 8.9479219 40.019359 9.0569844 40.019359 9.0839844 39.943359 C 9.2259844 39.544359 9.5433594 39.224078 9.9433594 39.080078 C 10.019359 39.053078 10.019359 38.943016 9.9433594 38.916016 C 9.5433594 38.774016 9.2259844 38.456641 9.0839844 38.056641 C 9.0704844 38.018641 9.0364531 38 9.0019531 38 z M 13.501953 39 C 13.450328 39 13.399406 39.028937 13.378906 39.085938 C 13.163906 39.686938 12.684938 40.159047 12.085938 40.373047 C 11.971938 40.413047 11.971937 40.580094 12.085938 40.621094 C 12.684937 40.837094 13.162906 41.315063 13.378906 41.914062 C 13.419906 42.028062 13.585953 42.028062 13.626953 41.914062 C 13.840953 41.316063 14.313063 40.837094 14.914062 40.621094 C 15.028062 40.580094 15.027109 40.415047 14.912109 40.373047 C 14.312109 40.160047 13.839 39.685938 13.625 39.085938 C 13.605 39.028937 13.553578 39 13.501953 39 z M 20.501953 40 C 20.450328 40 20.399406 40.028938 20.378906 40.085938 C 20.163906 40.686938 19.684938 41.159047 19.085938 41.373047 C 18.971937 41.413047 18.971937 41.580094 19.085938 41.621094 C 19.684938 41.837094 20.162906 42.315063 20.378906 42.914062 C 20.419906 43.028062 20.585953 43.028062 20.626953 42.914062 C 20.840953 42.316062 21.313063 41.837094 21.914062 41.621094 C 22.028062 41.580094 22.027109 41.415047 21.912109 41.373047 C 21.312109 41.160047 20.839 40.685938 20.625 40.085938 C 20.605 40.028937 20.553578 40 20.501953 40 z\"/></svg>"),
	Rules: []string{
		"||imgur.com^",
	},
	GroupID: "hosting",
}, {
	ID:      "instagram",
	Name:    "Instagram",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12 8.8A3.2 3.2 0 0 0 8.8 12a3.2 3.2 0 0 0 3.2 3.2 3.2 3.2 0 0 0 3.2-3.2A3.2 3.2 0 0 0 12 8.8zm0 0\" /><path d=\"M16 2.398H8A5.609 5.609 0 0 0 2.398 8v8A5.609 5.609 0 0 0 8 21.602h8A5.609 5.609 0 0 0 21.602 16V8A5.609 5.609 0 0 0 16 2.398zm-4 14.403A4.805 4.805 0 0 1 7.2 12c0-2.648 2.152-4.8 4.8-4.8 2.648 0 4.8 2.152 4.8 4.8 0 2.648-2.152 4.8-4.8 4.8zm5.602-9.602a.799.799 0 1 1 0 0zm0 0\" /></svg>"),
	Rules: []string{
		"||achat-followers-instagram.com^",
		"||acheter-followers-instagram.com^",
		"||acheterdesfollowersinstagram.com^",
		"||acheterfollowersinstagram.com^",
		"||bookstagram.com^",
		"||carstagram.com^",
		"||cdninstagram.com^",
		"||chickstagram.com^",
		"||ig.me^",
		"||igcdn.com^",
		"||igsonar.com^",
		"||igtv.com^",
		"||imstagram.com^",
		"||imtagram.com^",
		"||instaadder.com^",
		"||instachecker.com^",
		"||instafallow.com^",
		"||instafollower.com^",
		"||instagainer.com^",
		"||instagda.com^",
		"||instagify.com^",
		"||instagmania.com^",
		"||instagor.com^",
		"||instagram-brand.com^",
		"||instagram-engineering.com^",
		"||instagram-help.com^",
		"||instagram-press.com^",
		"||instagram-press.net^",
		"||instagram.com^",
		"||instagramci.com^",
		"||instagramcn.com^",
		"||instagramdi.com^",
		"||instagramhashtags.net^",
		"||instagramhilecim.com^",
		"||instagramhilesi.org^",
		"||instagramium.com^",
		"||instagramizlenme.com^",
		"||instagramkusu.com^",
		"||instagramlogin.com^",
		"||instagramm.com^",
		"||instagramn.com^",
		"||instagrampartners.com^",
		"||instagramphoto.com^",
		"||instagramq.com^",
		"||instagramsepeti.com^",
		"||instagramtakipcisatinal.net^",
		"||instagramtakiphilesi.com^",
		"||instagramtips.com^",
		"||instagramtr.com^",
		"||instagran.com^",
		"||instagranm.com^",
		"||instagrem.com^",
		"||instagrm.com^",
		"||instagtram.com^",
		"||instagy.com^",
		"||instamgram.com^",
		"||instangram.com^",
		"||instanttelegram.com^",
		"||instaplayer.net^",
		"||instastyle.tv^",
		"||instgram.com^",
		"||intagram.com^",
		"||intagrm.com^",
		"||intgram.com^",
		"||kingstagram.com^",
		"||lnstagram-help.com^",
		"||oninstagram.com^",
		"||online-instagram.com^",
		"||onlineinstagram.com^",
		"||theinstagramhack.com^",
		"||web-instagram.net^",
		"||wwwinstagram.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "iqiyi",
	Name:    "iQIYI",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M12.09 31.5a8 8 0 0 0 4.27.7c.19 0 .33 0 .38.21a1.41 1.41 0 0 0 1.4 1.25 16.86 16.86 0 0 0 2 0c.27 0 .4-.13.41-.41s0-.64 0-.95-.13-.45-.47-.46-.77 0-1.15 0a.56.56 0 0 1-.39-.08c.06-.1.15-.11.22-.14a2.25 2.25 0 0 0 1.45-2.07V18.29a2.13 2.13 0 0 0-.88-1.75 4 4 0 0 0-1.47-.65 10.45 10.45 0 0 0-3.82-.17 4.68 4.68 0 0 0-2 .61 2.29 2.29 0 0 0-1.25 2.09v11a2.06 2.06 0 0 0 1.3 2.08Zm2.3-12.84a2.55 2.55 0 0 1 0-.39.68.68 0 0 1 .47-.55 2.23 2.23 0 0 1 1.28 0 .58.58 0 0 1 .48.61v11.01c0 .68-.17.88-.86 1a1.52 1.52 0 0 1-1-.17.69.69 0 0 1-.34-.56v-.32ZM5.54 15h3c.21 0 .29-.08.32-.29a2.19 2.19 0 0 1 1.47-1.95 5.13 5.13 0 0 1 .88-.21 77.76 77.76 0 0 1 9.15-.83h7.55c1.8 0 3.59.18 5.38.36 1.24.13 2.48.28 3.72.49a2.26 2.26 0 0 1 2.05 2.13c0 .21.13.27.32.27h3c.24 0 .31-.09.29-.31a13.43 13.43 0 0 0-.26-1.66 3.92 3.92 0 0 0-3.12-3.12 42.34 42.34 0 0 0-4.86-.77C33.23 9 32 8.88 30.84 8.8c-1.41-.1-2.83-.18-4.24-.22h-2.65c-1.48 0-3 0-4.44.09-1 .07-1.92.09-2.88.16-1.48.11-2.95.24-4.42.44a28.28 28.28 0 0 0-4 .73 3.62 3.62 0 0 0-2.46 2.22 8 8 0 0 0-.52 2.51c.02.2.14.27.31.27Zm36.85 18h-3c-.24 0-.3.07-.34.29a2.14 2.14 0 0 1-1 1.72 3.55 3.55 0 0 1-1.19.39c-2.27.36-4.57.6-6.87.74-1.25.07-2.51.13-3.77.14h-4.54c-2 0-4-.12-6-.3-1.53-.14-3.06-.32-4.57-.56a3 3 0 0 1-1.44-.59 2.41 2.41 0 0 1-.77-1.6c0-.14-.06-.22-.22-.21-.7 0-1.39-.06-2 0H5.53c-.17 0-.24.08-.23.24a8.37 8.37 0 0 0 .46 2.38A3.65 3.65 0 0 0 8.27 38a26.19 26.19 0 0 0 3.49.67c2.32.32 4.65.49 7 .64 1.63.1 3.27.12 4.9.13s3.39 0 5.08-.12c.93-.06 1.87-.1 2.81-.17 1.43-.11 2.87-.24 4.29-.42a29.25 29.25 0 0 0 4-.74 3.63 3.63 0 0 0 2.4-2.18 7.86 7.86 0 0 0 .53-2.49c-.05-.24-.16-.32-.38-.32Zm-7.34-9.2c.86-2.38 1.71-4.76 2.57-7.13.14-.4 0-.58-.41-.59h-2.63c-.33 0-.4.06-.51.38-.32 1-.64 2.05-1 3.07-.22.7-.42 1.41-.65 2.17a2.14 2.14 0 0 1-.07-.25c-.47-1.67-1-3.32-1.52-5-.1-.32-.18-.38-.5-.39H27.7c-.38 0-.52.2-.39.56s.25.67.37 1c.83 2.3 1.64 4.61 2.49 6.9a7.16 7.16 0 0 1 .53 2.86c-.06 1.29 0 2.58 0 3.87 0 .45.11.55.54.56h2.48c.45 0 .52-.08.52-.52v-4.91a1.51 1.51 0 0 1 .06-.48l.75-2.1Zm-9.72-7.72h-2.41c-.49 0-.58.1-.58.59v14.65c0 .42.11.52.52.52h2.48c.48 0 .58-.1.58-.58V16.67c0-.49-.1-.59-.59-.59Zm16.89 0h-2.48c-.44 0-.53.09-.53.53v14.75c0 .4.09.48.49.48h2.53c.42 0 .52-.1.52-.52V16.6c0-.41-.11-.52-.53-.52ZM5.64 31.84h2.77a.33.33 0 0 0 .37-.34 2.71 2.71 0 0 0 0-.29v-9.89c0-.4-.09-.48-.49-.49H5.75c-.43 0-.5.08-.5.51V31.4c0 .32.1.44.39.44Zm-.39-12.58a.35.35 0 0 0 .39.4h2.72c.3 0 .42-.13.43-.42v-2.73c0-.29-.13-.42-.42-.42h-2.7c-.3 0-.42.12-.42.42v2.75Z\"/></svg>"),
	Rules: []string{
		"||iq.com^",
		"||iqiyi.com^",
		"||iqiyipic.com^",
		"||pps.tv^",
		"||ppsimg.com^",
		"||qiyi.com^",
		"||qiyipic.com^",
		"||qy.net^",
	},
	GroupID: "streaming",
}, {
	ID:      "kakaotalk",
	Name:    "KakaoTalk",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\" ><path d=\"M22.125 0H1.875C.839 0 0 .84 0 1.875v20.25C0 23.161.84 24 1.875 24h20.25C23.161 24 24 23.16 24 22.125V1.875C24 .839 23.16 0 22.125 0zM12 18.75c-.591 0-1.17-.041-1.732-.12-.562.396-3.813 2.679-4.12 2.722 0 0-.125.049-.232-.014s-.088-.229-.088-.229c.032-.22.843-3.018.992-3.533-2.745-1.36-4.57-3.769-4.57-6.513 0-4.246 4.365-7.688 9.75-7.688s9.75 3.442 9.75 7.688c0 4.245-4.365 7.687-9.75 7.687zM8.05 9.867h-.878v3.342c0 .296-.252.537-.563.537s-.562-.24-.562-.537V9.867h-.878a.552.552 0 0 1 0-1.101h2.88a.552.552 0 0 1 0 1.101zm10.987 2.957a.558.558 0 0 1 .109.417.559.559 0 0 1-.219.37.557.557 0 0 1-.338.114.558.558 0 0 1-.45-.224l-1.319-1.747-.195.195v1.227a.564.564 0 0 1-.562.563.563.563 0 0 1-.563-.563V9.328a.563.563 0 0 1 1.125 0v1.21l1.57-1.57a.437.437 0 0 1 .311-.126c.14 0 .282.061.388.167a.555.555 0 0 1 .165.356.438.438 0 0 1-.124.343l-1.282 1.281 1.385 1.835zm-8.35-3.502c-.095-.27-.383-.548-.75-.556-.366.008-.654.286-.749.555l-1.345 3.541c-.171.53-.022.728.133.8a.857.857 0 0 0 .357.077c.235 0 .414-.095.468-.248l.279-.73h1.715l.279.73c.054.153.233.248.468.248a.86.86 0 0 0 .357-.078c.155-.071.304-.268.133-.8l-1.345-3.54zm-1.311 2.443.562-1.596.561 1.596H9.376zm5.905 1.383a.528.528 0 0 1-.539.516h-1.804a.528.528 0 0 1-.54-.516v-3.82c0-.31.258-.562.575-.562s.574.252.574.562v3.305h1.195c.297 0 .54.231.54.515z\"/></svg>"),
	Rules: []string{
		"||kakao.com^",
		"||kgslb.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "kik",
	Name:    "Kik",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 3.5039062 12 C 1.9347705 11.994817 0.87857579 12.97636 0.4453125 13.849609 C 0.01204921 14.722858 0 15.564453 0 15.564453 A 1.0001 1.0001 0 0 0 0 15.59375 L 0 35 A 1.0001 1.0001 0 0 0 0.00390625 35.078125 C 0.00390625 35.078125 0.05696144 35.828363 0.5390625 36.554688 C 1.0211636 37.281011 2.0459252 38.004441 3.5019531 38.001953 C 4.8916439 38.000053 5.8837351 37.273604 6.3769531 36.578125 C 6.8701712 35.882646 6.9863281 35.166016 6.9863281 35.166016 A 1.0001 1.0001 0 0 0 7 35 L 7 31.802734 L 10.167969 36.554688 L 10.130859 36.494141 C 10.511831 37.164615 11.143097 37.525465 11.742188 37.730469 C 12.341278 37.935473 12.950104 38.001953 13.5 38.001953 C 15.411725 38.001953 17 36.431487 17 34.5 C 17 34.056649 16.90825 34.03442 16.851562 33.912109 C 16.794882 33.789799 16.730864 33.671331 16.654297 33.537109 C 16.501163 33.268666 16.298339 32.944015 16.058594 32.572266 C 15.579103 31.828767 14.950355 30.90254 14.322266 29.992188 C 13.310206 28.525308 12.655222 27.610988 12.300781 27.113281 L 14.707031 24.707031 A 1.0001 1.0001 0 0 0 14.738281 24.673828 C 14.738281 24.673828 15.354706 24.012223 15.748047 23.042969 C 16.141388 22.073714 16.298687 20.56089 15.259766 19.349609 C 14.281705 18.208994 12.842689 18.141009 11.925781 18.416016 C 11.008874 18.691022 10.371094 19.222656 10.371094 19.222656 A 1.0001 1.0001 0 0 0 10.292969 19.292969 L 6.9980469 22.587891 L 6.9921875 15.646484 A 1.0001 1.0001 0 0 0 6.9902344 15.580078 C 6.9902344 15.580078 6.9441634 14.743069 6.5058594 13.875 C 6.0675579 13.006938 5.0412971 12.005313 3.5039062 12 z M 30.503906 12 C 28.93477 11.9948 27.878577 12.97636 27.445312 13.849609 C 27.012049 14.722858 27 15.564453 27 15.564453 A 1.0001 1.0001 0 0 0 27 15.59375 L 27 35 A 1.0001 1.0001 0 0 0 27.003906 35.078125 C 27.003906 35.078125 27.056966 35.828363 27.539062 36.554688 C 28.021165 37.281011 29.045925 38.004441 30.501953 38.001953 C 31.891644 38.000053 32.883735 37.273604 33.376953 36.578125 C 33.870171 35.882646 33.986328 35.166016 33.986328 35.166016 A 1.0001 1.0001 0 0 0 34 35 L 34 31.802734 L 37.167969 36.554688 L 37.130859 36.494141 C 37.511831 37.164615 38.143096 37.525465 38.742188 37.730469 C 39.341277 37.935473 39.950104 38.001953 40.5 38.001953 C 42.411725 38.001953 44 36.431487 44 34.5 C 44 34.056649 43.908251 34.03442 43.851562 33.912109 C 43.794882 33.789799 43.730864 33.671331 43.654297 33.537109 C 43.501163 33.268666 43.298339 32.944015 43.058594 32.572266 C 42.579103 31.828767 41.950355 30.90254 41.322266 29.992188 C 40.310206 28.525308 39.655222 27.610988 39.300781 27.113281 L 41.707031 24.707031 A 1.0001 1.0001 0 0 0 41.738281 24.673828 C 41.738281 24.673828 42.354706 24.012223 42.748047 23.042969 C 43.141388 22.073714 43.298687 20.56089 42.259766 19.349609 C 41.281705 18.208994 39.842689 18.141009 38.925781 18.416016 C 38.008874 18.691022 37.371094 19.222656 37.371094 19.222656 A 1.0001 1.0001 0 0 0 37.292969 19.292969 L 33.998047 22.587891 L 33.992188 15.646484 A 1.0001 1.0001 0 0 0 33.990234 15.580078 C 33.990234 15.580078 33.944164 14.743069 33.505859 13.875 C 33.067647 13.006938 32.041297 12.005313 30.503906 12 z M 21.507812 18 C 19.85324 17.98686 18.785557 19.124468 18.382812 20.09375 C 18.181441 20.578391 18.090615 21.031738 18.044922 21.375 C 18.022072 21.546631 18.011459 21.69063 18.005859 21.796875 C 18.000252 21.90312 18 22.065333 18 21.984375 L 17.982422 34.998047 A 1.0001 1.0001 0 0 0 17.990234 35.134766 C 17.990234 35.134766 18.085674 35.862804 18.576172 36.568359 C 19.06667 37.273915 20.071581 37.997467 21.486328 38 C 22.885358 38.0026 23.885897 37.278643 24.380859 36.580078 C 24.875822 35.881513 24.986328 35.160156 24.986328 35.160156 A 1.0001 1.0001 0 0 0 25 35 L 25 21.996094 C 25 21.996094 25.02572 21.084043 24.625 20.117188 C 24.224283 19.150332 23.164841 18.013078 21.507812 18 z M 46.5 24 C 44.578848 24 43 25.578848 43 27.5 C 43 29.421152 44.578848 31 46.5 31 C 48.421152 31 50 29.421152 50 27.5 C 50 25.578848 48.421152 24 46.5 24 z M 46.5 26 C 47.340272 26 48 26.659728 48 27.5 C 48 28.340272 47.340272 29 46.5 29 C 45.659728 29 45 28.340272 45 27.5 C 45 26.659728 45.659728 26 46.5 26 z\"/></svg>"),
	Rules: []string{
		"||kik.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "kook",
	Name:    "KOOK",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"18 18 220 220\"><path d=\"M32 87c25.86-.19 51.72-.33 77.58-.41 12-.05 24.01-.1 36.02-.2 10.46-.07 20.93-.12 31.4-.14 5.53-.01 11.07-.04 16.62-.1 5.21-.05 10.43-.07 15.64-.06a387.2 387.2 0 0 0 5.75-.04c14.35-.22 14.35-.22 18.22 2.55A17.33 17.33 0 0 1 236 95l.88 3.6c.12 3.5-.2 6.37-.94 9.78l-.78 3.69-.87 3.92-.87 4.07a1749.43 1749.43 0 0 1-1.84 8.47c-.8 3.63-1.58 7.26-2.36 10.89l-2.24 10.38-.44 2.01c-.4 1.86-.8 3.73-1.22 5.59l-.7 3.21C224 163 224 163 223 164a233.75 233.75 0 0 1-8.63.1h-2.62l-8.31-.04A6730.23 6730.23 0 0 1 184 164l-3 16h-11l-8-16H25c-6.84-12.54-6.84-12.54-5-20l1.22-6.25 1.5-7.1.8-3.8 2.11-9.9 2.15-10.13L32 87Zm7 8c-1.35 3.37-2.33 6-3.05 9.44l-.55 2.55-.56 2.73-.6 2.83-1.24 5.92c-.62 3.02-1.26 6.03-1.9 9.05l-1.2 5.76-.58 2.73-.53 2.55-.46 2.24c-.45 2.65-.45 2.65-.33 7.2h17l3-12 .97 2.62c1.7 3.74 3.14 6.44 6.03 9.38 5.17 1.54 10.74.68 16 0 1.18-4.5 1.38-6.94-.94-11.04a187.05 187.05 0 0 0-2.62-4.15c-.9-1.38-1.77-2.77-2.63-4.17l-1.2-1.83c-.61-1.81-.61-1.81.16-3.88a71.73 71.73 0 0 1 5.42-7.18l2.42-2.94a157.62 157.62 0 0 1 8.08-8.76c1.85-2.9 1.99-5.68 2.31-9.05-10.17-1.5-10.17-1.5-19.72 1.08-3.04 2.88-5.15 6.35-7.28 9.92h-1l2-11H39Zm44 7c-1.15 2.9-1.8 5.8-2.37 8.86l-.52 2.5c-.36 1.72-.7 3.45-1.04 5.18a558.08 558.08 0 0 1-1.6 7.94l-1.03 5.06-.49 2.4c-1.1 5.76-.68 8.96 2.05 14.06 5.18.15 10.35.26 15.53.33l5.29.12c2.53.08 5.06.1 7.6.14l2.37.09c4.28 0 5.75-.28 9.1-3.19 2.58-3.7 3.5-7.6 4.35-11.96l.51-2.42c.36-1.68.7-3.36 1.04-5.04a665.71 665.71 0 0 1 1.61-7.68l1.03-4.92.48-2.3c1.57-7.33 1.57-7.33.09-14.5-3.04-2.53-6.18-2.3-9.96-2.3l-2.36-.04a398.83 398.83 0 0 0-4.96-.02c-2.52 0-5.03-.06-7.54-.12l-4.83-.01-2.26-.08c-6.16.11-9.06 2.62-12.09 7.9Zm48.96-2.85c-1.75 3.37-2.51 6.83-3.23 10.54l-.53 2.48-1.05 5.19a606 606 0 0 1-1.64 7.9l-1.03 5.05-.5 2.37c-1.13 5.82-1.4 10.19 2.02 15.32a61 61 0 0 0 7.86.5l2.37.03c1.66.02 3.31.03 4.97.03 2.53 0 5.05.06 7.57.11l4.84.02 2.27.07c3.99-.06 6.47-.57 9.5-3.26 3.18-3.67 4.1-7.5 5-12.19l.51-2.49c.36-1.72.7-3.45 1.04-5.18.5-2.64 1.05-5.27 1.6-7.9l1.03-5.05.49-2.37c1.1-5.81 1.36-10.2-2.05-15.32a66.9 66.9 0 0 0-8.11-.5l-2.45-.03a558.66 558.66 0 0 0-5.12-.03c-2.61 0-5.22-.06-7.83-.11l-4.98-.02-2.35-.07c-4.75.06-7.42.93-10.2 4.91ZM181 95a1692.08 1692.08 0 0 0-8.88 39.44l-.65 3.08-.59 2.85-.52 2.5c-.44 2.26-.44 2.26-.36 5.13h17l3-12c5.87 9.75 5.87 9.75 7 12l7.94.06 2.28.03c1.93 0 3.85-.04 5.78-.09 1.34-1.14 1.34-1.14 1.32-4.12-.37-4.5-1.96-7.32-4.38-11-3.93-5.99-3.93-5.99-3.98-9.47 1.39-3.22 3.3-5.26 5.73-7.79l2.72-2.91a409.78 409.78 0 0 1 4.55-4.7l1.6-1.7 1.38-1.38c1.72-3.14 1.73-6.39 2.06-9.93-9.68-1.42-9.68-1.42-18.79 1.08-3.29 2.87-5.8 6.28-8.21 9.92l1-11h-17Z\"/><path d=\"M100 112h7c-1.88 16.88-1.88 16.88-4 19-2 .04-4 .04-6 0 .46-6.55 1.21-12.68 3-19Zm48 0h7c-1 6.46-2.02 12.77-4 19h-7c.47-2.8.95-5.58 1.44-8.38l.4-2.4c1.05-6 1.05-6 2.16-8.22Z\"/></svg>"),
	Rules: []string{
		"||kaiheila.cn^",
		"||kookapp.cn^",
	},
	GroupID: "social_network",
}, {
	ID:      "lazada",
	Name:    "Lazada",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 100 100\"><path d=\"M26 17a2 2 0 0 0-1.1.3L8.5 27.4A3 3 0 0 0 7 30v29.1c0 1 .6 2 1.5 2.6l40 24.8c.2.3.6.4 1 .5h1a3 3 0 0 0 1-.5l40-24.8a3 3 0 0 0 1.5-2.6v-29c0-1.1-.6-2.1-1.5-2.7l-16.4-10a2.1 2.1 0 0 0-2.2 0l-15.4 9.4a14.3 14.3 0 0 1-15 0L27 17.3c-.3-.2-.7-.3-1.1-.3zm0 2 15.4 9.5a16.3 16.3 0 0 0 17.2 0L74 19l16.5 10.1v.1L50 51.4 9.4 29.2h.1L26 19zm48 4c-.4 0-.9 0-1.3.3l-5.5 3.4a.5.5 0 1 0 .6.9l5.4-3.4c.5-.3 1.1-.3 1.6 0l9.4 5.7a.5.5 0 1 0 .5-.8l-9.4-5.8c-.4-.2-.8-.4-1.3-.4zm-8.7 5a.5.5 0 0 0-.3 0l-1.6 1a.5.5 0 0 0 .6 1l1.6-1a.5.5 0 0 0-.3-1zM9 30.1l40.5 22.2v32.6L9.5 60a1 1 0 0 1-.5-.9v-29zm82 0v29c0 .4-.2.7-.5 1l-40 24.7V52.4L91 30.1zM12.5 35a.5.5 0 0 0-.5.5v21.2c0 .8.4 1.6 1.2 2l16 10a.5.5 0 1 0 .6-.8l-16-10c-.5-.2-.8-.7-.8-1.2V35.5a.5.5 0 0 0-.5-.5zm24 37.2a.5.5 0 0 0-.3.9l4 2.5a.5.5 0 1 0 .6-.9l-4-2.4a.5.5 0 0 0-.3-.1zm7 4.3a.5.5 0 0 0-.3 1l1 .6a.5.5 0 1 0 .6-.9l-1-.6a.5.5 0 0 0-.3 0z\"/></svg>"),
	Rules: []string{
		"||k1-lazadasg-oversea.gslb.ksyuncdn.com^",
		"||lazada.co.id^",
		"||lazada.co.th^",
		"||lazada.com.my^",
		"||lazada.com.ph^",
		"||lazada.com^",
		"||lazada.sg^",
		"||lazada.vn^",
		"||slatic.net^",
	},
	GroupID: "shopping",
}, {
	ID:      "leagueoflegends",
	Name:    "League of Legends",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 30 30\"><path d=\"M 7 4 L 9 7.25 L 9 22.75 L 6.875 26 L 21.957031 26 L 25 22 L 14 22 L 14 4 L 7 4 z M 16 4.0507812 L 16 6.0585938 C 20.493 6.5575937 24 10.375 24 15 C 24 16.849 23.438516 18.569 22.478516 20 L 24.785156 20 C 25.556156 18.498 26 16.801 26 15 C 26 9.272 21.598 4.5577812 16 4.0507812 z M 6.8730469 7.6113281 C 5.0940469 9.5663281 4 12.155 4 15 C 4 17.837 5.0884219 20.418094 6.8574219 22.371094 L 7 22.154297 L 7 19.105469 C 6.365 17.872469 6 16.479 6 15 C 6 13.521 6.365 12.127531 7 10.894531 L 7 7.8164062 L 6.8730469 7.6113281 z\"/></svg>"),
	Rules: []string{
		"||leagueoflegends.co.kr^",
		"||leagueoflegends.com^",
		"||lol.riotgames.com^",
		"||lolstatic.com^",
		"||lolusercontent.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "line",
	Name:    "LINE",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 9 4 C 6.24 4 4 6.24 4 9 L 4 41 C 4 43.76 6.24 46 9 46 L 41 46 C 43.76 46 46 43.76 46 41 L 46 9 C 46 6.24 43.76 4 41 4 L 9 4 z M 25 11 C 33.27 11 40 16.359219 40 22.949219 C 40 25.579219 38.959297 27.960781 36.779297 30.300781 C 35.209297 32.080781 32.660547 34.040156 30.310547 35.660156 C 27.960547 37.260156 25.8 38.519609 25 38.849609 C 24.68 38.979609 24.44 39.039062 24.25 39.039062 C 23.59 39.039062 23.649219 38.340781 23.699219 38.050781 C 23.739219 37.830781 23.919922 36.789063 23.919922 36.789062 C 23.969922 36.419063 24.019141 35.830937 23.869141 35.460938 C 23.699141 35.050938 23.029062 34.840234 22.539062 34.740234 C 15.339063 33.800234 10 28.849219 10 22.949219 C 10 16.359219 16.73 11 25 11 z M 23.992188 18.998047 C 23.488379 19.007393 23 19.391875 23 20 L 23 26 C 23 26.552 23.448 27 24 27 C 24.552 27 25 26.552 25 26 L 25 23.121094 L 27.185547 26.580078 C 27.751547 27.372078 29 26.973 29 26 L 29 20 C 29 19.448 28.552 19 28 19 C 27.448 19 27 19.448 27 20 L 27 23 L 24.814453 19.419922 C 24.602203 19.122922 24.294473 18.992439 23.992188 18.998047 z M 15 19 C 14.448 19 14 19.448 14 20 L 14 26 C 14 26.552 14.448 27 15 27 L 18 27 C 18.552 27 19 26.552 19 26 C 19 25.448 18.552 25 18 25 L 16 25 L 16 20 C 16 19.448 15.552 19 15 19 z M 21 19 C 20.448 19 20 19.448 20 20 L 20 26 C 20 26.552 20.448 27 21 27 C 21.552 27 22 26.552 22 26 L 22 20 C 22 19.448 21.552 19 21 19 z M 31 19 C 30.448 19 30 19.448 30 20 L 30 26 C 30 26.552 30.448 27 31 27 L 34 27 C 34.552 27 35 26.552 35 26 C 35 25.448 34.552 25 34 25 L 32 25 L 32 24 L 34 24 C 34.553 24 35 23.552 35 23 C 35 22.448 34.553 22 34 22 L 32 22 L 32 21 L 34 21 C 34.552 21 35 20.552 35 20 C 35 19.448 34.552 19 34 19 L 31 19 z\"/></svg>"),
	Rules: []string{
		"||gcld-line.com^",
		"||lin.ee^",
		"||line-apps-beta.com^",
		"||line-apps-rc.com^",
		"||line-apps.com^",
		"||line-cdn.net^",
		"||line-scdn.net^",
		"||line.biz^",
		"||line.me^",
		"||line.naver.jp^",
		"||linecorp.com^",
		"||linefriends.com.tw^",
		"||linefriends.com^",
		"||linegame.jp^",
		"||linemobile.com^",
		"||linemyshop.com^",
		"||lineshoppingseller.com^",
		"||linetv.tw^",
	},
	GroupID: "social_network",
}, {
	ID:      "linkedin",
	Name:    "LinkedIn",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M41,4H9C6.24,4,4,6.24,4,9v32c0,2.76,2.24,5,5,5h32c2.76,0,5-2.24,5-5V9C46,6.24,43.76,4,41,4z M17,20v19h-6V20H17z M11,14.47c0-1.4,1.2-2.47,3-2.47s2.93,1.07,3,2.47c0,1.4-1.12,2.53-3,2.53C12.2,17,11,15.87,11,14.47z M39,39h-6c0,0,0-9.26,0-10 c0-2-1-4-3.5-4.04h-0.08C27,24.96,26,27.02,26,29c0,0.91,0,10,0,10h-6V20h6v2.56c0,0,1.93-2.56,5.81-2.56 c3.97,0,7.19,2.73,7.19,8.26V39z\"/></svg>"),
	Rules: []string{
		"||bizographics.com^",
		"||cs1404.wpc.epsiloncdn.net^",
		"||cs767.wpc.epsiloncdn.net^",
		"||l-0005.dc-msedge.net^",
		"||l-0005.l-dc-msedge.net^",
		"||l-0005.l-msedge.net^",
		"||l-0015.l-msedge.net^",
		"||licdn.cn^",
		"||licdn.com^",
		"||linkedin.at^",
		"||linkedin.be^",
		"||linkedin.cn^",
		"||linkedin.com^",
		"||linkedin.nl^",
		"||linkedin.qtlcdn.com^",
		"||lnkd.in^",
	},
	GroupID: "social_network",
}, {
	ID:      "lionsgateplus",
	Name:    "Lionsgate+",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-21 2 120 120\"><path d=\"M35 3.7v84.8h43.9v31.8H0V3.7Z\"/></svg>"),
	Rules: []string{
		"||lionsgateplus.com^",
		"||starz.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "looke",
	Name:    "Looke",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -28 100 100\"><path d=\"m16.1.1-2-.1C7 0 0 5.2 0 11.2 0 15.4 2.4 17 6.2 17 5 16 4 14.8 4 11.4 4 7 6.7 4 11 2.8v33.5h1c6.1 0 10.5 7.5 15.5 7.5 3.3 0 5.3-2.3 5.3-5 0-.4 0-.8-.2-1.2a9 9 0 0 1-3.6 1c-5.4 0-8.8-3.4-12.9-4.3V.3z\"/><path d=\"M31.6 11.2c-7.1 0-9.3 7.7-9.3 13.2 0 8.2 4.7 11.1 9 11.1 5 0 8-4.7 8-12.5v-2c3-.4 6-1.8 7.3-3.9L46 16a9.2 9.2 0 0 1-6.5 2.8H39c-.6-4.2-2.5-7.5-7.5-7.5zm.5 20.7c-2.1 0-4.6-1.5-4.6-7.7 0-4.6 1.4-10.4 5.4-10.4 1.4 0 2.6.8 3.4 3-1.2 0-2 .5-2 2 0 1.6.9 2.3 2.7 2.4v1.1c0 6-1.6 9.6-4.9 9.6z\"/><path d=\"M51.6 11.2c-7.1 0-9.3 7.7-9.3 13.2 0 8.2 4.7 11.1 9 11.1 5 0 8-4.7 8-12.5v-2c3-.4 6-1.8 7.3-3.9L66 16a9.2 9.2 0 0 1-6.5 2.8H59c-.6-4.2-2.5-7.5-7.5-7.5zm.5 20.7c-2.1 0-4.6-1.5-4.6-7.7 0-4.6 1.4-10.4 5.4-10.4 1.4 0 2.6.8 3.4 3-1.2 0-2 .5-2 2 0 1.6.9 2.3 2.7 2.4v1.1c0 6-1.6 9.6-4.9 9.6z\"/><path d=\"M63 2.6v32.6h4.7v-10c1-2.8 2.2-3.7 3.9-3.7 1.6 0 3 .8 3 4.2V30c0 3 1.5 5.4 5.3 5.4 2 0 5.2-.6 6.6-8.8h-1.7c-.8 3.6-2 5.2-3.6 5.2-1.7 0-1.9-1.6-1.9-2.5l.2-4.1c0-3.1-.8-7.4-6.5-7.4h-.5l8-6.5h-4.6l-8.2 7.8V1.9Z\"/><path d=\"M99.6 17.4c0-5-3.2-6.2-6.4-6.2-6.8 0-9 8-9 13.3 0 8 4.8 11 9 11 3.6 0 6.8-1.9 6.8-4.7l-.1-1.2c-1.2 1.7-3.1 2.3-5.2 2.3-2.7 0-5-1.1-5.5-6.2 6.5-.7 10.4-3.9 10.4-8.3zm-10.4 6.5c0-4.7 1.6-10.4 5-10.4 1.5 0 2.3 1 2.3 3.4 0 3.6-2.8 6.2-7.3 7z\"/></svg>"),
	Rules: []string{
		"||looke.com.br^",
		"||ottvs.com.br^",
	},
	GroupID: "streaming",
}, {
	ID:      "mail_ru",
	Name:    "Mail.ru",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M256 141.176c-63.306 0-114.809 51.503-114.809 114.809S192.694 370.795 256 370.795s114.809-51.503 114.809-114.809S319.306 141.176 256 141.176zm0 188.254c-40.498 0-73.445-32.947-73.445-73.445 0-40.498 32.947-73.445 73.445-73.445 40.499 0 73.445 32.947 73.445 73.445 0 40.498-32.946 73.445-73.445 73.445z\" /><path d=\"M437.008 74.97C388.656 26.623 324.375 0 256 0h-.017C187.603.004 123.318 26.637 74.97 74.992 26.62 123.347-.005 187.637 0 256.017c.004 68.379 26.637 132.666 74.992 181.014C123.344 485.377 187.625 512.001 256 512h.017c55.945-.004 111.216-18.738 155.631-52.752 9.07-6.945 10.792-19.927 3.846-28.995-6.945-9.069-19.926-10.794-28.995-3.846-37.24 28.518-83.58 44.224-130.486 44.228h-.014c-57.324 0-111.224-22.324-151.761-62.856-40.542-40.536-62.871-94.435-62.875-151.766-.006-118.35 96.273-214.641 214.623-214.649H256c118.34 0 214.628 96.279 214.636 214.622v23.532c0 27.523-22.39 49.913-49.913 49.913-27.523 0-49.913-22.391-49.913-49.913v-23.532c0-11.422-9.259-20.682-20.682-20.682s-20.682 9.26-20.682 20.682v23.532c0 50.33 40.947 91.278 91.278 91.278S512 329.848 512 279.518v-23.534c-.005-68.38-26.638-132.666-74.992-181.014z\" /></svg>"),
	Rules: []string{
		"||imgsmail.ru^",
		"||mail.ru^",
		"||mycdn.me^",
	},
	GroupID: "social_network",
}, {
	ID:      "mastodon",
	Name:    "Mastodon",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M433 179.11c0-97.2-63.71-125.7-63.71-125.7-62.52-28.7-228.56-28.4-290.48 0 0 0-63.72 28.5-63.72 125.7 0 115.7-6.6 259.4 105.63 289.1 40.51 10.7 75.32 13 103.33 11.4 50.81-2.8 79.32-18.1 79.32-18.1l-1.7-36.9s-36.31 11.4-77.12 10.1c-40.41-1.4-83-4.4-89.63-54a102.54 102.54 0 0 1-.9-13.9c85.63 20.9 158.65 9.1 178.75 6.7 56.12-6.7 105-41.3 111.23-72.9 9.8-49.8 9-121.5 9-121.5zm-75.12 125.2h-46.63v-114.2c0-49.7-64-51.6-64 6.9v62.5h-46.33V197c0-58.5-64-56.6-64-6.9v114.2H90.19c0-122.1-5.2-147.9 18.41-175 25.9-28.9 79.82-30.8 103.83 6.1l11.6 19.5 11.6-19.5c24.11-37.1 78.12-34.8 103.83-6.1 23.71 27.3 18.4 53 18.4 175z\"/></svg>"),
	Rules: []string{
		"||aus.social^",
		"||awscommunity.social^",
		"||climatejustice.social^",
		"||cupoftea.social^",
		"||cyberplace.social^",
		"||defcon.social^",
		"||det.social^",
		"||glasgow.social^",
		"||h4.io^",
		"||hachyderm.io^",
		"||hessen.social^",
		"||hostux.social^",
		"||ieji.de^",
		"||indieweb.social^",
		"||infosec.exchange^",
		"||ioc.exchange^",
		"||kolektiva.social^",
		"||livellosegreto.it^",
		"||lor.sh^",
		"||lou.lt^",
		"||m.cmx.im^",
		"||mas.to^",
		"||masto.ai^",
		"||masto.es^",
		"||masto.nu^",
		"||masto.pt^",
		"||mastodon.au^",
		"||mastodon.bida.im^",
		"||mastodon.com.tr^",
		"||mastodon.eus^",
		"||mastodon.green^",
		"||mastodon.ie^",
		"||mastodon.iriseden.eu^",
		"||mastodon.nl^",
		"||mastodon.nu^",
		"||mastodon.nz^",
		"||mastodon.online^",
		"||mastodon.online^",
		"||mastodon.scot^",
		"||mastodon.sdf.org^",
		"||mastodon.social^",
		"||mastodon.social^",
		"||mastodon.top^",
		"||mastodon.uno^",
		"||mastodon.world^",
		"||mastodon.zaclys.com^",
		"||mastodonapp.uk^",
		"||mastodont.cat^",
		"||mastodontech.de^",
		"||mastodontti.fi^",
		"||mastouille.fr^",
		"||mathstodon.xyz^",
		"||metalhead.club^",
		"||mindly.social^",
		"||mstdn.ca^",
		"||mstdn.jp^",
		"||mstdn.party^",
		"||mstdn.plus^",
		"||mstdn.social^",
		"||muenchen.social^",
		"||muenster.im^",
		"||nerdculture.de^",
		"||noc.social^",
		"||norden.social^",
		"||nrw.social^",
		"||o3o.ca^",
		"||ohai.social^",
		"||piaille.fr^",
		"||pol.social^",
		"||ravenation.club^",
		"||rollenspiel.social^",
		"||ruby.social^",
		"||ruhr.social^",
		"||sfba.social^",
		"||socel.net^",
		"||social.anoxinon.de^",
		"||social.cologne^",
		"||social.dev-wiki.de^",
		"||social.linux.pizza^",
		"||social.politicaconciencia.org^",
		"||social.vivaldi.net^",
		"||stranger.social^",
		"||sueden.social^",
		"||tech.lgbt^",
		"||techhub.social^",
		"||theblower.au^",
		"||tkz.one^",
		"||todon.eu^",
		"||toot.aquilenet.fr^",
		"||toot.community^",
		"||toot.funami.tech^",
		"||toot.io^",
		"||toot.wales^",
		"||troet.cafe^",
		"||union.place^",
		"||universeodon.com^",
		"||urbanists.social^",
		"||wien.rocks^",
		"||wxw.moe^",
	},
	GroupID: "social_network",
}, {
	ID:      "mercado_libre",
	Name:    "Mercado Libre",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 256 256\"><path d=\"M114 56.6c-10.8 1.3-23.7 4-32.6 6.9C31.3 79.9 8.6 119.2 29 154.7c9.3 16.2 31 31.5 55 38.7 16 4.7 25.2 6 44 6 12.6 0 20-.5 26.5-1.7 48.6-9.5 79.9-36.8 79.9-69.7 0-14.3-5.3-26.4-16.6-38.6-13.8-14.7-35-25.4-60.7-30.5-9.3-1.8-35.3-3.2-43.1-2.3zm39 7.1c16.2 2.6 38.4 10.9 47.5 17.9 2.4 1.8 1.6 2.5-6.2 4.9-9.5 3-21.9 1.7-39.2-3.9-22.2-7.2-29-7.2-41.2.3-5 3.2-13.2 5.4-23.5 6.6-6.6.7-17.8-1.4-28.8-5.6-6.9-2.5-6.9-2.6 4.9-8.6C90.9 62.9 122 58.7 153 63.7zm-13.7 19.9c3.9.9 10.1 2.8 13.6 4.1 9.3 3.5 21.8 6.3 28.1 6.3 6.4 0 15.6-2.2 21.7-5.1 5.3-2.5 6.5-1.9 13.4 6.4 5.1 6.1 11.9 18.6 11.9 21.8 0 1.2-1.3 1.9-4.7 2.4-7.3 1.1-20.9 5.3-29.6 9.1l-7.8 3.4-11.7-10.9C153.4 101.6 141 93 133.6 93c-4.8 0-13.2 3.9-22.7 10.5-5.8 4.1-8.7 5.5-11.3 5.5-4.9 0-5.2-1.4-1.3-6 6.8-8 21.5-18.5 28-20 4.7-1.2 5.2-1.1 13 .6zm-65.6 9.5c6.7 1.6 10.8 2 17.1 1.6l8.3-.5-4.6 4.9c-7 7.5-6.2 12.8 2.3 15.4 4.1 1.2 8.6-.4 15.7-5.6 13.7-10 20.2-12.2 26.8-9 6.1 3 19.9 14.4 34.5 28.6l12.7 12.3-2.1 2.9c-1.2 1.5-3 2.8-4.1 2.8-1.2 0-6.5-4-12.2-9.2-10-9-13.1-10.5-13.1-6.3 0 1 3.8 5.3 8.4 9.5 4.7 4.2 8.7 8.3 9 9 .7 2-3.2 6.5-5.6 6.5-1.2 0-5.3-3.2-9.9-7.6-5.2-5.1-8.3-7.5-9.4-7.1-2.9 1.2-1.5 4.2 5.4 11.2 6 6 6.8 7.3 6 9.3-.4 1.2-2 2.7-3.4 3.4-2.4 1.1-3 .8-8.8-5-6.3-6.2-9.2-7.5-10.4-4.6-.4 1 .9 3.1 3.7 5.9 2.3 2.4 4 4.8 3.6 5.3-.9 1.5-5.7 2.1-8.3 1.1-1.9-.7-2.3-1.6-2.3-5 0-7.5-4.2-12.9-10-12.9-1.5 0-2-.7-2-2.8 0-6.4-5.9-11.1-11.9-9.5-1.6.4-3-.3-5.2-2.5-3.5-3.5-8.1-4.8-12.1-3.3-2 .8-3.4.6-6.4-1-4.7-2.3-6.8-2.4-10.3-.3-2.6 1.6-3 1.5-6.7-.8-9-5.7-29.7-12.8-37-12.8-1.2 0-2.5-.4-2.8-.9-.3-.5 1.2-4.6 3.5-9 2.8-5.7 6.1-10.2 10.9-15.1l6.8-6.9 7.6 3c4.2 1.6 11.5 3.9 16.3 5zm-31.2 31.6c3.9 1 11.5 4 17 6.8l10 5-.3 4.3c-.3 3.7.1 4.7 3.1 7.7 2.1 2.1 4.5 3.5 6 3.5 1.8 0 2.8.8 3.7 3 1.7 4.2 4.7 6 9.7 6 3.7 0 4.5.4 5.7 2.9 1.7 3.2 3.4 4.1 7.9 4.1 2 0 4.1.9 5.8 2.6 4 3.8 10.2 4.9 14.9 2.6 3.1-1.5 4.1-1.6 6.6-.5 4.2 1.8 9.4 1.6 12.9-.5 2-1.2 4.3-1.7 7.1-1.4 3.5.3 4.7-.1 7.8-2.8 2-1.8 3.6-3.8 3.6-4.5 0-.7 1.7-1.5 3.9-1.9 3.6-.5 9.1-5.1 9.1-7.6 0-.4 1.4-1 3.1-1.4 6.8-1.3 11.7-7.6 10.6-13.5-.6-2.7-.3-3 5.1-5.4 6.7-3 20.1-7.2 25.7-8.2 2.2-.4 4.8-.9 5.9-1.2 1.7-.5 1.8 0 1.4 7.5-.8 14-9.6 28.6-23.5 39.1-20.3 15.3-47 23.3-77.3 23.3-23.5 0-44.1-4.6-62-13.8-17.3-9-28.2-19.3-34.9-33.3-3-6.4-3.6-8.7-3.9-16.4l-.5-9 4.4.6c2.4.4 7.6 1.5 11.4 2.4zm42 13.3c1.8 3.5 3.5 3.8 6 1 1.4-1.5 2.9-2 5.4-1.8 3 .2 3.9.9 5 3.5 1.6 3.7 3.5 4.7 6.1 3.3 3.1-1.6 6.8-1.2 8 1 .6 1.1.7 3.7.4 6l-.7 4h4.6c3.7 0 4.9.5 6.6 2.6 2.7 3.5 2.6 5.9-.4 8.9-4.3 4.4-10.6 2.4-12.9-3.9-.6-1.8-2.3-1.8-6.9 0-1.8.7-4.7-2.1-4.7-4.5 0-3.2-2.1-4.1-6.8-2.8-5.1 1.4-7.3-.2-7.7-5.4-.2-1.9-.3-3.8-.4-4.2-.1-.4-2.3-.5-5.1-.1-4.7.6-5 .5-6-2-2.6-7 6.1-12.2 9.5-5.6z\"/></svg>"),
	Rules: []string{
		"||mercadolibre.cl^",
		"||mercadolibre.co.cr^",
		"||mercadolibre.com.ar^",
		"||mercadolibre.com.bo^",
		"||mercadolibre.com.co^",
		"||mercadolibre.com.do^",
		"||mercadolibre.com.ec^",
		"||mercadolibre.com.gt^",
		"||mercadolibre.com.hn^",
		"||mercadolibre.com.mx^",
		"||mercadolibre.com.ni^",
		"||mercadolibre.com.pa^",
		"||mercadolibre.com.pe^",
		"||mercadolibre.com.py^",
		"||mercadolibre.com.sv^",
		"||mercadolibre.com.uy^",
		"||mercadolibre.com.ve^",
		"||mercadolibre.com^",
		"||mercadolivre.com.br^",
		"||mlstatic.com^",
	},
	GroupID: "shopping",
}, {
	ID:      "minecraft",
	Name:    "Minecraft",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 50 50\"><path d=\"M 10.5 4 C 10.066406 4 9.695313 4.273438 9.5625 4.6875 L 0.0625 34.28125 C -0.0546875 34.648438 0.0273438 35.078125 0.3125 35.34375 L 10.40625 44.71875 C 10.589844 44.890625 10.839844 45 11.09375 45 L 22 45 C 22.449219 45 22.851563 44.683594 22.96875 44.25 L 24.3125 39.34375 C 24.40625 39.371094 24.492188 39.40625 24.59375 39.40625 L 27.03125 39.40625 L 31.65625 44.65625 C 31.847656 44.875 32.117188 45 32.40625 45 L 43.6875 45 C 44.167969 45 44.597656 44.660156 44.6875 44.1875 L 49.96875 16.1875 C 50.011719 15.96875 49.976563 15.730469 49.875 15.53125 L 44.1875 4.53125 C 44.015625 4.199219 43.6875 4 43.3125 4 L 31.90625 4 C 31.449219 4 31.050781 4.308594 30.9375 4.75 L 29.8125 9.125 L 27.46875 9.1875 C 27.03125 9.203125 26.648438 9.515625 26.53125 9.9375 L 26.46875 10.125 L 22.3125 4.40625 C 22.125 4.148438 21.820313 4 21.5 4 Z M 11.21875 6 L 20.09375 6 L 18.71875 10.59375 L 9.75 10.59375 Z M 32.6875 6 L 41.96875 6 L 39.6875 15.59375 L 35 15.59375 C 35.046875 15.449219 35.074219 15.3125 35.09375 15.15625 L 35.59375 11.71875 C 35.703125 10.734375 35.359375 10.113281 35.0625 9.78125 C 34.78125 9.46875 34.277344 9.09375 33.40625 9.09375 L 31.875 9.09375 Z M 30.625 11.09375 L 33.40625 11.09375 C 33.542969 11.09375 33.589844 11.125 33.59375 11.125 C 33.609375 11.152344 33.644531 11.277344 33.625 11.46875 L 33.09375 14.875 C 33.050781 15.273438 32.679688 15.5 32.3125 15.5 C 32.15625 15.5 32.007813 15.53125 31.875 15.59375 L 27.125 15.59375 L 28.0625 12.15625 C 28.089844 12.054688 28.097656 11.945313 28.09375 11.84375 L 28.28125 11.1875 Z M 9.125 12.59375 L 20.71875 12.59375 L 19.71875 16.34375 C 19.640625 16.644531 19.714844 16.972656 19.90625 17.21875 C 20.09375 17.464844 20.378906 17.59375 20.6875 17.59375 L 39.25 17.59375 L 35.78125 33.6875 L 27 33.6875 L 29.96875 22.65625 C 30.050781 22.355469 29.96875 22.027344 29.78125 21.78125 C 29.59375 21.535156 29.3125 21.40625 29 21.40625 L 25.5 21.40625 C 25.046875 21.40625 24.648438 21.71875 24.53125 22.15625 L 23.21875 27 L 19.125 27 L 20.375 22.5625 C 20.460938 22.261719 20.375 21.9375 20.1875 21.6875 C 20 21.4375 19.71875 21.3125 19.40625 21.3125 L 15.90625 21.3125 C 15.460938 21.3125 15.0625 21.605469 14.9375 22.03125 L 13.8125 25.90625 C 13.742188 26 13.660156 26.101563 13.625 26.21875 L 13.59375 26.40625 L 10.15625 26.40625 L 10.5625 25.1875 C 10.75 24.53125 10.628906 23.84375 10.25 23.34375 C 9.890625 22.867188 9.320313 22.59375 8.6875 22.59375 L 5.90625 22.59375 Z M 5.25 24.59375 L 8.65625 24.59375 L 8.28125 25.71875 C 8.089844 26.167969 8.042969 26.613281 8.15625 27.03125 C 7.808594 27.316406 7.5625 27.6875 7.4375 28.125 L 7.0625 29.46875 C 6.773438 30.195313 6.832031 30.976563 7.21875 31.5625 C 7.53125 32.035156 8.183594 32.59375 9.59375 32.59375 L 11.8125 32.59375 L 11.53125 33.5 L 2.375 33.59375 Z M 10.09375 28.40625 L 13 28.40625 L 12.375 30.59375 L 9.59375 30.59375 C 9.015625 30.59375 8.875 30.46875 8.875 30.46875 C 8.863281 30.441406 8.851563 30.316406 8.90625 30.1875 C 8.921875 30.148438 8.957031 30.101563 8.96875 30.0625 L 9.375 28.6875 C 9.410156 28.558594 9.714844 28.40625 10.09375 28.40625 Z\"/></svg>"),
	Rules: []string{
		"||minecraft.net^",
		"||minecraftservices.com^",
		"||mojang.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "nebula",
	Name:    "Nebula",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50.8 50.8\"><path d=\"m20.404 31.36 4.847 14.195 4.6-14.295 14.988-.05-11.97-9.002 4.748-14.344-12.316 9.002-12.416-9.15 4.65 14.492-11.773 9.003Z\"/></svg>"),
	Rules: []string{
		"||nebula.app^",
		"||nebula.tv^",
	},
	GroupID: "streaming",
}, {
	ID:      "netflix",
	Name:    "Netflix",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 30 30\"><path d=\"M24,4H6C4.895,4,4,4.895,4,6v18c0,1.105,0.895,2,2,2h18c1.105,0,2-0.895,2-2V6C26,4.895,25.105,4,24,4z M19,22c0,0-1.5-0.232-3-0.232l-2-5.507v5.507c-1.5,0-3,0.232-3,0.232V8h3l2,5.6V8h3V22z\" /></svg>"),
	Rules: []string{
		"|netflix.com.edgesuite.net^",
		"||dualstack.apiproxy-*.amazonaws.com^",
		"||dualstack.ichnaea-web-*.amazonaws.com^",
		"||fast.com^",
		"||netflix.ca^",
		"||netflix.com^",
		"||netflix.net^",
		"||netflixdnstest1.com^",
		"||netflixdnstest10.com^",
		"||netflixdnstest2.com^",
		"||netflixdnstest3.com^",
		"||netflixdnstest4.com^",
		"||netflixdnstest5.com^",
		"||netflixdnstest6.com^",
		"||netflixdnstest7.com^",
		"||netflixdnstest8.com^",
		"||netflixdnstest9.com^",
		"||netflixinvestor.com^",
		"||netflixtechblog.com^",
		"||nflxext.com^",
		"||nflximg.com^",
		"||nflximg.net^",
		"||nflxsearch.net^",
		"||nflxso.net^",
		"||nflxvideo.net^",
	},
	GroupID: "streaming",
}, {
	ID:      "nintendo",
	Name:    "Nintendo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M6 7v36h12.6V21.75l13 20.78.27.47H44V7H31.4v1l.04 20.22L18.5 7.47 18.22 7Zm2 2h9.1l14.5 23.22 1.84 3v-3.5L33.4 9H42v32h-9L18.44 17.75l-1.85-2.94V41H8Z\"/></svg>"),
	Rules: []string{
		"||nintendo-europe.com^",
		"||nintendo.be^",
		"||nintendo.co.jp^",
		"||nintendo.co.uk^",
		"||nintendo.com.au^",
		"||nintendo.com^",
		"||nintendo.de^",
		"||nintendo.es^",
		"||nintendo.eu^",
		"||nintendo.fr^",
		"||nintendo.it^",
		"||nintendo.jp^",
		"||nintendo.net^",
		"||nintendo.nl^",
		"||nintendo.pt^",
		"||nintendoswitch.cn^",
		"||nintendowifi.net^",
	},
	GroupID: "gaming",
}, {
	ID:      "nvidia",
	Name:    "Nvidia",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 48 48\"><path d=\"M20 8a2 2 0 0 0-2 2v2.55l.84-.05c10.76-.37 17.78 8.82 17.78 8.82s-8.05 9.8-16.44 9.8c-.73 0-1.47-.07-2.18-.19v-2.2c.73.23 1.52.35 2.3.35 5.88 0 11.35-7.6 11.35-7.6s-5.07-6.91-12.81-6.66l-.82.03v-2.3c-9.49.77-17.68 8.8-17.68 8.8S4.97 34.76 18 35.98v-2.44c.59.07 1.22.12 1.81.12 7.82 0 13.47-3.99 18.94-8.7.91.73 4.62 2.49 5.4 3.26-5.2 4.36-17.33 7.86-24.2 7.86-.66 0-1.32-.03-1.95-.1V38c0 1.1.9 2 2 2h25a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2H20zm-2 6.86v2.82a11.8 11.8 0 0 1 1.57-.07c4.95 0 7.9 3.85 7.9 3.85l-4.03 3.39c-1.8-3.02-2.43-4.35-5.44-4.7v8.57c-4.06-1.38-5.4-6.14-5.4-6.14s2.37-2.83 5.38-2.46H18v-2.44a15.66 15.66 0 0 0-9.22 4.46s2 7.52 9.22 8.8v2.6c-9.56-1.17-12.82-11.7-12.82-11.7s4.27-6.3 12.82-6.97z\"/></svg>"),
	Rules: []string{
		"||geforce.com^",
		"||geforcenow.com^",
		"||nvidia.cn^",
		"||nvidia.com.global.ogslb.com^",
		"||nvidia.com^",
		"||nvidia.eu^",
		"||nvidia.partners^",
		"||nvidiagrid.net^",
		"||nvidianews.com^",
		"||tegrazone.com^",
	},
	GroupID: "software",
}, {
	ID:      "odysee",
	Name:    "Odysee",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-11 2 178 178\"><path d=\"M82 57c-14 5-20-2-21-14-1-13 12-17 12-17 14-5 18 2 21 12s1 14-12 19m65 85-9-28a67 67 0 0 0-21-23 5 5 0 0 1 0-8c7-6 18-18 22-25 3-4 7-13 8-20 0-6-1-12-8-15s-11 1-11 1c-5 3-6 12-9 21-4 10-10 11-13 11s-1-3-9-24c-7-21-26-17-40-9-19 11-11 35-6 50-3 2-12 4-21 9l-15 8c-6 6-9 11-7 19a12 12 0 0 0 6 7c5 2 13-1 24-10 9-6 19-9 19-9l13 24c7 13-7 17-8 17-2 0-23-2-18 16s31 12 44 3c14-9 10-38 10-38 13-2 17 12 19 19 1 7-2 19 11 20a21 21 0 0 0 6-1c7-2 11-5 13-9a9 9 0 0 0 0-6M88 33a9 9 0 0 0-2-3h-2v2l1 2 1 1h1l1-3m0 7-1 2a7 7 0 0 1 1 5l1 2h1l1-1c1-3 0-5-1-7l-2-1\"/></svg>"),
	Rules: []string{
		"||odycdn.com^",
		"||odysee.com^",
		"||odysee.live^",
		"||odysee.tv^",
	},
	GroupID: "social_network",
}, {
	ID:      "ok",
	Name:    "OK.ru",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 96 96\"><path d=\"M50 28c-3.313 0-6 2.688-6 6 0 3.313 2.688 6 6 6 3.313 0 6-2.688 6-6 0-3.313-2.688-6-6-6zm0 0\" /><path d=\"M50 4C24.637 4 4 24.637 4 50s20.637 46 46 46 46-20.637 46-46S75.363 4 50 4zm0 16c7.73 0 14 6.27 14 14s-6.27 14-14 14-14-6.27-14-14 6.27-14 14-14zm14.828 49.172A3.999 3.999 0 0 1 62 76a3.987 3.987 0 0 1-2.828-1.172L50 65.656l-9.172 9.172a3.999 3.999 0 0 1-5.656 0 3.999 3.999 0 0 1 0-5.656l6.43-6.43c-1.836-.539-3.618-1.207-5.29-2.066A4.302 4.302 0 0 1 34 56.859c0-2.98 3.172-4.761 5.809-3.375A21.767 21.767 0 0 0 50 56c3.684 0 7.148-.91 10.191-2.516C62.828 52.098 66 53.88 66 56.86c0 1.602-.89 3.078-2.313 3.813-1.671.863-3.453 1.531-5.289 2.07zm0 0\" /></svg>"),
	Rules: []string{
		"||insideok.ru^",
		"||ok.games^",
		"||ok.ru^",
		"||okcdn.ru^",
		"||oktech.ru^",
		"||st.mycdn.me^",
	},
	GroupID: "social_network",
}, {
	ID:      "olvid",
	Name:    "Olvid",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 250 250\"><path d=\"M51 2.5c-18.4 4-35 17.3-43.3 34.6C.3 52.4.5 50.3.5 126v67.5l2.3 8c3.4 11.7 8.3 19.8 17.6 29 5.9 5.9 10.1 9 15.6 11.7 14.2 7 12.9 6.9 91.3 6.6 69.5-.3 70.3-.3 76-2.5 17.3-6.6 30.3-17.7 37.4-32 7.5-14.9 7.4-13.9 7.1-92.3-.3-68.8-.3-69.6-2.5-76-3.3-9.6-9-18.6-16.3-26-7.6-7.5-14.8-12-25.2-15.8l-7.3-2.7-69.5-.2c-56.7-.1-70.7.1-76 1.2zm95 39.9c39.6 9.5 66 42.4 66 82.1 0 32.6-17.1 60.1-46.5 74.6-14.9 7.4-23 9.2-40.5 9.2-17.3 0-25.5-1.8-39.7-8.8A85.66 85.66 0 0 1 40.4 145c-2.5-9.1-2.5-31.9 0-41 9.3-33.7 34.8-56.6 70.4-63 6.9-1.3 27.7-.5 35.2 1.4z\"/><path d=\"M113.5 78.4a43.05 43.05 0 0 0-29 23.9c-10.1 21.4-4.2 47.7 13.8 61.4 1.7 1.4 2.5 2.7 2.1 3.7-.9 2.3-9.1 8.1-16.2 11.4l-6.2 2.9 3.8.7c10.4 1.7 31.4-.2 44.2-4 17.5-5.2 32.8-17.4 39.5-31.5 5-10.5 6.4-20.9 4.3-31.6-2.9-14.6-10-25.4-20.9-32-9.9-5.9-23.7-7.8-35.4-4.9z\"/></svg>"),
	Rules: []string{
		"||olvid-attachment-chunks.s3.eu-west-3.amazonaws.com^",
		"||olvid.io^",
	},
	GroupID: "messenger",
}, {
	ID:      "onlyfans",
	Name:    "OnlyFans",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M157 97c-23.9 3.1-43.2 9.7-63.5 21.8-24.7 14.7-47.6 39.5-60.8 65.8-5.3 10.5-12 30-13.7 39.4-.6 3.6-1.4 7.6-1.7 9-1 4.8-1.2 35.6-.2 43 1.2 9.1 5.8 29.1 7 30.4.5.6.9 1.6.9 2.4 0 2.5 8.2 20.3 12.9 28.2 8.8 14.6 12.9 19.8 25.7 32.6 21.9 22 49.5 36.9 79.4 43.1 17.9 3.7 42.5 4.2 60 1.2 30.9-5.2 60.2-19.9 83.1-41.7 14.3-13.6 25.2-28.6 35.4-48.7 1.8-3.6 2.4-4 6.5-4.3 7.4-.5 23.9-4.1 33.2-7.2 20-6.7 39.1-19.1 52.3-34.1 13.5-15.3 21.7-30.3 28.1-50.9 1.8-5.8 3.1-10.6 3-10.8-.2-.1-2.7.3-5.7.8-13.7 2.7-19.5 3.2-38.9 3.5-16.5.3-27.8-.7-39-3.4-4.1-1-3.5-1.2 7-3.6 13.7-3.2 31.3-9.5 44.5-16 16.4-8.1 17.5-8.8 28.2-16.7 19.7-14.7 33.7-31.5 44.4-53.3 4.1-8.5 10.9-27.6 10.9-30.7 0-1-129.5-.6-133.5.4-1.1.3-4.7.9-8 1.2-31 3.6-52.9 13.4-69.6 31.3l-4.6 4.9-3.9-3.3c-16.8-14.3-43.9-27.1-67.4-32-14.2-2.9-38.6-4-52-2.3zm33.6 113.4c6.8 2.1 16 8.2 21.3 14.2 4.7 5.2 9.6 14.7 10.7 20.4 3.3 17.8-1.3 33.1-13.6 45.1-3.8 3.8-7.5 6.9-8.2 6.9-.6 0-1.9.6-2.7 1.3-2.8 2.4-13.1 5-20.8 5.2-13.9.5-25-4-35-14.1-4.1-4-7.4-8.5-9.3-12.6-10.5-22.7-2.6-49 18.6-61.8 11-6.6 26.5-8.4 39-4.6z\"/></svg>"),
	Rules: []string{
		"||onlyfans.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "origin",
	Name:    "Origin",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M 12 4 C 11.539063 4 11.09375 4.046875 10.65625 4.121094 C 11.082031 3.183594 11.550781 2.445313 12 2 C 12.195313 1.804688 12.011719 1.484375 11.738281 1.539063 C 7.808594 2.359375 4 7.0625 4 12 C 4 16.417969 7.582031 20 12 20 C 12.460938 20 12.90625 19.953125 13.34375 19.878906 C 12.917969 20.816406 12.449219 21.554688 12 22 C 11.804688 22.195313 11.988281 22.515625 12.261719 22.460938 C 16.191406 21.640625 20 16.9375 20 12 C 20 7.582031 16.417969 4 12 4 Z M 12 15 C 10.34375 15 9 13.65625 9 12 C 9 10.34375 10.34375 9 12 9 C 13.65625 9 15 10.34375 15 12 C 15 13.65625 13.65625 15 12 15 Z\" /></svg>"),
	Rules: []string{
		"|cloudsync-prod.s3.amazonaws.com^",
		"|origin-a.akamaihd.net^",
		"|rtm.tnt-ea.com^",
		"|ssl-lvlt.cdn.ea.com^",
		"||accounts.ea.com^",
		"||dawngate.com^",
		"||eastore.com^",
		"||lordofultima.com^",
		"||origin.com^",
		"||origin.tv^",
		"||signin.ea.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "paramountplus",
	Name:    "Paramount Plus",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"180 60 200 200\"><path d=\"M260.2 203.3c-.9-.4-2.4-2 .1-6.6l5.6-11.8c.2-.4-.2-.8-.5-.5l-4.9 5c-2.3 2.4-6.3 9.3-7.1 10.6l-6 9.9c.6 0 1 .7.7 1.2l-5.5 9.2c-1.3 2.3 1.1 3.9 1.4 3.4 8.6-13.9 13.6-12.8 13.6-12.8l2.9-6.7c.3-.4.1-.8-.3-.9\"/><path d=\"M279.8 87.2c-49.3 0-89.3 40-89.3 89.3 0 19.9 6.5 38.2 17.4 53 3.7-1.6 5.8-4 7.3-5.9l16.6-21.3c.4-.4.8-.8 1.3-1l2.5-1.1 27.3-34.7 4-3.1 8.1-11.3c.2-.3.5-.6.8-.8l3.6-2.6c.9-.6 2.1-.7 3 0l4.3 3a17 17 0 0 1 5.4 6.2l17.3 30.3c.4.7.7 1 1.4 1.3 3.4 1.7 5.4 2 9.9 6.8 2.1 2.3 11.1 12.4 23.8 28.1 1.8 2.4 4 4.4 7.2 5.8a88.95 88.95 0 0 0 17.4-52.9c0-49.1-40-89.1-89.3-89.1m-65.2 94.1-5.8-1.9-3.6 4.9v-6.1l-5.8-1.9 5.8-1.9v-6.1l3.6 4.9 5.8-1.9-3.6 4.9 3.6 5.1zm-1.3 20-1.9 5.8-1.9-5.8h-6.1l4.9-3.6-1.9-5.8 4.9 3.6 4.9-3.6-1.9 5.8 4.9 3.6h-5.9zm1.1-46.1 1.9 5.8-4.9-3.6-4.9 3.6 1.9-5.8-4.9-3.6h6.1l1.9-5.8 1.9 5.8h6.1l-5.1 3.6zm9.8-13.1-3.6-4.9-5.8 1.9 3.6-4.9-3.6-4.9 5.8 1.9 3.6-4.9v6.1l5.8 1.9-5.8 1.9v5.9zm15.2-21.3-1.9 5.8-1.9-5.8h-6.1l4.9-3.6-1.9-5.8 4.9 3.6 4.9-3.6-1.9 5.8 4.9 3.6h-5.9zm19.2-9.7L255 116v-6.1l-5.8-1.9 5.8-1.9v-6l3.6 4.9 5.8-1.9-3.6 4.9 3.6 4.9-5.8-1.8zm24.3-5.7 1.9 5.8-4.9-3.6-4.9 3.6 1.9-5.8-4.9-3.6h6.1L280 96l1.9 5.8h6.1l-5.1 3.6zm21.8 4.5v6.1l-3.6-4.9-5.8 1.9 3.6-4.9-3.6-4.9 5.8 1.9 3.6-4.9v6.1l5.8 1.9-5.8 1.7zm40.3 61.5 5.8 1.9 3.6-4.9v6.1l5.8 1.9-5.8 1.9v6.1l-3.6-4.9-5.8 1.9 3.6-4.9-3.6-5.1zm-22.9-44.8-1.9-5.8h-6.1l4.9-3.6-1.9-5.8 4.9 3.6 4.9-3.6-1.9 5.8 4.9 3.6H324l-1.9 5.8zm13.4 15.5v-6l-5.8-1.9 5.8-1.9v-6.1l3.6 4.9 5.8-1.9-3.6 4.9 3.6 4.9-5.8-1.9-3.6 5zm10.9 9.5 1.9-5.8 1.9 5.8h6.1l-4.9 3.6 1.9 5.8-4.9-3.6-4.9 3.6 1.9-5.8-4.9-3.6h5.9zm3.8 49.7-1.9 5.8-1.9-5.8h-6.1l4.9-3.6-1.9-5.8 4.9 3.6 4.9-3.6-1.9 5.8 4.9 3.6h-5.9z\"/><path d=\"M312.2 228.1c.4-.6 1.1-2.3-.2-5.5l-3.9-10.6c-.5-1.4.6-2.2 1.4-1.3 0 0 7.5 8.6 9.4 12.2l3.7 6.1c3.2.2 11.9.5 20.3.5-.8-.8-1.6-1.7-2.4-2.7C326.1 209 317 199.1 317 199c-2.9-3.2-4.3-3.8-6.5-4.8-.3-.1-.7-.3-1-.5v2.7c0 .4-.4.5-.6.2l-21.1-37.1-.1-.1c-.9-1.7-2.2-3.2-3.8-4.4l-2.1-1.4-10.1 23.2c1.6 0 2.6 1.6 2 3l-9.3 21.5h8.5c3.3 0 6.6.6 9.6 1.9l2.2.9s-6.8 14-6.8 21.3c0 1.3.2 2.7.6 4h15.6l-.7-4.4c.2-.1 9.6 2.2 18.8 3.1\"/></svg>"),
	Rules: []string{
		"||paramountplus.com^",
		"||pplusstatic.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "peacock_tv",
	Name:    "Peacock TV",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-233 0 1964 1964\"><path d=\"M519.7 101.8h6.2c20.7 0 41.1.6 61.7 3.3l3.7.5a322.8 322.8 0 0 1 43.2 8c47.3 10.3 105.3 25.3 144 55.5v2l2.5.7a62 62 0 0 1 12.4 6.7l2.5 1.6c12.8 8.3 25 17.1 36.8 26.8l11.4 9.2c12.3 9.6 12.3 9.6 15.4 13.5a37 37 0 0 0 5.6 5.6c5.3 4.5 10.2 9.5 15 14.5a611.3 611.3 0 0 0 4 4c9 9 17.3 18.7 25.5 28.4l2.3 2.8c50.7 61 50.7 61 50.7 76.2l2 1c5.2 7.3 9 15.7 13 23.7a1540.5 1540.5 0 0 0 3 6.2c11.7 23.3 11.7 23.3 13 31.1h2c28 71.8 46.2 144.9 46.2 222.3v3.6c0 45.4-5 91.7-19.2 135.1l-1.1 3.3c-5 15.4-10.5 30.6-16.7 45.5l-.8 1.9a346.3 346.3 0 0 1-11.4 24.3h-2l-.5 1.6a84 84 0 0 1-8 17.5l-1.7 2.8a339.7 339.7 0 0 1-14.8 23.1l-1.5 2-9 13a600 600 0 0 0-4.2 5.8 161 161 0 0 1-15 18.6 176 176 0 0 0-8.5 10.3 217 217 0 0 1-8.8 10.3l-1.4 1.5c-10.4 11.5-10.4 11.5-16 16.1a47.3 47.3 0 0 0-5 5.2 96.5 96.5 0 0 1-13.6 13.2h-2v2c-1.6 1.4-1.6 1.4-3.8 3-3.8 2.9-7.3 6-10.9 9.3-6 5.6-12.5 10.5-19.3 15.2l-8.8 6.4-7 5a398 398 0 0 0-7.5 5.6c-11 8.1-22.8 14.8-34.6 21.7a673.5 673.5 0 0 0-8.4 5 330.7 330.7 0 0 1-62.2 28.5l-15 5.6a850 850 0 0 1-27.5 10.1 2134 2134 0 0 0-48 17.6 1789 1789 0 0 1-61 22.2c-5.8 2-11.4 4.1-17 6.4-8 3.2-16 6.2-24.2 9.2l-2.4.9a1593.7 1593.7 0 0 1-37 13 353 353 0 0 0-20.6 7.8 849 849 0 0 1-37.6 14l-2.1.8c-2.9 1-5 1.7-8.1 1.7l-1 2c-1.7.7-1.7.7-4 1.3-5.9 1.6-11.5 3.6-17.2 5.7a24 24 0 0 1-8.8 2l-1 2-5 2-2.3.9-2.4.8-2.7 1a4858.8 4858.8 0 0 1-12 4.4 1727.8 1727.8 0 0 0-6.4 2.3 1774.4 1774.4 0 0 1-9.2 3.3l-2.8 1-2.7 1-2.4.8c-3.2.7-5.2 0-8.1-1.5v-2h-2v-2h-2c-1.7-1.7-1.7-1.7-3.5-4-2.4-3-2.4-3-5.5-5v-2l-3-1v-2h-2v-2h-2v-2l-1.8-.8a21.7 21.7 0 0 1-5.7-4.5l-1.8-1.9-1.7-1.8a129.3 129.3 0 0 0-8.9-8.3 63 63 0 0 1-7.3-7.4 176.4 176.4 0 0 0-20.8-19.7 88.8 88.8 0 0 1-8-7.6v-2h-2l-5-6-1 664c-5.7 2.3-5.7 2.3-9.3 2.3h-62a32105.1 32105.1 0 0 1-69.7-.1H10c-6.2 0-6.2 0-7.3-1.2a58 58 0 0 1-.2-4v-27.6a20952.2 20952.2 0 0 1-.2-43 87531.5 87531.5 0 0 1 0-47.4l-.2-42.6a422579 422579 0 0 1-.5-200.8L1 1136.5v-2.1a812326.8 812326.8 0 0 1-.2-129.5v-6L.4 879.6a91455.8 91455.8 0 0 1-.1-97.9v-16a23348.6 23348.6 0 0 0-.2-41v-40a4694 4694 0 0 0 0-20.9 430.2 430.2 0 0 1 8.8-101l1-4.5c9.6-48.4 9.6-48.4 17.1-68 1.5-4 2.8-7.9 4-11.9a678.2 678.2 0 0 1 40.2-99.8 536.4 536.4 0 0 1 53-86l7.8-10.5c9.9-13.7 9.9-13.7 14-16.8 2.8-2.4 4.7-5 7-8 2.7-3.7 5.9-7 9-10.3l2-2a905.3 905.3 0 0 1 5.6-5.9l1.7-1.8 4.3-4.2h2v-2c1.4-1.6 1.4-1.6 3-3h2v-2c1.3-1.4 1.3-1.4 3.2-3l2.2-1.9 2.6-2 2.8-2.5 9.2-7.6 2.9-2.4 2.7-2.2 2.4-2c2-1.4 2-1.4 4-1.4l.7-1.8c1.5-2.6 2.8-3.6 5.3-5.2l2.7-1.8 3.3-2.2 4.1-2.8 13.9-9.2 1.9-1.3a379.8 379.8 0 0 1 44-24.7l2.5-1.2a1139.5 1139.5 0 0 1 18.6-8.8l2.4-1.1c32.4-15.1 69-24.4 104.2-30.1a81.6 81.6 0 0 0 8-1.8c5.6-1.4 11.4-2 17.1-2.7l5.8-.8c23.5-3 47-3.9 70.6-3.8zm-35.1 245.3-6.4.3a198 198 0 0 0-20.5 2.6l-3 .5c-5 .9-10 2-14.8 3.8-2.5.9-5 1.6-7.6 2.4a216 216 0 0 0-71.7 34.4 157.7 157.7 0 0 0-24.5 20.6l-9 8c-21.2 20.2-36.4 46.7-49.5 72.4l-1.5 3a312.7 312.7 0 0 0-27.5 84l-.5 2.7c-.6 3.7-.7 7.3-.6 11v15.6a11121.7 11121.7 0 0 0 0 60.3 94668.8 94668.8 0 0 1 0 173.3v191.2a8930 8930 0 0 0 9.6-3.4l2.7-1c7-2.4 13.8-5 20.6-7.8 22-9 44-17.6 66.2-26.2l3-1c4.8-2 9.7-3.8 14.5-5.7 11.2-4.3 11.2-4.3 22.3-9 9-3.9 18.4-7.3 27.7-10.8 16-6 32-12 47.8-18.7 12.4-5.2 25-10 37.6-14.8a876.7 876.7 0 0 0 42.5-16.9 411 411 0 0 1 20.9-8.2 5160 5160 0 0 0 24-9.2 4214 4214 0 0 1 5.2-2 652 652 0 0 0 27.4-11 422 422 0 0 1 8-3.4 200.7 200.7 0 0 0 52-29l8.6-6.3a229 229 0 0 0 24.6-21.6 779.4 779.4 0 0 1 4.4-4.4 217 217 0 0 0 17.5-19.7l1.6-2a250.7 250.7 0 0 0 39.6-73.8c.8-2.4 1.8-4.7 2.8-7a106 106 0 0 0 5-17.5l.8-3.5c12.3-56 9.8-117.8-11.8-171.2l-1.6-3.9a782.4 782.4 0 0 0-3-7.6 381.4 381.4 0 0 1-2.5-6.4 272.8 272.8 0 0 0-39-65l-1.8-2.6a219.7 219.7 0 0 0-16.6-18.2l-2.4-2.4-2.3-2.3-2-2.1c-1.7-1.7-1.7-1.7-3.8-1.5l-.7-1.7c-1.8-3.1-4.4-5.1-7.1-7.4l-1.6-1.4c-3-2.5-5.9-4.2-9.6-5.5v-2h-3v-2c-3.8-3-8-5.4-12-8l-2.1-1.3c-10-6.4-20-12-31-16.7l-2.1-1a404 404 0 0 0-43.8-15l-2.8-.8c-7.1-2-14.3-3.3-21.7-4.3l-3.4-.5c-14-2-27.8-2.5-42-2.5h-18c-4.2 0-8 .1-12.1 1.1zm934 3 1.9.9c9.2 4.3 17.8 9.1 26 15.1l2.6 1.8a131 131 0 0 1 48.8 86.5c3.9 32-2.7 67.8-22.8 93.6a583.5 583.5 0 0 1-10 12.3 168.2 168.2 0 0 0-2.8 3.4c-3 3.9-6.5 6.9-10.3 9.9l-2 1.4c-7.9 6-16.3 11.1-25 15.9l-2.1 1.1a92.3 92.3 0 0 1-24.4 8.2l-2.3.6a124 124 0 0 1-83.6-11.7l-2-1c-9-4.4-16.5-9.3-24-16l-2.4-2a94.3 94.3 0 0 1-25.6-32v-3h-2c-4.5-8-7.8-15.8-10.3-24.5l-.8-2.6a136 136 0 0 1-4.3-36v-2a123.5 123.5 0 0 1 8.2-45.5 123.3 123.3 0 0 1 66.4-71.6 248.6 248.6 0 0 0 4.8-2.2 118.6 118.6 0 0 1 98-.6zm27-325 2.6 2a515.6 515.6 0 0 1 7.4 6l1.9 1.5a68 68 0 0 1 13 14.5v2h2l2 5h2a142.2 142.2 0 0 1 19 106c-1.3 5.5-3 10.7-5 16l-.6 2a128 128 0 0 1-163.1 75.3c-8-3.2-15.4-6.8-22.8-11a145.2 145.2 0 0 0-6.4-3.3v-2l-5-2v-2l-1.8-.9c-2.2-1-2.2-1-5.2-3v-2l-1.8-.3c-2.8-1-4-2.3-5.8-4.6l-1.8-2a31 31 0 0 1-3.6-6.2h-2l-2.6-3.6-1.4-2.2-1.5-2.4-1.5-2.4c-3.7-5.8-3.7-5.8-5-8.5-1-2-1-2-3-3.9-5-9.8-8.7-20-11.2-30.7l-.5-2.1c-4.5-19.5-4.4-42.7.7-62.2l.5-2.2c5-18.8 15.2-35.2 27.3-50.3l2.9-4 1.3-1.5h2v-2c3.4-3.2 7.2-6 11-9l3-2.4c43.5-33.3 109.2-37.3 153-1.6zM1370.3 678l3.1-.1c6.4 0 12 .6 18.2 2.2l3.9.8a129.8 129.8 0 0 1 83 57.2c19.8 30.1 24 67.2 17 102a124.2 124.2 0 0 1-19 44h-2l-.6 2.1c-1.6 3.6-4 6.3-6.5 9.3l-1.4 1.6a100 100 0 0 1-19.7 18l-2.3 1.6a1114.3 1114.3 0 0 1-4.4 3 211.7 211.7 0 0 0-4.8 3.5c-24.9 17.3-59.8 20.7-89 15.8-25.3-5.9-46-17.7-65.2-34.9l-2-1.7a119.7 119.7 0 0 1-21-28.3v-2l-2-1a119.2 119.2 0 0 1-3.4-7.2l-1-2.2c-2.8-6.7-5-13.5-6.6-20.6l-1-3.6c-4.3-19.2-4-41.3 1-60.4l.6-2.4a151.3 151.3 0 0 1 21.4-44.6h2l.6-2.1a34 34 0 0 1 6.8-9.1l1.6-1.8a128.2 128.2 0 0 1 74.6-37.6c2.3-.3 2.3-.3 4.2-.9 4.5-1 9.2-.7 13.9-.7zm80.3 715.1a319.8 319.8 0 0 1 5 5l2.3 1.7 1.7 1.3v2h2c2.8 3 5.2 6.2 7.7 9.4a345.5 345.5 0 0 0 3.6 4.5c14 17.8 21 39 24.7 61.1l.6 3.5c3.2 27.1-3.3 55.3-15.6 79.5h-2l-1 5h-2v3h-2v3h-2l-.8 1.7c-8.3 15.6-23.4 26.7-38.2 35.3l-2.2 1.3a129.4 129.4 0 0 1-98.8 11.7 131.6 131.6 0 0 1-54-33l-1.8-1.6a123 123 0 0 1-36.3-82c-.8-28.2 3.2-57 20-80.4l2-3c19.6-29.5 48-47.1 82.2-55.8a96 96 0 0 1 7.9-1.2l3-.4c33.9-3.1 67.5 7.2 94 28.4zm4.6-333.9c4 3.3 4 3.3 5.4 5v2h2a107 107 0 0 1 4.6 5.7l1.4 1.8 2.7 3.7a254.2 254.2 0 0 0 3.4 4.5c19.4 25.2 27 59.8 23.4 91-3.9 29-14.8 53.7-34.5 75.2l-1.5 1.6a131 131 0 0 1-55.5 34.4l-3 1c-21.8 7-51.5 7.7-72.6-1.9-2.8-1.3-5.7-2.3-8.6-3.3-13-5-24-12-34.8-20.8l-2.9-2.2-2.1-1.8v-2h-2v-2l-3-1a123.1 123.1 0 0 1-33-61l-.6-2.3c-4.2-19.5-4-40.3.6-59.7l.5-2.1c5.9-24.4 20.1-49 39.5-64.9l1.8-1.6c48.3-45 120-38.4 168.8.7zm-4.6 671.9 2.5 2.1a130.3 130.3 0 0 1 43.5 123l-.4 2a147.8 147.8 0 0 1-14.6 42h-2l-1 5h-2v3h-2v3a98.9 98.9 0 0 1-3.5 3.4 107.5 107.5 0 0 1-33.8 30.5 246.8 246.8 0 0 0-4.4 2.8c-24.6 15.7-59 20.3-87.4 14.7-15-3.4-31.2-8.8-44-17.5v-2l-2-.7a34.4 34.4 0 0 1-9-6.2l-1.6-1.4a677 677 0 0 1-5.3-4.7l-1.9-1.6a736.5 736.5 0 0 1-5.3-4.8l-1.7-1.5a23 23 0 0 1-6.1-8 587.9 587.9 0 0 0-6-9l-4-6-1.5-2.4c-3.9-6-6.5-12.2-8.7-19l-1-3.2a142 142 0 0 1-2.8-72.5l.4-2c3.4-15.5 11-31.4 20.6-44h2l.9-2.3c1-2.7 1-2.7 3-5.7h2l1-1.8c1-2.2 1-2.2 3-5.2h2v-2h2v-2l4.3-3.4 7.7-6c2-1.6 2-1.6 4-1.6v-2h3v-2a160.3 160.3 0 0 1 56-19l3.2-.4c32-3.1 66.5 7.2 90.9 28.4z\"/><path d=\"M246.6 586.1h1l1 446 5-1c-1 2-1 2-4 3.1l-3 1c-1.7-1.8-1.1-3.8-1.2-6v-17.6a11055.4 11055.4 0 0 1 0-63.8V841.6a146142.6 146142.6 0 0 0 0-133.3v-37.4a42143 42143 0 0 1 0-75.6v-2.1c0-4.9 0-4.9 1.2-7zm-54-369 2 1-37 37-2-1 6.6-7.1 1.9-2a994.8 994.8 0 0 1 5.5-5.9l1.7-1.8 4.3-4.2h2v-2c1.4-1.6 1.4-1.6 3-3h2v-2l3.9-3.5a98 98 0 0 0 6-5.5z\"/></svg>"),
	Rules: []string{
		"||peacock.com^",
		"||peacocktv.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "pinterest",
	Name:    "Pinterest",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25,2C12.318,2,2,12.317,2,25s10.318,23,23,23s23-10.317,23-23S37.682,2,25,2z M27.542,32.719 c-3.297,0-4.516-2.138-4.516-2.138s-0.588,2.309-1.021,3.95s-0.507,1.665-0.927,2.591c-0.471,1.039-1.626,2.674-1.966,3.177 c-0.271,0.401-0.607,0.735-0.804,0.696c-0.197-0.038-0.197-0.245-0.245-0.678c-0.066-0.595-0.258-2.594-0.166-3.946 c0.06-0.88,0.367-2.371,0.367-2.371l2.225-9.108c-1.368-2.807-0.246-7.192,2.871-7.192c2.211,0,2.79,2.001,2.113,4.406 c-0.301,1.073-1.246,4.082-1.275,4.224c-0.029,0.142-0.099,0.442-0.083,0.738c0,0.878,0.671,2.672,2.995,2.672 c3.744,0,5.517-5.535,5.517-9.237c0-2.977-1.892-6.573-7.416-6.573c-5.628,0-8.732,4.283-8.732,8.214 c0,2.205,0.87,3.091,1.273,3.577c0.328,0.395,0.162,0.774,0.162,0.774l-0.355,1.425c-0.131,0.471-0.552,0.713-1.143,0.368 C15.824,27.948,13,26.752,13,21.649C13,16.42,17.926,11,25.571,11C31.64,11,37,14.817,37,21.001 C37,28.635,32.232,32.719,27.542,32.719z\" /></svg>"),
	Rules: []string{
		"||pin.it^",
		"||pinimg.com^",
		"||pinterest.at^",
		"||pinterest.be^",
		"||pinterest.ca^",
		"||pinterest.ch^",
		"||pinterest.cl^",
		"||pinterest.co.at^",
		"||pinterest.co.in^",
		"||pinterest.co.kr^",
		"||pinterest.co.nz^",
		"||pinterest.co.uk^",
		"||pinterest.co^",
		"||pinterest.com.au^",
		"||pinterest.com.bo^",
		"||pinterest.com.ec^",
		"||pinterest.com.mx^",
		"||pinterest.com.pe^",
		"||pinterest.com.py^",
		"||pinterest.com.uy^",
		"||pinterest.com.vn^",
		"||pinterest.com^",
		"||pinterest.de^",
		"||pinterest.dk^",
		"||pinterest.ec^",
		"||pinterest.engineering^",
		"||pinterest.es^",
		"||pinterest.fr^",
		"||pinterest.hu^",
		"||pinterest.id^",
		"||pinterest.ie^",
		"||pinterest.in^",
		"||pinterest.info^",
		"||pinterest.it^",
		"||pinterest.jp^",
		"||pinterest.kr^",
		"||pinterest.mx^",
		"||pinterest.nl^",
		"||pinterest.nz^",
		"||pinterest.pe^",
		"||pinterest.ph^",
		"||pinterest.pt^",
		"||pinterest.ru^",
		"||pinterest.se^",
		"||pinterest.th^",
		"||pinterest.tw^",
		"||pinterest.uk^",
		"||pinterest.vn^",
		"||pinterestmail.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "playstation",
	Name:    "PlayStation",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 30 30\"><path d=\"M11.18 3.74v21.12l4.58 1.4V8.58c0-.51 0-.77.26-1.02.12-.26.38-.26.63-.13.64.26 1.02.76 1.02 1.78v7c1.53.76 2.8.76 3.81 0 1.02-.77 1.53-1.9 1.53-3.82 0-2.03-.38-3.3-1.27-4.32-.76-1.02-2.16-1.91-4.2-2.55-2.54-.76-4.7-1.4-6.36-1.78zM9.91 16.97l-5.85 2.04-.89.38c-1.4.63-2.16 1.27-2.16 1.9.12.77.38 1.79 2.29 2.42 1.78.64 3.18.9 6.74-.12v-2.3c-3.44 1.15-3.95 1.02-4.45.77-.51-.25-.51-.5-.39-.64.39-.25 1.78-.76 1.78-.76l2.93-1.02v-2.67zm12.94 1c-.41-.02-.82-.01-1.24.02-1.4 0-2.67.25-4.2.64v2.67l2.8-1.02 1.53-.51s.64-.13 1.02-.25c.63-.13 1.4.12 1.4.12.38 0 .63.13.63.38.13.26-.12.39-.76.64l-1.4.51-5.09 1.9v2.68l2.3-.77 6.35-2.28.77-.39c1.52-.5 2.16-1.14 2.03-1.9 0-.77-.89-1.28-2.42-1.79a14.28 14.28 0 0 0-3.72-.66z\"/></svg>"),
	Rules: []string{
		"||gaikai.com",
		"||playstation-cloud.com",
		"||playstation-cloud.net",
		"||playstation.com",
		"||playstation.net",
		"||scea.com",
		"||sonyentertainmentnetwork.com",
		"||station.sony.com",
	},
	GroupID: "gaming",
}, {
	ID:      "plenty_of_fish",
	Name:    "Plenty of Fish",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-8 -3 30 30\"><path d=\"M13.96 4.88C11.3.68 7.04 1.25.22 1.25v.09c.52.2.95.59 1.21 1.08.26.47.38 1.04.38 1.72v16.44c.01.61-.11 1.21-.38 1.76-.25.5-.68.9-1.2 1.1v.09h7.13v-.09c-.5-.22-.92-.6-1.17-1.1a3.78 3.78 0 0 1-.4-1.76V16c.54.13 1.08.2 1.62.19a7.66 7.66 0 0 0 6.84-4.3c.47-.97.7-2.1.7-3.41a6.6 6.6 0 0 0-1-3.6ZM9.45 13.6a3.33 3.33 0 0 1-2.96 1.65c-.24 0-.49-.02-.73-.05V7.56l.01-4.63a3 3 0 0 0-.1-.88c1.62 0 2.43.5 3.16 1.19.74.68 1.86 2.68 1.86 5.52a9.4 9.4 0 0 1-1.24 4.85Z\"/></svg>"),
	Rules: []string{
		"||pof.com^",
	},
	GroupID: "dating",
}, {
	ID:      "plex",
	Name:    "Plex",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 48 48\"><path d=\"M11.5 6A5.5 5.5 0 0 0 6 11.5v25a5.5 5.5 0 0 0 5.5 5.5h25a5.5 5.5 0 0 0 5.5-5.5v-25A5.5 5.5 0 0 0 36.5 6h-25zm6.67 7.08h6.47L31.75 24l-7.1 10.92h-6.48L25.2 24l-7.03-10.92z\"/></svg>"),
	Rules: []string{
		"||plex.bz^",
		"||plex.direct^",
		"||plex.tv^",
		"||plexapp.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "pluto_tv",
	Name:    "Pluto TV",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -80 560 560\"><path d=\"M357.3 164.3c-19.7 0-35.7 16-35.7 35.7s16 35.7 35.7 35.7 35.7-16 35.7-35.7-16-35.7-35.7-35.7m0 52.1a16.41 16.41 0 0 1 0-32.8c9 0 16.4 7.4 16.4 16.4 0 9.1-7.4 16.4-16.4 16.4m-40.6-32.3v-18.4h-16.6v-18l-20 8.1v9.9h-12.3v18.4H280v23.7c0 8.2 2.4 15 7 19.6 4.6 4.6 11.4 7 19.7 7h9.9V216h-6.8c-6.8 0-9.8-3-9.8-9.8v-22.1h16.7zM240 173.8v30.1c0 6.9-5.6 12.6-12.6 12.6-6.9 0-12.6-5.7-12.6-12.6v-37.4l-19.8 8v28.8c0 17.9 14.5 32.5 32.4 32.5s32.5-14.5 32.5-32.5v-37.6l-19.9 8.1zm-73.6-18v78.5h20v-86.5zm-41.1 8.5c-8.3 0-15.4 2.8-20.7 8.2l-2.8-6.7-16.2 6.5v80h20v-23.6c5.2 4.7 12 7 19.7 7 9.2 0 17.6-3.7 23.8-10.5 6.1-6.6 9.4-15.6 9.4-25.2 0-19.9-14.6-35.7-33.2-35.7m-3.1 52.1c-9.2 0-16.7-7.4-16.7-16.4 0-9.1 7.5-16.4 16.7-16.4s16.7 7.4 16.7 16.4-7.5 16.4-16.7 16.4m316.5-52.1c-19.7 0-35.7 16-35.7 35.7s16 35.7 35.7 35.7 35.7-16 35.7-35.7c0-19.7-16-35.7-35.7-35.7m14.1 53.1h-6.7l-9.5-23H427v11.9c0 2.6 1.2 4.1 4.1 4.1h4.2v7h-5.2c-7.1 0-10.8-4-10.8-10.6v-12.4H414v-6.7h5.3V183l7.6-3.1v7.8h15l7.4 19.3 7.5-19.4h8.2l-12.2 29.8z\"/></svg>"),
	Rules: []string{
		"||pluto.tv^",
	},
	GroupID: "streaming",
}, {
	ID:      "privacy",
	Name:    "Privacy",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"-2 0 42 42\"><path fill-rule=\"evenodd\" d=\"m28.516 30.648-.857-1.386-1.935-3.136a9.853 9.853 0 0 0 2.523-3.66 9.76 9.76 0 0 0 .31-6.26 9.853 9.853 0 0 0-3.562-5.185 9.955 9.955 0 0 0-5.985-2 9.94 9.94 0 0 0-5.986 2 9.848 9.848 0 0 0-3.564 5.185 9.76 9.76 0 0 0 .31 6.26 9.853 9.853 0 0 0 2.523 3.66L5.031 37.892a.654.654 0 0 1-.312.267.665.665 0 0 1-.42.013.65.65 0 0 1-.343-.225.65.65 0 0 1-.123-.397V18.875h-.007c0-3.331 1.107-6.468 3.022-9.016a15.152 15.152 0 0 1 7.842-5.436 15.292 15.292 0 0 1 9.572.306c3 1.096 5.65 3.126 7.481 5.92a14.998 14.998 0 0 1 2.427 9.197 15.002 15.002 0 0 1-3.587 8.808 15.267 15.267 0 0 1-2.065 1.992m-9.505 3.26c1.129 0 2.284-.079 3.388-.328.979-.222 1.936-.54 2.856-.951l-.854-1.383-2.838-4.6a1.888 1.888 0 0 1 .636-2.608 6.058 6.058 0 0 0 2.487-2.953 6.02 6.02 0 0 0-1.995-7.03 6.115 6.115 0 0 0-3.68-1.225 6.12 6.12 0 0 0-3.682 1.225 6.03 6.03 0 0 0-2.185 3.178 6.008 6.008 0 0 0 .19 3.852 6.056 6.056 0 0 0 2.487 2.953 1.889 1.889 0 0 1 .637 2.607l-1.845 2.99-1.562 2.532-.278.45a14.152 14.152 0 0 0 6.24 1.292h-.002ZM8.772 39.098l-.476.772a4.468 4.468 0 0 1-2.184 1.829 4.48 4.48 0 0 1-2.846.13 4.468 4.468 0 0 1-2.364-1.592A4.404 4.404 0 0 1 0 37.552V18.875h.007c0-4.183 1.382-8.113 3.771-11.29A18.992 18.992 0 0 1 13.611.78a19.102 19.102 0 0 1 11.967.38 18.97 18.97 0 0 1 9.368 7.422 18.758 18.758 0 0 1 3.04 11.501 18.767 18.767 0 0 1-4.5 11.024 19.006 19.006 0 0 1-10.247 6.17 19.07 19.07 0 0 1-3.613.463c-.089-.003-.534.007-.613.007a19.111 19.111 0 0 1-8.257-1.867l-1.984 3.215v.001Z\" clip-rule=\"evenodd\"/></svg>"),
	Rules: []string{
		"||privacy.com.br^",
	},
	GroupID: "privacy",
}, {
	ID:      "qq",
	Name:    "QQ",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 32 32\" fill=\"currentColor\"><path d=\"M11.25 32C8.35 32 6 30.74 6 29.24c0-1.5 2.34-2.75 5.25-2.75s5.25 1.26 5.25 2.75S14.16 32 11.25 32ZM27 29.24c0-1.5-2.34-2.75-5.25-2.75s-5.25 1.26-5.25 2.75S18.84 32 21.75 32 27 30.74 27 29.24ZM14.88 7.18c0 .63-.32 1.18-.8 1.18-.49 0-.81-.55-.81-1.18 0-.63.32-1.18.8-1.18.5 0 .81.55.81 1.18ZM18.93 6c-.48 0-.8.55-.8 1.18 0 .63.32-.4.8-.4.49 0 .81 1.03.81.4S19.41 6 18.93 6Z\"/><path d=\"M6.65 12.64s4.69 2.46 9.93 2.46c5.24 0 9.93-2.46 9.93-2.46.1-.1.21-.16.31-.21 0-1.1-.08-2.03-.08-2.81C26.74 4.29 22.14 0 16.5 0S6.18 4.3 6.18 9.62v2.78c.14.04.3.11.47.24Zm12.63-8.67c1.11 0 1.98 1.28 1.98 2.79s-.87 2.78-1.98 2.78c-1.11 0-1.99-1.27-1.99-2.78 0-1.51.88-2.79 1.99-2.79Zm-5.56 0c1.11 0 1.99 1.28 1.99 2.79s-.88 2.78-1.99 2.78c-1.11 0-1.99-1.27-1.99-2.78 0-1.51.88-2.79 2-2.79Zm2.78 6.63c2.91 0 5.3.46 5.3 1s-2.39 1.65-5.3 1.65c-2.91 0-5.3-1.13-5.3-1.66s2.39-1 5.3-1Zm11.37 5.18-.17.12c-.16.08-5.24 3.18-11.04 3.18-1.43 0-2.7-.24-3.97-.48-.24 1.67-.24 3.26-.24 3.97 0 1.28-1.03 1.2-2.3 1.28-1.27 0-2.23.16-2.3-1.04 0-.16-.09-2.78.4-5.56a23.87 23.87 0 0 1-2.7-1.35 3.3 3.3 0 0 1-.34-.22C4 17.55 3 19.6 3 21.22c0 3.82 1.11 3.42 1.11 3.42.48 0 1.27-.8 1.99-1.67C7.77 27.67 11.73 31 16.5 31c4.76 0 8.73-3.34 10.4-8.03.72.88 1.51 1.67 1.99 1.67 0 0 1.11.4 1.11-3.42 0-1.58-.97-3.63-2.13-5.44Z\"/></svg>"),
	Rules: []string{
		"||qq-video.cdn-go.cn^",
		"||qq.com^$denyallow=wx.qq.com|weixin.qq.com",
		"||url.cn^",
	},
	GroupID: "streaming",
}, {
	ID:      "rakuten_viki",
	Name:    "Rakuten Viki",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 5 5 L 5 45 L 45 45 L 45 5 L 5 5 z M 19.435547 14 L 19.4375 14 L 20.587891 14 L 20.587891 17.21875 L 21.929688 15.570312 L 23.496094 15.570312 L 21.578125 17.789062 L 23.802734 20.302734 L 22.236328 20.302734 L 20.587891 18.357422 L 20.587891 20.302734 L 19.435547 20.302734 L 19.435547 14 z M 10.001953 14.390625 L 11.933594 14.390625 C 13.105594 14.390625 14.056641 15.304687 14.056641 16.429688 C 14.056641 17.114687 13.701109 17.719797 13.162109 18.091797 L 14.892578 20.302734 L 13.427734 20.302734 L 11.996094 18.470703 L 11.169922 18.470703 L 11.169922 20.302734 L 10.001953 20.302734 L 10.001953 14.390625 z M 28.746094 14.390625 L 29.865234 14.390625 L 29.865234 15.568359 L 30.820312 15.568359 L 30.820312 16.691406 L 29.865234 16.691406 L 29.865234 18.716797 C 29.865234 19.163797 30.210578 19.298828 30.392578 19.298828 C 30.538578 19.298828 30.665625 19.246641 30.765625 19.181641 L 31.501953 20.123047 C 31.150953 20.323047 30.719203 20.421875 30.408203 20.421875 C 29.574203 20.421875 28.746094 19.791375 28.746094 18.734375 L 28.746094 16.691406 L 28.154297 16.691406 L 28.154297 15.570312 L 28.15625 15.570312 L 28.746094 15.570312 L 28.746094 14.390625 z M 33.347656 15.449219 C 34.620656 15.449219 35.762281 16.566578 35.488281 18.267578 L 32.269531 18.267578 C 32.416531 19.349578 33.688172 19.898406 34.451172 18.816406 L 35.439453 19.363281 C 34.804453 20.229281 34.048984 20.423828 33.458984 20.423828 C 32.290984 20.423828 31.126953 19.401547 31.126953 17.935547 C 31.126953 16.541547 32.053656 15.449219 33.347656 15.449219 z M 16.628906 15.453125 C 17.041906 15.453125 17.344641 15.573297 17.681641 15.779297 L 17.681641 15.570312 L 18.800781 15.570312 L 18.800781 20.302734 L 17.681641 20.302734 L 17.681641 20.09375 C 17.344641 20.29975 17.042906 20.419922 16.628906 20.419922 C 15.357906 20.419922 14.392578 19.3055 14.392578 17.9375 C 14.391578 16.5695 15.356906 15.453125 16.628906 15.453125 z M 38 15.453125 C 39.187 15.453125 40 16.379484 40 17.521484 L 40 20.302734 L 38.882812 20.302734 L 38.882812 17.521484 C 38.882812 17.000484 38.509797 16.560547 37.966797 16.560547 C 37.423797 16.560547 37.050781 17.000484 37.050781 17.521484 L 37.050781 20.302734 C 37.050781 20.302734 35.931641 20.303734 35.931641 20.302734 L 35.931641 15.570312 L 37.050781 15.570312 L 37.050781 15.744141 C 37.050781 15.744141 37.45 15.453125 38 15.453125 z M 11.169922 15.513672 L 11.169922 17.345703 L 11.931641 17.345703 C 12.456641 17.346703 12.886719 16.936688 12.886719 16.429688 C 12.886719 15.924687 12.456641 15.513672 11.931641 15.513672 L 11.169922 15.513672 z M 23.685547 15.570312 L 24.802734 15.570312 L 24.802734 18.351562 C 24.802734 18.872563 25.17575 19.314453 25.71875 19.314453 C 26.26175 19.314453 26.634766 18.872563 26.634766 18.351562 L 26.634766 15.570312 L 27.753906 15.570312 L 27.753906 20.304688 L 26.634766 20.304688 L 26.634766 20.128906 C 26.634766 20.128906 26.235547 20.421875 25.685547 20.421875 C 24.498547 20.421875 23.685547 19.493562 23.685547 18.351562 L 23.685547 15.570312 z M 33.324219 16.470703 C 32.877344 16.478703 32.428047 16.772172 32.310547 17.326172 L 34.324219 17.326172 C 34.215219 16.740172 33.771094 16.462703 33.324219 16.470703 z M 16.628906 16.59375 C 16.001906 16.59375 15.542969 17.1885 15.542969 17.9375 C 15.542969 18.6875 16.001906 19.279297 16.628906 19.279297 C 17.255906 19.279297 17.698219 18.6865 17.699219 17.9375 C 17.699219 17.1875 17.255906 16.59375 16.628906 16.59375 z M 16.240234 21.587891 L 34.472656 21.587891 L 17.693359 23.046875 L 16.240234 21.587891 z M 10 25.466797 L 13.179688 25.466797 L 15.326172 32.365234 L 17.441406 25.466797 L 20.607422 25.466797 L 16.578125 36 L 14.074219 36 L 10 25.466797 z M 21.617188 25.466797 L 24.628906 25.466797 L 24.628906 36 L 21.617188 36 L 21.617188 25.466797 z M 26.335938 25.466797 L 29.347656 25.466797 L 29.347656 29.470703 L 32.681641 25.466797 L 36.078125 25.466797 L 32.095703 30.183594 L 36.355469 36 L 32.896484 36 L 30.179688 32.126953 L 29.347656 32.957031 L 29.347656 36 L 26.335938 36 L 26.335938 25.466797 z M 36.988281 25.466797 L 40 25.466797 L 40 36 L 36.988281 36 L 36.988281 25.466797 z\"/></svg>"),
	Rules: []string{
		"||m-content-viki.s.llnwi.net^",
		"||viki.com^",
		"||viki.io^",
	},
	GroupID: "streaming",
}, {
	ID:      "reddit",
	Name:    "Reddit",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M14.238 15.348c.085.084.085.221 0 .306-.465.462-1.194.687-2.231.687l-.008-.002-.008.002c-1.036 0-1.766-.225-2.231-.688-.085-.084-.085-.221 0-.305.084-.084.222-.084.307 0 .379.377 1.008.561 1.924.561l.008.002.008-.002c.915 0 1.544-.184 1.924-.561.085-.084.223-.084.307 0zm-3.44-2.418c0-.507-.414-.919-.922-.919-.509 0-.923.412-.923.919 0 .506.414.918.923.918.508.001.922-.411.922-.918zm13.202-.93c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-5-.129c0-.851-.695-1.543-1.55-1.543-.417 0-.795.167-1.074.435-1.056-.695-2.485-1.137-4.066-1.194l.865-2.724 2.343.549-.003.034c0 .696.569 1.262 1.268 1.262.699 0 1.267-.566 1.267-1.262s-.568-1.262-1.267-1.262c-.537 0-.994.335-1.179.804l-2.525-.592c-.11-.027-.223.037-.257.145l-.965 3.038c-1.656.02-3.155.466-4.258 1.181-.277-.255-.644-.415-1.05-.415-.854.001-1.549.693-1.549 1.544 0 .566.311 1.056.768 1.325-.03.164-.05.331-.05.5 0 2.281 2.805 4.137 6.253 4.137s6.253-1.856 6.253-4.137c0-.16-.017-.317-.044-.472.486-.261.82-.766.82-1.353zm-4.872.141c-.509 0-.922.412-.922.919 0 .506.414.918.922.918s.922-.412.922-.918c0-.507-.413-.919-.922-.919z\" /></svg>"),
	Rules: []string{
		"||redd.it^",
		"||reddit.com^",
		"||redditmail.com^",
		"||redditmedia.com^",
		"||redditstatic.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "riot_games",
	Name:    "Riot Games",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 64 64\"><path d=\"M31.3 2.2a1 1 0 0 0-.8 1.4l.8 1.8a1 1 0 1 0 1.8-.8l-.8-1.8a1 1 0 0 0-1-.6zm-4.3 2a1 1 0 0 0-.9 1.5l1 1.8a1 1 0 1 0 1.7-.9L28 4.8a1 1 0 0 0-1-.6zm12 1a1 1 0 0 0-.4.1l-34 16.2a1 1 0 0 0-.6 1.1L9.3 47a1 1 0 0 0 1 .8h7a1 1 0 0 0 1-1l-1-12.2 3 12.4a1 1 0 0 0 .9.8h7.3a1 1 0 0 0 1-1l-.2-15.8L32 47a1 1 0 0 0 1 .8h7.6a1 1 0 0 0 1-1l1.3-19.4 1.4 19.5a1 1 0 0 0 1 1h10.2a1 1 0 0 0 1-1L60 11.2a1 1 0 0 0-.8-1l-20-5a1 1 0 0 0-.3 0zm-16.3 1a1 1 0 0 0-.9 1.5l.9 1.8a1 1 0 1 0 1.8-.8l-.9-1.8a1 1 0 0 0-1-.6zm16.4 1L57.9 12l-3.3 33.8h-8.3l-1.9-25a1 1 0 0 0-1.2-.8l-1.2.3a1 1 0 0 0-.7.9l-1.7 24.6h-5.8L30.3 25a1 1 0 0 0-1.3-.8l-1 .4a1 1 0 0 0-.8 1l.3 20.2H22l-4-17a1 1 0 0 0-1.2-.7l-1.1.3a1 1 0 0 0-.7 1l1.2 16.4H11L6.1 23l33-15.7zM18.5 8.4a1 1 0 0 0-1 1.5l.9 1.8a1 1 0 1 0 1.8-.9L19.3 9a1 1 0 0 0-.8-.6zm-4.3 2.1a1 1 0 0 0-.1 0 1 1 0 0 0-.9 1.4l.9 1.8a1 1 0 1 0 1.8-.8L15 11a1 1 0 0 0-.8-.6zm-4.4 2a1 1 0 0 0-.9 1.5l.9 1.8a1 1 0 1 0 1.8-.9l-.9-1.8a1 1 0 0 0-1-.5zm-4.3 2.1a1 1 0 0 0-.9 1.4l.9 1.9a1 1 0 1 0 1.8-1l-.9-1.7a1 1 0 0 0-.9-.6zM30.7 49a1 1 0 0 0-.9 1.4l2.5 6.5a1 1 0 0 0 .7.6l20.7 5.3a1 1 0 0 0 1.2-.9L56 51.4a1 1 0 0 0-1-1L30.9 49a1 1 0 0 0-.1 0zm1.5 2.1L54 52.3l-.9 8.2-19-4.8-1.8-4.6z\"/></svg>"),
	Rules: []string{
		"||dradis-prod.rdatasrv.net^",
		"||pvp.net^",
		"||rgpub.io^",
		"||riotcdn.com^",
		"||riotcdn.net^",
		"||riotgames.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "roblox",
	Name:    "Roblox",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"m13.383 14.341-3.726-.958.959-3.726 3.726.959-.96 3.726zM4.913 0 0 19.088 19.088 24 24 4.912 4.912 0z\" /></svg>"),
	Rules: []string{
		"||blox.com^",
		"||rbx.cn^",
		"||rbx.com^",
		"||rbxadder.com^",
		"||rbxcdn.com^",
		"||rbxcdn.net^",
		"||rbxinfra.com^",
		"||rbxinfra.net^",
		"||roblox.cn^",
		"||roblox.com^",
		"||roblox.qq.com^",
		"||robloxcdn.com^",
		"||robloxdev.cn^",
	},
	GroupID: "gaming",
}, {
	ID:      "rockstar_games",
	Name:    "Rockstar Games",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M12 3c-4.96 0-9 4.04-9 9v26c0 4.96 4.04 9 9 9h26c4.96 0 9-4.04 9-9V12c0-4.96-4.04-9-9-9H12zm0 2h26c3.88 0 7 3.12 7 7v26c0 3.88-3.12 7-7 7H12c-3.88 0-7-3.12-7-7V12c0-3.88 3.12-7 7-7zm3.72 5a1 1 0 0 0-.97.79l-3.87 18a1 1 0 0 0 .98 1.21h4.27a1 1 0 0 0 .97-.79L18.47 23h2.07c.94 0 1.12.15 1.36.73.24.57.3 1.76.1 3.4-.08.68-.05 1.22.02 1.6v.03a1 1 0 0 0 .3.97l3.37 3.12-2.6 5.74a1 1 0 0 0 1.43 1.26l5.58-3.39 4.29 3.33a1 1 0 0 0 1.6-.98l-1.09-5.56 4.7-3.47a1 1 0 0 0-.6-1.8h-4.86l-.82-5.14a1 1 0 0 0-.98-.84 1 1 0 0 0-.88.51l-2.77 5a14.3 14.3 0 0 1 .06-2.83c.15-1.48.01-2.64-.18-3.45-.06-.28-.08-.25-.15-.45.3-.17.4-.13.77-.5.8-.8 1.6-2.18 1.75-4.26.17-2.26-.55-3.98-1.92-4.9C27.65 10.17 25.91 10 24 10h-8.28zm.81 2H24c1.75 0 3.13.25 3.9.77.76.52 1.18 1.27 1.05 3.1-.13 1.67-.69 2.51-1.17 3a2 2 0 0 1-.82.56 1 1 0 0 0-.6 1.44s.12.21.27.82c.14.6.26 1.53.13 2.79a14.24 14.24 0 0 0-.01 3.52h-2.76c-.01-.19-.04-.32 0-.62.22-1.78.25-3.21-.24-4.42A3.38 3.38 0 0 0 20.54 21h-2.87a1 1 0 0 0-.98.78L15.32 28H13.1l3.44-16zm2.76 1.03a1 1 0 0 0-.98.8l-.98 4.94a1 1 0 0 0 .98 1.2h4.47c.79 0 1.65-.12 2.44-.58a3.6 3.6 0 0 0 1.68-2.41 3.3 3.3 0 0 0-.72-2.92 3.35 3.35 0 0 0-2.47-1.03h-4.42zm.82 2h3.6c.41 0 .79.16 1 .4.22.22.36.52.23 1.15-.13.62-.36.88-.72 1.08a3 3 0 0 1-1.44.3h-3.25l.58-2.93zm11.7 10.99.49 3.11a1 1 0 0 0 .98.84h2.69l-2.76 2.05a1 1 0 0 0-.4 1l.7 3.56-2.73-2.12a1 1 0 0 0-1.13-.07l-3.4 2.07 1.56-3.44a1 1 0 0 0-.23-1.15L25.55 30H29a1 1 0 0 0 .88-.51l1.92-3.47z\"/></svg>"),
	Rules: []string{
		"||rockstargames.com^",
		"||rsg.sc^",
	},
	GroupID: "gaming",
}, {
	ID:      "samsung_tv_plus",
	Name:    "Samsung TV Plus",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"121 -91 672 672\"><path d=\"m710.504 89.711.004 38.892c0 .073.021.14.021.214V352.97c0 21.351-17.05 38.526-38.326 38.835l-.05.052h-.473c-.015 0-.028.004-.042.004h-96.769v31.034a24.11 24.11 0 0 1-24.162 24.163H368.046a24.11 24.11 0 0 1-24.162-24.163v-31.034H208.832v35.86c0 34.394 27.687 62.083 62.081 62.083h457.22c34.395 0 62.085-27.69 62.085-62.083V151.795c0-34.394-27.69-62.084-62.084-62.084zM185.028 0c-34.394 0-62.084 27.69-62.084 62.084V329.78c0 34.393 27.69 62.081 62.083 62.081h23.804V128.817c0-21.546 17.346-38.89 38.892-38.89h38.6l.176-.216h424.005V62.084C710.504 27.69 682.814 0 648.421 0Z\"/></svg>"),
	Rules: []string{
		"||internetat.tv^",
		"||samsung.wurl.tv^",
		"||samsungcloud.tv^",
		"||samsungtvplus.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "shein",
	Name:    "Shein",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M14 4C8.49 4 4 8.49 4 14v22c0 5.51 4.49 10 10 10h22c5.51 0 10-4.49 10-10V14c0-5.51-4.49-10-10-10H14zm0 2h22c4.43 0 8 3.57 8 8v22c0 4.43-3.57 8-8 8H14c-4.43 0-8-3.57-8-8V14c0-4.43 3.57-8 8-8zm11 7c-4 0-8.5 2-8.5 6.5 0 7.75 13 6.25 13 11 0 3.25-3.5 3.5-4.5 3.5-2 0-5-1-6.5-2L16 34.5c2.5 1.5 5.5 2.75 9 2.75 3 0 8.5-1.5 8.5-6.75 0-7-13-6.75-13-11 0-3 3.5-3.5 4.5-3.5 1.25 0 3.75.5 5 1.5l2.5-2.25C31 14 29 13 25 13z\"/></svg>"),
	Rules: []string{
		"||shein.co.uk^",
		"||shein.com^",
		"||shein.se^",
		"||sheinsz.ltwebstatic.com^",
	},
	GroupID: "shopping",
}, {
	ID:      "shopee",
	Name:    "Shopee",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25 1c-5.3 0-9.4 5-9.8 11H5a2 2 0 0 0-2 2.1l1.7 30.2a5 5 0 0 0 5 4.7h30.4a5 5 0 0 0 5-4.7L47 14a2 2 0 0 0-2-2.1H35C34.3 6 30.2 1 25 1zm0 2c4 0 7.4 3.9 7.8 9H17.2c.4-5.1 3.8-9 7.8-9zM5 14h10.8a1 1 0 0 0 .4 0h17.6a1 1 0 0 0 .4 0h10.7l-1.7 30.2a3 3 0 0 1-3 2.8H9.8a3 3 0 0 1-3-2.8L5 14zm20 4c-4.2 0-7.5 2.7-7.5 6.3 0 4 3.8 5.4 7 6.6 4 1.4 6.5 2.5 6.5 5.7 0 2.4-2.7 4.4-6 4.4-3.8 0-7-2.7-7-2.7l-1.2 1.6c.8.7 4.1 3.1 8.1 3.1 4.5 0 8-2.8 8-6.4 0-4.8-4-6.3-7.7-7.6-3.5-1.3-5.7-2.3-5.7-4.7 0-2.5 2.3-4.3 5.6-4.3a11 11 0 0 1 6 1.9l1-1.7c-.3-.1-3.2-2.2-7-2.2z\"/></svg>"),
	Rules: []string{
		"||shopee.cl^",
		"||shopee.cn^",
		"||shopee.co.id^",
		"||shopee.co.th^",
		"||shopee.com.br^",
		"||shopee.com.co^",
		"||shopee.com.mx^",
		"||shopee.com.my^",
		"||shopee.com^",
		"||shopee.es^",
		"||shopee.fr^",
		"||shopee.id^",
		"||shopee.in^",
		"||shopee.io^",
		"||shopee.ph^",
		"||shopee.sg^",
		"||shopee.tw^",
		"||shopee.vn^",
		"||shopeemobile.com^",
		"||shp.ee^",
	},
	GroupID: "shopping",
}, {
	ID:      "signal",
	Name:    "Signal",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><path d=\"M26.6 16c-.2 4-1.9 7.2-5.5 9.2a10.6 10.6 0 0 1-10.5-.2h-.5l-3.8.9c-.2.1-.3 0-.2-.2l.9-3.8-.1-.5a10.6 10.6 0 1 1 19.5-7.2l.2 1.8z\"/><path d=\"M4.6 28.6c-.8 0-1.4-.7-1.2-1.4l.6-2.5.2-.1.9.2c.2 0 .1.1.1.2l-.5 2c-.1.3-.1.3.3.2l2-.5c.2 0 .2 0 .3.2l.2.8-.1.2-2.8.7c.1 0 .1 0 0 0zm5.1-1.2-1 .2c-.2.1-.3 0-.3-.2l-.2-.8.1-.2 1.5-.3h.2c.9.5 1.9.9 2.9 1.2.1 0 .2.1.1.2l-.2.7c0 .2-.1.2-.3.2-.9-.2-1.8-.6-2.6-1 0 .1 0 0-.2 0zm-3.8-5.3-.3 1.3c-.1.5 0 .4-.5.3l-.6-.1c-.1 0-.2-.1-.1-.2l.2-.9v-.4c-.4-.8-.8-1.7-1-2.6-.1-.3-.1-.3.2-.3l.7-.2.2.1c.3 1 .7 2 1.2 2.9-.1 0 0 0 0 .1zM26.4 8.3l-.1.1-.7.5c-.1.1-.2.1-.2 0-.7-.9-1.4-1.6-2.3-2.3-.1-.1-.1-.1 0-.2l.5-.7c.1-.1.1-.1.2 0 1 .7 1.8 1.5 2.6 2.6 0-.1 0-.1 0 0zm-7.2-4.9h.1c1.1.3 2.2.7 3.2 1.3.2.1.2.2.1.3l-.4.7-.2.1a10 10 0 0 0-3-1.2c-.1 0-.2-.1-.1-.2l.2-.9.1-.1zM6.5 9s-.1-.1 0 0l-.8-.6v-.3l1-1.3 1.4-1.2h.3l.5.7v.3C8 7.3 7.3 8 6.6 8.9l-.1.1zm21.1 9.9.9.2.1.2-.8 2.2-.5 1-.3.1-.7-.4-.1-.2c.5-.9 1-1.9 1.2-3 0-.1.1-.2.2-.1zM4.4 13.1l-.9-.2-.1-.2c.2-.9.6-1.8 1-2.6l.3-.6c.2-.2.2-.2.3-.1l.8.5c.1.1.1.1 0 .2-.5.9-1 1.9-1.2 3 0 0 0 .1-.2 0zM3 16l.1-1.7c0-.2.1-.2.3-.2l.8.1.2.2c-.1 1.1-.1 2.1 0 3.2l-.1.2-.9.1c-.2 0-.2-.1-.2-.2C3 17.2 3 16.6 3 16zm25.6-3.2-.1.1-.9.2c-.2 0-.2-.1-.2-.2-.2-.9-.6-1.7-1-2.5l-.2-.4c-.1-.1 0-.1 0-.2l.8-.5h.2a15 15 0 0 1 1.4 3.5zm-2.2 10.9-.1.1c-.7.9-1.6 1.8-2.5 2.5-.1.1-.2.1-.2 0l-.5-.7v-.3c.8-.6 1.6-1.4 2.2-2.2h.3l.7.5.1.1zM16 3l1.7.1c.2 0 .2.1.2.3l-.1.7-.2.2a16 16 0 0 0-3.1 0c-.2 0-.2 0-.2-.2l-.1-.8c0-.1 0-.2.2-.2L16 3zm0 26-1.8-.1c-.2 0-.2-.1-.2-.3l.1-.8.2-.2c1.1.1 2.1.1 3.2 0 .1 0 .2 0 .2.2l.1.8c0 .2-.1.2-.2.2-.4.2-1 .2-1.6.2zM12.8 3.4l.1.1.2.9c0 .2-.1.2-.2.2-.9.2-1.8.6-2.6 1-.3.2-.5.2-.7-.1l-.2-.4c-.1-.2-.1-.2.1-.3.8-.5 1.7-.9 2.6-1.2l.7-.2zM29 16l-.1 1.7c0 .2-.1.2-.3.2l-.7-.1c-.3 0-.3 0-.2-.3v-3.1c0-.1 0-.2.2-.2l.8-.1c.2 0 .2 0 .2.2L29 16zm-9.8 12.6-.1-.1-.2-.9.2-.2c.9-.2 1.7-.6 2.5-1l.4-.2c.1-.1.1 0 .2 0l.5.8v.2c-1.1.6-2.2 1.1-3.5 1.4z\"/></svg>"),
	Rules: []string{
		"||signal.org^",
		"||whispersystems.org^",
	},
	GroupID: "messenger",
}, {
	ID:      "skype",
	Name:    "Skype",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 26 26\"><path d=\"M23.363 14.387c.153-.739.23-1.5.23-2.266C23.594 5.883 18.45.805 12.122.805c-.594 0-1.191.047-1.781.136A6.891 6.891 0 0 0 6.852 0C3.074 0 0 3.035 0 6.762c0 1.144.293 2.27.852 3.265-.133.688-.2 1.391-.2 2.094 0 6.238 5.149 11.316 11.47 11.316.648 0 1.3-.054 1.94-.164.95.477 2.012.727 3.086.727C20.926 24 24 20.969 24 17.238c0-1.004-.215-1.96-.637-2.851zM17.758 17.3c-.508.707-1.258 1.27-2.23 1.668-.966.394-2.122.593-3.434.593-1.578 0-2.903-.273-3.934-.812a5.074 5.074 0 0 1-1.808-1.582c-.47-.664-.707-1.324-.707-1.961 0-.395.156-.738.457-1.023.304-.278.687-.418 1.148-.418.379 0 .703.109.969.332.254.21.469.523.644.93.192.437.407.808.633 1.1.211.282.524.52.918.704.399.188.938.281 1.598.281.91 0 1.652-.191 2.215-.57.546-.367.812-.813.812-1.352 0-.43-.14-.765-.422-1.027-.3-.277-.699-.492-1.176-.637-.5-.152-1.18-.32-2.015-.496-1.14-.238-2.11-.523-2.88-.847-.788-.332-1.425-.79-1.89-1.364-.472-.582-.71-1.312-.71-2.172 0-.816.253-1.554.75-2.191.488-.633 1.206-1.125 2.132-1.46.91-.333 1.996-.5 3.223-.5.98 0 1.844.108 2.566.331.723.223 1.336.524 1.813.89.484.376.843.774 1.07 1.188.227.418.344.832.344 1.235 0 .386-.153.738-.453 1.046-.297.31-.68.465-1.125.465-.41 0-.727-.097-.95-.289-.207-.18-.418-.46-.656-.863-.273-.516-.605-.918-.984-1.203-.371-.277-.989-.418-1.836-.418-.79 0-1.43.156-1.902.465-.461.293-.684.633-.684 1.039 0 .246.07.449.219.629.156.187.379.351.656.488.289.145.586.258.883.34.308.082.82.207 1.523.367.887.191 1.707.398 2.43.625.73.234 1.363.516 1.879.848.527.34.941.773 1.238 1.293.297.52.445 1.16.445 1.91a4.07 4.07 0 0 1-.77 2.418zm0 0\" /></svg>"),
	Rules: []string{
		"||edge-skype-com.s-0001.s-msedge.net^",
		"||skype-edf.akadns.net^",
		"||skype.com^",
		"||skype.net^",
		"||skype^",
		"||skypeassets.com^",
		"||skypeassets.net^",
		"||skypedata.akadns.net^",
	},
	GroupID: "messenger",
}, {
	ID:      "slack",
	Name:    "Slack",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 54 54\"><path fill-rule=\"evenodd\" d=\"M19.71.13a5.38 5.38 0 0 0-5.37 5.39 5.38 5.38 0 0 0 5.37 5.39h5.38V5.52A5.38 5.38 0 0 0 19.7.13m0 14.37H5.38A5.38 5.38 0 0 0 0 19.88a5.38 5.38 0 0 0 5.38 5.4H19.7a5.38 5.38 0 0 0 5.38-5.4 5.38 5.38 0 0 0-5.38-5.38m34.06 5.38a5.38 5.38 0 0 0-5.38-5.38 5.38 5.38 0 0 0-5.37 5.38v5.4h5.37a5.38 5.38 0 0 0 5.38-5.4m-14.34 0V5.52A5.38 5.38 0 0 0 34.05.13a5.38 5.38 0 0 0-5.38 5.39v14.36a5.38 5.38 0 0 0 5.38 5.4 5.38 5.38 0 0 0 5.37-5.4M34.05 54a5.38 5.38 0 0 0 5.37-5.39 5.38 5.38 0 0 0-5.37-5.38h-5.38v5.38A5.38 5.38 0 0 0 34.05 54m0-14.37h14.33a5.38 5.38 0 0 0 5.38-5.38 5.38 5.38 0 0 0-5.38-5.39H34.05a5.38 5.38 0 0 0-5.38 5.39 5.38 5.38 0 0 0 5.38 5.38M0 34.25a5.38 5.38 0 0 0 5.38 5.39 5.38 5.38 0 0 0 5.37-5.4v-5.38H5.38A5.38 5.38 0 0 0 0 34.25m14.34 0V48.6A5.38 5.38 0 0 0 19.7 54a5.38 5.38 0 0 0 5.38-5.39V34.25a5.38 5.38 0 0 0-5.38-5.39 5.38 5.38 0 0 0-5.37 5.39\"/></svg>"),
	Rules: []string{
		"||slack-edge.com^",
		"||slack-files.com ^",
		"||slack-imgs.com^",
		"||slack.com^",
		"||slackb.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "snapchat",
	Name:    "Snapchat",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12.176 4c.715 0 3.136.191 4.277 2.668.383.828.285 2.273.211 3.437l-.004.051c-.008.164-.02.32-.027.469.015.02.164.156.492.168.25-.012.54-.086.855-.23a.784.784 0 0 1 .57.008h.005c.254.09.422.261.425.44.004.173-.128.43-.789.68a2.694 2.694 0 0 1-.25.082c-.375.118-.945.293-1.117.692-.097.215-.066.48.09.785 0 .004.004.008.004.012.047.105 1.187 2.62 3.73 3.027.094.016.16.094.153.188a.24.24 0 0 1-.024.101c-.105.238-.578.574-2.234.824-.133.02-.188.188-.266.547-.03.13-.058.258-.101.39-.035.118-.11.173-.235.173h-.02a2.34 2.34 0 0 1-.37-.043 4.986 4.986 0 0 0-.996-.102c-.23 0-.473.02-.715.059-.496.078-.918.367-1.363.672-.653.445-1.32.902-2.364.902-.047 0-.09 0-.136-.004-.028.004-.055.004-.086.004-1.043 0-1.711-.457-2.36-.902-.445-.305-.867-.594-1.363-.672a4.533 4.533 0 0 0-.719-.059c-.418 0-.75.063-.992.106a2.02 2.02 0 0 1-.371.054c-.102 0-.211-.023-.258-.18-.039-.136-.07-.269-.101-.394-.075-.328-.125-.531-.266-.55-1.656-.247-2.129-.587-2.234-.825-.012-.035-.024-.066-.024-.101a.182.182 0 0 1 .156-.188c2.54-.406 3.68-2.922 3.727-3.031.004 0 .004-.004.004-.008.156-.305.187-.57.094-.79-.176-.398-.747-.57-1.122-.687a3.147 3.147 0 0 1-.25-.082c-.75-.289-.812-.582-.785-.734.051-.254.407-.434.692-.434a.49.49 0 0 1 .207.04c.336.152.64.23.906.23.363 0 .52-.148.54-.168-.009-.164-.02-.34-.032-.52-.074-1.164-.168-2.609.21-3.433 1.138-2.477 3.555-2.668 4.27-2.668L12.133 4h.043m0-1.602h-.043l-.313.008v-.004c-.953 0-4.187.262-5.722 3.598-.387.844-.45 1.887-.422 2.922-.922.02-2 .625-2.215 1.726-.082.407-.184 1.786 1.781 2.54.012.003.02.007.031.011-.39.559-1.113 1.34-2.168 1.508-.902.14-1.55.941-1.5 1.86.016.226.067.44.153.64.41.938 1.406 1.363 2.543 1.613a1.83 1.83 0 0 0 1.785 1.305c.246 0 .465-.043.66-.078a3.44 3.44 0 0 1 .703-.082c.149 0 .305.012.465.039.14.023.457.238.711.41.73.5 1.727 1.184 3.266 1.184h.101c.04 0 .078.004.121.004 1.532 0 2.528-.68 3.258-1.176.281-.192.582-.399.723-.422.156-.024.312-.04.46-.04.259 0 .458.032.696.075.266.05.477.074.668.074.852 0 1.543-.508 1.785-1.293 1.137-.25 2.129-.672 2.535-1.593.094-.22.149-.43.16-.649a1.783 1.783 0 0 0-1.496-1.871c-1.054-.168-1.78-.95-2.172-1.508l.036-.011c1.601-.618 1.824-1.645 1.816-2.204-.02-.855-.594-1.601-1.477-1.918a2.37 2.37 0 0 0-.777-.156c.027-1.015-.039-2.078-.422-2.914-1.539-3.336-4.773-3.598-5.73-3.598zm0 0\" /></svg>"),
	Rules: []string{
		"||impala-media-production.s3.amazonaws.com^",
		"||sc-cdn.net^",
		"||snap-dev.net^",
		"||snapads.com^",
		"||snapchat.com^",
		"||snapkit.co",
	},
	GroupID: "social_network",
}, {
	ID:      "soundcloud",
	Name:    "SoundCloud",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\" fill-rule=\"evenodd\" clip-rule=\"evenodd\"><path d=\"M19 17.75c2.07 0 3.75-1.68 3.75-3.75 0-2.07-1.68-3.75-3.75-3.75-.173 0-.344.012-.511.035-.73-2.337-2.913-4.035-5.489-4.035-.818 0-1.596.171-2.301.48-.273.119-.449.389-.449.687l0 9.583c0 .414.336.75.75.75l8 0zM7.25 8l0 9c0 .414.336.75.75.75.414 0 .75-.336.75-.75l0-9c0-.414-.336-.75-.75-.75-.414 0-.75.336-.75.75zM4.25 10l0 7c0 .414.336.75.75.75.414 0 .75-.336.75-.75l0-7c0-.414-.336-.75-.75-.75-.414 0-.75.336-.75.75zM1.25 12l0 5c0 .414.336.75.75.75.414 0 .75-.336.75-.75l0-5c0-.414-.336-.75-.75-.75-.414 0-.75.336-.75.75z\"/></svg>"),
	Rules: []string{
		"||sndcdn.com^",
		"||soundcloud.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "spotify",
	Name:    "Spotify",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25.009,1.982C12.322,1.982,2,12.304,2,24.991S12.322,48,25.009,48s23.009-10.321,23.009-23.009S37.696,1.982,25.009,1.982z M34.748,35.333c-0.289,0.434-0.765,0.668-1.25,0.668c-0.286,0-0.575-0.081-0.831-0.252C30.194,34.1,26,33,22.5,33.001 c-3.714,0.002-6.498,0.914-6.526,0.923c-0.784,0.266-1.635-0.162-1.897-0.948s0.163-1.636,0.949-1.897 c0.132-0.044,3.279-1.075,7.474-1.077C26,30,30.868,30.944,34.332,33.253C35.022,33.713,35.208,34.644,34.748,35.333z M37.74,29.193 c-0.325,0.522-0.886,0.809-1.459,0.809c-0.31,0-0.624-0.083-0.906-0.26c-4.484-2.794-9.092-3.385-13.062-3.35 c-4.482,0.04-8.066,0.895-8.127,0.913c-0.907,0.258-1.861-0.272-2.12-1.183c-0.259-0.913,0.272-1.862,1.184-2.12 c0.277-0.079,3.854-0.959,8.751-1c4.465-0.037,10.029,0.61,15.191,3.826C37.995,27.328,38.242,28.388,37.74,29.193z M40.725,22.013 C40.352,22.647,39.684,23,38.998,23c-0.344,0-0.692-0.089-1.011-0.275c-5.226-3.068-11.58-3.719-15.99-3.725 c-0.021,0-0.042,0-0.063,0c-5.333,0-9.44,0.938-9.481,0.948c-1.078,0.247-2.151-0.419-2.401-1.495 c-0.25-1.075,0.417-2.149,1.492-2.4C11.729,16.01,16.117,15,21.934,15c0.023,0,0.046,0,0.069,0 c4.905,0.007,12.011,0.753,18.01,4.275C40.965,19.835,41.284,21.061,40.725,22.013z\" /></svg>"),
	Rules: []string{
		"/_spotify-connect._tcp.local/",
		"|audio-ak-spotify-com.akamaized.net^",
		"|audio4-ak-spotify-com.akamaized.net^",
		"|heads-ak-spotify-com.akamaized.net^",
		"|heads4-ak-spotify-com.akamaized.net^",
		"|spotify.com.edgesuite.net^",
		"|spotify.map.fastly.net^",
		"|spotify.map.fastlylb.net^",
		"||byspotify.com^",
		"||pscdn.co^",
		"||scdn.co^",
		"||spoti.fi^",
		"||spotify-everywhere.com^",
		"||spotify.com^",
		"||spotify.design^",
		"||spotifycdn.com^",
		"||spotifycdn.net^",
		"||spotifycharts.com^",
		"||spotifycodes.com^",
		"||spotifyforbrands.com^",
		"||spotifyjobs.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "spotify_video",
	Name:    "Spotify Video",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25.009,1.982C12.322,1.982,2,12.304,2,24.991S12.322,48,25.009,48s23.009-10.321,23.009-23.009S37.696,1.982,25.009,1.982z M34.748,35.333c-0.289,0.434-0.765,0.668-1.25,0.668c-0.286,0-0.575-0.081-0.831-0.252C30.194,34.1,26,33,22.5,33.001 c-3.714,0.002-6.498,0.914-6.526,0.923c-0.784,0.266-1.635-0.162-1.897-0.948s0.163-1.636,0.949-1.897 c0.132-0.044,3.279-1.075,7.474-1.077C26,30,30.868,30.944,34.332,33.253C35.022,33.713,35.208,34.644,34.748,35.333z M37.74,29.193 c-0.325,0.522-0.886,0.809-1.459,0.809c-0.31,0-0.624-0.083-0.906-0.26c-4.484-2.794-9.092-3.385-13.062-3.35 c-4.482,0.04-8.066,0.895-8.127,0.913c-0.907,0.258-1.861-0.272-2.12-1.183c-0.259-0.913,0.272-1.862,1.184-2.12 c0.277-0.079,3.854-0.959,8.751-1c4.465-0.037,10.029,0.61,15.191,3.826C37.995,27.328,38.242,28.388,37.74,29.193z M40.725,22.013 C40.352,22.647,39.684,23,38.998,23c-0.344,0-0.692-0.089-1.011-0.275c-5.226-3.068-11.58-3.719-15.99-3.725 c-0.021,0-0.042,0-0.063,0c-5.333,0-9.44,0.938-9.481,0.948c-1.078,0.247-2.151-0.419-2.401-1.495 c-0.25-1.075,0.417-2.149,1.492-2.4C11.729,16.01,16.117,15,21.934,15c0.023,0,0.046,0,0.069,0 c4.905,0.007,12.011,0.753,18.01,4.275C40.965,19.835,41.284,21.061,40.725,22.013z\" /></svg>"),
	Rules: []string{
		"||eip-ntt.video-ak.cdn.spotify.com.akahost.net^",
		"||video-ak.cdn.spotify.com^",
		"||video-akpcw-cdn-spotify-com.akamaized.net^",
		"||video-akpcw.spotifycdn.com.edgesuite.net^",
		"||video-akpcw.spotifycdn.com^",
		"||video-fa.scdn.co^",
	},
	GroupID: "streaming",
}, {
	ID:      "steam",
	Name:    "Steam",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 22 22\"><path d=\"M14.398 7.2a2.4 2.4 0 1 0 .003 4.799 2.4 2.4 0 0 0-.003-4.8zm0 0\" fill=\"none\" strokeWidth=\"1.6\" stroke=\"currentColor\" strokeMiterlimit=\"10\" /><path d=\"M8 14c-.629 0-1.18.297-1.547.75l1.758.48c.426.114.68.555.562.98a.804.804 0 0 1-.984.563l-1.762-.48A1.998 1.998 0 0 0 10 16c0-1.105-.895-2-2-2zm0 0\" /><path d=\"M19.2 3.2H4.8c-.886 0-1.6.714-1.6 1.6v9.063l2.027.551a3.213 3.213 0 0 1 2.289-1.566l2.136-2.567a4.799 4.799 0 1 1 4.066 4.066l-2.566 2.137A3.195 3.195 0 0 1 8 19.2 3.2 3.2 0 0 1 4.8 16c0-.016.005-.027.005-.043l-1.606-.437v3.68c0 .886.715 1.6 1.602 1.6h14.398c.887 0 1.602-.714 1.602-1.6V4.8c0-.886-.715-1.6-1.602-1.6zm0 0\" /></svg>"),
	Rules: []string{
		"|steambroadcast.akamaized.net^",
		"|steamcdn-a.akamaihd.net^",
		"|steamcommunity-a.akamaihd.net^",
		"|steamstore-a.akamaihd.net^",
		"|steamusercontent-a.akamaihd.net^",
		"|steamuserimages-a.akamaihd.net^",
		"|steamvideo-a.akamaihd.net^",
		"|xz.pphimalayanrt.com^",
		"||csgo.wmsj.cn^",
		"||dl.steam.clngaa.com^",
		"||dl.steam.ksyna.com^",
		"||dota2.wmsj.cn^",
		"||playartifact.com^",
		"||s.team^",
		"||st.dl.bscstorage.net^",
		"||st.dl.eccdnx.com^",
		"||st.dl.pinyuncloud.com^",
		"||steam-api.com^",
		"||steam-chat.com^",
		"||steamchina.com^",
		"||steamcommunity.com^",
		"||steamcontent.com^",
		"||steamdeck.com^",
		"||steamgames.com^",
		"||steampipe.steamcontent.tnkjmec.com^",
		"||steampowered.com.8686c.com^",
		"||steampowered.com^",
		"||steamserver.net^",
		"||steamstatic.com.8686c.com^",
		"||steamstatic.com^",
		"||steamusercontent.com^",
		"||underlords.com^",
		"||valvesoftware.com^",
		"||wmsjsteam.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "telegram",
	Name:    "Telegram (Web)",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M46.137,6.552c-0.75-0.636-1.928-0.727-3.146-0.238l-0.002,0C41.708,6.828,6.728,21.832,5.304,22.445 c-0.259,0.09-2.521,0.934-2.288,2.814c0.208,1.695,2.026,2.397,2.248,2.478l8.893,3.045c0.59,1.964,2.765,9.21,3.246,10.758 c0.3,0.965,0.789,2.233,1.646,2.494c0.752,0.29,1.5,0.025,1.984-0.355l5.437-5.043l8.777,6.845l0.209,0.125 c0.596,0.264,1.167,0.396,1.712,0.396c0.421,0,0.825-0.079,1.211-0.237c1.315-0.54,1.841-1.793,1.896-1.935l6.556-34.077 C47.231,7.933,46.675,7.007,46.137,6.552z M22,32l-3,8l-3-10l23-17L22,32z\" /></svg>"),
	Rules: []string{
		"||comments.app^",
		"||contest.com^",
		"||graph.org^",
		"||quiz.directory^",
		"||t.me^",
		"||tdesktop.com^",
		"||telega.one^",
		"||telegra.ph^",
		"||telegram-cdn.org^",
		"||telegram.dog^",
		"||telegram.me^",
		"||telegram.org^",
		"||telegram.space^",
		"||telesco.pe^",
		"||tg.dev^",
		"||tx.me^",
		"||usercontent.dev^",
	},
	GroupID: "messenger",
}, {
	ID:      "temu",
	Name:    "Temu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 256 256\"><path d=\"M199.1 0C230.525 0 256 25.475 256 56.9v142.2c0 31.425-25.475 56.9-56.9 56.9H56.9C25.475 256 0 230.525 0 199.1V56.9C0 25.475 25.475 0 56.9 0zm-64 132.98h-3.4c-3.025 0-5.5 2.45-5.475 5.475v37.625c0 3.025 2.45 5.5 5.475 5.5s5.5-2.45 5.5-5.5v-24.7l9.25 13.05c1.925 2.7 5.925 2.7 7.875 0l9.25-13.05v24.7a5.5 5.5 0 0 0 5.5 5.5c3.025 0 5.5-2.45 5.475-5.5v-37.625c0-3.025-2.45-5.5-5.475-5.475h-3.4c-1.3 0-2.55.625-3.3 1.7l-11.975 18-12-18a3.997 3.997 0 0 0-3.3-1.7zm85.05 0c-3.025 0-5.5 2.45-5.5 5.475v22.975c0 7.225-4.075 10.925-10.775 10.9-6.7 0-10.775-3.825-10.75-11.225v-22.65c0-3.025-2.45-5.5-5.5-5.475-3.025 0-5.5 2.45-5.475 5.475v22.9c0 13.4 8.2 20.225 21.6 20.225s21.9-6.75 21.875-20.55v-22.575c0-3.025-2.45-5.5-5.475-5.475zm-154.22 0H33.855c-3.025 0-5.5 2.45-5.5 5.475s2.45 5.5 5.5 5.5h10.55v32.075c0 3.025 2.45 5.5 5.475 5.5s5.5-2.45 5.5-5.5v-32.075h10.55a5.5 5.5 0 0 0 5.5-5.5c0-3.025-2.45-5.5-5.5-5.475zm47.475 0H83.68c-3.025 0-5.5 2.45-5.5 5.475v37.575a5.5 5.5 0 0 0 5.5 5.5h29.725c3.025 0 5.5-2.45 5.475-5.5 0-3.025-2.45-5.5-5.475-5.5h-24.25v-7.8h21.1c3.025 0 5.5-2.45 5.5-5.475s-2.45-5.5-5.5-5.5h-21.1v-7.8h24.25c3.025 0 5.5-2.45 5.475-5.5 0-3.025-2.45-5.5-5.475-5.475zM59.78 75.63l-1.025.025c-4.275.275-7.2 2.125-8.85 4.625-1.925-2.875-5.525-4.9-10.95-4.6l-.125.175c-.625 1-2.975 5.475.825 10.35.775.825 2.675 3.15 1.9 6.125L30.53 110.155c-.9 1.45-.5 3.325.875 4.3 2.85 2 8.575 4.75 18.5 4.75 9.9 0 15.625-2.75 18.475-4.75l.375-.325a3.179 3.179 0 0 0 .5-3.975l-11-17.825.075.325-.125-.5c-.6-2.675.9-4.8 1.725-5.75l.2-.2c3.825-4.875 1.45-9.325.825-10.35l-.1-.175zm35.7 8.35c-3.775-7.5-8.675-8.775-11.125-6.825-1.875 1.5-6.2 7.425-6.5 7.825-4.775 6.775-4.5 8.425 1.625 12.275 3.45 2.175 6.225-.625 7.425-1.45-.575 3.575-2.325 9.2-4.95 13.15-1.425-1.075-2.475-1.9-3.125-2.5-.825-.75-2.075-.7-2.875.075a1.865 1.865 0 0 0-.55 1.425c.025.525.25 1.025.625 1.375 6.375 5.825 14.75 9.125 23.675 9.15 8.95 0 17.375-3.3 23.75-9.15.825-.75.85-2 .1-2.8a2.07 2.07 0 0 0-2.875-.075c-.5.45-1 .875-1.525 1.3l-2.8-6.25c-.45-1.075-.95-2.425-1.5-4.05.275-.675.85-1.325 1.675-2.175.6-.6 1.1-1.2 1.475-1.775 1.85-2.925.8-4.65.225-5.8-1.325-2.7-3.4-1.825-4.9-.225-1.85 1.95-3.65 2.8-6.55 3.45-2.425.55-4.3.275-5.85-.7-2.15-1.325-5.45-6.25-5.45-6.25zm69.325-7.625c-8 7.6-.325 24.125-14.875 31.15-1.6.775-2.925-1.775-5.075-1.775-6.075.05-17.675 5.4-18.125 8.1-.375 2.225 4.575 4 19.175 4.025 12.7 0 16.8-19.325 21.25-19.35 4.45 0 2.375 17.525 1.9 19.35h4.65c-.4-1.825-.7-7.325-.675-15.1 0-7.775 1.4-9.5 2.525-15.375.975-5.1-6.575-9.525-10.75-11.025zm45.6.625H197.38c-8.425 0-15.425 6.525-16 14.925l-.95 13.475c-.45 6.4 4.625 11.825 11.025 11.85h24.85c6.425 0 11.475-5.425 11.05-11.85l-.95-13.475c-.6-8.4-7.575-14.925-16-14.925zm-110.65 31c3.925 0 6.925 1.925 8.025 5.5-2.675.7-5.35 1.05-8.075 1.025-4.1 0-5.55-.375-8.175-1.075 1.05-3.15 4.525-5.45 8.225-5.45zm98.225-19.825v.375c0 3.25 2.65 5.925 5.9 5.925s5.925-2.65 5.925-5.925v-.375c0-1.45 5.25-1.45 5.25 0v.375c0 6.15-5 11.15-11.175 11.15-6.15 0-11.15-5-11.15-11.15v-.375c0-1.45 5.225-1.45 5.25 0z\"/></svg>"),
	Rules: []string{
		"||kwcdn.com^",
		"||temu.com^",
	},
	GroupID: "shopping",
}, {
	ID:      "tidal",
	Name:    "Tidal",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 9 12 C 8.7615 12 8.5237969 12.091437 8.3417969 12.273438 L 1.2734375 19.341797 C 0.9094375 19.705797 0.9094375 20.294203 1.2734375 20.658203 L 8.3417969 27.726562 C 8.7057969 28.090563 9.2942031 28.090563 9.6582031 27.726562 L 16.726562 20.658203 C 16.908563 20.476203 17 20.2385 17 20 C 17 19.7615 16.908563 19.523797 16.726562 19.341797 L 9.6582031 12.273438 C 9.4762031 12.091437 9.2385 12 9 12 z M 17 20 C 17 20.2385 17.091438 20.476203 17.273438 20.658203 L 24.341797 27.726562 C 24.523797 27.908563 24.7615 28 25 28 C 25.2385 28 25.476203 27.908563 25.658203 27.726562 L 32.726562 20.658203 C 32.908563 20.476203 33 20.2385 33 20 C 33 19.7615 32.908563 19.523797 32.726562 19.341797 L 25.658203 12.273438 C 25.294203 11.909437 24.705797 11.909437 24.341797 12.273438 L 17.273438 19.341797 C 17.091437 19.523797 17 19.7615 17 20 z M 33 20 C 33 20.2385 33.091437 20.476203 33.273438 20.658203 L 40.341797 27.726562 C 40.705797 28.090563 41.294203 28.090563 41.658203 27.726562 L 48.726562 20.658203 C 49.090563 20.294203 49.090563 19.705797 48.726562 19.341797 L 41.658203 12.273438 C 41.294203 11.909437 40.705797 11.909437 40.341797 12.273438 L 33.273438 19.341797 C 33.091437 19.523797 33 19.7615 33 20 z M 25 28 C 24.7615 28 24.523797 28.091437 24.341797 28.273438 L 17.273438 35.341797 C 16.909437 35.705797 16.909437 36.294203 17.273438 36.658203 L 24.341797 43.726562 C 24.705797 44.090562 25.294203 44.090562 25.658203 43.726562 L 32.726562 36.658203 C 33.090563 36.294203 33.090563 35.705797 32.726562 35.341797 L 25.658203 28.273438 C 25.476203 28.091437 25.2385 28 25 28 z\"/></svg>"),
	Rules: []string{
		"||tidal.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "tiktok",
	Name:    "TikTok",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M41 4H9C6.243 4 4 6.243 4 9v32c0 2.757 2.243 5 5 5h32c2.757 0 5-2.243 5-5V9c0-2.757-2.243-5-5-5zm-3.994 18.323a7.482 7.482 0 0 1-.69.035 7.492 7.492 0 0 1-6.269-3.388v11.537a8.527 8.527 0 1 1-8.527-8.527c.178 0 .352.016.527.027v4.202c-.175-.021-.347-.053-.527-.053a4.351 4.351 0 1 0 0 8.704c2.404 0 4.527-1.894 4.527-4.298l.042-19.594h4.016a7.488 7.488 0 0 0 6.901 6.685v4.67z\" /></svg>"),
	Rules: []string{
		"||amemv.com^",
		"||bdurl.com^",
		"||bytecdn.cn^",
		"||bytedance.map.fastly.net^",
		"||bytedapm.com^",
		"||bytegoofy.com^",
		"||byteimg.com^",
		"||byteoversea.com^",
		"||bytescm.com^",
		"||douyin.com^",
		"||douyincdn.com^",
		"||douyinliving.com^",
		"||douyinpic.com^",
		"||douyinstatic.com^",
		"||douyinvod.com^",
		"||huoshan.com^",
		"||huoshanstatic.com^",
		"||huoshanzhibo.com^",
		"||muscdn.com^",
		"||musical.ly^",
		"||p16-tiktok-*.ibyteimg.com^",
		"||p16-tiktokcdn-com.akamaized.net^",
		"||pstatp.com^",
		"||snssdk.com^",
		"||tiktok.com^",
		"||tiktokcdn-us.com^",
		"||tiktokcdn.com^",
		"||tiktokrow-cdn.com^",
		"||tiktokv.com^",
		"||ttlivecdn.com.c.bytefcdn-oversea.com^",
		"||ttlivecdn.com^",
		"||v*.tiktokcdn-eu.com^",
		"||zijieapi.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "tinder",
	Name:    "Tinder",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25,48C13.225,48,5,39.888,5,28.271c0-6.065,3.922-12.709,9.325-15.797c0.151-0.086,0.322-0.132,0.496-0.132 c0.803,0,1.407,0.547,1.407,1.271c0,1.18,0.456,3.923,1.541,5.738c4.455-1.65,9.074-5.839,7.464-16.308 c-0.008-0.051-0.012-0.102-0.012-0.152c0-0.484,0.217-0.907,0.579-1.132c0.34-0.208,0.764-0.221,1.14-0.034 C31.173,3.808,45,11.892,45,28.407C45,39.394,36.215,48,25,48z M26.052,3.519c0.003,0.001,0.005,0.002,0.008,0.004 C26.057,3.521,26.055,3.52,26.052,3.519z\" /></svg>"),
	Rules: []string{
		"||gotinder.com^",
		"||tinder.com^",
		"||tindersparks.com^",
	},
	GroupID: "dating",
}, {
	ID:      "tumblr",
	Name:    "Tumblr",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M40 0H10A10 10 0 0 0 0 10v30a10 10 0 0 0 10 10h30a10 10 0 0 0 10-10V10A10 10 0 0 0 40 0Zm-6 40.24c0 .12-.05.24-.14.32-.12.1-2.85 2.44-9.12 2.44-7.51 0-7.74-8.38-7.74-9.34V23.01L13.43 23a.42.42 0 0 1-.43-.42V18.8c0-.18.1-.34.27-.4.07-.03 6.79-2.64 6.79-8.98 0-.24.2-.43.43-.43h4.09c.24 0 .43.2.43.43L25 17h6.56c.24 0 .43.2.43.45v5.1c0 .24-.19.45-.43.45H25v10.5c0 .25.23 3.27 3.43 3.27a10.3 10.3 0 0 0 4.91-1.39c.14-.08.3-.09.44 0 .13.07.22.21.22.37Z\"/></svg>"),
	Rules: []string{
		"||tumblr.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "twitch",
	Name:    "Twitch",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M4.8 3.2L3.2 6.397V19.2h4v2.403h3.198l2.403-2.403H16l4.8-4.8v-11.2zm14.4 10.402L16.8 16H12l-2.398 2.398V16H6.398V4.8H19.2zm0 0\" /><path d=\"M15.2 12.8h-1.598V7.2h1.597zm-3.2 0h-1.602V7.2H12zm0 0\" /></svg>"),
	Rules: []string{
		"||ext-twitch.tv^",
		"||jtvnw.net^",
		"||ttvnw.net^",
		"||twitch.tv^",
		"||twitchcdn.net^",
		"||twitchsvc.net^",
	},
	GroupID: "streaming",
}, {
	ID:      "twitter",
	Name:    "X (formerly Twitter)",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z\"/></svg>"),
	Rules: []string{
		"||ads-twitter.com^",
		"||cms-twdigitalassets.com^",
		"||periscope.tv^",
		"||pscp.tv^",
		"||t.co^",
		"||tellapart.com^",
		"||tweetdeck.com^",
		"||twimg.com^",
		"||twitpic.com^",
		"||twitter.biz^",
		"||twitter.com^",
		"||twitter.jp^",
		"||twittercommunity.com^",
		"||twitterflightschool.com^",
		"||twitterinc.com^",
		"||twitteroauth.com^",
		"||twitterstat.us^",
		"||twtrdns.net^",
		"||twttr.com^",
		"||twttr.net^",
		"||twvid.com^",
		"||vine.co^",
		"||x.com^",
	},
	GroupID: "social_network",
}, {
	ID:      "ubisoft",
	Name:    "Ubisoft",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><path d=\"M15.22 3C7.14 3 3.66 10.18 3.66 10.18l1.03.74s-1.3 2.45-1.26 5.6A12.5 12.5 0 0 0 16.08 29a12.5 12.5 0 0 0 12.49-12.46c0-9-6.98-13.54-13.35-13.54zm.07 2.2c6.3 0 11.2 5.07 11.2 10.98 0 6.27-4.71 10.62-10.2 10.62-4.04 0-7.69-3.08-7.69-7.3a5.8 5.8 0 0 1 2.75-5.03l.21.23a6.37 6.37 0 0 0-1.53 3.91c0 3.32 2.6 5.62 5.88 5.62 4.18 0 6.97-3.56 6.97-7.7 0-4.81-4.25-8.9-9.36-8.9a11.1 11.1 0 0 0-6.61 2.3l-.21-.2a10.07 10.07 0 0 1 8.59-4.54zM13.4 9.8c3.26 0 6.44 2.15 7.24 5.22l-.3.1a8.35 8.35 0 0 0-6.52-3.44c-5.08 0-7.75 4.62-7.36 8.47l-.3.12s-.56-1.24-.56-2.71a7.8 7.8 0 0 1 7.8-7.76zm2.15 5.33a2.77 2.77 0 0 1 2.78 2.74c0 1.23-.79 1.96-.79 1.96l.94.65s-.93 1.46-2.82 1.46a3.4 3.4 0 0 1-.1-6.8z\"/></svg>"),
	Rules: []string{
		"||ubi.com^",
		"||ubisoft.com^",
		"||ubisoft.org^",
		"||ubisoftconnect.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "valorant",
	Name:    "Valorant",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M4 6a1 1 0 0 0-1 1v18a1 1 0 0 0 .2.6l14 17a1 1 0 0 0 .8.4h14a1 1 0 0 0 .8-1.6l-28-35A1 1 0 0 0 4 6zm42 1a1 1 0 0 0-.8.4l-18 22A1 1 0 0 0 28 31h14a1 1 0 0 0 .8-.4l4-5a1 1 0 0 0 .2-.6V8a1 1 0 0 0-1-1zM5 9.9 30 41H18.4L5 24.6V10zm40 .9v13.8L41.5 29H30.1L45 10.8z\"/></svg>"),
	Rules: []string{
		"||playvalorant.com",
		"||valorant.scd.riotcdn.net",
		"||valorant.secure.dyn.riotcdn.net",
	},
	GroupID: "gaming",
}, {
	ID:      "viber",
	Name:    "Viber",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 44.78125 13.15625 C 44 10.367188 42.453125 8.164063 40.1875 6.605469 C 37.328125 4.632813 34.039063 3.9375 31.199219 3.511719 C 27.269531 2.925781 23.710938 2.84375 20.316406 3.257813 C 17.136719 3.648438 14.742188 4.269531 12.558594 5.273438 C 8.277344 7.242188 5.707031 10.425781 4.921875 14.734375 C 4.539063 16.828125 4.28125 18.71875 4.132813 20.523438 C 3.789063 24.695313 4.101563 28.386719 5.085938 31.808594 C 6.046875 35.144531 7.722656 37.527344 10.210938 39.09375 C 10.84375 39.492188 11.65625 39.78125 12.441406 40.058594 C 12.886719 40.214844 13.320313 40.367188 13.675781 40.535156 C 14.003906 40.6875 14.003906 40.714844 14 40.988281 C 13.972656 43.359375 14 48.007813 14 48.007813 L 14.007813 49 L 15.789063 49 L 16.078125 48.71875 C 16.269531 48.539063 20.683594 44.273438 22.257813 42.554688 L 22.472656 42.316406 C 22.742188 42.003906 22.742188 42.003906 23.019531 42 C 25.144531 41.957031 27.316406 41.875 29.472656 41.757813 C 32.085938 41.617188 35.113281 41.363281 37.964844 40.175781 C 40.574219 39.085938 42.480469 37.355469 43.625 35.035156 C 44.820313 32.613281 45.527344 29.992188 45.792969 27.019531 C 46.261719 21.792969 45.929688 17.257813 44.78125 13.15625 Z M 35.382813 33.480469 C 34.726563 34.546875 33.75 35.289063 32.597656 35.769531 C 31.753906 36.121094 30.894531 36.046875 30.0625 35.695313 C 23.097656 32.746094 17.632813 28.101563 14.023438 21.421875 C 13.277344 20.046875 12.761719 18.546875 12.167969 17.09375 C 12.046875 16.796875 12.054688 16.445313 12 16.117188 C 12.050781 13.769531 13.851563 12.445313 15.671875 12.046875 C 16.367188 11.890625 16.984375 12.136719 17.5 12.632813 C 18.929688 13.992188 20.058594 15.574219 20.910156 17.347656 C 21.28125 18.125 21.113281 18.8125 20.480469 19.390625 C 20.347656 19.511719 20.210938 19.621094 20.066406 19.730469 C 18.621094 20.816406 18.410156 21.640625 19.179688 23.277344 C 20.492188 26.0625 22.671875 27.933594 25.488281 29.09375 C 26.230469 29.398438 26.929688 29.246094 27.496094 28.644531 C 27.574219 28.566406 27.660156 28.488281 27.714844 28.394531 C 28.824219 26.542969 30.4375 26.726563 31.925781 27.78125 C 32.902344 28.476563 33.851563 29.210938 34.816406 29.917969 C 36.289063 31 36.277344 32.015625 35.382813 33.480469 Z M 26.144531 15 C 25.816406 15 25.488281 15.027344 25.164063 15.082031 C 24.617188 15.171875 24.105469 14.804688 24.011719 14.257813 C 23.921875 13.714844 24.289063 13.199219 24.835938 13.109375 C 25.265625 13.035156 25.707031 13 26.144531 13 C 30.476563 13 34 16.523438 34 20.855469 C 34 21.296875 33.964844 21.738281 33.890625 22.164063 C 33.808594 22.652344 33.386719 23 32.90625 23 C 32.851563 23 32.796875 22.996094 32.738281 22.984375 C 32.195313 22.894531 31.828125 22.378906 31.917969 21.835938 C 31.972656 21.515625 32 21.1875 32 20.855469 C 32 17.628906 29.371094 15 26.144531 15 Z M 31 21 C 31 21.550781 30.550781 22 30 22 C 29.449219 22 29 21.550781 29 21 C 29 19.347656 27.652344 18 26 18 C 25.449219 18 25 17.550781 25 17 C 25 16.449219 25.449219 16 26 16 C 28.757813 16 31 18.242188 31 21 Z M 36.710938 23.222656 C 36.605469 23.6875 36.191406 24 35.734375 24 C 35.660156 24 35.585938 23.992188 35.511719 23.976563 C 34.972656 23.851563 34.636719 23.316406 34.757813 22.777344 C 34.902344 22.140625 34.976563 21.480469 34.976563 20.816406 C 34.976563 15.957031 31.019531 12 26.160156 12 C 25.496094 12 24.835938 12.074219 24.199219 12.21875 C 23.660156 12.34375 23.125 12.003906 23.003906 11.464844 C 22.878906 10.925781 23.21875 10.390625 23.757813 10.269531 C 24.539063 10.089844 25.347656 10 26.160156 10 C 32.125 10 36.976563 14.851563 36.976563 20.816406 C 36.976563 21.628906 36.886719 22.4375 36.710938 23.222656 Z\" /></svg>"),
	Rules: []string{
		"||viber.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "vimeo",
	Name:    "Vimeo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 41 5 C 34.210938 4.992188 30.46875 8.796875 28.167969 16.210938 C 29.371094 15.765625 30.578125 15.214844 31.671875 15.214844 C 33.972656 15.214844 34.738281 16.070313 34.410156 18.726563 C 34.300781 20.386719 33.644531 23.066406 31.671875 26.164063 C 29.699219 29.152344 27.984375 30 27 30 C 25.796875 30 24.882813 28.269531 23.898438 23.621094 C 23.570313 22.292969 22.804688 19.304688 21.925781 13.664063 C 21.160156 8.464844 18.613281 5.667969 15 6 C 13.46875 6.109375 11.636719 7.535156 8.570313 10.191406 C 6.378906 12.183594 4.300781 13.621094 2 15.613281 L 4.191406 18.421875 C 6.269531 16.984375 7.476563 16.429688 7.804688 16.429688 C 9.335938 16.429688 10.757813 18.863281 12.183594 23.84375 C 13.386719 28.378906 14.699219 32.914063 15.90625 37.449219 C 17.765625 42.429688 20.066406 44.863281 22.695313 44.863281 C 27.074219 44.863281 32.328125 40.882813 38.570313 32.695313 C 44.699219 24.949219 47.78125 18.535156 48 14 C 48.21875 8.027344 45.816406 5.109375 41 5 Z\" /></svg>"),
	Rules: []string{
		"*vod-adaptive.akamaized.net^",
		"||livestream.com^",
		"||vhx.tv^",
		"||vhxqa1.com^",
		"||vhxqa2.com^",
		"||vhxqa3.com^",
		"||vhxqa4.com^",
		"||vhxqa6.com^",
		"||vimeo-staging.com^",
		"||vimeo-staging2.com^",
		"||vimeo.com^",
		"||vimeo.fr^",
		"||vimeobusiness.com^",
		"||vimeocdn.com^",
		"||vimeogoods.com^",
		"||vimeoondemand.com^",
		"||vimeostatus.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "vk",
	Name:    "VK.com",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12 .96C5.914.96.96 5.915.96 12c0 6.086 4.954 11.04 11.04 11.04 6.086 0 11.04-4.954 11.04-11.04C23.04 5.914 18.085.96 12 .96zm4.785 13.216c1.074.953 1.3 1.293 1.336 1.351.445.707-.492.793-.492.793h-1.98s-.481.004-.891-.27c-.672-.437-1.375-1.288-1.867-1.14-.414.125-.41.684-.41 1.16 0 .172-.149.25-.481.25h-.617c-1.086 0-2.262-.363-3.434-1.59-1.656-1.734-3.113-5.222-3.113-5.222s-.086-.176.008-.281c.105-.122.394-.106.394-.106h1.918s.18.031.309.125c.11.074.168.219.168.219s.32 1.062.734 1.742c.801 1.32 1.172 1.355 1.445 1.215.399-.207.266-1.617.266-1.617s.02-.602-.187-.871c-.16-.211-.465-.32-.598-.336-.11-.016.07-.203.3-.313.31-.137.727-.172 1.446-.164.563.004.723.04.941.09.665.152.5.555.5 1.969 0 .453-.062 1.09.278 1.3.148.09.652.204 1.55-1.257.43-.692.77-1.84.77-1.84s.067-.125.176-.188c.113-.066.11-.062.262-.062.152 0 1.683-.012 2.02-.012.335 0 .651-.004.702.191.078.282-.246 1.25-1.07 2.305-1.355 1.723-1.504 1.563-.383 2.559zm0 0\" /></svg>"),
	Rules: []string{
		"||mvk.com^",
		"||userapi.com^",
		"||vk-cdn.me^",
		"||vk-cdn.net^",
		"||vk-portal.net^",
		"||vk.cc^",
		"||vk.com^",
		"||vk.design^",
		"||vk.link^",
		"||vk.me^",
		"||vkcache.com^",
		"||vkgo.app^",
		"||vklive.app^",
		"||vkmessenger.app^",
		"||vkmessenger.com^",
		"||vkontakte.ru^",
		"||vkuseraudio.com^",
		"||vkuserlive.net^",
		"||vkuservideo.com^",
		"||vkuservideo.net^",
	},
	GroupID: "social_network",
}, {
	ID:      "voot",
	Name:    "Voot",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M96 340c-1 4-4 6-7 6H48c-3 0-6-2-8-6L0 213c-1-2 0-5 2-5l2-1h30c4 0 7 3 8 6l25 87c1 3 2 3 3 0l25-87c1-3 4-6 7-6h31c2 0 4 2 4 4v2L96 340zm46-50v-32c0-29 14-56 63-56s63 27 63 56v32c0 28-14 56-63 56s-63-28-63-56zm85 1v-35c0-13-7-20-22-20s-22 7-22 20v35c0 13 7 20 22 20s22-7 22-20zm54-1v-32c0-29 14-56 63-56s63 27 63 56v32c0 28-14 56-63 56s-63-28-63-56zm85 1v-35c0-13-7-20-22-20s-21 7-21 20v35c0 13 6 20 21 20s22-7 22-20zm144 44-2-17-1-2c-1-3-3-5-6-5h-2l-10 1c-2 1-4 0-6-2l-2-11v-56c0-3 2-6 6-6h17c4 0 6-2 7-5l1-22c0-3-2-5-5-6h-21c-3 0-5-2-5-5v-28c0-3-2-5-5-5h-1l-30 4c-3 1-5 4-5 7v22c0 3-3 5-6 5h-7c-4 0-6 3-6 6v22c0 3 2 5 6 5h7c3 0 6 3 6 6v67c0 26 15 36 42 36 8 0 16-1 23-4h1c2 0 5-3 5-6l-1-1z\"/></svg>"),
	Rules: []string{
		"||voot.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "wargaming",
	Name:    "Wargaming",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12 1.998c-5.52 0-10 4.481-10 9.988 0 5.52 4.48 9.996 10 9.996s10-4.476 10-9.996c0-5.507-4.48-9.988-10-9.988zm0 2c4.413 0 8 3.588 8 7.988 0 3.246-1.944 6.04-4.727 7.293.54-1.861.831-3.988.807-6.226l1.414.414a23.648 23.648 0 0 0-2-4.041c-.627 1.347-1.48 2.56-2.52 3.68l1.68-.133c-1.507 2.92-3.134 3.906-5.547 4.013-.386-4.213.12-7.014 2.827-9.04l.386 1.493c.653-.974 1.36-2.12 2.373-2.947-1.506-.6-2.999-.627-4.492-.334.386.16.76.588 1.014.828-3.485 1.662-5.643 4.202-6.744 7.68A7.95 7.95 0 0 1 4 11.986c0-4.4 3.587-7.988 8-7.988z\"/></svg>"),
	Rules: []string{
		"||wargaming.com^",
		"||wargaming.net^",
		"||wgcdn.co^",
		"||wgcrowd.io^",
		"||worldoftanks.com^",
		"||worldofwarplanes.com^",
		"||worldofwarships.eu^",
		"||wotblitz.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "wechat",
	Name:    "WeChat",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 19 6 C 9.625 6 2 12.503906 2 20.5 C 2 24.769531 4.058594 28.609375 7.816406 31.390625 L 5.179688 39.304688 L 13.425781 34.199219 C 15.714844 34.917969 18.507813 35.171875 21.203125 34.875 C 23.390625 39.109375 28.332031 42 34 42 C 35.722656 42 37.316406 41.675781 38.796875 41.234375 L 45.644531 45.066406 L 43.734375 38.515625 C 46.3125 36.375 48 33.394531 48 30 C 48 23.789063 42.597656 18.835938 35.75 18.105469 C 34.40625 11.152344 27.367188 6 19 6 Z M 13 14 C 14.101563 14 15 14.898438 15 16 C 15 17.101563 14.101563 18 13 18 C 11.898438 18 11 17.101563 11 16 C 11 14.898438 11.898438 14 13 14 Z M 25 14 C 26.101563 14 27 14.898438 27 16 C 27 17.101563 26.101563 18 25 18 C 23.898438 18 23 17.101563 23 16 C 23 14.898438 23.898438 14 25 14 Z M 34 20 C 40.746094 20 46 24.535156 46 30 C 46 32.957031 44.492188 35.550781 42.003906 37.394531 L 41.445313 37.8125 L 42.355469 40.933594 L 39.105469 39.109375 L 38.683594 39.25 C 37.285156 39.71875 35.6875 40 34 40 C 27.253906 40 22 35.464844 22 30 C 22 24.535156 27.253906 20 34 20 Z M 29.5 26 C 28.699219 26 28 26.699219 28 27.5 C 28 28.300781 28.699219 29 29.5 29 C 30.300781 29 31 28.300781 31 27.5 C 31 26.699219 30.300781 26 29.5 26 Z M 38.5 26 C 37.699219 26 37 26.699219 37 27.5 C 37 28.300781 37.699219 29 38.5 29 C 39.300781 29 40 28.300781 40 27.5 C 40 26.699219 39.300781 26 38.5 26 Z\" /></svg>"),
	Rules: []string{
		"||wechat.com^",
		"||weixin.qq.com.cn^",
		"||weixin.qq.com^",
		"||weixinbridge.com^",
		"||wx.qq.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "weibo",
	Name:    "Weibo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 35 6 C 34.222656 6 33.472656 6.078125 32.75 6.207031 C 32.207031 6.300781 31.84375 6.820313 31.9375 7.363281 C 32.03125 7.910156 32.550781 8.273438 33.09375 8.179688 C 33.726563 8.066406 34.359375 8 35 8 C 41.085938 8 46 12.914063 46 19 C 46 20.316406 45.757813 21.574219 45.328125 22.753906 C 45.195313 23.09375 45.253906 23.476563 45.484375 23.757813 C 45.71875 24.039063 46.082031 24.171875 46.441406 24.105469 C 46.800781 24.039063 47.09375 23.78125 47.207031 23.4375 C 47.710938 22.054688 48 20.566406 48 19 C 48 11.832031 42.167969 6 35 6 Z M 35 12 C 34.574219 12 34.171875 12.042969 33.789063 12.109375 C 33.246094 12.207031 32.878906 12.722656 32.976563 13.269531 C 33.070313 13.8125 33.589844 14.175781 34.132813 14.082031 C 34.425781 14.03125 34.714844 14 35 14 C 37.773438 14 40 16.226563 40 19 C 40 19.597656 39.890625 20.167969 39.691406 20.707031 C 39.503906 21.226563 39.773438 21.800781 40.292969 21.988281 C 40.8125 22.175781 41.386719 21.910156 41.574219 21.390625 C 41.84375 20.648438 42 19.84375 42 19 C 42 15.144531 38.855469 12 35 12 Z M 21.175781 12.40625 C 17.964844 12.34375 13.121094 14.878906 8.804688 19.113281 C 4.511719 23.40625 2 27.90625 2 31.78125 C 2 39.3125 11.628906 43.8125 21.152344 43.8125 C 33.5 43.8125 41.765625 36.699219 41.765625 31.046875 C 41.765625 27.59375 38.835938 25.707031 36.21875 24.871094 C 35.59375 24.660156 35.175781 24.558594 35.488281 23.71875 C 35.695313 23.21875 36 22.265625 36 21 C 36 19.5625 35 18.316406 33 18.09375 C 32.007813 17.984375 28 18 25.339844 19.113281 C 25.339844 19.113281 23.871094 19.746094 24.289063 18.59375 C 25.023438 16.292969 24.917969 14.40625 23.765625 13.359375 C 23.140625 12.730469 22.25 12.425781 21.175781 12.40625 Z M 20.3125 23.933594 C 28.117188 23.933594 34.441406 27.914063 34.441406 32.828125 C 34.441406 37.738281 28.117188 41.71875 20.3125 41.71875 C 12.511719 41.71875 6.1875 37.738281 6.1875 32.828125 C 6.1875 27.914063 12.511719 23.933594 20.3125 23.933594 Z M 19.265625 26.023438 C 16.246094 26.046875 13.3125 27.699219 12.039063 30.246094 C 10.46875 33.484375 11.933594 37.042969 15.699219 38.191406 C 19.464844 39.445313 23.960938 37.5625 25.53125 34.113281 C 27.097656 30.769531 25.113281 27.214844 21.347656 26.277344 C 20.660156 26.097656 19.960938 26.019531 19.265625 26.023438 Z M 20.824219 30.25 C 21.402344 30.25 21.871094 30.714844 21.871094 31.292969 C 21.871094 31.871094 21.402344 32.339844 20.824219 32.339844 C 20.246094 32.339844 19.777344 31.871094 19.777344 31.292969 C 19.777344 30.714844 20.246094 30.25 20.824219 30.25 Z M 16.417969 31.292969 C 16.746094 31.296875 17.074219 31.347656 17.382813 31.453125 C 18.722656 31.878906 19.132813 33.148438 18.308594 34.207031 C 17.589844 35.265625 15.945313 35.792969 14.707031 35.265625 C 13.476563 34.738281 13.167969 33.464844 13.886719 32.515625 C 14.425781 31.71875 15.429688 31.28125 16.417969 31.292969 Z\" /></svg>"),
	Rules: []string{
		"||wbimg.cn^",
		"||wbimg.com^",
		"||wcdn.cn^",
		"||weibo.cn^",
		"||weibo.com.cn^",
		"||weibo.com^",
		"||weibocdn.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "whatsapp",
	Name:    "WhatsApp",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M3.836 16.668l-1.352 4.934 5.047-1.329zm0 0\" /><path d=\"M12 2.398C6.7 2.398 2.398 6.7 2.398 12c0 5.3 4.301 9.602 9.602 9.602 5.3 0 9.602-4.301 9.602-9.602 0-5.3-4.301-9.602-9.602-9.602zm4.738 12.915c-.195.554-1.168 1.093-1.601 1.128-.442.043-.852.2-2.856-.59-2.418-.953-3.945-3.433-4.062-3.593-.121-.156-.969-1.285-.969-2.453 0-1.172.613-1.746.828-1.985a.875.875 0 0 1 .637-.297c.156 0 .316 0 .453.004.172.004.36.016.535.41.215.47.676 1.645.735 1.766.058.117.101.262.019.418-.078.156-.121.254-.234.399-.121.136-.25.308-.36.41-.117.12-.242.25-.101.488.136.238.613 1.016 1.32 1.645.906.812 1.672 1.062 1.91 1.18.238.12.38.1.516-.06.14-.156.594-.69.754-.93.156-.237.316-.198.531-.12.219.078 1.39.656 1.629.773.238.121.394.18.453.278.063.097.063.574-.137 1.129zm0 0\" /></svg>"),
	Rules: []string{
		"||wa.me^",
		"||whatsapp-plus.info^",
		"||whatsapp-plus.me^",
		"||whatsapp-plus.net^",
		"||whatsapp.cc^",
		"||whatsapp.com^",
		"||whatsapp.info^",
		"||whatsapp.net^",
		"||whatsapp.org^",
		"||whatsapp.tv^",
		"||whatsappbrand.com^",
	},
	GroupID: "messenger",
}, {
	ID:      "wizz",
	Name:    "Wizz",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 -297 867 867\"><path d=\"M94.66 31.7c0-11.49-7.72-21.78-17.23-23.05Q47.26 4.74 17.18.16C7.7-1.34 0 7.77 0 20.57v207.77c0 25.69 15.38 43.88 34.38 40.93q44.73-6.52 89.6-11.57c17.66-2.09 32.49-18.81 34.34-38.88q4.86-52.95 9.73-105.04c.54-5.82 8.04-5.63 8.59.16q4.86 51.9 9.73 103.01c1.85 19.55 16.69 33.01 34.4 31.58q44.97-3.47 90.02-5.46a36.76 36.76 0 0 0 34.66-36.57V47.86a18.27 18.27 0 0 0-17.33-18.23q-30.32-1.15-60.63-2.97c-9.56-.59-17.31 7.13-17.31 17.32v112.25c0 5.52-7.5 6.48-8.57 1.06q-10.13-51.32-20.26-104c-3.38-17.49-17.5-31.07-33.85-32.59q-15.16-1.35-30.32-2.87c-16.34-1.7-30.42 10.04-33.79 28.63q-10.1 55.6-20.2 113.34c-1.06 6.1-8.52 5.4-8.52-.87Zm297.01-.38c-12.77-.2-23.11 7.4-23.12 17.07V223.6c0 9.69 10.35 17.28 23.12 17.08q41.4-.63 82.8 0c12.77.2 23.11-7.4 23.11-17.08V48.4c0-9.69-10.34-17.28-23.11-17.08q-41.4.62-82.8 0ZM520.7 47.87a18.28 18.28 0 0 1 17.33-18.23q64.98-2.47 129.85-8c9.55-.84 17.3 7.09 17.3 17.78v65.23c0 18.33-11.46 34.12-27.47 37.67q-27.56 6.23-55.16 12.04c-5.08 1.07-4.31 8.95.9 9.04q32.23.5 64.44 1.2c9.55.17 17.29 9 17.29 19.7v48.28c0 10.7-7.74 18.62-17.3 17.78q-64.84-5.53-129.84-8a18.27 18.27 0 0 1-17.33-18.23V164.9a35.26 35.26 0 0 1 27.86-34.62q29.6-6.15 59.18-12.68c5.12-1.14 4.38-9.15-.85-9.06q-34.42.55-68.86.87a17.3 17.3 0 0 1-17.33-17.48Zm181.75-9.81c0-10.8 7.74-20.32 17.28-21.34Q784.49 9.97 848.97.16c9.5-1.49 17.18 7.62 17.18 20.41v77.96c0 21.94-11.38 40.83-27.3 44.95q-27.4 7.28-54.87 13.76c-5.06 1.2-4.29 10.3.9 10.47q32.08 1.03 64.1 2.25c9.49.31 17.18 10.96 17.18 23.75v57.72c0 12.8-7.7 21.9-17.19 20.41q-64.46-9.8-129.24-16.56c-9.54-1.03-17.27-10.55-17.27-21.34v-65.82c0-18.61 11.63-34.66 27.77-38.57q29.49-7.02 58.92-14.88c5.1-1.37 4.36-10.67-.85-10.49q-34.25 1.11-68.57 2c-9.54.22-17.27-8.36-17.27-19.15Z\"/></svg>"),
	Rules: []string{
		"||getwizz.io^",
		"||wizz.chat^",
		"||wizzapp.com^",
	},
	GroupID: "dating",
}, {
	ID:      "xboxlive",
	Name:    "Xbox Live",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 84 84\" fill=\"currentColor\"><path d=\"M42.44 34.08c12.8 9.73 34.5 33.65 27.94 40.42a42.24 42.24 0 0 1-27.94 10.48A42.03 42.03 0 0 1 14.5 74.5c-6.67-6.77 15.13-30.69 27.83-40.32 0-.1.1-.1.1-.1ZM64.56 6.24A41.32 41.32 0 0 0 42.43 0a41.32 41.32 0 0 0-22.11 6.24c-.1 0-.1.1-.1.21s.1.11.2.11c8.26-1.8 20.75 5.3 21.91 6.03h.21c1.17-.74 13.65-7.83 21.9-6.03.12 0 .22 0 .22-.1s0-.22-.1-.22ZM12.7 12.17c-.1 0-.1.1-.21.1a42.56 42.56 0 0 0-3.81 55.88c0 .11.1.11.2.11s.11-.1 0-.21C5.62 57.99 22.23 33.75 30.8 23.6l.11-.1c0-.11 0-.11-.1-.11-13.02-12.91-17.36-11.54-18.1-11.22Zm41.38 11.11-.1.1s0 .11.1.11c8.57 10.16 25.08 34.4 21.9 44.45v.22c.11 0 .22 0 .22-.11a42.53 42.53 0 0 0 8.67-25.72 42.21 42.21 0 0 0-12.59-30.16c-.1-.1-.1-.1-.21-.1-.64-.22-4.97-1.6-18 11.21Z\"/></svg>"),
	Rules: []string{
		"||gamepass.com^",
		"||xbox-global.ifs.windows.com^",
		"||xbox-guide-public.rec.mp.microsoft.com^",
		"||xbox.ipv6.microsoft.com^",
		"||xboxab.com^",
		"||xboxab.net^",
		"||xboxlive.com^",
		"||xboxservices.com^",
	},
	GroupID: "gaming",
}, {
	ID:      "xiaohongshu",
	Name:    "Xiaohongshu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M35 22v2h1v-2h-1zm0 0v2h1v-2h-1zm9-18H6c-1.09 0-2 .91-2 2v38c0 1.09.91 2 2 2h38c1.09 0 2-.91 2-2V6c0-1.09-.91-2-2-2zM12 24c0 1.38-.19 5.89-2.61 6.24l-.28-1.98c.39-.19.89-2.14.89-4.26v-2h2v2zm3 6h-2V19h2v11zm2.29-.29c-1.2-1.2-1.29-4.73-1.29-5.78V22h2v1.93c0 1.91.34 3.99.71 4.36l-1.42 1.42zM22 31h-3l1-2h3l-1 2zm9 0h-7l1-2h2v-7h-2l-2.1 4.38h1.72l-1 2H21a1 1 0 0 1-.82-1.57L22 24h-2a1 1 0 0 1-.86-1.51l3-5 1.72 1.02L21.77 22H25v-2h6v2h-2v7h2v2zm9-2.5a2.5 2.5 0 0 1-2.5 2.5c-1.21 0-1.22-.86-1.45-2H38v-3h-3v5h-2v-5h-2v-2h2v-2h-1v-2h1v-1h2v1h1a2 2 0 0 1 2 2v2a2 2 0 0 1 2 2v2.5zm0-6.5h-1v-1c0-.55.45-1 1-1s1 .45 1 1-.45 1-1 1zm-5 2h1v-2h-1v2zm0-2v2h1v-2h-1z\"/></svg>"),
	Rules: []string{
		"||xhscdn.com^",
		"||xhscdn.net^",
		"||xiaohongshu.com.my^",
		"||xiaohongshu.com^",
		"||xiaohongshu.net^",
	},
	GroupID: "shopping",
}, {
	ID:      "youtube",
	Name:    "YouTube",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M19.695 4.04S15.348 3.2 12 3.2s-7.695.84-7.695.84L1.602 7.2v9.6l2.703 3.16s4.347.84 7.695.84 7.695-.84 7.695-.84l2.703-3.16V12 7.2zM9.602 15.68V8.32L16 12zm0 0\" /><path d=\"M19.2 4a3.198 3.198 0 1 0 0 6.398c1.769 0 3.198-1.43 3.198-3.199C22.398 5.434 20.968 4 19.2 4zm0 9.602a3.198 3.198 0 1 0 0 6.398c1.769 0 3.198-1.434 3.198-3.2 0-1.769-1.43-3.198-3.199-3.198zM1.601 7.199c0 1.77 1.43 3.2 3.199 3.2 1.765 0 2.398-1.43 2.398-3.2C7.2 5.434 6.566 4 4.801 4 3.03 4 1.6 5.434 1.6 7.2zM4.8 13.602c-1.77 0-3.2 1.43-3.2 3.199A3.198 3.198 0 1 0 8 16.8c0-1.77-1.434-3.2-3.2-3.2zm0 0\" /></svg>"),
	Rules: []string{
		"||ggpht.cn^",
		"||ggpht.com^",
		"||googlevideo.com^",
		"||wide-youtube.l.google.com^",
		"||withyoutube.com^",
		"||youtu.be^",
		"||youtube-nocookie.com^",
		"||youtube-ui.l.google.com^",
		"||youtube.ae^",
		"||youtube.al^",
		"||youtube.am^",
		"||youtube.at^",
		"||youtube.az^",
		"||youtube.ba^",
		"||youtube.be^",
		"||youtube.bg^",
		"||youtube.bh^",
		"||youtube.bo^",
		"||youtube.by^",
		"||youtube.ca^",
		"||youtube.cat^",
		"||youtube.ch^",
		"||youtube.cl^",
		"||youtube.co.ae^",
		"||youtube.co.at^",
		"||youtube.co.cr^",
		"||youtube.co.hu^",
		"||youtube.co.id^",
		"||youtube.co.il^",
		"||youtube.co.in^",
		"||youtube.co.jp^",
		"||youtube.co.ke^",
		"||youtube.co.kr^",
		"||youtube.co.ma^",
		"||youtube.co.nz^",
		"||youtube.co.th^",
		"||youtube.co.tz^",
		"||youtube.co.ug^",
		"||youtube.co.uk^",
		"||youtube.co.ve^",
		"||youtube.co.za^",
		"||youtube.co.zw^",
		"||youtube.co^",
		"||youtube.com.ar^",
		"||youtube.com.au^",
		"||youtube.com.az^",
		"||youtube.com.bd^",
		"||youtube.com.bh^",
		"||youtube.com.bo^",
		"||youtube.com.br^",
		"||youtube.com.by^",
		"||youtube.com.co^",
		"||youtube.com.do^",
		"||youtube.com.ec^",
		"||youtube.com.ee^",
		"||youtube.com.eg^",
		"||youtube.com.es^",
		"||youtube.com.gh^",
		"||youtube.com.gr^",
		"||youtube.com.gt^",
		"||youtube.com.hk^",
		"||youtube.com.hn^",
		"||youtube.com.hr^",
		"||youtube.com.jm^",
		"||youtube.com.jo^",
		"||youtube.com.kw^",
		"||youtube.com.lb^",
		"||youtube.com.lv^",
		"||youtube.com.ly^",
		"||youtube.com.mk^",
		"||youtube.com.mt^",
		"||youtube.com.mx^",
		"||youtube.com.my^",
		"||youtube.com.ng^",
		"||youtube.com.ni^",
		"||youtube.com.om^",
		"||youtube.com.pa^",
		"||youtube.com.pe^",
		"||youtube.com.ph^",
		"||youtube.com.pk^",
		"||youtube.com.pt^",
		"||youtube.com.py^",
		"||youtube.com.qa^",
		"||youtube.com.ro^",
		"||youtube.com.sa^",
		"||youtube.com.sg^",
		"||youtube.com.sv^",
		"||youtube.com.tn^",
		"||youtube.com.tr^",
		"||youtube.com.tw^",
		"||youtube.com.ua^",
		"||youtube.com.uy^",
		"||youtube.com.ve^",
		"||youtube.com^",
		"||youtube.cr^",
		"||youtube.cz^",
		"||youtube.de^",
		"||youtube.dk^",
		"||youtube.ee^",
		"||youtube.es^",
		"||youtube.fi^",
		"||youtube.fr^",
		"||youtube.ge^",
		"||youtube.googleapis.com^",
		"||youtube.gr^",
		"||youtube.gt^",
		"||youtube.hk^",
		"||youtube.hr^",
		"||youtube.hu^",
		"||youtube.ie^",
		"||youtube.in^",
		"||youtube.iq^",
		"||youtube.is^",
		"||youtube.it^",
		"||youtube.jo^",
		"||youtube.jp^",
		"||youtube.kr^",
		"||youtube.kz^",
		"||youtube.la^",
		"||youtube.lk^",
		"||youtube.lt^",
		"||youtube.lu^",
		"||youtube.lv^",
		"||youtube.ly^",
		"||youtube.ma^",
		"||youtube.md^",
		"||youtube.me^",
		"||youtube.mk^",
		"||youtube.mn^",
		"||youtube.mx^",
		"||youtube.my^",
		"||youtube.ng^",
		"||youtube.ni^",
		"||youtube.nl^",
		"||youtube.no^",
		"||youtube.pa^",
		"||youtube.pe^",
		"||youtube.ph^",
		"||youtube.pk^",
		"||youtube.pl^",
		"||youtube.pr^",
		"||youtube.pt^",
		"||youtube.qa^",
		"||youtube.ro^",
		"||youtube.rs^",
		"||youtube.ru^",
		"||youtube.sa^",
		"||youtube.se^",
		"||youtube.sg^",
		"||youtube.si^",
		"||youtube.sk^",
		"||youtube.sn^",
		"||youtube.soy^",
		"||youtube.sv^",
		"||youtube.tn^",
		"||youtube.tv^",
		"||youtube.ua^",
		"||youtube.ug^",
		"||youtube.uy^",
		"||youtube.vn^",
		"||youtube^",
		"||youtubeeducation.com^",
		"||youtubeembeddedplayer.googleapis.com^",
		"||youtubefanfest.com^",
		"||youtubegaming.com^",
		"||youtubego.co.id^",
		"||youtubego.co.in^",
		"||youtubego.com.br^",
		"||youtubego.com^",
		"||youtubego.id^",
		"||youtubego.in^",
		"||youtubei.googleapis.com^",
		"||youtubekids.com^",
		"||youtubemobilesupport.com^",
		"||yt.be^",
		"||ytimg.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "yy",
	Name:    "YY",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"33 41 194 194\"><path d=\"M36.7 100.1c-2.3 1.3-3.9 5.6-3.2 8.1.4 1 8.2 10.9 17.5 22l16.9 20.1-2.2 2.7c-12.1 14.7-12.6 16.2-8.2 20.5 2.6 2.7 7.1 3.3 9.7 1.2 2.3-1.8 53.3-62.9 54.7-65.4 2.5-4.9-1.4-10.3-7.6-10.3-2.9 0-4.5 1.6-19.4 19.2-8.9 10.6-16.5 19.3-16.9 19.3-.5 0-7.2-7.7-15-17-7.8-9.4-15.2-18-16.6-19.3-2.7-2.3-6.7-2.8-9.7-1.1zm6.2 3.9c1 .5 8.5 8.8 16.6 18.4 8 9.6 15.5 17.8 16.6 18.1 1 .4 2.8.4 3.8 0 1.1-.3 8.6-8.5 16.7-18.1 8.1-9.6 15.6-17.9 16.6-18.5 2.3-1.2 4.8.4 4.8 3.1 0 .9-3.6 5.9-7.9 11.1-4.4 5.2-15.6 18.6-25.1 29.9-18.1 21.7-20.8 24.4-23.4 23.4-2.9-1.1-1.7-5 3.4-11.4 2.8-3.5 5.3-7.3 5.6-8.6.7-2.9-.1-4.1-18.2-25.6C44.5 116.4 38 107.9 38 107c0-1.4 1.8-4 2.8-4 .2 0 1.1.4 2.1 1zm96.3-2.7c-1.2 1.3-2.2 3.5-2.2 4.9 0 3 .1 3.2 19.2 25.9 8.2 9.7 14.8 18 14.8 18.4 0 .4-2.7 3.8-6 7.7-4.8 5.5-6 7.6-6 10.3 0 5.6 5.1 8.9 10.4 6.9 1.3-.5 46.3-53.3 54.4-63.8 1.2-1.6 2.2-4.1 2.2-5.6 0-3.5-3.8-7-7.6-7-3.6 0-6.1 2.4-23.8 23.7-7 8.4-12.8 15.3-13 15.3-.2 0-7.3-8.2-15.7-18.3-8.3-10-15.9-18.8-16.7-19.5-2.6-2-7.6-1.5-10 1.1zm11.4 6.9c2.8 2.9 9.6 10.7 15.1 17.3 12.1 14.4 13.5 15.8 16.4 15.3 2.3-.3 9.1-7.5 25.4-27.1 8.6-10.4 11-12 13.2-9.1.7 1 1.3 2.1 1.3 2.6 0 .7-20 24.9-41.8 50.6-11.2 13.2-12.8 14.6-15.5 13.1-3-1.7-2.7-2.4 6.1-13.9 1.7-2.4 3.2-5.5 3.2-7 0-2-4.1-7.5-15.9-21.6-8.7-10.4-16.1-19.9-16.5-21.1-.5-1.5-.2-2.5 1.1-3.2 2.6-1.5 2.4-1.6 7.9 4.1z\"/></svg>"),
	Rules: []string{
		"||yy.com^",
	},
	GroupID: "streaming",
}, {
	ID:      "zhihu",
	Name:    "Zhihu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 30 30\"><path d=\"M14.46 14.191H9.982c0-.471.033-.954.039-1.458v-5.5h5.106V5.935a1.352 1.352 0 00-.404-.957 1.378 1.378 0 00-.968-.396H5.783c.028-.088.056-.177.084-.255.274-.82 1.153-3.326 1.153-3.326a4.262 4.262 0 00-2.413.698c-.57.4-.912.682-1.371 1.946-.532 1.453-.997 2.856-1.31 3.693C1.444 8.674.28 11.025.28 11.025a5.85 5.85 0 002.52-.61c1.119-.593 1.679-1.502 2.054-2.883l.09-.3h2.334v5.5c0 .5-.045.982-.073 1.46h-4.12c-.71 0-1.39.278-1.893.775a2.638 2.638 0 00-.783 1.874h6.527a17.717 17.717 0 01-.778 3.649 16.796 16.796 0 01-3.012 5.273A33.104 33.104 0 010 28.74s3.13 1.175 5.425-.954c1.388-1.292 2.631-3.814 3.23-5.727a28.09 28.09 0 001.12-5.229h5.967v-1.37a1.254 1.254 0 00-.373-.899 1.279 1.279 0 00-.909-.37zm-3.19 5.484l-2.312 1.491 5.038 7.458a6.905 6.905 0 00.672-2.218 3.15 3.15 0 00-.28-2.168l-3.118-4.563zM29.05 4.582H16.733V25.94h3.018l.403 2.572 4.081-2.572h4.815V4.582zm-5.207 18.69l-2.396 1.509-.235-1.508h-1.724V7.233h6.78v16.04h-2.425z\" /></svg>"),
	Rules: []string{
		"||zhihu.com^",
		"||zhimg.com^",
	},
	GroupID: "social_network",
}}

// serviceGroups contains raw service group data.
var serviceGroups = []serviceGroup{{
	ID: "ai",
}, {
	ID: "cdn",
}, {
	ID: "dating",
}, {
	ID: "gambling",
}, {
	ID: "gaming",
}, {
	ID: "hosting",
}, {
	ID: "messenger",
}, {
	ID: "privacy",
}, {
	ID: "shopping",
}, {
	ID: "social_network",
}, {
	ID: "software",
}, {
	ID: "streaming",
}}
