## Checklist for releasing a new version

1. [ ] Update Msys2 installer at https://github.com/msys2/msys2-installer/releases/
1. [ ] Update versions
  - `Alire.Version`
  - `alire.toml`
  - `user-changes.md`
1. [ ] In repo `alire-index`: create new index version branches if necessary.
  - Edit index/index.toml to match.
1. [ ] Run all tests (regular+local) (`/testsuite/run-dev.sh`)
1. [ ] Create test release in own fork.
  - To verify builds succeed.
  - As the Windows build can rarely fail, this provides a backup .exe
1. [ ] Create a proper release in alire-project/alire
  - Tag corresponding commit as vX.X.X (github does it if missing).
  - Use autogenerated release notes.
  - Credit all collaborators (if release notes aren't exhaustive).
1. [ ] Ensure the index version is the default branch in the community repos:
  - alire-index
  - alire-index-checks (must match alire-index)
  - alire-index-staging (when it exists)
  - test-index
1. [ ] Update Alire.Version and alire.toml to -dev in release branch.
1. [ ] Update stable version used in alire-index workflows
  - We used to use default in setup-alire, but by making it explicit we can
    test the new release before making it the default for everyone (next step).
1. [ ] After a screening period, update default version in setup-alire repo.
  - For major Alire versions with breaking changes, bump the setup-alire
    version too.
